/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAisosur.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAisosur.v#1 $
*/
MAparams MAisosurface_params {
   float+nosave def_level =;
   float level =;
   int level_deci = 2;
   boolean color = 0;
   int iso_comp = 0;
   int map_comp = 0;
   boolean+nosave middle = 0;
   init_commands = "";
   reset_commands =
        "isosurface_params.level=isosurface_params.def_level;"
       +"isosurface_params.level_deci=2;"
       +"isosurface_params.color=0;"
       +"isosurface_params.iso_comp=0;"
       +"isosurface_params.map_comp=0;"
       ;
};

MAmacroUI MAisosurfaceUI {
   MAisosurface_params+IPort2 &isosurface_params;
   Mesh+Node_Data+IPort2 &fld_in;

   height => isosurface_panel.height;
   MAUIframe isosurface_panel {
      parent => <-.parent;
      y => <-.y;
      height => set_middle_button.y + set_middle_button.height + 15;
   };
   MAUIslider2 level_slider {
      parent =><-.isosurface_panel;
      x = 5;
      y => <-.map_comp_rbl.y + <-.map_comp_rbl.height + 10;
      min => <-.fld_in.node_data[isosurface_params.iso_comp].min;
      max => <-.fld_in.node_data[isosurface_params.iso_comp].max;
      value =><-.isosurface_params.level;
      title = "MAISOS_LEV";
      min_oonly = 1;
      max_oonly = 1;
   };
   MAUIbutton set_middle_button {
      parent =><-.isosurface_panel;
      y =><-.level_slider.y + <-.level_slider.height + 5;
      label = "MAISOS_SET";
      do=> <-.isosurface_params.middle;
   };
   MADVnode_data_labels node_data_labels {
      in => <-.fld_in;
      labels[];
   };
   MAUIradioBoxLabel+nosave iso_comp_rbl {
      labels => <-.node_data_labels.labels;
      x = 5;
      y = 5;
      parent => <-.isosurface_panel;
      title = "MAISOCOMP_SEL";
      &selectedItem => <-.isosurface_params.iso_comp;
   };
   MAUItoggle iso_color_toggle {
      parent => <-.isosurface_panel;
      x = 5;
      y => <-.iso_comp_rbl.y + <-.iso_comp_rbl.height + 10;
      width = 110;
      height = 24;
      set => <-.isosurface_params.color;
      label = "MAISO_VIS_COLOR";
   };
   MADVnode_data_labels node_data_labels {
      in => <-.fld_in;
      labels[];
   };
   MAUIradioBoxLabel+nosave map_comp_rbl {
      labels => <-.node_data_labels.labels;
      x = 5;
      y => <-.iso_color_toggle.y + <-.iso_color_toggle.height + 5;
      parent => <-.isosurface_panel;
      title = "MAMAPCOMP_SEL";
      active => <-.isosurface_params.color;
      &selectedItem => <-.isosurface_params.map_comp;
   };
};

MAmodule MAisosurface {
   MAisosurface_params+IPort2 &isosurface_params;
   Mesh+Node_Data+IPort2 &fld_in;
   MAset_param set_level {
      int iso_comp => <-.isosurface_params.iso_comp;
      trigger+nres => is_valid(fld_in.node_data[iso_comp].min)
                     &is_valid(fld_in.node_data[iso_comp].max);
      in_value+nres => (fld_in.node_data[iso_comp].min
                       +fld_in.node_data[iso_comp].max)*0.5;
      def_value => <-.isosurface_params.def_level;
      value => <-.isosurface_params.level;
   };
   GMOD.parse_v  set_middle {
      v_commands => "$push -usr\n"
                   +"isosurface_params.level="
                   +"(fld_in.node_data[isosurface_params.iso_comp].min
                   +fld_in.node_data[isosurface_params.iso_comp].max)*0.5;"
                   +"isosurface_params.middle=0;"
                   +"$pop\n"
                  ;
      trigger => active;
      active  => <-.isosurface_params.middle;
      relative => <-;
      on_inst = 0;
   };
   MADVnmap DVnmap {
      in => <-.fld_in;
      nparam => <-.isosurface.nparam;
      iso_comp => <-.isosurface_params.iso_comp;
      iso_val =><-.isosurface_params.level;
      map_comp => {<-.isosurface_params.map_comp};
   };
   MADVcombine_mesh_and_data DVcomb_mesh_and_data {
     in_mesh => <-.isosurface.out;
     in_nd => <-.DVnmap.out;
   };
   MADVisosurface isosurface {
     in => <-.fld_in;
      component => <-.isosurface_params.iso_comp;
      level => <-.isosurface_params.level;
   };
   MADVswitch DVswitch {
      in => { <-.isosurface.out, 
              <-.DVcomb_mesh_and_data.out };
      index => <-.isosurface_params.color;
   };
   fld_out => DVswitch.out;
};
