/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAisovol.v#1 $"
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under CVS control at KGT in:
	$Source:$
*/
MAparams MAisovolume_params {
   float+nosave def_level =;
   float level =;
   int level_deci = 2;
   boolean above = 1;
   int iso_component = 0;
   int map_component = 0;
   boolean middle = 0;
   int+nosave cell_data[] = {0};
   init_commands = "";
   reset_commands =
        "isovolume_params.level=isovolume_params.def_level;"
       +"isovolume_params.level_deci=2;"
       +"isovolume_params.above=1;"
       +"isovolume_params.middle=0;"
       +"isovolume_params.iso_component=0;"
       +"isovolume_params.map_component=0;"
       +"isovolume_params.cell_data={0};"
       ;
};

MAmacroUI MAisovolumeUI {
   MAisovolume_params+IPort2 &isovolume_params;
   Mesh+Node_Data+IPort2 &fld_in;

   height => isovolume_panel.height;
   MAUIframe isovolume_panel {
      parent => <-.parent;
      y => <-.y;
      height => set_middle_button.y + set_middle_button.height + 15;
   };
   MADVnode_data_labels node_data_labels {
      in => <-.fld_in;
      labels[];
   };
   MAUIradioBoxLabel+nosave iso_comp_rbl {
      labels => <-.node_data_labels.labels;
      x = 5;
      y = 5;
      parent => <-.isovolume_panel;
      title = "MAISOCOMP_SEL";
      &selectedItem => <-.isovolume_params.iso_component;
   };
   MADVnode_data_labels node_data_labels {
      in => <-.fld_in;
      labels[];
   };
   MAUIradioBoxLabel+nosave map_comp_rbl {
      labels => <-.node_data_labels.labels;
      x = 5;
      y => <-.iso_comp_rbl.y + <-.iso_comp_rbl.height + 5;
      parent => <-.isovolume_panel;
      title = "MAMAPCOMP_SEL";
      &selectedItem => <-.isovolume_params.map_component;
   };
   MAUItoggle above {
      parent =><-.isovolume_panel;
      label = "MAISOV_ABOVE";
      set => <-.isovolume_params.above;
      x = 5;
      y => <-.map_comp_rbl.y + <-.map_comp_rbl.height;
      width = 150;
   };
   MAUIslider2 level_slider {
      parent =><-.isovolume_panel;
      x = 5;
      y =><-.above.y + <-.above.height + 5;
      min => <-.fld_in.node_data[isovolume_params.iso_component].min;
      max => <-.fld_in.node_data[isovolume_params.iso_component].max;
      value =><-.isovolume_params.level;
      title = "MAISOS_LEV";
      min_oonly = 1;
      max_oonly = 1;
   };
   MAUIbutton set_middle_button {
      parent =><-.isovolume_panel;
      y =><-.level_slider.y + <-.level_slider.height + 5;
      label = "MAISOS_SET";
      do => <-.isovolume_params.middle;
   };
};

MAmodule MAisovolume {
   MAisovolume_params+IPort2 &isovolume_params;
   Mesh+Node_Data+IPort2 &fld_in;

   MAset_param set_level {
      int iso_component => <-.isovolume_params.iso_component;
      trigger+nres => is_valid(fld_in.node_data[iso_component].min)
                     &is_valid(fld_in.node_data[iso_component].max);
      in_value+nres => (fld_in.node_data[iso_component].min
                       +fld_in.node_data[iso_component].max)*0.5;
      def_value => <-.isovolume_params.def_level;
      value => <-.isovolume_params.level;
   };

   GMOD.parse_v  set_middle {
      v_commands => "$push -usr\n"
                   +"isovolume_params.level="
                   +"(fld_in.node_data[isovolume_params.iso_component].min
                   +fld_in.node_data[isovolume_params.iso_component].max)*0.5;"
                   +"isovolume_params.middle=0;"
                   +"$pop\n"
                  ;
      trigger => active;
      active  => <-.isovolume_params.middle;
      relative => <-;
      on_inst = 0;
   };
   
   boolean+nres has_cell_data => field_in.nnode_data > 0;
   MADVcut isovolume {
      in => <-.fld_in;
      level => <-.isovolume_params.level;
      above => <-.isovolume_params.above;
      cut_comp => <-.isovolume_params.iso_component;
      map_comp => {<-.isovolume_params.map_component};
      //Later cell_data => switch(<-.has_cell_data, <-.isovolume_params.cell_data);
   };
   fld_out => isovolume.out;
};
