/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAmarker.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAmarker.v#1 $
*/
MAparams MAmarker_params {
   int scale_comp = 0;
   int map_comp = 0;
   int marker_type = 0;
   boolean normalize = 1;
   float scale = 1;
   float scale_min = 0;
   float scale_max = 10;
   int scale_deci = 2;
   int subdiv = 6;
   int mode1 = GD_NO_POINTS;
   int mode2 = GD_LINES;
   int mode3 = GD_SURF_GOURAUD;
   int mode4 = GD_NO_VOLUME;
   int mode5 = GD_NO_BOUNDS;
   init_commands = "";
   reset_commands = "marker_params.scale_comp=0;"
                   +"marker_params.map_comp=0;"
                   +"marker_params.marker_type=0;"
                   +"marker_params.normalize=1;"
                   +"marker_params.scale=1;"
                   +"marker_params.scale_min=0;"
                   +"marker_params.scale_max=10;"
                   +"marker_params.scale_deci=2;"
                   +"marker_params.subdiv=6;"
                   +"marker_params.mode1="+GD_NO_POINTS+";"
                   +"marker_params.mode2="+GD_LINES+";"
                   +"marker_params.mode3="+GD_SURF_GOURAUD+";"
                   +"marker_params.mode4="+GD_NO_VOLUME+";"
                   +"marker_params.mode5="+GD_NO_BOUNDS+";"
                   ;
};

MAmacroUI MAmarkerUI {
   MAmarker_params+IPort2 &marker_params;
   Mesh+Node_Data+IPort2 &fld_in<NEportLevels={2,1}>;
   height => marker_panel.height;
   MAUIframe marker_panel {
      parent => <-.parent;
      y => <-.y;
      height =>sphere_slider.y + sphere_slider.height + 15;
   };
   MADVnode_data_labels node_data_labels {
      in =><-.fld_in;
   };
   MAUIradioBoxLabel map_radio {
      parent =><-.marker_panel;
      x = 5;
      y = 5;
      labels =><-.node_data_labels.labels;
      &selectedItem =><-.marker_params.map_comp;
      title ="MAMARK_SEL_COL";
   };
   MAUIradioBoxLabel scale_radio {
      parent =><-.marker_panel;
      x = 5;
      y =><-.map_radio.y + <-.map_radio.height + 5;
      labels =><-.node_data_labels.labels;
      &selectedItem =><-.marker_params.scale_comp;
      title ="MAMARK_SEL_SCALE";
   };
   MAUIradioBoxLabel marker_type_radio {
      parent =><-.marker_panel;
      x = 5;
      y =><-.scale_radio.y + <-.scale_radio.height + 5;
      &selectedItem =><-.marker_params.marker_type;
      labels = {"MAMARK_BOX","MAMARK_DIA","MAMARK_CROSS","MAMARK_SPHERE"};
      title ="MAMARK_TYPE";
   };
   MAUIslider2 scale_slider {
      parent =><-.marker_panel;
      x = 5;
      y =><-.marker_type_radio.y + <-.marker_type_radio.height + 5;
      value =><-.marker_params.scale;
      min =><-.marker_params.scale_min;
      max =><-.marker_params.scale_max;
      decimalPoints =><-.marker_params.scale_deci;
      title = "MAMARK_SCALE";
      immediateMode = 0;
   };
   MAUItoggle norm_toggle {
      parent =><-.marker_panel;
      x = 5;
      y =><-.scale_slider.y + <-.scale_slider.height + 5;
      set =><-.marker_params.normalize;
      label = "MAMARK_NORM_SCALE";
   };
   MAUIslider sphere_slider {
      parent => <-.marker_panel;
      x = 5;
      y => <-.norm_toggle.y + <-.norm_toggle.height + 5;
      title = "MAMARK_SP_LABEL";
      min = 5;
      max = 30;
      value => <-.marker_params.subdiv; 
      mode = "integer";
      active => <-.marker_params.marker_type == 3; 
   };
};


MAmodule MAmarker {
   Mesh+Node_Data+IPort2 &fld_in<NEportLevels={2,1}>;
   MAmarker_params+IPort2 &marker_params;
   // Box Glyph
   macro Box {
      Mesh+OPort box {
         nnodes = 8;
         nspace = 3;
         coordinates {
            nvals = 8;
            veclen = 3;
            values[8][3] = {
               -0.5,-0.5,-0.5,
                0.5,-0.5,-0.5,
                0.5,0.5,-0.5,
               -0.5,0.5,-0.5,
               -0.5,-0.5,0.5,
                0.5,-0.5,0.5,
                0.5,0.5,0.5,
               -0.5,0.5,0.5
            };
         };
         ncell_sets = 1;
         !cell_set[0] {
            ncells = 6;
            cell_ndim = 2;
            cell_nnodes = 4;
            cell_corner_nnodes = 4;
            cell_order = 1;
            poly_flag = 0;
            node_connect_list = { 3,2,1,0,
                                  4,5,6,7,
                                  0,4,7,3,
                                  1,2,6,5,
                                  0,1,5,4,
                                  2,3,7,6
                                };
            cell_type = 5;
            cell_name = "Quad";
      
         };
      };
      olink fld_out => box;
   };
   // Cross Glyph
   macro Cross {
      Line  set1 {
         ncells = 3;
   	 node_connect_list = {0,1,2,3,4,5};
      };
      Mesh  cross {
         int nnodes = 6;
         int nspace = 3;
         coordinates {
            float values[nvals][veclen] = {
   	         {-0.5,0,0},{0.5,0,0},{0,-0.5,0},{0,0.5,0},{0,0,-0.5},{0,0,0.5}
            };
         };
         int ncell_sets = 1;
         cell_set[ncell_sets] => {set1};    
      };
      olink fld_out => cross;
   };
   // Diamond Glyph
   macro Diamond {
      Tri  set1 {
      ncells = 8;
      node_connect_list = 
                {2,5,0, 2,1,5, 2,4,1, 2,0,4, 3,0,5, 3,5,1, 3,1,4, 3,4,0};
      };
      Mesh  diamond {
        int nnodes = 6;
      	int nspace = 3;
       	coordinates {
   	      float values[nvals][veclen] = {
                 {-0.5,0,0},{0.5,0,0},{0,-0.5,0},{0,0.5,0},{0,0,-0.5},{0,0,0.5}
       	      };
       	};
       	int ncell_sets = 1;
       	cell_set[ncell_sets] => {set1};    
      };
      olink fld_out => diamond;
   };
   // Sphere Glyph
   MAgen_sphere Sphere {
      subdiv => <-.marker_params.subdiv;
   };
   link glyph_out => switch(marker_params.marker_type+1,
                            Box.fld_out,
                            Diamond.fld_out,
                            Cross.fld_out,
                            Sphere.fld_out
                           );
// if sphere, no lines
   GMOD.copy_on_change set_nolines {
      input   => switch((<-.marker_params.marker_type == 3)+1,
                        GD_LINES, GD_NO_LINES);
      output  => <-.marker_params.mode2;
   };
// if sphere, no lines end
   MADVglyph+nosave glyph {
      in =><-.fld_in;
      glyph =><-.glyph_out;
      glyph_comp = 0;
      vector = 0;
      &map_comp =><-.marker_params.map_comp;
      &scale_comp =><-.marker_params.scale_comp;
      &scale =><-.marker_params.scale;
      &normalize =><-.marker_params.normalize;
      scale_x = 1;
      scale_y = 1;
      scale_z = 1;
   };
   fld_out => glyph.out;
};
