/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAmorbit.v#1 $"
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under CVS control at KGT in:
	$Source:$
*/

MAparams MAmol_orbit_params {
   float+nosave def_posi_level =;
   int level_deci = 2;
   int iso_comp = 0;
   int map_comp = 0;
   boolean+nosave middle = 0;
   float posi_level =;
   init_commands = "";
   reset_commands =
      "mol_orbit_params.posi_level=mol_orbit_params.def_posi_level;"
     +"mol_orbit_params.level_deci=2;"
     +"mol_orbit_params.iso_comp=0;"
     +"mol_orbit_params.map_comp=0;"
     +"mol_orbit_params.middle = 1;"
     ;
};

MAmacroUI MAmol_orbitUI {
   MAmol_orbit_params+IPort2 &mol_orbit_params;
   Mesh+Node_Data+IPort2 &fld_in;
   float+nres min_value => .fld_in.node_data[0].min;
   float+nres max_value => .fld_in.node_data[0].max;

   height => isosurface_panel.height;
   MAUIframe isosurface_panel {
      parent => <-.parent;
      y => <-.y;
      height => set_middle_button.y + set_middle_button.height + 15;
   };
   MAUIslider2 level_slider {
      parent =><-.isosurface_panel;
      x = 5;
      y => <-.iso_comp_rbl.y + <-.iso_comp_rbl.height + 10;
      min = 0.;
      max => <-.max_value;
      value =><-.mol_orbit_params.posi_level;
      title = "MAISOS_LEV";
      min_oonly = 1;
      max_oonly = 1;
   };
   MAUIbutton set_middle_button {
      parent =><-.isosurface_panel;
      y =><-.level_slider.y + <-.level_slider.height + 10;
      label = "MAISOS_SET";
      do => <-.mol_orbit_params.middle;
   };
   MADVnode_data_labels node_data_labels {
      in => <-.fld_in;
      labels[];
   };
   MAUIradioBoxLabel+nosave iso_comp_rbl {
      labels => <-.node_data_labels.labels;
      x = 5;
      y = 5;
      parent => <-.isosurface_panel;
      title = "MAISOCOMP_SEL";//Later
      &selectedItem => <-.mol_orbit_params.iso_comp;
   };
};

MAmodule MAmol_orbit {
   MAmol_orbit_params+IPort2 &mol_orbit_params;
   Mesh+Node_Data+IPort2 &fld_in;
   MAset_param set_posilevel {
      trigger+nres => is_valid(fld_in.node_data[0].min)
                     &is_valid(fld_in.node_data[0].max);
      in_value+nres => (fld_in.node_data[0].max)*0.5;
      def_value => <-.mol_orbit_params.def_posi_level;
      value => <-.mol_orbit_params.posi_level;
   };
   GMOD.parse_v  set_middle {
      v_commands => "$push -usr\n"
                   +"mol_orbit_params.posi_level="
                   +"(fld_in.node_data[0].max)*0.5;"
                   +"mol_orbit_params.middle=0;"
                   +"$pop\n"
                  ;
      trigger => active;
      active  => <-.mol_orbit_params.middle;
      relative => <-;
      on_inst = 0;
   };
   MADVnmap DVnmap_posi {
      in => <-.DVextract_comp.out;
      nparam => <-.posi_isosuf.nparam;
      iso_comp => <-.mol_orbit_params.iso_comp;
      iso_val =><-.mol_orbit_params.posi_level;
      map_comp => {<-.mol_orbit_params.map_comp};
   };
   MADVnmap DVnmap_nega {
      in => <-.DVextract_comp.out;
      nparam => <-.nega_isosuf.nparam;
      iso_comp => <-.mol_orbit_params.iso_comp;
      iso_val =>-<-.mol_orbit_params.posi_level;
      map_comp => {<-.mol_orbit_params.map_comp};
   };
   MADVcombine_mesh_and_data DVcomb_posi {
     in_mesh => <-.posi_isosuf.out;
     in_nd => <-.DVnmap_posi.out;
   };
   MADVcombine_mesh_and_data DVcomb_nega {
     in_mesh => <-.nega_isosuf.out;
     in_nd => <-.DVnmap_nega.out;
   };
   MADVextract_comp DVextract_comp {
     in => <-.fld_in;
     component => <-.mol_orbit_params.iso_comp;
   };
   MADVisosurface posi_isosuf {
      in => <-.DVextract_comp.out;
      component => <-.mol_orbit_params.iso_comp;
      level => <-.mol_orbit_params.posi_level;
   };
   MADVisosurface nega_isosuf {
      in => <-.DVextract_comp.out;
      component => <-.mol_orbit_params.iso_comp;
      level => -<-.mol_orbit_params.posi_level; 
   };
   fld_out => DVcomb_posi.out;
   olink Nfld_out => DVcomb_nega.out;
};
