/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAoffset.v#1 $
*/
MAparams MAoffset_params {
   boolean+nosave run   = 0;
   boolean+nosave reset = 0;
   boolean cycle    = 0;
   boolean bounds   = 0;
   boolean color    = 1;
   int map_comp     = 0;
   float count      = 1;
   float count_max  = 1000;
   int count_deci   = 2;
   float start      = 0;
   float start_max  = 1000;
   int start_deci   = 2;
   float end        = 1;
   float end_max    = 1000;
   int end_deci     = 2;
   float incr       = 0.1;
   float incr_max   = 1000;
   int incr_deci    = 2;
   float scale      = 1;
   float scale_max  = 1000;
   float scale_deci = 2;
   int scale_data   = 1;
   init_commands = "";
   reset_commands = "offset_params.run=0;"
                   +"offset_params.reset=0;"
                   +"offset_params.cycle=0;"
                   +"offset_params.bounds=0;"
                   +"offset_params.color=1;"
                   +"offset_params.count=0;"
                   +"offset_params.count_max=1000;"
                   +"offset_params.count_deci=2;"
                   +"offset_params.start=0;"
                   +"offset_params.start_max=1000;"
                   +"offset_params.start_deci=2;"
                   +"offset_params.end=1;"
                   +"offset_params.end_max=1000;"
                   +"offset_params.end_deci=2;"
                   +"offset_params.incr=0.1;"
                   +"offset_params.incr_max=1000;"
                   +"offset_params.incr_deci=2;"
                   +"offset_params.map_comp = 0;"
                   +"offset_params.scale = 1;"
                   +"offset_params.scale_max = 1000;"
                   +"offset_params.scale_deci =2;"
                   +"offset_params.scale_data = 0;"
                   ;
};

MAmacroUI MAoffset_map_compUI{
   height => offset_map_comp_panel.height;
   MAoffset_params+IPort2 &offset_params;
   MAUIframe offset_map_comp_panel {
      parent => <-.parent;
      y => <-.y;
      height =>map_comp_rbl.y + map_comp_rbl.height +15;
   };

   Mesh+Node_Data+IPort2 &fld_in;

   MADVnode_data_labels node_data_labels {
      in => <-.fld_in;
      labels[];
   };
   MAUItoggle offset_color_toggle {
      parent => <-.offset_map_comp_panel;
      y = 10;
      height = 20;
      set => <-.offset_params.color;
      label = "MASTRM_COL";
   };
   MAUIradioBoxLabel map_comp_rbl {
      labels => combine_array ({"MAVECTOR_MAGNITUDE"},<-.node_data_labels.labels);
      x = 5;
      y => <-.offset_color_toggle.y + <-.offset_color_toggle.height + 5;
      parent => <-.offset_map_comp_panel;
      title = "MAMAPCOMP_SEL";
      active => <-.offset_params.color;
      &selectedItem => <-.offset_params.map_comp;
   };
};

MAmacroUI MAoffsetUI {
   MAoffset_params+IPort2 &offset_params;

   height => offset_panel.height;
   MAUIframe offset_panel {
      parent => <-.parent;
      y      => <-.y;
      height => ((<-.scale_field.y + <-.scale_field.height) + 10);
   };
   MAUIbutton reset_b {
      parent => <-.offset_panel;
      x = 15;
      y = 5;
      width = 40;
      height = 40;
      label = "reset";
      labelPixmap.filename = MAVS_ICON_PATH + "offset/oreset.x";
      labelPixmap.fileType = "avs_image";
      do =><-.offset_params.reset;
   };
   reset_b stop_b {
      x =><-.reset_b.x + width;
      label = "stop";
      labelPixmap.filename = MAVS_ICON_PATH + "offset/ostop.x";
      do =>!(<-.offset_params.run);
   };
   reset_b run_b {
      x =><-.stop_b.x + width;
      label = "run";
      labelPixmap.filename = MAVS_ICON_PATH + "offset/orun.x";
      do =>;
   };
   GMOD.parse_v set_run {
      v_commands = "$push -usr\nrun=1;cycle=0;bounds=0;$pop\n";
      trigger =><-.run_b.do;
      on_inst = 0;
      relative =><-.offset_params;
   };
   set_run set_cycle {
      v_commands = "$push -usr\nrun=1;cycle=1;bounds=0;$pop\n";
      trigger =><-.cycle_b.do;
   };
   set_run set_bounds {
      v_commands = "$push -usr\nrun=1;cycle=0;bounds=1;$pop\n";
      trigger =><-.bounds_b.do;
   };
   reset_b cycle_b {
      x =><-.run_b.x + width;
      label = "cycle";
      labelPixmap.filename = MAVS_ICON_PATH + "offset/ocycle.x";
      do =>;
   };
   reset_b bounds_b {
      x =><-.cycle_b.x + width;
      label = "bound";
      labelPixmap.filename = MAVS_ICON_PATH + "offset/obounds.x";
      do =>;
   };
   float rate => (monitor_panel.width - indicator.width)/
                 (offset_params.end - offset_params.start);
   MAUIpanel monitor_panel {
      parent =><-.offset_panel;
      x =><-.reset_b.x;
      y => <-.reset_b.y + <-.reset_b.height + 5;
      width = 200;
      height = 10;
      color.backgroundColor = "white";
   };
   MAUIpanel indicator {
      parent =><-.monitor_panel;
      x =><-.rate * <-.offset_params.count;
      y = 0;
      width = 10;
      height = 15;
      color.backgroundColor = MAVS_RED;
   };
/*
 *   MAUItoggle color_toggle {
 *      parent =><-.offset_panel;
 *      x = 5;
 *      y => <-.monitor_panel.y + <-.monitor_panel.height + 5;
 *      label = "MAOFSET_COL";
 *      set =><-.offset_params.color;
 *   };
 */
   MAUIlabel start_label {
      parent =><-.offset_panel;
      label = "MAOFSET_START";
      x = 5;
      y => <-.monitor_panel.y + <-.monitor_panel.height + 15;
      width = 135;
   };
   start_label end_label {
      y =><-.start_label.y + <-.start_label.height + 20;
      label = "MAOFSET_END";
   };
   start_label incr_label {
      y =><-.end_label.y + <-.end_label.height + 20;
      label = "MAOFSET_INCR";
   };
   MAUIfield2 start_field {
      parent =><-.offset_panel;
      x = 140;
      y =><-.start_label.y - 6;
      allwidth = 80;
      min = 0;
      max =><-.offset_params.start_max;
      decimalPoints =><-.offset_params.start_deci;
      value =><-.offset_params.start;
      min_oonly = 1;
   };
   start_field end_field {
      y =><-.end_label.y - 6;
      max =><-.offset_params.end_max;
      decimalPoints =><-.offset_params.end_deci;
      value =><-.offset_params.end;
   };
   start_field incr_field {
      y =><-.incr_label.y - 6;
      max =><-.offset_params.incr_max;
      decimalPoints =><-.offset_params.incr_deci;
      value =><-.offset_params.incr;
   };
   MAUItoggle offset_data_toggle {
      parent =><-.offset_panel;
      x = 30;
      y => <-.incr_field.y + <-.incr_field.height + 10;
      height = 20;
      set => <-.offset_params.scale_data;
      label = "MAOFSET_SCALE_DATA";
   };
   start_label scale_label {
      y => <-.offset_data_toggle.y + <-.offset_data_toggle.height + 30;
      label = "MAOFSET_SCALE";
   };
   start_field scale_field {
      y =><-.scale_label.y - 6;
      max =><-.offset_params.scale_max;
      decimalPoints =><-.offset_params.scale_deci;
      value =><-.offset_params.scale;
   };
};

MAmodule MAoffset {
   MAoffset_params+IPort2 &offset_params;
   Mesh+Node_Data+IPort2 &fld_in;
   ilink fld_in2;

   MADVoffset offset {
      in => <-.fld_in;
      component = 0;
      scale => (<-.offset_params.count * <-.offset_params.scale);
   };

   MADVmagnitude+nosave magnitude {
      component = 0;
      in => <-.offset.out;
   };

//   MADVcomb_comp comb_comp {
//      nd1 => <-.magnitude.out;
//      nd2 => <-.fld_in2;
//      comp1 = {0};
//      comp2 => init_array(.nd2.nnode_data,0,(.nd2.nnode_data - 1));
//   };

   MicroAVS.MADVextract_comp extract_comp {
      component=> <-.offset_params.map_comp - 1;
      in => switch((<-.offset_params.map_comp != 0),<-.fld_in2);
   };

   MADVcombine_mesh_and_data+nosave comb_mesh_and_data {
      in_mesh => <-.magnitude.out;
      in_nd => switch((<-.offset_params.map_comp != 0) +1, <-.magnitude.out_nd, <-.extract_comp.out_nd);
//      in_nd =><-.comb_comp.out;
   };

//   MicroAVS.MADVextract_comp extract_comp {
//      component=> <-.offset_params.map_comp;
//      in => <-.comb_mesh_and_data.out;
//   };

   GMOD.loop+nosave MAloop {
      &reset =><-.offset_params.reset;
      &run =><-.offset_params.run;
      &cycle =><-.offset_params.cycle + <-.offset_params.bounds * 2;
      &start_val =><-.offset_params.start;
      &end_val =><-.offset_params.end;
      &incr =><-.offset_params.incr;
      &count =><-.offset_params.count;
      done+nosave;
   };
   MADVextract_mesh+nosave extract_mesh {
      &in =><-.offset.out;
   };
/* test for MicroAVS 7.0 Rev.C */
/*
   MADVdata_math data_math{
      in1 => <-.comb_mesh_and_data.out;
      operation => switch((<-.offset_params.scale_data + 1) && is_valid(<-.comb_mesh_and_data.out),
                          "#1",
                          (str_format("#1 * %f",<-.offset_params.count)));
   };
*/
   MADVdata_math data_math{
      in1 => <-.comb_mesh_and_data.out;
      operation => switch((<-.offset_params.scale_data + 1),
                          "#1",
                          (str_format("#1 * %f",<-.offset_params.count)));
   };

   MADVswitch switch {
      &in =>{<-.extract_mesh.out,<-.data_math.out};
      &index =><-.offset_params.color;
   };
   fld_out => .switch.out;
};
