/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAscalar2texture.v#1 $
*/

MAmodule MAscalar2texture {
   ilink in_dmap;
   MAs2t_params &s2t_params;
   MAcolmap_params &colmap_params;
   Mesh+Node_Data+nres &in<NEportLevels=1>      => fld_in;
   int nnodes<NEportLevels={0,1}>               => in.nnodes;
   float+nres min<NEportLevels={0,1}>           => in.node_data[0].min;
   float+nres max<NEportLevels={0,1}>           => in.node_data[0].max;
#ifdef MICROAVS_DEV_KIT
   float offset =>  1.0 / .s2t_params.texture_size;
   float scale  => ( .s2t_params.texture_size / (.s2t_params.texture_size + 2.0) );
#else
   float offset =>  switch ( (is_valid(.s2t_params.texture_size) + 1)
                             ,(1.0 / 256)
                             ,(1.0 / .s2t_params.texture_size)
                           );
   float scale  =>  switch ( (is_valid(.s2t_params.texture_size) + 1)
                             ,(256/258)
                             ,( .s2t_params.texture_size / (.s2t_params.texture_size + 2.0))
                           );
#endif
   float+nres v1<NEportLevels={0,1}>[nnodes]    => .in.node_data[0].values;
   float+nres v2<NEportLevels={0,1}>[nnodes][1] => switch( (((max - min) == 0) + 1),
                                                           (.offset + .scale * (v1 - min) / (max - min)),
                                                           v1
                                                         );
   MAinterleave_2_arrays interleave{
      in1 => <-.v2;
      in2 => <-.v2;
      out => switch( ((((<-.max - <-.min) == 0) || (error)) + 1),
                     combine_array(rin1,rin2),
                     0);
   };
   Node_Data nduv<NEcolor2=65280> {
      node_data {
         veclen = 2;
         values+nres <NEportLevels={3,0}>[nvals][veclen] => <-.<-.interleave.out;
//         float+opt null_value;
//         min => <-.<-.min;
//         max => <-.<-.max;
//         float min;
//         float max;
//         float min_vec[veclen];
//         float max_vec[veclen];
         id = 670;
         labels = "texture coords";
         units = "unit range";
      };
      nnode_data = 1;
      nnodes     => <-.nnodes;
   };
   GMOD.copy_on_change set_min{
      trigger => <-.min;
      input   => <-.min;
//      on_inst = 0;
      on_inst = 1;
   };
   GMOD.copy_on_change set_max{
      trigger => <-.max;
      input   => <-.max;
//      on_inst = 0;
      on_inst = 1;
   };

   MADmap2Image Dmap2Image {
      dmap  => <-.in_dmap;
      min         => <-.set_min.output;
      max         => <-.set_max.output;
      curmin      => <-.colmap_params.curmin;
      curmax      => <-.colmap_params.curmax;
      min_col_val => <-.colmap_params.min_col_val;
      max_col_val => <-.colmap_params.max_col_val;
#ifdef MICROAVS_DEV_KIT
      width       => <-.s2t_params.texture_size;
#else
      width       => switch(  (is_valid(.s2t_params.texture_size) + 1)
                             ,(256)
                             ,(<-.s2t_params.texture_size)
                           );
#endif
      out<NEportLevels={0,3}>;
   };

   Mesh+Node_Data &out<NEportLevels={0,1}> => merge(nduv,in,,,,);

//   fld_out=> in;
//   GMOD.parse_v set_out{
//      v_commands => switch((s2t_params.s2t_on + 1),"fld_out => in;\n", "fld_out => out;\n");
//      trigger    => <-.s2t_params.s2t_on;
//      relative   => <-.<-;
//   };
#ifdef MICROAVS_DEV_KIT
   fld_out => switch((s2t_params.s2t_on + 1),in,out);
#else
   fld_out => switch( (is_valid(.s2t_params.s2t_on) + 1)
                      ,(in)
                      ,switch((s2t_params.s2t_on + 1),in,out)
                    );
#endif
};


