/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAscauni.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAscauni.v#1 $
*/
MAparams MAscatuni2d_params {
   int dim1 = 10;
   int dim2 = 10;
   boolean preview = 0;
   int order = 2;
   int dim1_min = 3;
   int dim1_max = 30;
   int dim2_min = 3;
   int dim2_max = 30;
   int order_min = 1;
   int order_max = 10;
   init_commands = "";
   reset_commands = "scatuni2d_params.dim1=10;"
                   +"scatuni2d_params.dim2=10;"
                   +"scatuni2d_params.preview=0;"
                   +"scatuni2d_params.order=2;"
                   +"scatuni2d_params.dim1_min=3;"
                   +"scatuni2d_params.dim1_max=30;"
                   +"scatuni2d_params.dim2_min=3;"
                   +"scatuni2d_params.dim2_max=30;"
                   +"scatuni2d_params.order_min=1;"
                   +"scatuni2d_params.order_max=10;"
                   ;
};
MAparams MAscatuni3d_params {
   int dim1 = 5;
   int dim2 = 5;
   int dim3 = 5;
   boolean preview = 0;
   int order = 2;
   int dim1_min = 3;
   int dim1_max = 30;
   int dim2_min = 3;
   int dim2_max = 30;
   int dim3_min = 3;
   int dim3_max = 30;
   int order_min = 1;
   int order_max = 10;
   init_commands = "";
   reset_commands => "scatuni3d_params.dim1=5;"
                    +"scatuni3d_params.dim2=5;"
                    +"scatuni3d_params.dim3=5;"
                    +"scatuni3d_params.preview=0;"
                    +"scatuni3d_params.order=2;"
                    +"scatuni3d_params.dim1_min=3;"
                    +"scatuni3d_params.dim1_max=30;"
                    +"scatuni3d_params.dim2_min=3;"
                    +"scatuni3d_params.dim2_max=30;"
                    +"scatuni3d_params.dim3_min=3;"
                    +"scatuni3d_params.dim3_max=30;"
                    +"scatuni3d_params.order_min=1;"
                    +"scatuni3d_params.order_max=10;"
                    ;
};
MAmodule MAscatuni2d {
   MAscatuni2d_params+IPort2 &scatuni2d_params;
   MADVscat2uni scat2uni {
      in => <-.fld_in;
      rndim = 2;
      rdims => {<-.scatuni2d_params.dim1, 
                <-.scatuni2d_params.dim2
               };
      search_cube => { rdims[0], rdims[1] };
      interp_order => <-.scatuni2d_params.order;
   };
   fld_out => .scat2uni.out;
};
MAmodule MAscatuni3d {
   MAscatuni3d_params+IPort2 &scatuni3d_params;
   MADVscat2uni scat2uni {
      in => <-.fld_in;
      rndim = 3;
      rdims => {<-.scatuni3d_params.dim1, 
                <-.scatuni3d_params.dim2,
                <-.scatuni3d_params.dim3
               };
      search_cube => { rdims[0], rdims[1], rdims[2]};
      interp_order => <-.scatuni3d_params.order;
   };
   fld_out => .scat2uni.out;
};

MAmacroUI MAscatuni2dUI {
   ilink scat_in; // input scatter data
   ilink struct_in;// input structured data
   MAscatuni2d_params+IPort2 &scatuni2d_params;

   height => scatuni2d_panel.height;
   MAUIframe scatuni2d_panel {
      parent =><-.parent;
      y =><-.y;
      height => <-.interpolateUI.height + 5;
   };
   macro interpolateUI {
      ilink parent =><-.scatuni2d_panel;
      imlink obj_in => {<-.sphere_glyph.obj_out,
                        <-.contour.obj_out,
                        <-.unif_bounds.obj_out};
      olink height => preview_frame.y + preview_frame.height;
      GMOD.instancer instancer {
         Value => preview_toggle.set;
         Group => preview; 
      };
      MAUIframe preview_frame {
         parent => <-.parent;
         x = 5;
         width = 220;
         height = 200;
         y => order_slider.y + order_slider.height + 10;
      };
      macro preview<instanced=0> {
         imlink obj_in => <-.obj_in;
         ilink+nres parent => <-.preview_frame;
         ilink vis => <-.<-.scatuni2d_params.preview;
         DefaultLightOn DefaultLightOn;
         DefaultLightInfo DefaultLightInfo {
             lights => {<-.DefaultLightOn};
         };
         MAdefaultCamera3D DefaultCamera3D {
             objects => {<-.GroupObject.obj};
             auto_norm = "Data and Object";
             norm_scale = 0.85;
         };
         BestVirtPal BestVirtPal { gamma = 1.0; };
         MAdefaultView DefaultView {
             handle<NEportLevels={2,0}> => <-.UIrenderView.handle;
             virtpal<NEportLevels={2,0}> => <-.BestVirtPal;
             light_info<NEportLevels={2,0}> => <-.DefaultLightInfo;
             cameras<NEportLevels={2,0}>=> {<-.DefaultCamera3D};
         };
         macro GroupObject<locked=0> {
             imlink+nres child_objs => <-.obj_in;
             DefaultXform Xform;
             MAdefaultObject Top<NEportLevels={0,1}> {
                 dmap<export=0>;
                 xform<export=0> => <-.Xform;
                 props<export=0>;
                 modes<export=0>;
                 objects+nres<export=0> => <-.child_objs;
                 altobj<export=0>;
                 name<export=2> => name_of(<-.<-);
                 pick_info<export=0>;
                 visible =><-.<-.vis;
             };
             olink obj => .Top;
         };
         UIrenderView UIrenderView {
             parent => <-.parent;
             y => (<-.<-.preview_toggle.y + <-.<-.preview_toggle.height) + 5;
             width = 150;
             height =>width;
             x =35;
         };
      };
      MAUItoggle preview_toggle {
         parent => <-.preview_frame;
         label => "MAUNI_PREVIEW";
         x = 5;
         y = 5;
         width = 100;
         set+nres =><-.<-.scatuni2d_params.preview;
      };
      MAUIslider2 dim1_slider {
         parent => <-.parent;
         value+nres => <-.<-.scatuni2d_params.dim1;
         title => "MAUNI_DIM1";
         x = 5;
         y = 5;
         allwidth = 220;
         min =><-.<-.scatuni2d_params.dim1_min;
         max =><-.<-.scatuni2d_params.dim1_max;
         mode = "integer";
         decimalPoints = 0;
         precision_oonly=1;
      };
      MAUIslider2 dim2_slider {
         parent => <-.parent;
         value+nres => <-.<-.scatuni2d_params.dim2;
         title => "MAUNI_DIM2";
         x => dim1_slider.x;
         y => ((dim1_slider.y + dim1_slider.height) + 5);
         allwidth => dim1_slider.allwidth;
         height => dim1_slider.height;
         min =><-.<-.scatuni2d_params.dim2_min;
         max =><-.<-.scatuni2d_params.dim2_max;
         mode = "integer";
         decimalPoints = 0;
         precision_oonly=1;
      };
      MAUIslider2 order_slider {
         parent => <-.parent;
         value+nres => <-.<-.scatuni2d_params.order;
         title => "MAUNI_ORDER";
         x => dim1_slider.x;
         y => ((dim2_slider.y + dim2_slider.height) + 5);
         allwidth => dim2_slider.allwidth;
         height => dim2_slider.height;
         min =><-.<-.scatuni2d_params.order_min;
         max =><-.<-.scatuni2d_params.order_max;
         mode = "integer";
         decimalPoints = 0;
         precision_oonly=1;
      };
   };
   macro contour {
      group &in<NEportLevels={2,1}> {
         MAGDxform_templ &xform;
      } => <-.struct_in;
      MAdefaultMinMax MinMax<export_all=1> {
         input+nres => <-.in;
      };
      DefaultLinear Datamap<export_all=1> {
         dataMin+nres => <-.MinMax.min_value;
         dataMax+nres => <-.MinMax.max_value;
      };
      DefaultProps Props<export_all=1> {
         trans = 0.75;
      };
      MAdefaultObject Obj<NEportLevels={0,1},export_all=2> {
         input+nres => <-.in;
         dmap => <-.Datamap;
         xform => in.xform;
         props => <-.Props;
         objects+nres => <-.child_objs;
         name => name_of(<-.<-);
      };
      olink obj_out => .Obj;
   };
   macro sphere_glyph {
      ilink+nres fld_in => switch(<-.scatuni2d_params.preview,
                             <-.scat_in);
      MADVgeo_glyph glyph {
         in => <-.fld_in;
         glyph => {<-.sphere.combine_mesh_data.out};
         scale = 1.;
         color = {1.,1.,1.};
         normalize = 1;
      };
      olink obj_out => .DefaultObject;
      MAdefaultObject DefaultObject {
         input => <-.glyph.out;
         props => <-.DefaultProps;
      };
      macro sphere {
         ilink fld_in => <-.fld_in;
         link+nres max_range => (max_array(fld_in.coordinates.values) 
                               - min_array(fld_in.coordinates.values));
         link+nres rad => (max_array(.max_range) / 30);
         float radius => .rad;
         MADVradius_data radius_data {
            in_data => {<-.radius};
         };
         MADVpoint_mesh point_mesh {
            coord => <-.center_xyz.out;
         };
         MADVinterleave_3_arrays center_xyz {
            in1 = {0};
            in2 => .in1;
            in3 => .in1;
         };
         MADVcombine_mesh_and_data combine_mesh_data {
            in_mesh => <-.point_mesh.out;
            in_nd => <-.radius_data.out;
            out<NEportLevels={0,3}>;
         };
      };
      DefaultProps DefaultProps { col = {1.,0.,0.}; };
   };
   macro unif_bounds {
      ilink+nres fld_in => switch(<-.scatuni2d_params.preview,
                             <-.struct_in);
      MADVbounds bounds {
         in => <-.fld_in;
         hull = 1;
         edges = 1;
         faces = 0;
         imin = 0;
         imax = 0;
         jmin = 0;
         jmax = 0;
         kmin = 1;
         kmax = 0;
         data = 0;
         component = 0;
      };
      MAdefaultObject DefaultObject<NEportLevels={0,1}> {
         input => <-.bounds.out;
      };
      olink obj_out => .DefaultObject;
   };
 };
MAmacroUI MAscatuni3dUI {
   ilink scat_in;
   ilink struct_in;
   MAscatuni3d_params+IPort2 &scatuni3d_params;

   height => scatuni3d_panel.height;
   MAUIframe scatuni3d_panel {
      parent =><-.parent;
      y =><-.y;
      height => <-.interpolateUI.height + 5;
   };
   macro interpolateUI {
      ilink parent =><-.scatuni3d_panel;
      imlink obj_in => {<-.sphere_glyph.obj_out,
                        <-.orthoslice.obj_out,
                        <-.unif_bounds.obj_out};
      olink height => preview_frame.y + preview_frame.height;
      GMOD.instancer instancer {
         Value => preview_toggle.set;
         Group => preview; 
      };
      MAUIframe preview_frame {
         parent => <-.parent;
         x = 5;
         width = 220;
         height = 200;
         y => order_slider.y + order_slider.height + 10;
      };
      macro preview<instanced=0> {
         imlink obj_in => <-.obj_in;
         ilink parent => <-.preview_frame;
         ilink vis =><-.<-.scatuni3d_params.preview;
         DefaultLightOn DefaultLightOn;
         DefaultLightInfo DefaultLightInfo {
            lights => {<-.DefaultLightOn};
         };
         DefaultXform DefaultXform {
            mat = {
               0.71,0.30,-0.64,0.00,
              -0.70,0.31,-0.64,0.00,
               0.00,0.90, 0.43,0.00,
               0.00,0.00, 0.00,1.00
            };
         };
         MAdefaultCamera3D DefaultCamera3D {
            objects => {<-.GroupObject.obj};
            auto_norm = "Data and Object";
            norm_scale = 0.85;
            xform => <-.DefaultXform;
            from = {0.,0.,0.};
            up = {0.301498,0.308694, 0.902112};
            at = {0.636078,0.639706, -0.431487};
            scale = 1.0;
         };
         BestVirtPal BestVirtPal { gamma = 1.0; };
         MAdefaultView DefaultView {
            handle<NEportLevels={2,0}> => <-.UIrenderView.handle;
            virtpal<NEportLevels={2,0}> => <-.BestVirtPal;
            light_info<NEportLevels={2,0}> => <-.DefaultLightInfo;
            cameras<NEportLevels={2,0}> => {<-.DefaultCamera3D};
         };
         macro GroupObject<locked=0> {
            imlink child_objs => <-.obj_in;
            DefaultXform Xform {
               mat = {
                  5.6,0.0,0.0,0.0,
                  0.0,5.6,0.0,0.0,
                  0.0,0.0,5.6,0.0,
                  0.0,0.0,0.0,1.0
               };
            };
            MAdefaultObject Top<NEportLevels={0,1}> {
               dmap<export=0>;
               xform<export=0> => <-.Xform;
               props<export=0>;
               modes<export=0>;
               objects<export=0> => <-.child_objs;
               altobj<export=0>;
               name<export=2> => name_of(<-.<-);
               pick_info<export=0>;
               visible =><-.<-.vis;
            };
            olink obj => .Top;
         };
         UIrenderView UIrenderView {
            parent => <-.parent;
            x = 35;
            y = 35;
            width = 150;
            height => width;
          };
      };
      MAUItoggle preview_toggle {
         parent => <-.preview_frame;
         label => "MAUNI_PREVIEW";
         x = 5;
         y = 5;
         width = 100;
         set+nres =><-.<-.scatuni3d_params.preview;
      };
      MAUIslider2 dim1_slider {
         parent => <-.parent;
         value+nres => <-.<-.scatuni3d_params.dim1;
         title => "MAUNI_DIM1";
         x = 5;
         y = 5;
         allwidth = 220;
         min =><-.<-.scatuni3d_params.dim1_min;
         max =><-.<-.scatuni3d_params.dim1_max;
         mode = "integer";
         decimalPoints = 0;
         precision_oonly=1;
      };
      MAUIslider2 dim2_slider {
         parent => <-.parent;
         value+nres => <-.<-.scatuni3d_params.dim2;
         title => "MAUNI_DIM2";
         x => dim1_slider.x;
         y => ((dim1_slider.y + dim1_slider.height) + 5);
         allwidth => dim1_slider.allwidth;
         height => dim1_slider.height;
         min =><-.<-.scatuni3d_params.dim2_min;
         max =><-.<-.scatuni3d_params.dim2_max;
         mode = "integer";
         decimalPoints = 0;
         precision_oonly=1;
      };
      MAUIslider2 dim3_slider {
         parent => <-.parent;
         value+nres => <-.<-.scatuni3d_params.dim3;
         title => "MAUNI_DIM3";
         x => dim1_slider.x;
         y => ((dim2_slider.y + dim2_slider.height) + 5);
         allwidth => dim1_slider.allwidth;
         height => dim1_slider.height;
         min =><-.<-.scatuni3d_params.dim3_min;
         max =><-.<-.scatuni3d_params.dim3_max;
         mode = "integer";
         decimalPoints = 0;
         precision_oonly=1;
      };
      MAUIslider2 order_slider {
         parent => <-.parent;
         value+nres => <-.<-.scatuni3d_params.order;
         title => "MAUNI_ORDER";
         x => dim1_slider.x;
         y => ((dim3_slider.y + dim3_slider.height) + 5);
         allwidth => dim2_slider.allwidth;
         height => dim2_slider.height;
         min =><-.<-.scatuni3d_params.order_min;
         max =><-.<-.scatuni3d_params.order_max;
         mode = "integer";
         decimalPoints = 0;
         precision_oonly=1;
      };
   };
// START
   macro orthoslice {
      ilink+nres fld_in => switch(<-.scatuni3d_params.preview,
                                  <-.struct_in);
      olink obj_out => .DataObject.obj;
      MADVorthoslice_unif orthoslice_unif {
         in => <-.fld_in;
         axis = 2;
         plane => (in.dims[2] / 2);
      };
      macro DataObject<locked=0> {
         group &in<NEportLevels={2,1}> {
            MAGDxform_templ &xform;
         } => <-.orthoslice_unif.out;
         imlink child_objs;
         MAdefaultMinMax MinMax<export_all=1> {
            input => in;
         };
         DefaultLinear Datamap<export_all=1> {
            dataMin => MinMax.min_value;
            dataMax => MinMax.max_value;
         };
         MAdefaultObject Obj<NEportLevels={0,1},export_all=2> {
            input => in;
            dmap => Datamap;
            xform => in.xform;
            props => <-.DefaultProps;
            objects => child_objs;
            name => name_of(<-.<-);
         };
         olink obj => Obj;
         DefaultProps DefaultProps {
            trans = 0.75;
         };
      };
   };
// END
   macro sphere_glyph {
      ilink+nres fld_in => switch(<-.scatuni3d_params.preview,
                                  <-.scat_in);
      MADVgeo_glyph glyph {
         in => <-.fld_in;
         glyph => {<-.sphere.combine_mesh_data.out};
         scale = 1.;
         color = {1.,1.,1.};
         normalize = 1;
      };
      olink obj_out => .DefaultObject;
      MAdefaultObject DefaultObject {
         input => <-.glyph.out;
         props => <-.DefaultProps;
      };
      macro sphere {
         ilink fld_in => <-.fld_in;
         link+nres max_range => (max_array(fld_in.coordinates.values) 
                               - min_array(fld_in.coordinates.values));
         link+nres rad => (max_array(.max_range) / 30);
         float radius => .rad;
         MADVradius_data radius_data {
            in_data => {<-.radius};
         };
         MADVpoint_mesh point_mesh {
            coord => <-.center_xyz.out;
         };
         MADVinterleave_3_arrays center_xyz {
            in1 = {0};
            in2 => .in1;
            in3 => .in1;
         };
         MADVcombine_mesh_and_data combine_mesh_data {
            in_mesh => <-.point_mesh.out;
            in_nd => <-.radius_data.out;
            out<NEportLevels={0,3}>;
         };
      };
      DefaultProps DefaultProps {
         col = {1.,0.,0.};
      };
   };
   macro unif_bounds {
      ilink+nres fld_in => switch(<-.scatuni3d_params.preview,
                                  <-.struct_in);
      MADVbounds bounds {
         in => <-.fld_in;
         hull = 1;
         edges = 1;
         faces = 0;
         imin = 0;
         imax = 1;
         jmin = 0;
         jmax = 1;
         kmin = 1;
         kmax = 0;
         data = 0;
         component = 0;
      };
      MAdefaultObject DefaultObject<NEportLevels={0,1}> {
         input => <-.bounds.out;
      };
      olink obj_out => .DefaultObject;
   };
 };
