/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAstream.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAstream.v#1 $
*/
MAparams MAstream_params {
   int+IPort2   order		= 1;
   int+IPort2   forw_back	= 1;
   int+IPort2   nseg		= 2;
   int+IPort2   max_seg		= 256;
   int+IPort2   max_seg_min	= 0;
   int+IPort2   max_seg_max	= 10000;
   int+IPort2   stream_comp	= 0;
   float+IPort2 min_vel		= 0.0001;
   int+IPort2   color		= 1;
   int+IPort2   map_comp	= 0;
   int+IPort2   ribbons		= 0;
   float+IPort2 rib_width	= 1;
   float+IPort2 rib_angle	= 0;

   MAiline_Param iline_Param{
      width          = 64;
      height         = 64;
      illuminationOn = 0;
      IlluminationModel<NEnumColors=1, NEcolor0=0x00ff00> {
         Ka<animate=1>    = 0.1;	// ambient 0->1
         Kd<animate=1>    = 0.2;	// diffuse 0->1
         Ks<animate=1>    = 0.8;	// specular 0->1
         n<animate=1>     = 20;	// shininess 1->100
         p<animate=1>     = 3;	// phong modifier 1.2->8
         Trans<animate=1> = 1.0;	// Transparency 0->1
         Blend<animate=1> = 0.25;// Color Blending 0->1
      };
      HaloModel<NEnumColors=1, NEcolor0=0x00ff00> {
         haloWidth<animate=1> = 0;
         lineWidth<animate=1> = 1;
         doDepthMask          = 0;
         doAntialiasHalo      = 0;
         doSmoothShade        = 0;
      };
      AnimationEffect<NEnumColors=1, NEcolor0=0x00ff00> {
         animationOn              = 0;
         StairDash                = 0;	// 0 - stair  1 - dash
         StairType                = 0;	// 0 - down  1 - up  2 - up&down
         effectLength<animate=1>  = 1;
         effectSpacing<animate=1> = 1;
         TranspWidth              = 0;	// 0 - transparency  1 - width
         InverseEffect            = 0;	// 0 - normal  1 - inverse
         effectStep               = 0;
   };
};

   init_commands = "";
   reset_commands =
       "stream_params.order=1;"
      +"stream_params.forw_back=1;"
      +"stream_params.nseg=2;"
      +"stream_params.max_seg=256;"
      +"stream_params.max_seg_min=0;"
      +"stream_params.max_seg_max=10000;"
      +"stream_params.stream_comp=0;"
      +"stream_params.min_vel=0.0001;"
      +"stream_params.color=1;"
      +"stream_params.ribbons=0;"
      +"stream_params.rib_width=1;"
      +"stream_params.rib_angle=0;"
      +"stream_params.map_comp = 0;"
      +"stream_params.iline_Param.illuminationOn = 0;"
      +"stream_params.iline_Param.MAIlluminationModel.Ka = 0.1;"
      +"stream_params.iline_Param.MAIlluminationModel.Kd = 0.2;"
      +"stream_params.iline_Param.MAIlluminationModel.Ks = 0.8;"
      +"stream_params.iline_Param.MAIlluminationModel.n = 20.0;"
      +"stream_params.iline_Param.MAIlluminationModel.p = 3.0;"
      +"stream_params.iline_Param.MAIlluminationModel.Trans = 1.0;"
      +"stream_params.iline_Param.MAIlluminationModel.Blend = 0.25;"
      +"stream_params.iline_Param.HaloModel.haloWidth = 0;"
      +"stream_params.iline_Param.HaloModel.lineWidth = 1;"
      +"stream_params.iline_Param.HaloModel.doDepthMask = 0;"
      +"stream_params.iline_Param.HaloModel.doAntialiasHalo = 0;"
      +"stream_params.iline_Param.HaloModel.doSmoothShade = 0;"
      +"stream_params.iline_Param.AnimationEffect.animationOn = 0;"
      +"stream_params.iline_Param.AnimationEffect.StairDash = 0;"
      +"stream_params.iline_Param.AnimationEffect.StairType = 0;"
      +"stream_params.iline_Param.AnimationEffect.effectLength = 1;"
      +"stream_params.iline_Param.AnimationEffect.effectSpacing = 1;"
      +"stream_params.iline_Param.AnimationEffect.TranspWidth = 0;"
      +"stream_params.iline_Param.AnimationEffect.InverseEffect = 0;"
      +"stream_params.iline_Param.AnimationEffect.effectStep = 0;";
};

MAmacroUI MAstream_map_compUI{
   MAstream_params+IPort2 &stream_params;
   height => stream_map_comp_panel.height;
   MAUIframe stream_map_comp_panel {
      parent => <-.parent;
      y => <-.y;
      height =>map_comp_rbl.y + map_comp_rbl.height +15;
   };
   
   Mesh+Node_Data+IPort2 &fld_in;
   
   MADVnode_data_labels node_data_labels {
      in => <-.fld_in;
      labels[];
   };
   MAUItoggle stream_color_toggle {
      parent => <-.stream_map_comp_panel;
      y = 10;
      height = 20;
      set => <-.stream_params.color;
      label = "MASTRM_COL";
   };
   MAUIradioBoxLabel map_comp_rbl {
      labels => combine_array ({"MAVECTOR_MAGNITUDE"},<-.node_data_labels.labels);
      x = 5;
      y => <-.stream_color_toggle.y + <-.stream_color_toggle.height + 5;
      parent => <-.stream_map_comp_panel;
      title = "MAMAPCOMP_SEL";
      active => <-.stream_params.color;
      &selectedItem => <-.stream_params.map_comp;
   };
};
MAmacroUI MAstreamUI {
   MAstream_params+IPort2 &stream_params;

   height => stream_panel.height;
   MAUIframe stream_panel {
      parent => <-.parent;
      y => <-.y;
      height =>stream_max_seg_slider.y + stream_max_seg_slider.height +15;
   };
   MAUIradioBoxLabel stream_radiobox_label {
      parent => <-.stream_panel;
      x = 5;
      y = 5;
      height = 90;
      labels => {"MASTRM_BACK", "MASTRM_FOR"};
      title = "MASTRM_DIR";
      &selectedItem => <-.stream_params.forw_back;
   };
/*   MAUItoggle stream_color_toggle {
 *      parent => <-.stream_panel;
 *      y = 100;
 *      height = 20;
 *      set => <-.stream_params.color;
 *      label = "MASTRM_COL";
 *   };
 */
   MAUIslider stream_nseg_slider {
      parent => <-.stream_panel;
      y      = 100;
      min = 1;
      max = 16;
      value => <-.stream_params.nseg;
      mode = 1;
      title = "MASTRM_NSEG";
   };
   MAUIslider stream_order_slider {
      parent => <-.stream_panel;
      y => <-.stream_nseg_slider.y + <-.stream_nseg_slider.height + 5;
      min = 1;
      max = 4;
      value => <-.stream_params.order;
      mode = 1;
      title = "MASTRM_ORDER";
   };
   MAUIslider2 stream_max_seg_slider {
      parent => <-.stream_panel;
      x = 5;
      y => stream_order_slider.y + <-.stream_order_slider.height + 5;
      min => <-.stream_params.max_seg_min;
      max => <-.stream_params.max_seg_max;
      value => <-.stream_params.max_seg;
      mode = 1;
      decimalPoints = 0;
      precision_oonly = 1;
      title = "MASTRM_MAX_SEG";
      valEditor.UI.min_field.min=0;
   };
};

MAmodule MAstream {
   ilink fld_in2;
   ilink probe_in;
   MADVinterp_data interp_data{
      in => <-.fld_in2;
      probe => <-.stream.out;
      comps => init_array(.in.nnode_data,0,(.in.nnode_data - 1));
   };
   
   MADVextract_comp extract_comp {
      component => abs((<-.stream_params.map_comp - 1));
      in => <-.interp_data.out;
   };
   MAstream_params+IPort2 &stream_params;

   MADVstream stream {
      MAstream_params+IPort2 &stream_params => <-.stream_params;
      in => <-.fld_in;
      probe => <-.probe_in;
      order => stream_params.order;
      forw_back => stream_params.forw_back;
      nseg => stream_params.nseg;
      min_vel => stream_params.min_vel;
      max_seg => stream_params.max_seg;
      stream_comp => stream_params.stream_comp;
      ribbons => stream_params.ribbons;
      rib_width => stream_params.rib_width;
      rib_angle => stream_params.rib_angle;
   }; 
   MADVmagnitude magnitude {
      component = 0;
      &in => <-.stream.out;
   };

   fld_out+nosave;
   int index => (stream_params.color * (2 - (stream_params.map_comp == 0)));
   GMOD.parse_v set_fld_out{
      v_commands =>"$push \n"
                  + switch(<-.index + 1
                  ,"fld_out => stream.out;\n"
                  ,"fld_out => magnitude.out;\n"
                  ,"fld_out => extract_comp.out;\n")
                  +"$pop \n";
      trigger    => (is_valid(<-.fld_in) || <-.index);
      on_inst    = 0;
      relative   => <-.<-;
   };

};
