/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAuline.v#1 $
*/
MAparams MAuline_params {
   boolean+nosave  reset =;
   boolean         allnode = 0;
   boolean         line_vis = 1;
   boolean         rot_trans = 0;
   float           scale = 1.0;
   int             dim1 = 8;
   DefaultXform    xform;
   float           z_rot = 0.0;
   int             z_rot_deci = 0;
   float+nosave    def_x_trans =;
   float+nosave    def_y_trans =;
   float           x_trans =;
   float           y_trans =;
   int             x_trans_deci = 1;
   int             y_trans_deci = 1;
   init_commands  = "";
   reset_commands = 
      "uline_params.line_vis=1;"
     +"uline_params.allnode=0;"
     +"uline_params.rot_trans=0;"
     +"uline_params.scale=1;"
     +"uline_params.dim1=8;"
     +"uline_params.z_rot=0.0;"
     +"uline_params.z_rot_deci=1;"
     +"uline_params.x_trans=uline_params.def_x_trans;"
     +"uline_params.y_trans=uline_params.def_y_trans;"
     +"uline_params.x_trans_deci=1;"
     +"uline_params.y_trans_deci=1;"
     ;
};

MAmacroUI MAuline2dUI {
   MAuline_params+IPort2 &uline_params;
   Mesh+Node_Data+IPort2 &fld_in;
   float+nres min0_value => .fld_in.coordinates.min_vec[0];
   float+nres max0_value => .fld_in.coordinates.max_vec[0];
   float+nres min1_value => .fld_in.coordinates.min_vec[1];
   float+nres max1_value => .fld_in.coordinates.max_vec[1];

   height => uline_panel.height;
   MAUIframe uline_panel {
      parent => <-.parent;
      y => <-.y;
      height =>switch(<-.uline_params.allnode+1,
                      <-.line_reset.y + <-.line_reset.height + 10,
                      <-.allnode_toggle.y + <-.allnode_toggle.height + 10
                     );
   };
   MAUItoggle allnode_toggle {
      parent =><-.uline_panel;
      label = "MAFLINE_ALL";
      x = 5;
      y = 5;
      &set =><-.uline_params.allnode;
   };
   MAUItoggle line_toggle {
      parent =><-.uline_panel;
      label = "MAFLINE_VIS";
      visible => switch(<-.uline_params.allnode+1,1,0);
      x = 5;
      y =><-.allnode_toggle.y + <-.allnode_toggle.height + 5;
      &set =><-.uline_params.line_vis;
   };
   MAUIslider2 z_rot_slider {
      parent =><-.uline_panel;
      visible => switch(<-.uline_params.allnode+1,1,0);
      x = 5;
      y =><-.line_toggle.y + <-.line_toggle.height + 5;
      min = -180;
      max = 180;
      &value =><-.uline_params.z_rot;
      &decimalPoints =><-.uline_params.z_rot_deci;
      min_oonly = 1;
      max_oonly = 1;
      title = "MAFLINE_ROT";
   };
   MAUIslider2 x_trans_slider {
      parent =><-.uline_panel;
      visible => switch(<-.uline_params.allnode+1,1,0);
      x = 5;
      y =><-.z_rot_slider.y + <-.z_rot_slider.height + 5;
      &min => <-.min0_value;
      &max => <-.max0_value;
      &value =><-.uline_params.x_trans;
      &decimalPoints =><-.uline_params.x_trans_deci;
      title = "MAFLINE_XTRANS";
   };
   x_trans_slider y_trans_slider {
      y =><-.x_trans_slider.y + <-.x_trans_slider.height + 5;
      &min => <-.min1_value;
      &max => <-.max1_value;
      &value =><-.uline_params.y_trans;
      &decimalPoints =><-.uline_params.y_trans_deci;
      title = "MAFLINE_YTRANS";
   };
   MAUIlabel scale_label {
      parent =><-.uline_panel;
      visible => switch(<-.uline_params.allnode+1,1,0);
      x = 5;
      y =><-.y_trans_slider.y + <-.y_trans_slider.height + 15;
      width = 100;
      height = 25;
      label = "MAFLINE_SCALE";
      alignment = "right";
   };
   scale_label xdim_label {
      y =><-.scale_label.y + <-.scale_label.height + 5;
      label = "MAFLINE_XDIM";
   };
   MAUIfield scale_field {
      parent =><-.uline_panel;
      visible => switch(<-.uline_params.allnode+1,1,0);
      x = 130;
      y =><-.scale_label.y - 4;
      width = 80;
      height = 25;
      decimalPoints = 2;
      min = 0;
      &value =><-.uline_params.scale;
   };
   scale_field xdim_field {
      y =><-.xdim_label.y - 4;
      min = 2;
      decimalPoints = 0;
      &value =><-.uline_params.dim1;
   };
   MAUIbutton line_reset {
      parent =><-.uline_panel;
      visible => switch(<-.uline_params.allnode+1,1,0);
      x =5;
      y =><-.xdim_label.y + <-.xdim_label.height + 5;
      width = 220;
      height = 25;
      &do =><-.uline_params.reset;
      label = "MAFLINE_RESET_LINE";
   };
};

MAmodule MAuline2d {
   MAuline_params &uline_params<NEportLevels={2,1}>;
   Mesh+Node_Data &fld_in<NEportLevels={2,1}>;

   GMOD.copy_on_change set_line_vis {
      input   => !(<-.uline_params.allnode);
      output  => <-.uline_params.line_vis;
      on_inst = 0;
   };
   Line_Mesh uline {
      dims => {<-.uline_params.dim1};
      points+nres => { <-.fld_in.coordinates.min_vec[0],
                       <-.fld_in.coordinates.max_vec[0] };
      &xform => <-.uline_params.xform;
   };
   GMOD.parse_v ResetLine {
      v_commands => "$push -usr\n"
                   +"scale=1.0;"
                   +"dim1=8;"
                   +"z_rot=0.0;"
                   +"z_rot_deci=1;"
                   +"x_trans_deci=1;"
                   +"y_trans_deci=1;"
                   +"x_trans=def_x_trans;"
                   +"y_trans=def_y_trans;"
                   +"reset=0;"
                   +"$pop\n";
      trigger => <-.uline_params.reset;
      active => <-.uline_params.reset;
      on_inst = 0;
      relative => <-.uline_params;
   };
   MAset_param set_x_trans {
      trigger+nres  => is_valid(fld_in.coordinates.min_vec[0])
                      &is_valid(fld_in.coordinates.max_vec[0]);
      in_value+nres => fld_in.coordinates.min_vec[0];
      def_value     => <-.uline_params.def_x_trans;
      value         => <-.uline_params.x_trans;
   };
   MAset_param set_y_trans {
      trigger+nres  => is_valid(fld_in.coordinates.min_vec[1])
                      &is_valid(fld_in.coordinates.max_vec[1]);
      in_value+nres => (fld_in.coordinates.min_vec[1]
                       +fld_in.coordinates.max_vec[1]) * 0.5;
      def_value     => <-.uline_params.def_y_trans;
      value         => <-.uline_params.y_trans;
   };

   MAGDxform_edit+nosave XformEdit {
      scale => <-.uline_params.scale;
      //shell_vis => <-.uline_params.line_vis;
      absolute     = 1;
      xform        => <-.uline_params.xform;
      z_rot        => <-.uline_params.z_rot;
      /* v7.0 */
      /* x_trans+nres => <-.uline_params.x_trans - fld_in.coordinates.min_vec[0]; */
      x_trans+nres => <-.uline_params.x_trans;
      y_trans      => <-.uline_params.y_trans;
      z_trans+nres => (fld_in.coordinates.min_vec[2]
                      +fld_in.coordinates.max_vec[2]) * 0.5;
   };
   MAdataObject+nosave DataObject {
      ilink uline_params => <-.uline_params;
      in => <-.uline;
      Obj {
         xform   => <-.uline_params.xform;
         visible => <-.uline_params.line_vis;
         name    => "ME_LINE";
      };
   };
   fld_out       => switch(uline_params.allnode+1,uline,fld_in);
   olink obj_out => DataObject.obj;
};
