/*
			Copyright (c) 1998 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/funcs.v#1 $
*/
//
// Transform Functions for slice plane
//
module MAset_xform_bypick {
   boolean+read+notify+req trigger;
   float+read+nonotify+req p1[3];
   float+read+nonotify+req p2[3];
   float+read+nonotify+req p3[3];
   float+nonotify+req ori_cen[3] => xform.center;
   float+write+nonotify x_vec[3];
   float+write+nonotify y_vec[3];
   float+write+nonotify z_vec[3];
   DefaultXform+write+nonotify &xform<NEportLevels={2,0}>;
   omethod+req update = "MAset_bypick_update";
};
module MAset_xform_byvec {
   boolean+read+notify+req trigger;
   float+read+nonotify+req ori_cen[3] => xform.center;
   float+read+nonotify+req center[3];
   float+read+nonotify+req vector[3];
   float+write+nonotify x_vec[3];
   float+write+nonotify y_vec[3];
   float+write+nonotify z_vec[3];
   DefaultXform+write+nonotify &xform<NEportLevels={2,0}>;
   omethod+req update = "MAset_byvec_update";
};
module MAset_xyz_vec {
   DefaultXform+read+notify &xform<NEportLevels={2,0}>;
   float+write+nonotify x_vec[3];
   float+write+nonotify y_vec[3];
   float+write+nonotify z_vec[3];
   omethod+req update = "MAset_xyz_vec_update";
};
module MAset_local_xform {
   float+read+nonotify+req x_vec[3];
   float+read+nonotify+req y_vec[3];
   float+read+nonotify+req z_vec[3];
   float+read+notify+req trans_x;
   float+read+notify+req trans_y;
   float+read+notify+req trans_z;
   float+read+notify+req angle_x;
   float+read+notify+req angle_y;
   float+read+notify+req angle_z;
   DefaultXform+write+nonotify &xform<NEportLevels={2,0}>;
   omethod+req update = "MAset_local_update";
};
module MAset_local_axis_xform {
   boolean+read+notify+req active;
   float+read+notify+req x_vec[3];
   float+read+notify+req y_vec[3];
   float+read+notify+req z_vec[3];
   float+read+notify+req trans_x;
   float+read+notify+req trans_y;
   float+read+notify+req trans_z;
   float+read+notify+req scale;
   DefaultXform+write+nonotify xform<NEportLevels={0,2}>;
   omethod+req update = "MAset_local_axis_xform_update";
};
module MAhsv_to_argb {
   float  h_min;
   float  h_max;
   float  s_min;
   float  s_max;
   float  v_min;
   float  v_max;
   int    div;
   double d_min;
   double d_max;
   byte   argb[256][4];
   cxxmethod+req Update<use_src_file=0>
                       (.h_min+read+notify+req,
                        .h_max+read+notify+req,
                        .s_min+read+notify+req,
                        .s_max+read+notify+req,
                        .v_min+read+notify+req,
                        .v_max+read+notify+req,
                        .div+read+notify+req,
                        .d_min+read+notify+req,
                        .d_max+read+notify+req,
                        .argb+write+nonotify);
};
module MAtailed_advect {
   Mesh+Node_Data+IPort2 &in {
      nnodes+req;
      xform+nonotify;
   };
   float+IPort2 time;
   int direction;
   float+IPort2 start_time;
   float release_interval;
   float+IPort2 time_step_interval;
   int tracer_len;
   int+IPort2 tracer_style;
   int time_step_number;
   Mesh+Node_Data isolines { &xform+nowrite => in.xform; };
   Mesh+Node_Data new_probe { &xform+nowrite => in.xform; };
   Mesh+Node_Data+OPort2 out { &xform+nowrite => in.xform; };
   Mesh+Node_Data+OPort2 out_tracer { &xform+nowrite => in.xform; };
   omethod+req upd_advect(.in+read+notify+req,
                          .time+read+notify+req,
                          .direction+read+notify+req,
                          .start_time+read+notify+req,
                          .release_interval+read+notify+req,
                          .tracer_len+read+notify+req,
                          .tracer_style+read+notify+req,
                          .time_step_number+write,
                          .new_probe+write,
                          .out+write,
                          .out_tracer+write) = "MAtailed_advect_update";
};
//
// Downsize
//
module MADVdownsize_struct {
   Mesh_Struct+Node_Data+Iparam &in {
      xform+nonotify;
      nnodes+req;
   };
   float+Iparam factor[in.ndim];
   Mesh_Struct+Node_Data+Oparam out {
      &xform+nowrite => in.xform;
      node_data {
         &min+nres     => in.node_data[index_of(node_data)].min;
         &max+nres     => in.node_data[index_of(node_data)].max;
         &min_vec+nres => in.node_data[index_of(node_data)].min_vec;
         &max_vec+nres => in.node_data[index_of(node_data)].max_vec;
      };
   };
   method+notify_val+notify_inst update<status=1> = "MADVdownsize_update";
};

module MADVdownsize_unif {
   Mesh_Unif+Node_Data+Iparam &in {
      xform+nonotify;
      nnodes+req;
   };
   float+Iparam factor[in.ndim];
   Mesh_Unif+Node_Data+Oparam out {
      &xform+nowrite => in.xform;
      node_data {
         &min+nres     => in.node_data[index_of(node_data)].min;
         &max+nres     => in.node_data[index_of(node_data)].max;
         &min_vec+nres => in.node_data[index_of(node_data)].min_vec;
         &max_vec+nres => in.node_data[index_of(node_data)].max_vec;
      };
   };
   method+notify_val+notify_inst update<status=1> = "MADVdownsize_unif_update";
};

module MADVdownsize_rect {
   Mesh_Rect+Node_Data+Iparam &in {
      xform+nonotify;
      nnodes+req;
   };
   float+Iparam factor[in.ndim];
   Mesh_Rect+Node_Data+Oparam out {
      &xform+nowrite => in.xform;
      node_data {
         &min+nres     => in.node_data[index_of(node_data)].min;
         &max+nres     => in.node_data[index_of(node_data)].max;
         &min_vec+nres => in.node_data[index_of(node_data)].min_vec;
         &max_vec+nres => in.node_data[index_of(node_data)].max_vec;
      };
   };
   method+notify_val+notify_inst update<status=1> = "MADVdownsize_rect_update";
};

$include MicroAVS/DV/MAisolabel.v
