/*
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/minmax.v#1 $
*/
//
// UI for min/max level UI
// used by
//	MAcontou,v MAisolin.v
//
macro+nosave MADVminmaxLevelUI {
   ilink parent;
   ilink fld_in;
   int y = 5;
   int height => set_minmax_button.y + set_minmax_button.height;
   float+nres   min_value    => fld_in.node_data[0].min;
   float+nres   max_value    => fld_in.node_data[0].max;
   boolean+nres null_flag    => fld_in.node_data[0].null_flag;
   float+nres   null_value   => fld_in.node_data[0].null_value;
   float+nres   values[]     => fld_in.node_data[0].values;
   float+nres real_min_value => min_array({min_value,
      cache(min_array(magnitude(values), null_flag, null_value))});
   float+nres real_max_value => max_array({max_value,
      cache(max_array(magnitude(values), null_flag, null_value))});
   float level_min;
   float level_max;
   int level_min_deci;
   int level_max_deci;
   boolean fit = 0;

   MAUIlabel label {
      parent => <-.parent;
      x = 5;
      y => <-.y;
      label = "MACONT_DATA_LABEL";
   };
   MAUIslider2 min_slider {
      parent => <-.parent;
      x = 5;
       y => <-.label.y + <-.label.height + 5;
      min => <-.real_min_value;
      max => <-.real_max_value;
      value => <-.level_min;
      decimalPoints => <-.level_min_deci;
      title = "MACONT_MIN_LEV";
      min_oonly = 1;
      max_oonly = 1;
   };
   min_slider max_slider {
      y => <-.min_slider.y + <-.min_slider.height + 5;
      min => <-.real_min_value;
      max => <-.real_max_value;
      value => <-.level_max;
      decimalPoints => <-.level_max_deci;
      title = "MACONT_MAX_LEV";
   };
   MAUIbutton set_minmax_button {
      parent => <-.parent;
      y => <-.max_slider.y + <-.max_slider.height + 5;
      label = "MACONT_SET";
      do = 0; // init. zero
   };
   GMOD.copy_on_change set_fit {
      input => <-.fit;
      output => <-.set_minmax_button.do;
      on_inst = 0;
   };
   GMOD.parse_v set_minmax {
      v_commands =>  "$push -usr\n"
                   + "level_min=min_value;" 
                   + "level_max=max_value;" 
                   + "set_minmax_button.do=0;"
                   + "$pop\n";
      active  => .trigger;
      trigger => <-.set_minmax_button.do;
      relative => <-;
      on_inst = 0;
   };
   float+nres fix => 
      switch(1+(min_slider.value > max_slider.value),
             min_slider.value,
             max_slider.value);
   GMOD.copy_on_change copyfix {
      input   => <-.fix;
      output  => <-.min_slider.value;
      on_inst = 0;
   };
};
