/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Field/birdco.v#1 $
*/
MAnetwork FLDBirdCol3D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_BIRDCOLOR_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_BIRDCOLOR_T";
   Params {
      params.help_name = "bcol3d";
      params.name = "bird_col";
      MAdownsize_params downsize_params;
      MAorthoslice_params orthoslice_params;
      MAbird_color_params bird_color_params;
#ifdef MICROAVS_DEV_KIT
      MAs2t_params+nres &s2t_params => MicroAVScontroller.Params.ModuleParams.s2t_params;
#else
      MAs2t_params+nres &s2t_params => MicroAVS.Params.ModuleParams.s2t_params;
#endif //MICROAVS_DEV_KIT
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      /* s2t̓ZbgȂ*/
      init_params.init_commands => downsize_params.init_commands
                                 + orthoslice_params.init_commands
                                 + bird_color_params.init_commands
                                 + s2t_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => downsize_params.reset_commands
                                 + orthoslice_params.reset_commands
                                 + bird_color_params.reset_commands
                                 //+ s2t_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
/*
   GMOD.parse_v set_s2t_params {
      v_commands = "$push -usr\n"
                  +"s2t_params.s2t_on        = <-.env_params.scalar2texture.s2t_on;\n"
                  +"s2t_params.texture_size  = <-.env_params.scalar2texture.texture_size;\n"
                  +"$pop\n";
      trigger    => <-.Params.env_params.scalar2texture.s2t_on;
      relative   => <-.Params;
   };
*/
   Modules {
      MAdownsize MAdownsize {
         downsize_params =><-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
         fld_in =><-.fld_in;
      };
      MAorthoslice MAorthoslice {
         orthoslice_params =><-.<-.Params.orthoslice_params;
         fld_in =><-.MAdownsize.fld_out;
      };
      MAbird_color MAbird_color {
         bird_color_params =><-.<-.Params.bird_color_params;
         fld_in =><-.MAorthoslice.fld_out;
      };
      MAscalar2texture MAscalar2texture{
         s2t_params    => <-.<-.Params.s2t_params;
         fld_in        => <-.MAbird_color.fld_out;
         in_dmap       => <-.<-.DataObject.Datamap;
         colmap_params => <-.<-.Params.colmap_params;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in        => <-.MAscalar2texture.in;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out             => MAscalar2texture.fld_out;
      olink legend_out => .MAcmapLegendSet.legend_out;
      olink texture_out   => .MAscalar2texture.Dmap2Image.out;
   };
   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAdownsizeUI.height
               + MAorthosliceUI.height
               + MAbird_colorUI.height 
               + MAmaplegendUI.height
               + 5;
#ifdef OLDOLD
      MAmoduleCommonUI {
#ifdef MSDOS
         GMOD.copy_on_change set_noactive {
            input = 0;
            output =><-.active;
            copy_on_change<weight=3>;
         };
#endif //MSDOS
         boolean active = 0;
         save_button.active =><-.active;
      };
#endif //OLDOLD
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         downsize_params =><-.<-.Params.downsize_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAorthosliceUI MAorthosliceUI {
         fld_in =><-.<-.Modules.MAorthoslice.fld_in;
         parent => <-.parent;
         orthoslice_params =><-.<-.Params.orthoslice_params;
         y =><-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAbird_colorUI MAbird_colorUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         bird_color_params =><-.<-.Params.bird_color_params;
         y =><-.MAorthosliceUI.y + <-.MAorthosliceUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAbird_colorUI.y + <-.MAbird_colorUI.height;
         active => <-.<-.Params.bird_color_params.color;
      };
   };

/*  for MicroAVS 6.0 lݒ */
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_init_params {
     v_commands => "$push\n"
                  +switch((Params.env_params.surf_plot.scale < (-1)) + 1
                    , "Params.bird_color_params.scale_min   = -1;\n"
                    , "Params.bird_color_params.scale_min   = <-.env_params.surf_plot.scale;\n")
                  +switch((Params.env_params.surf_plot.scale > 1) + 1
                    , "Params.bird_color_params.scale_max   = 1;\n"
                    , "Params.bird_color_params.scale_max   = <-.env_params.surf_plot.scale;\n")
                  +switch((Params.env_params.surf_plot.offset < (-1)) + 1
                    , "Params.bird_color_params.offset_min   = -1;\n"
                    , "Params.bird_color_params.offset_min   = <-.env_params.surf_plot.offset;\n")
                  +switch((Params.env_params.surf_plot.offset > 1) + 1
                    , "Params.bird_color_params.offset_max   = 1;\n"
                    , "Params.bird_color_params.offset_max   = <-.env_params.surf_plot.offset;\n")
                  +"$pop\n"
                  +"$push\n"
                  +"Params.bird_color_params.scale  = <-.env_params.surf_plot.scale;\n"
                  +"Params.bird_color_params.offset = <-.env_params.surf_plot.offset;\n"
                  +"$pop\n"
                  +"$push\n"
                  +switch((strlen(Params.env_params.surf_plot.colormap) != 0) + 1
                    , "Params.colmap_params.rd_filename;\n"
                    , "Params.colmap_params.rd_filename = <-.env_params.surf_plot.colormap;\n"
                     +"Params.colmap_params.rd_ok       = 1;\n")
                  +"$pop\n"
                  +"$push\n"
                  +"get_init_params.active =  1;\n"
//                  +"MicroAVS.FLDBirdCol3D.get_init_params.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_rd_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_wt_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_init_params.active =  0;\n"
//                  +"MicroAVS.FLDBirdCol3D.set_init_params.active =  0;\n"
                  +"$pop\n";
     relative   => <-;
     trigger    => is_valid(<-.Modules.MAbird_color.fld_in);
     on_inst    = 0;
   };
   string+nres local_colormap => MicroAVScontroller.Params.env_params.surf_plot.colormap;
   GMOD.parse_v set_rd_filename {
     v_commands    => "local_colormap = Params.colmap_params.rd_filename;\n";
//     v_commands    => "Params.env_params.surf_plot.colormap = MicroAVS.FLDBirdCol3D.Params.colmap_params.rd_filename;\n";
     trigger+nres  => Params.colmap_params.rd_ok;
     relative+nres => <-.<-;
//     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v set_wt_filename {
     v_commands    => "local_colormap = Params.colmap_params.wt_filename;\n";
//     v_commands    => "Params.env_params.surf_plot.colormap = MicroAVS.FLDBirdCol3D.Params.colmap_params.wt_filename;\n";
     trigger+nres  => Params.colmap_params.wt_ok;
     relative+nres => <-.<-;
//     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v get_init_params {
     v_commands    => "$push\n"
                     +"MicroAVScontroller.Params.env_params.surf_plot.scale  =" + Params.bird_color_params.scale + ";\n"
                     +"MicroAVScontroller.Params.env_params.surf_plot.offset =" + Params.bird_color_params.offset + ";\n"
//                     +"Params.env_params.surf_plot.scale    = MicroAVS.FLDBirdCol3D.Params.bird_color_params.scale;\n"
//                     +"Params.env_params.surf_plot.offset   = MicroAVS.FLDBirdCol3D.Params.bird_color_params.offset;\n"
                     +"$pop\n"
                     +"$push\n"
                     +"MicroAVScontroller.Control.SetenvParams.setenv_params.Go =  1;\n"
//                     +"Control.SetenvParams.setenv_params.Go =  1;\n"
                     +"$pop\n";
     trigger+nres  => MicroAVScontroller.Params.params.env_params;
//     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
#endif //MICROAVS_DEV_KIT

/*  for MicroAVS 6.0 lݒ */

   DataObject{
      ilink in_texture => <-.Modules.texture_out;
      ilink def_fld    => <-.Modules.MAbird_color.fld_out;
      child_objs => {<-.Modules.legend_out};
      MinMax.input => <-.def_fld;
      MAdefaultTexture Texture{
         data => <-.in_texture;
      };
      Obj{
         texture   => switch(<-.<-.Params.s2t_params.s2t_on, <-.Texture);
      };
   };
};


MAnetwork FLDBirdCol2D
#ifdef MAVS_USE_USER_NAME
< user_name="ME_BIRDCOLOR_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_BIRDCOLOR_T";
   Params {
      params.help_name = "bcol2d";
      params.name = "bird_col";
      MAdownsize_params downsize_params;
      MAbird_color_params bird_color_params;
#ifdef MICROAVS_DEV_KIT
      MAs2t_params+nres &s2t_params => MicroAVScontroller.Params.ModuleParams.s2t_params;
#else
      MAs2t_params+nres &s2t_params => MicroAVS.Params.ModuleParams.s2t_params;
#endif //MICROAVS_DEV_KIT
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => downsize_params.init_commands
                                 + bird_color_params.init_commands
                                 + s2t_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => downsize_params.reset_commands
                                 + bird_color_params.reset_commands
                                 //+ s2t_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
/*
   GMOD.parse_v set_s2t_params {
      v_commands = "$push -usr\n"
                  +"s2t_params.s2t_on        = <-.env_params.scalar2texture.s2t_on;\n"
                  +"s2t_params.texture_size  = <-.env_params.scalar2texture.texture_size;\n"
                  +"$pop\n";
      trigger    => <-.Params.env_params.scalar2texture.s2t_on;
      relative   => <-.Params;
   };
*/
   Modules {
      MAdownsize MAdownsize {
         downsize_params =><-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
         fld_in =><-.fld_in;
      };
      MAbird_color MAbird_color {
         bird_color_params =><-.<-.Params.bird_color_params;
         fld_in =><-.MAdownsize.fld_out;
      };
      MAscalar2texture MAscalar2texture{
         s2t_params    => <-.<-.Params.s2t_params;
         fld_in        => <-.MAbird_color.fld_out;
         in_dmap       => <-.<-.DataObject.Datamap;
         colmap_params => <-.<-.Params.colmap_params;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in        => <-.MAscalar2texture.in;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out             => MAscalar2texture.fld_out;
      olink legend_out    => .MAcmapLegendSet.legend_out;
      olink texture_out   => .MAscalar2texture.Dmap2Image.out;
   };
   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAdownsizeUI.height
               + MAbird_colorUI.height 
               + MAmaplegendUI.height
               + 5;
#ifdef OLDOLD
      MAmoduleCommonUI {
#ifdef MSDOS
         GMOD.copy_on_change set_noactive {
            input = 0;
            output =><-.active;
            copy_on_change<weight=3>;
         };
#endif //MSDOS
         boolean active = 0;
         save_button.active =><-.active;
      };
#endif //OLDOLD
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         downsize_params =><-.<-.Params.downsize_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAbird_colorUI MAbird_colorUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         bird_color_params =><-.<-.Params.bird_color_params;
         y =><-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAbird_colorUI.y + <-.MAbird_colorUI.height;
         active => <-.<-.Params.bird_color_params.color;
      };
   };

/*  for MicroAVS 6.0 lݒ */
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_init_params {
     v_commands => "$push\n"
                  +switch((Params.env_params.surf_plot.scale < (-1)) + 1
                    , "Params.bird_color_params.scale_min   = 1;\n"
                    , "Params.bird_color_params.scale_min   = <-.env_params.surf_plot.scale;\n")
                  +switch((Params.env_params.surf_plot.scale > 1) + 1
                    , "Params.bird_color_params.scale_max   = 1;\n"
                    , "Params.bird_color_params.scale_max   = <-.env_params.surf_plot.scale;\n")
                  +switch((Params.env_params.surf_plot.offset < (-1)) + 1
                    , "Params.bird_color_params.offset_min   = -1;\n"
                    , "Params.bird_color_params.offset_min   = <-.env_params.surf_plot.offset;\n")
                  +switch((Params.env_params.surf_plot.offset > 1) + 1
                    , "Params.bird_color_params.offset_max   = 1;\n"
                    , "Params.bird_color_params.offset_max   = <-.env_params.surf_plot.offset;\n")
                  +"$pop\n"
                  +"$push\n"
                  +"Params.bird_color_params.scale  = <-.env_params.surf_plot.scale;\n"
                  +"Params.bird_color_params.offset = <-.env_params.surf_plot.offset;\n"
                  +"$pop\n"
                  +"$push\n"
                  +switch((strlen(Params.env_params.surf_plot.colormap) != 0) + 1
                    , "Params.colmap_params.rd_filename;\n"
                    , "Params.colmap_params.rd_filename = <-.env_params.surf_plot.colormap;\n"
                     +"Params.colmap_params.rd_ok       = 1;\n")
                  +"$pop\n"
                  +"$push\n"
                  +"MicroAVS.FLDBirdCol2D.get_init_params.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_rd_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_wt_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"MicroAVS.FLDBirdCol2D.set_init_params.active =  0;\n"
                  +"$pop\n";
     relative   => <-;
     trigger    => is_valid(<-.Modules.MAbird_color.fld_in);
     on_inst    = 0;
   };
   GMOD.parse_v set_rd_filename {
     v_commands    => "Params.env_params.surf_plot.colormap = MicroAVS.FLDBirdCol2D.Params.colmap_params.rd_filename;\n";
     trigger+nres  => Params.colmap_params.rd_ok;
     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v set_wt_filename {
     v_commands    => "Params.env_params.surf_plot.colormap = MicroAVS.FLDBirdCol2D.Params.colmap_params.wt_filename;\n";
     trigger+nres  => Params.colmap_params.wt_ok;
     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v get_init_params {
     v_commands    => "$push\n"
                     +"Params.env_params.surf_plot.scale  = MicroAVS.FLDBirdCol2D.Params.bird_color_params.scale;\n"
                     +"Params.env_params.surf_plot.offset = MicroAVS.FLDBirdCol2D.Params.bird_color_params.offset;\n"
                     +"$pop\n"
                     +"$push\n"
                     +"Control.SetenvParams.setenv_params.Go =  1;\n"
                     +"$pop\n";
     trigger+nres  => MicroAVScontroller.Params.params.env_params;
     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
#endif //MICROAVS_DEV_KIT

/*  for MicroAVS 6.0 lݒ */


   DataObject{
      ilink in_texture => <-.Modules.texture_out;
      ilink def_fld    => <-.Modules.MAbird_color.fld_out;
      child_objs => {<-.Modules.legend_out};
      MinMax.input => <-.def_fld;
      MAdefaultTexture Texture{
         data => <-.in_texture;
      };
      Obj{
         texture   => switch(<-.<-.Params.s2t_params.s2t_on, <-.Texture);
      };
   };
};
