/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Field/brick3d.v#1 $"
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under CVS control at KGT in:
	$Source:$
*/
MAnetwork FLDBrick3D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_BRICK3D_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_BRICK3D_T";
   Params {
      params.help_name = "brick3d";
      params.name = "brick3d";
      MAdownsize_params downsize_params;
      MAbrick3D_params brick3D_params;
      MAextract_scalar_params extract_scalar_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => downsize_params.init_commands
                                 + extract_scalar_params.init_commands
                                 + brick3D_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => downsize_params.reset_commands 
                                 + extract_scalar_params.reset_commands
                                 + brick3D_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MAdownsize MAdownsize {
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
      };
      MAextract_scalar MAextract_scalar {
         fld_in =><-.MAdownsize.fld_out;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAbrick3D MAbrick3D {
         fld_in => <-.MAextract_scalar.fld_out;
         brick3D_params =><-.<-.Params.brick3D_params;
      };
      MAcmapBrickLegendSet MAcmapLegendSet {
         fld_in => <-.MAextract_scalar.fld_out;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      olink colormap_out => .MAcmapLegendSet.colormap_out;
      olink legend_out => .MAcmapLegendSet.legend_out;
      fld_out => MAbrick3D.fld_out;
   };
   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAdownsizeUI.height
               + MAextract_scalarUI.height
               + MAbrick3DUI.height
               + MAmaplegendUI.height
               + 5;
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAextract_scalarUI MAextract_scalarUI {
         parent => <-.parent;
         fld_in =><-.fld_in;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAbrick3DUI MAbrick3DUI {
         parent => <-.parent;
         fld_in => <-.<-.Modules.MAextract_scalar.fld_out;
         brick3D_params =><-.<-.Params.brick3D_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAbrick3DUI.y + <-.MAbrick3DUI.height;
         //active => <-.<-.Params.brick3D_params.color;
      };
   };
   DataObject {
      MAdefaultTexture Texture {
         data => <-.<-.fld_in;
         colormap { nnodes = 256; nnode_data = 1;
            !node_data[0] { veclen = 4;
                values => <-.<-.<-.<-.Modules.colormap_out.node_data[0].values;
            };
         };
      };
      Obj.texture => Texture;
   };
   DataObject.child_objs => {<-.Modules.legend_out};
};
