/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Field/isosur.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Field/isosur.v#1 $
*/
MAnetwork FLDIsosurf
#ifdef MAVS_USE_USER_NAME
< user_name="ME_ISOSURF_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_ISOSURF_T";

   ilink-nosave+IPort2+nres in_pick;
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_in_pick {
      on_inst    =  1;
      active     =  1;
      relative   => <-;
      v_commands => "$push\n in_pick => <-.MAviewer.picked_obj;\n $pop\n";
    };
#endif //MICROAVS_DEV_KIT
   Params {
      params.help_name = "isosurf";
      params.name = "isosurf";
      MAdownsize_params downsize_params;
      MAisosurface_params isosurface_params;
#ifdef MICROAVS_DEV_KIT
      MAs2t_params+nres &s2t_params => MicroAVScontroller.Params.ModuleParams.s2t_params;
#else
      MAs2t_params+nres &s2t_params => MicroAVS.Params.ModuleParams.s2t_params;
#endif //MICROAVS_DEV_KIT
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      MAcut_plane_params cut_plane_params;
      init_params.init_commands => downsize_params.init_commands
                                 + isosurface_params.init_commands
                                 + s2t_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => downsize_params.reset_commands 
                                 + isosurface_params.reset_commands
                                 //+ s2t_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
/*
   GMOD.parse_v set_s2t_params {
      v_commands = "$push -usr\n"
                  +"s2t_params.s2t_on        = <-.env_params.scalar2texture.s2t_on;\n"
                  +"s2t_params.texture_size  = <-.env_params.scalar2texture.texture_size;\n"
                  +"$pop\n";
      trigger    => <-.Params.env_params.scalar2texture.s2t_on;
      relative   => <-.Params;
   };
*/
   Modules {
      MAdownsize MAdownsize {
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
      };
      MAisosurface MAisosurface {
         fld_in =><-.MAdownsize.fld_out;
         isosurface_params =><-.<-.Params.isosurface_params;
      };
   /*  for MicroAVS5.0 cut_plane */

      ilink+nres in_pick<export=1> => <-.in_pick;
      MAcut_plane_params &cut_plane_params => Params.cut_plane_params;
      MAcut_plane MAcut_plane{                          /* f[^Jbg郂W[ */
         in_field => MAisosurface.fld_out;
         in_pick  => <-.in_pick;
         cut_plane_params => <-.<-.Params.cut_plane_params;
      };
      olink+nres plane_axis_obj => MAcut_plane.plane_axis_obj;

   /*  for MicroAVS5.0 cut_plane */
      MAscalar2texture MAscalar2texture{
         s2t_params    => <-.<-.Params.s2t_params;
         fld_in        => <-.MAcut_plane.out_fld;
         in_dmap       => <-.<-.DataObject.Datamap;
         colmap_params => <-.<-.Params.colmap_params;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in        => <-.MAscalar2texture.in;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out           => MAscalar2texture.fld_out;
      olink legend_out  => MAcmapLegendSet.legend_out;
      olink texture_out => .MAscalar2texture.Dmap2Image.out;
   };
   UI {
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAdownsizeUI.height
               + MAisosurfaceUI.height
               + MAmaplegendUI.height
               + 5;
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAisosurfaceUI MAisosurfaceUI {
         parent => <-.parent;
         fld_in =><-.<-.Modules.MAisosurface.fld_in;
         isosurface_params =><-.<-.Params.isosurface_params;
         y =><-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         active =><-.<-.Params.isosurface_params.color;
         y =><-.MAisosurfaceUI.y + <-.MAisosurfaceUI.height;
      };
   };

/*  for MicroAVS 6.0 lݒ */

#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_init_params {
     v_commands => "$push\n"
                  +switch(is_valid(<-.Params.env_params.iso_surface.level) + 1
                         ," "
                         ,"Params.isosurface_params.level = <-.env_params.iso_surface.level;\n")
                  +"$pop\n"
                  +"$push\n"
                  +switch((strlen(Params.env_params.iso_surface.colormap) != 0) + 1
                    , "Params.colmap_params.rd_filename;\n"
                    , "Params.colmap_params.rd_filename = <-.env_params.iso_surface.colormap;\n"
                     +"Params.colmap_params.rd_ok       = 1;\n")
                  +"$pop\n"
                  +"$push\n"
                  +"get_init_params.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_rd_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_wt_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_init_params.active =  0;\n"
                  +"$pop\n";
     relative   => <-;
     trigger    => is_valid(<-.Modules.MAisosurface.fld_in);
     on_inst    = 0;
   };
   string+nres local_colormap => MicroAVScontroller.Params.env_params.iso_surface.colormap;
   GMOD.parse_v set_rd_filename {
     v_commands    => "local_colormap = Params.colmap_params.rd_filename;\n";
     trigger+nres  => Params.colmap_params.rd_ok;
     relative+nres => <-.<-;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v set_wt_filename {
     v_commands    => "local_colormap = Params.colmap_params.wt_filename;\n";
     trigger+nres  => Params.colmap_params.wt_ok;
     relative+nres => <-.<-;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v get_init_params {
     v_commands    => "$push\n"
                     +"MicroAVScontroller.Params.env_params.iso_surface.level =" + Params.isosurface_params.level + ";\n"
                     +"$pop\n"
                     +"$push\n"
                     +"MicroAVScontroller.Control.SetenvParams.setenv_params.Go =  1;\n"
                     +"$pop\n";
     trigger+nres  => MicroAVScontroller.Params.params.env_params;
//     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
#endif //MICROAVS_DEV_KIT

/*  for MicroAVS 6.0 lݒ */


   DataObject{
      ilink in_texture => <-.Modules.texture_out;
      ilink def_fld    => <-.Modules.MAcut_plane.out_fld;
      MAcut_plane_params &cut_plane_params => <-.Modules.MAcut_plane.cut_plane_params;
      child_objs => 
      switch(Params.isosurface_params.color + 1
            , {<-.Modules.MAcut_plane.plane_axis_obj}
            , {<-.Modules.MAcut_plane.plane_axis_obj, <-.Modules.legend_out});
      MinMax.input => <-.def_fld;
      MAdefaultTexture Texture{
         data => <-.in_texture;
      };
      Obj{
         &cut_plane_params => <-.cut_plane_params;
         texture   => switch(<-.<-.Params.s2t_params.s2t_on, <-.Texture);
      };
   };
};
