/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Field/volren.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Field/volren.v#1 $
*/
MAnetwork FLDVolren
#ifdef MAVS_USE_USER_NAME
< user_name="ME_VOLREN_T",locked=0 >
#else
< locked=0 >
#endif // MAVS_USE_USER_NAME
{
   -DataObject;
   title = "ME_VOLREN_T";
   Params {
      params.help_name = "volren";
      params.name = "volren";
      MAdownsize_params downsize_params;
      MAextract_scalar_params extract_scalar_params;
      MAvolren_params volren_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => downsize_params.init_commands
                                 + extract_scalar_params.init_commands
                                 + volren_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => downsize_params.reset_commands
                                 + extract_scalar_params.reset_commands
                                 + volren_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
//
// Redefine Volume Rendering DataObject
//
   macro DataObject<locked=0> {
      group &in<NEportLevels={2,1},NEnumColors=4,NEcolor0=0xff> {
         GDxform_templ &xform;
         method render;
      } => <-.Modules.fld_out;
      imlink child_objs => { <-.Modules.legend_out };
      DefaultProps Props { inherit = 0; };
      DefaultModes Modes { mode = {0,0,0,3,0}; };
      VolumeRender+nosave VolRenderDatamap {
         /********* v6.0 2002.01.22 
         change dataMin+nres =><-. in.node_data[0].min;
         dataMax+nres =><-. in.node_data[0].max;
         **************/
         dataMin+nres => <-.MinMax.min_value;
         dataMax+nres => <-.MinMax.max_value;
         DataRange = {
            {
               UIMaxValue=128.,,,,,,,,,,,,
            },};
      };
      DefaultPickInfo PickInfo;
      MAaltObject InvisibleAltObj {
         alt_in => <-.in;
         Obj.visible = 0;
      };
      MAdefaultObject Obj {
         input+nres => <-.in;
         dmap => <-.VolRenderDatamap;
         xform+nres => in.xform;
         props => <-.Props;
         modes => <-.Modes;
         objects => <-.child_objs;
         use_altobj = 1;
         altobj => <-.InvisibleAltObj.obj;
         name => <-.<-.title;
         pick_info => <-.PickInfo;
         // added by sugino 97.8.16
         visible =><-.<-.params.obj_vis;
         //
      };
      olink obj => .Obj;
   };
   DataObject {
      /********** v6.0 2002.01.22 add ********/
         MAdefaultMinMax MinMax {
         input => <-.in;
         min_value =;
         max_value =;
      };
      /********** end v6.0 2002.01.22 add ********/
      Props.fat_ray => !(<-.<-.Params.volren_params.smooth);
      /***  v6.0
      VolRenderDatamap {
         !DataRange[0] {
             selectAlphaRange=> !(<-.<-.<-.Params.volren_params.model);
             UIMaxValue =><-.<-.<-.Params.volren_params.border;
             !controlPoints[0] {v1 =><-.<-.<-.Params.volren_params.low_min;};
             !controlPoints[1] {v1 =><-.<-.<-.Params.volren_params.low_max;};
         };
         !DataRange[1] {
             selectAlphaRange=> !(<-.<-.<-.Params.volren_params.model);
             !controlPoints[0] {v1 =><-.<-.<-.Params.volren_params.high_min;};
             !controlPoints[1] {v1 =><-.<-.<-.Params.volren_params.high_max;};
         };
      };
     end v6.0***/
   };
   Modules {
      obj_in =><-.DataObject.obj;
      MAdownsize MAdownsize {
         fld_in =><-.fld_in;
         downsize_params =><-.<-.Params.downsize_params;
         params =><-.<-.Params.params;
      };
      MAextract_scalar MAextract_scalar {
         fld_in =><-.MAdownsize.fld_out;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAvolren MAvolren {
         volren_params =><-.<-.Params.volren_params;
         fld_in =><-.MAextract_scalar.fld_out;
      };
      MAcmapVolLegendSet MAcmapVolLegendSet {
         fld_in => <-.MAvolren.fld_out;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
         /*** v6.0 add ***/
         MAcolmap{
            volren_params=> <-.<-.<-.Params.volren_params;
         };
         /*** end v6.0 ***/
      };
      fld_out => MAvolren.fld_out;
      olink legend_out => .MAcmapVolLegendSet.legend_out;
   };
   UI {
      ilink obj_in =><-.DataObject.obj;
      help_path = "/fld";
      height => MAmoduleCommonUI.height
               + MAdownsizeUI.height
               + MAextract_scalarUI.height
               + MAvolrenUI.height 
               + MAmaplegendUI.height
               + 5;
      MAmoduleCommonUI {
#ifdef MSDOS
         GMOD.copy_on_change set_noactive {
            input = 0;
            output =><-.active;
            copy_on_change<weight=3>;
         };
#endif //MSDOS
         boolean active = 0;
         save_button.active =><-.active; 
      }; 
      MAdownsizeUI MAdownsizeUI {
         parent => <-.parent;
         downsize_params =><-.<-.Params.downsize_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAextract_scalarUI MAextract_scalarUI {
         fld_in =><-.<-.Modules.MAextract_scalar.fld_in;
         parent => <-.parent;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAdownsizeUI.y + <-.MAdownsizeUI.height;
      };
      MAvolrenUI MAvolrenUI {
         obj_in =><-.obj_in;
         parent => <-.parent;
         volren_params =><-.<-.Params.volren_params;
         /*** v6.0 2002.01.22 add ***/
         colmap_params => <-.<-.Params.colmap_params;
         /*** end v6.0 2002.01.22 add ***/
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAvolrenUI.y + <-.MAvolrenUI.height;
      };
   };

/*  for MicroAVS 6.0 lݒ */

#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_init_params {
     v_commands => "$push\n"
                  +switch(is_valid(<-.Params.env_params.volume_render.border) + 1
                         ," "
                         ,"Params.volren_params.border   = <-.env_params.volume_render.border;\n")
                  +"Params.volren_params.low_min  = <-.env_params.volume_render.low_min;\n"
                  +"Params.volren_params.low_max  = <-.env_params.volume_render.low_max;\n"
                  +"Params.volren_params.high_min = <-.env_params.volume_render.high_min;\n"
                  +"Params.volren_params.high_max = <-.env_params.volume_render.high_max;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"get_init_params.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_init_params.active =  0;\n"
                  +"$pop\n";
     relative   => <-;
     trigger    => is_valid(<-.Modules.MAvolren.fld_in);
     on_inst    = 0;
   };
   GMOD.parse_v get_init_params {
     v_commands    => "$push\n"
                     +"MicroAVScontroller.Params.env_params.volume_render.border   =" + Params.volren_params.border + ";\n"
                     +"MicroAVScontroller.Params.env_params.volume_render.low_min  =" + Params.volren_params.low_min + ";\n"
                     +"MicroAVScontroller.Params.env_params.volume_render.low_max  =" + Params.volren_params.low_max + ";\n"
                     +"MicroAVScontroller.Params.env_params.volume_render.high_min =" + Params.volren_params.high_min + ";\n"
                     +"MicroAVScontroller.Params.env_params.volume_render.high_max =" + Params.volren_params.high_max + ";\n"
                     +"$pop\n"
                     +"$push\n"
                     +"MicroAVScontroller.Control.SetenvParams.setenv_params.Go =  1;\n"
                     +"$pop\n";
     trigger+nres  => MicroAVScontroller.Params.params.env_params;
//     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
#endif //MICROAVS_DEV_KIT

/*  for MicroAVS 6.0 lݒ */

};
