/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Funcs/readers.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Funcs/readers.v#1 $
*/
//
// MicroAVS Readers
//
group+nosave MAfilename_to_type
{
   string+Iparam &filename;
   string+Iparam &modules[];
   string+Iparam &executables[];
   string+Iparam &file_suffixes[];
   string+Iparam &data_types[];
   string+Iparam &comments[];
   string+Iparam &helps[];
   group &options;
   string+Oparam module;
   string+Oparam executable;
   string+Oparam file_suffix;
   string+Oparam data_type;
   string+Oparam help;
   string+Oparam ok_filename;
   string+Oparam basename;
   int+Oparam    data_type_index;
   string+Oparam comment;
   boolean+read+nonotify &require; //check of kind_of_data_type, when re-read
   int+Oparam    err_no;
   int+Oparam    current; // data type config
   int+Oparam    old_one; // data type config old one
   omethod+notify_val update = "MAfilename_to_type_update";
};

module+nosave MA_plug_in_reader
   < // for geom functions
#ifdef AC_KIT_V1
      link_files   = "-lgeom -lutil -lac -lacvt"
#else
      link_files   = "-lgeom -lutil -lackit -lacvt"
#endif // AC_KIT_V1
   >
{
   string+Iparam    &module = "builtin";
   string+Iparam    &executable = "";
   string+Iparam    &data_type;
   string+Iparam    &filename;
   boolean+opt+read &portable;
   boolean+opt+read &swap;
   boolean+opt+read &flip;
   int+Oparam       err_no;
   int+Oparam+read  done;
   portable<NEvisible=0>;
   swap<NEvisible=0>;
   flip<NEvisible=0>;
   // out;
   ptr+nonotify+read+write func_ptr<NEvisible=0>;
   omethod+notify_inst  instance<NEvisible=0,status=1> = "MAreader_instance";
   omethod+notify_val   update<NEvisible=0,status=1>   = "MAreader_update";
   method+notify_deinst delete<NEvisible=0>            = "MAreader_delete";
};

module+nosave MAcheck_data {
   prim+Iparam                 &trigger;
   string+IPort2+req+nonotify  &module = "builtin";
   string+IPort2+req+nonotify  &executable = "";
   string+IPort2+req+nonotify  &data_type;
   string+IPort2+req+nonotify  &filename;
   int+Oparam                  err_no;
   int+Oparam                  config;
   omethod+notify_val update<status=1> = "MAcheck_data_update";
};

MA_plug_in_reader MAimage_reader {
   data_type = "image";
   boolean+Iparam flip = 0;
   flip<NEvisible=1>;
   Field_Unif+Dim2+Space2+Oparam out { xform.rspace = 2; };
};
MA_plug_in_reader MAfield_reader {
   data_type = "field";
   boolean+Iparam portable = 1;
   boolean+Iparam swap = 0;
   boolean+Iparam flip = 0;
   Mesh_Struct+Node_Data+Oparam &out;
   portable<NEvisible=1>;
   swap<NEvisible=1>;
   int+read+write+notify stepno;
   int+read+write+nonotify nsteps = 0;
   string+write+nonotify time_string = "";

/* for MicroAVS5.0 */

        int+read+write+notify ndim;
        int+read+write+notify check;
        int+read+write+notify min0;
        int+read+write+notify min1;
        int+read+write+notify min2;
        int+read+write+notify max0;
        int+read+write+notify max1;
        int+read+write+notify max2;
        float+read+write+notify factor0;
        float+read+write+notify factor1;
        float+read+write+notify factor2;
        int+read+write+notify end0;
        int+read+write+notify end1;
        int+read+write+notify end2;
        int+read+write+notify set;
        int+read+write+notify exec;

/* for MicroAVS5.0 */

   ptr+read+write+nonotify local_ptr<NEvisible=0> = 0;
   ptr+read+write+nonotify coord_ptr<NEvisible=0> = 0;
   int+read+write+nonotify file_offset<NEvisible=0> = 0;

   update(filename, portable, swap, flip, stepno, store_all);

   // not supported yet store_all
   int+read store_all<NEvisible=0>;
   Time_Mesh_Struct+Time_Node_Data+Oparam &out_all<NEvisible=0> {
      nsteps+opt;
      time+opt;
      time_coordinates+opt;
      time_node_data+opt;
      nnode_data+opt;
   };
};
MA_plug_in_reader MAucd_reader {
   data_type = "ucd";
   Mesh+Cell_Data+Node_Data+Oparam out;

   int+read+write+notify current_step;
   int+read+write+nonotify total = 0;
   string+write+nonotify step_title = "";
   string+read+write cycle_type = 0;
   int+read+write new_format = 0;
   ptr+read+write file_pos<NEvisible=0> = 0;
   ptr+read+write top<NEvisible=0> = 0;

   update(filename, current_step, store_all);

   // not supported yet store_all
   boolean+read store_all<NEvisible=0>;
   ptr+read+write all_comments<NEvisible=0> = 0;
   Time_Mesh+Time_Cell_Data+Time_Node_Data+Oparam out_all<NEvisible=0>;
};
MA_plug_in_reader MAgeom_reader {
   data_type = "geom";
   int+Oparam    one_obj = 1;	// 1: one obj; 0: multiple objs
   string+Oparam names[];
   Field+Oparam  out { int ndim = 3; };
   Field+Oparam  fields[];
};

MA_plug_in_reader MAmvgeo_reader {
   data_type = "mvgeo";
   int+Oparam one_obj;
   int+write+nonotify     color_size = 256;
   boolean+write+nonotify select_values = 0;
   double+write+nonotify  curmin = 0.0;
   double+write+nonotify  curmax = 255.0;
   double+write+nonotify  min_col_val = 0.0;
   double+write+nonotify  max_col_val = 255.0;
   double+write+nonotify  min_h = 0.67;
   double+write+nonotify  min_s = 1.00;
   double+write+nonotify  min_v = 1.00;
   double+write+nonotify  max_h = 0.00;
   double+write+nonotify  max_s = 1.00;
   double+write+nonotify  max_v = 1.00;
   olink out;
};
//
// Check 3 status
//
module MAcheck3 {
   string+nonotify+read+write old_old_type =; // to keep previous type
   string+nonotify+read+write old_type =; // to keep previous type
   string+Iparam              &new_type =;
   int+opt+read               &cancel;
   int+opt+read               &delete;
   int+nonotify+read          &empty;
   int+Oparam    status; //1:Add /2:Delete/Cancel /3:Add/Delete/Cancel
   omethod+notify_val update<status=1> = "MAcheck3_update";
};

//
// Gaussian CUBE data reader
//
MA_plug_in_reader  MAcube_reader {
   data_type = "cube";
   Field_Struct+Oparam out;
};

//
// Ball(Sphere) Geometry for Gaussian and PDB reader;
//
Mesh+Space3+Scalar+Node_Data_Float Ball {
   ncell_sets = 1;
   cell_set+Point {
      ncells => <-.nnodes;
      node_connect_list => init_array(ncells, 0, ncells-1);
   };
   nnode_data = 2;
   node_data = {
      {veclen = 1,id = 668}, //values = Radius
      {veclen = 3,id = 667}  //values = RGB
   };
};
//
// PDB reader
//
MA_plug_in_reader  MApdb_reader {
   data_type = "pdb";
   int+read+nonotify    &cpk = 0;	// 0:ball&stick/1:ball
   int+read+nonotify    &rad_type = 0;	//0:vdw/1:ion/2:user/[3:constant]
   float+read+nonotify  &factor = 0.2;
   float+write+nonotify VdwRadius[];
   float+write+nonotify IonRadius[];
   float+write+nonotify UsrRadius[];
   float+write+nonotify const_radius;
   float+write+nonotify radius[Balls.nnodes]
                           => switch(rad_type+1,
                                     VdwRadius * factor,
                                     IonRadius * factor,
                                     UsrRadius * factor,
                                     const_radius);
   Ball+Oparam          Balls { !node_data[0] { values => <-.<-.radius; }; };
   Mesh_Lines_3D+Oparam Sticks {
      node_data.id = 667; // RGB
   };
   TextField+Oparam     TextField {
      text_values => switch(<-.num_flag + 1,
                            <-.atom_symbols, <-.atom_symbols_and_num);
   };
   boolean+read+nonotify  &num_flag = 0;
   string+write+nonotify  atom_symbols[];
   string+write+nonotify  atom_symbols_and_num[];
   string+write+nonotify  atom_table_file;
};

//
// Gaussian LOG data reader
//
MApdb_reader MAlog_reader {
   data_type = "log";
};

//
// LightWave3D Model data reader
//
MA_plug_in_reader  MAlwo_reader {
   data_type = "lwo";
   string+Oparam      name;
   Field+write+Oparam fields[];
};

//
// MGF (MicroAVS Geometroy ASCII Format) reader
//
MA_plug_in_reader  MAmgf_reader
<
need_objs =
"GDM.DefaultObject
 DefaultProps
 DefaultModes
 DefaultPickInfo
 GDM.DefaultTexture
 Field
 MAGD.MAdefaultObject
 FLD
"
>
{
   data_type = "mgf";
   int+read+write+notify    current_step;
   int+write+nonotify       total;
   boolean+write+nonotify   new_format;
   ptr+read+write+nonotify  file_pos<NEvisible=0> = 0;
   int+read+write+nonotify  convertor_id<NEvisible=0> = -999;
   ptr+read+write+nonotify  edit_list<NEvisible=0> = 0;
   string+write+nonotify    step_title<NEportLevels={0,2}>;
   MAdefaultObject+nonotify Top<NEportLevels={0,2}>;

   update(filename, current_step);
};
