/*
			Copyright (c) 1998 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/axiscord.v#1 $
*/
//
// Axis Editor
//
MAparams MAaxiscoord_editor_params {
    boolean axis_vis = 1;
    float   x_pos = 0;
    float   y_pos = 0;
    float   z_pos = 0;
    boolean+nosave list_update;
    group+nosave &top_extent {
       double xmin;
       double ymin;
       double zmin;
       double xmax;
       double ymax;
       double zmax;
    };
    group+nosave def_axis_pars {
       double min[3]  =>
          { <-.top_extent.xmin, <-.top_extent.ymin, <-.top_extent.zmin };
       double max[3]  =>
          { <-.top_extent.xmax, <-.top_extent.ymax, <-.top_extent.zmax };
       double step[3] => (max - min) / 5;
       double label_offset[3] => step * 3 / 5;
       double num_offset[3] => step / 5;
    };
    group   axis1 {
       string label = "X";
       double start;
       double end;
       double step;
       double label_offset = 0.0;
       double num_offset = 0.0;
       double pow = 1.0;    
       double+nosave def_start;
       double+nosave def_end;
       double+nosave def_step;
       double+nosave def_label_offset;
       double+nosave def_num_offset;
       int origin_point = 1;
    };
    axis1 axis2 {
       label = "Y";
    };
    axis1 axis3 {
       label = "Z";
    };
    group &axis[] => {axis1, axis2, axis3};
    int           current_label = 0;
    string+nosave label => axis[current_label].label;
    float+nosave  start => axis[current_label].start;
    float+nosave  end   => axis[current_label].end;
    float+nosave  step  => axis[current_label].step;
    int+nosave  origin_point => axis[current_label].origin_point;
    float+nosave  label_offset => axis[current_label].label_offset;
    float+nosave  num_offset  => axis[current_label].num_offset;
    float+nosave  pow => axis[current_label].pow; 
    string+nosave FontTable[] => str_array("MAVLAB_FONTS",";");
    string+nosave SampleFontTable[] => str_array("MAVLAB_SAMPLEFONTS",";");
    string+nosave StyleTable[] = {"medium-r", "bold-r", "medium-i", "bold-i"};
    int title_font_index = 0;
    int title_height = 18;
    int title_style = 0;
    string+nosave title_font => FontTable[title_font_index];
    string+nosave title_sample_font => SampleFontTable[.title_font_index];
   string+nosave title_style_str => StyleTable[title_style];
   string+nosave title_font_list => "-*-"+title_font+"-"+title_style_str+"-*-*-"+title_height+"-*-*-*-*-*-*-*";
    int num_font_index = 0;
    int num_height = 12;
    int num_style = 0;
    string+nosave num_font => FontTable[num_font_index];
    string+nosave num_sample_font => SampleFontTable[.num_font_index];
    string+nosave num_style_str => StyleTable[title_style];
    string+nosave num_font_list => "-*-"+num_font+"-"+num_style_str+"-*-*-"+num_height+"-*-*-*-*-*-*-*";    
    boolean palette_vis = 1;
    float red           = GD_DEFAULT_RED;
    float green         = GD_DEFAULT_GREEN;
    float blue          = GD_DEFAULT_BLUE;
    float decimal       = 1;
    boolean+nosave axis_label_vis = 0;
    boolean+nosave num_label_vis = 0;
    boolean+nosave axis_move_vis = 0;
    boolean+nosave axis_color_vis = 0;
    boolean+nosave axis_reset;
    boolean+nosave reset;

    init_commands => "";
    reset_commands =
       "axis_editor_params{"
      +"current_label = 0;"
      +"palette_vis = 1;"
      +"title_height = 18;"
      +"title_font_index = 0;"
      +"title_style = 0;"
      +"num_height = 12;"
      +"num_font_index = 0;"
      +"num_style = 0;"
      +"red=1.0;green=1.0;blue=1.0;"
      +"decimal = 1;"
      +"x_pos=0.0;y_pos=0.0;z_pos=0.0;"
      +"axis_vis = 1;"
      +"reset = 1;"
      +"};"
      ; 
};

MAmacroUI MAaxiscoordEditorUI {
   MAaxiscoord_editor_params &axis_coord_editor_params;
  
   height => axis_coord_editor_panel.height;
   MAUIframe axis_coord_editor_panel {
      parent => <-.parent;
      y => <-.y;
      width => parent.clientWidth - 2;
      height => <-.axis_move_button.y + <-.axis_move_button.height + 10;
   };
   MAUIbutton axis_reset {
      parent => <-.axis_coord_editor_panel;
      x = 3;
      y = 3;
      width = 100;
      label = "MAV3AXISG_RESET";
      do => <-.axis_coord_editor_params.axis_reset;
   };
   MAUItoggle axis_vis_toggle {
      parent => <-.axis_coord_editor_panel;
      x => <-.axis_reset.x + <-.axis_reset.width + 15;
      y = 3;
      width = 100;
      label = "MAUI_DISPLAY";
      set => <-.axis_coord_editor_params.axis_vis;
   };
   MAUIOptionMenuLabel axis_editor_panel {
      parent => <-.axis_coord_editor_panel;
      options = {"MAV3AXISG_XLABEL",
                 "MAV3AXISG_YLABEL","MAV3AXISG_ZLABEL"};
      selectedItem => <-.axis_coord_editor_params.current_label;
      label = "MAV3AXISG_EDITOR";
      x = 0;
      y => <-.axis_vis_toggle.y + <-.axis_vis_toggle.height + 10;
      width = 200;
      //height = 30;
   };
   MAUIframe axis_frame {
      parent => <-.axis_coord_editor_panel;
      y => <-.axis_editor_panel.y + <-.axis_editor_panel.height;
      width => parent.clientWidth - 5;
      height => <-.power_distance.y + <-.power_distance.height + 10;
   };
   MAUIlabel editor_label {
      parent => <-.axis_frame;
      y = 3;
      label => switch(axis_coord_editor_params.current_label + 1,
               "MAV3AXISG_XEDITOR", "MAV3AXISG_YEDITOR", "MAV3AXISG_ZEDITOR");
   };
#ifdef OLDOLD
   MAUIlabel start_label {
      parent => <-.axis_frame;
      y => <-.editor_label.y + <-.editor_label.height;
      width = 100;
      label = "MAV3AXISG_START";
   };
   MAUIfield start {
      parent => <-.axis_frame;
      x => <-.start_label.x + <-.start_label.width;
      y => <-.start_label.y;
      width = 88;
      value => <-.axis_coord_editor_params.start;
   };
   start_label end_label {
      y => <-.start.y + <-.start.height;
      label = "MAV3AXISG_END";
   };
   start end {
      x => <-.end_label.x + <-.end_label.width;
      y => <-.end_label.y;
      value => <-.axis_coord_editor_params.end;
   };
   start_label step_label {
      y => <-.end.y + <-.end.height;
      label = "MAV3AXISG_STEP";
   };
   start step {
      x => <-.step_label.x + <-.step_label.width;
      y => <-.step_label.y;
      value => <-.axis_coord_editor_params.step;
   };
#else
   MAUIFieldLabel start {
      parent => <-.axis_frame;
      y => <-.editor_label.y + <-.editor_label.height;
      width = 220;
      label = "MAV3AXISG_START";
      value => <-.axis_coord_editor_params.start;
   };
   MAUIFieldLabel end {
      parent => <-.axis_frame;
      y => <-.start.y + <-.start.height;
      width = 220;
      label = "MAV3AXISG_END";
      value => <-.axis_coord_editor_params.end;
   };
   MAUIFieldLabel step {
      parent => <-.axis_frame;
      y => <-.end.y + <-.end.height;
      width = 220;
      label = "MAV3AXISG_STEP";
      value => <-.axis_coord_editor_params.step;
   };
#endif
   MAUItoggle origin_toggle{
      x      => <-.step.UIlabel.x + <-.step.UIlabel.width;
      y      => <-.step.y + <-.step.height + 5;
      parent => <-.axis_frame;
      label  = "AV3AXISG_ORIGIN";
      set    => <-.axis_coord_editor_params.origin_point;
   };
   MAUIlabel text_label {
      parent => <-.axis_frame;
      x = 5;
      y => ((<-.origin_toggle.y + <-.origin_toggle.height) + 5);
      width = 110;
      label = "MAV3AXISG_LABEL_INPUT";
   }; 
   MAUItext text {
      parent => <-.axis_frame;
      y => <-.text_label.y + <-.text_label.height;
      width = 235;
      multiLine = 1;
      text => <-.axis_coord_editor_params.label;
   };
   MAUIFieldLabel text_distance {
      parent => <-.axis_frame;
      y => <-.text.y + <-.text.height;
      width = 225;
      label = "MAV3AXISG_LABEL_DISTANCE";
      value => <-.axis_coord_editor_params.label_offset;
      UIlabel.width => <-.width - 60;
      UIfield {
         x => <-.UIlabel.x + <-.UIlabel.width + 5;
         width = 60;
      };
   };
   MAUIFieldLabel power {
      parent => <-.axis_frame;
      label = "MAV3AXISG_LABEL_POW";
      value => <-.axis_coord_editor_params.pow;
      y => <-.text_distance.y + <-.text_distance.height;
      width => <-.text_distance.width;
      UIlabel.width => <-.width - 60;
      UIfield {
         x => <-.UIlabel.x + <-.UIlabel.width + 5;
         width = 60;
      };
   };
   MAUIFieldLabel power_distance {
      parent => <-.axis_frame;
      label => "MAV3AXISG_NUM_DISTANCE";
      y => <-.power.y + <-.power.height;
      width => <-.power.width;
      value => <-.axis_coord_editor_params.num_offset;
      UIlabel.width => <-.width - 60;
      UIfield {
         x => <-.UIlabel.x + <-.UIlabel.width + 5;
         width = 60;
      };
   };
   MAUIbutton label_editor_button {
      parent => <-.axis_coord_editor_panel;
      y => <-.axis_frame.y + <-.axis_frame.height + 5;
      width = 130;
      label = "MAV3AXISG_LABEL_EDITOR";
      do => <-.axis_coord_editor_params.axis_label_vis;
   };
   MAUIbutton axis_editor_button {
      parent => <-.axis_coord_editor_panel;
      x => <-.label_editor_button.x + <-.label_editor_button.width + 3;
      y => <-.label_editor_button.y;
      width = 110;
      label = "MAV3AXISG_NUM_EDITOR";
      do => <-.axis_coord_editor_params.num_label_vis;
   };
   MAUIbutton axis_move_button {
      parent => <-.axis_coord_editor_panel;
      y => <-.axis_editor_button.y + <-.axis_editor_button.height + 3;
      width = 130;
      label = "MAV3AXISG_MOVE";
      do => <-.axis_coord_editor_params.axis_move_vis;
   };
   MAUIbutton axis_color_button {
      parent => <-.axis_coord_editor_panel;
      x => <-.axis_move_button.x + <-.axis_move_button.width + 3;
      y => <-.axis_move_button.y;
      width = 110;
      label = "MAV3AXISG_COLOR";
      do => <-.axis_coord_editor_params.axis_color_vis;
   };
   
   GMOD.instancer axis_editor_instancer {
      Value => <-.axis_coord_editor_params.axis_label_vis;
      Group => <-.axis_editor;
      active = 2; // nested instancer bug workaround
   };
   macro axis_editor<instanced=0> {
      ilink axis_coord_editor_params => <-.axis_coord_editor_params;
            
      MAUIcloseDialog axis_panel {
         visible => <-.axis_coord_editor_params.axis_label_vis;
         title = "MAV3AXISG_LABEL_EDITOR";
         width  = 240;
         height = 300;
      };
      MAUIframe axis_frame {
         parent => <-.axis_panel;
         y => 0;
         width  => parent.clientWidth;
         height => parent.clientHeight - 40;
      };
      MAUIOptionMenuLabel LabelFont {
         parent => <-.axis_frame;
         options => <-.axis_coord_editor_params.FontTable;
         x = 10;
         y = 10;
         width = 225;
         height = 30;
         selectedItem => <-.axis_coord_editor_params.title_font_index;
         label = "MAVLAB_FONT";
      };
      MAUIOptionMenuLabel LabelStyle {
         parent => <-.axis_frame;
         options => {
            "MAVLAB_NORMAL", "MAVLAB_BOLD", "MAVLAB_ITALIC", "MAVLAB_BOLDITLIC"
         };
         x = 10;
         y => <-.LabelFont.y + <-.LabelFont.height;
         width = 225;
         height = 30;
         selectedItem => <-.axis_coord_editor_params.title_style;
         label = "MAVLAB_STYLE";
      };
      MAUIslider HeightSlider {
         parent => <-.axis_frame;
         x = 10;
         y => <-.LabelStyle.y + <-.LabelStyle.height+5;
         width = 210;
#ifdef MSDOS
         //height = 35;
#else
         height = 60;
#endif //MSDOS
         title = "MAUI_SCALE";
         min = 0; // for title off
         max = 72;
         value => <-.axis_coord_editor_params.title_height;
         mode = "integer";
         decimalPoints = 0;
      };
      MAUIframe SampleFrame {
         parent => <-.axis_frame;
         x = 10;
         y => <-.HeightSlider.y + <-.HeightSlider.height + 10;
         width = 210;
         height = 90;
      };
      MAUIpanel SamplePanel {
         parent => <-.SampleFrame;
         x = 0;
         y = 0;
         width =>parent.clientWidth;
         height =>parent.clientHeight;
         color.backgroundColor = "black";
      };
      MAUIlabel SampleLabel {
         parent => <-.SamplePanel;
         label = "MAVLAB_SAMPLE";
         x = 0;
#ifdef MSDOS
         y => (72 - <-.axis_coord_editor_params.title_height * 0.7) / 2;
#else
         y = 0;
#endif //MSDOS
         width => parent.clientWidth;
         height => parent.clientHeight;
         fontAttributes {
            family => <-.<-.axis_coord_editor_params.title_sample_font;
            height => max_array({1, <-.<-.axis_coord_editor_params.title_height * 0.7});
            weight => switch(<-.<-.axis_coord_editor_params.title_style+1,
                             "medium","bold","medium","bold");
            slant => switch(<-.<-.axis_coord_editor_params.title_style+1,
                             "regular","regular","oblique","oblique");
         };
         color.foregroundColor = "white";
         color.backgroundColor = "black";
      };
   };
   GMOD.instancer num_editor_instancer {
      Value => <-.axis_coord_editor_params.num_label_vis;
      Group => <-.num_editor;
      active = 2; // nested instancer bug workaround
   };
   macro num_editor<instanced=0> {
      ilink axis_coord_editor_params => <-.axis_coord_editor_params;
      
      MAUIcloseDialog num_panel {
         visible => <-.axis_coord_editor_params.num_label_vis;
         title = "MAV3AXISG_NUM_EDITOR";
         width  = 240;
         height = 335;
      };
      MAUIframe num_frame {
         parent => <-.num_panel;
         y => 0;
         width  => parent.clientWidth;
         height => parent.clientHeight - 40;
      };
      MAUIOptionMenuLabel LabelFont {
         parent => <-.num_frame;
         options => <-.axis_coord_editor_params.FontTable;
         x = 10;
         y = 10;
         width = 225;
         height = 30;
         selectedItem => <-.axis_coord_editor_params.num_font_index;
         label = "MAVLAB_FONT";
      };
      MAUIOptionMenuLabel LabelStyle {
         parent => <-.num_frame;
         options => {
            "MAVLAB_NORMAL", "MAVLAB_BOLD", "MAVLAB_ITALIC", "MAVLAB_BOLDITLIC"
         };
         x = 10;
         y => <-.LabelFont.y + <-.LabelFont.height;
         width = 225;
         height = 30;
         selectedItem => <-.axis_coord_editor_params.num_style;
         label = "MAVLAB_STYLE";
      };
      MAUIslider DecimalSlider {
         parent => <-.num_frame;
         x = 10;
         y => <-.LabelStyle.y + <-.LabelStyle.height+5;
         width = 210;
#ifdef MSDOS
         //height = 35;
#else
         height = 55;
#endif //MSDOS
         title = "MAV3AXISG_DECIMAL";
         min = 0;
         max = 10;
         value => <-.axis_coord_editor_params.decimal;
         mode = "integer";
         decimalPoints = 0;
      };
      MAUIslider HeightSlider {
         parent => <-.num_frame;
         x = 10;
         y => <-.DecimalSlider.y + <-.DecimalSlider.height+5;
         width = 210;
#ifdef MSDOS
         //height = 35;
#else
         height = 55;
#endif //MSDOS
         title = "MAUI_SCALE";
         min = 0; // 0 for off
         max = 72;
         value => <-.axis_coord_editor_params.num_height;
         mode = "integer";
         decimalPoints = 0;
      };
      MAUIframe SampleFrame {
         parent => <-.num_frame;
         x = 10;
         y => <-.HeightSlider.y + <-.HeightSlider.height + 10;
         width = 210;
         height = 85;
      };
      MAUIpanel SamplePanel {
         parent => <-.SampleFrame;
         x = 0;
         y = 0;
         width =>parent.clientWidth;
         height =>parent.clientHeight;
         color.backgroundColor = "black";
      };
      MAUIlabel SampleLabel {
         parent => <-.SamplePanel;
         label = "MAVLAB_SAMPLE";
         x = 0;
#ifdef MSDOS
         y => (72 - <-.axis_coord_editor_params.num_height * 0.7) / 2;
#else
         y = 0;
#endif //MSDOS
         width  => parent.clientWidth;
         height => parent.clientHeight;
         fontAttributes {
            family => <-.<-.axis_coord_editor_params.num_sample_font;
            height => max_array({1, <-.<-.axis_coord_editor_params.num_height * 0.7});
            weight => switch(<-.<-.axis_coord_editor_params.num_style+1,
                             "medium","bold","medium","bold");
            slant => switch(<-.<-.axis_coord_editor_params.num_style+1,
                             "regular","regular","oblique","oblique");
         };
         color.foregroundColor = "white";
         color.backgroundColor = "black";
      };
   };

   GMOD.instancer axis_move_editor_instancer {
      Value => <-.axis_coord_editor_params.axis_move_vis;
      Group => <-.axis_move_editor;
      active = 2; // nested instancer bug workaround
   };
   macro axis_move_editor<instanced=0> {
      ilink axis_coord_editor_params => <-.axis_coord_editor_params;
      
      MAUIcloseDialog axis_panel {
         visible => <-.axis_coord_editor_params.axis_move_vis;
         width = 234;
         height => <-.zslider.y + <-.zslider.height + 90;
         title = "MAV3AXISG_MOVE_EDITOR";
      };
      MAUIframe axis_frame {
         parent => <-.axis_panel;
         y = 0;
         width => parent.clientWidth;
         height => parent.height - 70;
      };
      MAUIslider2 xslider {
         parent => <-.axis_frame;
         x = 5;
         y = 10;
         allwidth => parent.clientWidth - 2 * x;
         min = -100.0;
         max = 100.0;
         title = "MAV3AXISG_X";
         value => <-.axis_coord_editor_params.x_pos;
      };
      MAUIslider2 yslider {
         parent => <-.axis_frame;
         x = 5;
         y => <-.xslider.y + <-.xslider.height + 10;
         allwidth => parent.clientWidth - 2 * x;
         min = -100.0;
         max = 100.0;
         title = "MAV3AXISG_Y";
         value => <-.axis_coord_editor_params.y_pos;
      };
      MAUIslider2 zslider {
         parent => <-.axis_frame;
         x = 5;
         y => <-.yslider.y + <-.yslider.height + 10;
         allwidth => parent.clientWidth - 2 * x;
         min = -100.0;
         max = 100.0;
         title = "MAV3AXISG_Z";
         value => <-.axis_coord_editor_params.z_pos;
      };
   };
   GMOD.instancer color_editor_instancer {
      Value => <-.axis_coord_editor_params.axis_color_vis;
      Group => <-.color_editor;
      active = 2; // nested instancer bug workaround
   };
   macro color_editor<instanced=0> {
      ilink axis_coord_editor_params => <-.axis_coord_editor_params;
      
      MAUIcloseDialog color_panel {
         visible => <-.axis_coord_editor_params.axis_color_vis;
         width = 240;
         height = 290;
         title = "MAUI_COL";
      };   
      MAcolorEditorUI MAcolorEditor {
         parent => <-.color_panel;
         visible = 1;
         y => 10;
         palette_vis => <-.axis_coord_editor_params.palette_vis;
         red => <-.axis_coord_editor_params.red;
         green => <-.axis_coord_editor_params.green;
         blue => <-.axis_coord_editor_params.blue;
      };
   };
};

MAeditor MAaxiscoordEditor {
   title = "MAV3AXISG_TITLE";
   int current_label => Params.axis_editor_params.current_label;
 
   Params {
      params.name      = "axiscord";
      params.help_name = "axiscord";
      params.visible   = 0; // 0 for instancer
      MAaxiscoord_editor_params axis_editor_params {
         axis_vis    => <-.viewer_params.axis_coord;
         list_update => <-.viewer_params.list_update;
         top_extent  => <-.viewer_params.top_extent;

         MAset_param set_start[3] {
            int id    => index_of(set_start);
            trigger   => is_valid(in_value);
            in_value  => <-.def_axis_pars.min[id];
            def_value => <-.axis[id].def_start;
            value     => <-.axis[id].start;
         };
         MAset_param set_end[3] {
            int id    => index_of(set_end);
            trigger   => is_valid(in_value);
            in_value  => <-.def_axis_pars.max[id];
            def_value => <-.axis[id].def_end;
            value     => <-.axis[id].end;
         };
         MAset_param set_step[3] {
            int id    => index_of(set_step);
            trigger   => is_valid(in_value);
            in_value  => <-.def_axis_pars.step[id];
            def_value => <-.axis[id].def_step;
            value     => <-.axis[id].step;
         };
         MAset_param set_num_offset[3] {
            int id    => index_of(set_num_offset);
            trigger   => is_valid(in_value);
            in_value  => <-.def_axis_pars.num_offset[id];
            def_value => <-.axis[id].def_num_offset;
            value     => <-.axis[id].num_offset;
         };
         MAset_param set_label_offset[3] {
            int id    => index_of(set_label_offset);
            trigger   => is_valid(in_value);
            in_value  => <-.def_axis_pars.label_offset[id];
            def_value => <-.axis[id].def_label_offset;
            value     => <-.axis[id].label_offset;
         };
      };
      init_params.init_commands => axis_editor_params.init_commands;
      reset_params.reset_commands => axis_editor_params.reset_commands;
      GMOD.parse_v reset_axis {
         on_inst = 0;
         trigger => <-.axis_editor_params.reset;
         relative => <-.axis_editor_params;
         v_commands =
 "$push -usr\n"
+"!axis[0]{start=top_extent.xmin;end=top_extent.xmax;step=(end-start)/5;};"
+"!axis[1]{start=top_extent.ymin;end=top_extent.ymax;step=(end-start)/5;};"
+"!axis[2]{start=top_extent.zmin;end=top_extent.zmax;step=(end-start)/5;};"
+"!axis[0]{label=\"X\";pow=1;label_offset=(.step/5)*3;num_offset=(.step/5);};"
+"!axis[1]{label=\"Y\";pow=1;label_offset=(.step/5)*3;num_offset=(.step/5);};"
+"!axis[2]{label=\"Z\";pow=1;label_offset=(.step/5)*3;num_offset=(.step/5);};"
+"$pop\n";
};
      GMOD.parse_v reset_pos {
         on_inst = 0;
         trigger => <-.axis_editor_params.axis_reset;
         relative => <-.axis_editor_params;
         v_commands =
 "$push -usr\n"
+"!axis[0]{start=top_extent.xmin;end=top_extent.xmax;step=(end-start)/5;};"
+"!axis[1]{start=top_extent.ymin;end=top_extent.ymax;step=(end-start)/5;};"
+"!axis[2]{start=top_extent.zmin;end=top_extent.zmax;step=(end-start)/5;};"
+"x_pos = 0.0;y_pos = 0.0;z_pos = 0.0;"
+"$pop\n";
      };

   };
   GMOD.copy_on_change set_UI_vis {
      input => switch(<-.Params.axis_editor_params.axis_vis, 1); 
      output => <-.UI.visible;
      on_inst = 0;
   };

   macro+nosave MAaxisObj {
      //ilink in_field => <-.in_field;
      ilink axis_coord_editor_params => <-.Params.axis_editor_params;
      link vis => axis_coord_editor_params.axis_vis;
      
         
      DV_Param_axis x_axis_param {
         start=><-.axis_coord_editor_params.axis[0].start;
	 end=><-.axis_coord_editor_params.axis[0].end; 
         ref => .start;
 	 step=><-.axis_coord_editor_params.axis[0].step;
	 tick_y_below =>y_axis_param.ref-y_axis_param.limits[0];
	 tick_y_above =>y_axis_param.limits[1]-y_axis_param.ref;
	 tick_z_below =>z_axis_param.ref-z_axis_param.limits[0];
	 tick_z_above =>z_axis_param.limits[1]-z_axis_param.ref;
	 minor_ticks = 0;
	 minor_scale = 1;
	 ndig => <-.axis_coord_editor_params.decimal;
	 float+nres+Port2 off_anno => <-.axis_coord_editor_params.axis1.num_offset;
	 y_anno => (-1)*off_anno;
	 z_anno => (-1)*off_anno;
	 float+nres+Port2 labeloff_anno => <-.axis_coord_editor_params.axis1.label_offset;
         float+nres+Port2 label_anno => (-1)*labeloff_anno;
	 axis_name => <-.axis_coord_editor_params.axis[0].label;
         int origin_point => <-.axis_coord_editor_params.axis[0].origin_point;
      };

      DV_Param_axis y_axis_param {
         start=><-.axis_coord_editor_params.axis[1].start;
	 end=><-.axis_coord_editor_params.axis[1].end; 
	 ref => .start;
	 step=><-.axis_coord_editor_params.axis[1].step;
	 tick_y_below =>x_axis_param.limits[1]-x_axis_param.ref;
	 tick_y_above =>x_axis_param.ref-x_axis_param.limits[0];
	 tick_z_below =>z_axis_param.ref-z_axis_param.limits[0];
	 tick_z_above =>z_axis_param.limits[1]-z_axis_param.ref;
	 minor_ticks = 0;
	 minor_scale = 1;
	 ndig => <-.axis_coord_editor_params.decimal;
	 float+nres+Port2 off_anno => <-.axis_coord_editor_params.axis2.num_offset;
	 y_anno => off_anno;
	 z_anno => (-1)*off_anno;
         float+nres+Port2 labeloff_anno => <-.axis_coord_editor_params.axis2.label_offset;
         float+nres+Port2 labely_anno => labeloff_anno;
         float+nres+Port2 labelz_anno => (-1)*labeloff_anno;
	 axis_name => <-.axis_coord_editor_params.axis[1].label;
         int origin_point => <-.axis_coord_editor_params.axis[1].origin_point;
      };

      DV_Param_axis z_axis_param {
         start=><-.axis_coord_editor_params.axis[2].start;
	 end=><-.axis_coord_editor_params.axis[2].end; 
	 ref => .start;
	 step=><-.axis_coord_editor_params.axis[2].step;
	 tick_y_below =>y_axis_param.ref-y_axis_param.limits[0];
	 tick_y_above =>y_axis_param.limits[1]-y_axis_param.ref;
	 tick_z_below =>x_axis_param.limits[1]-x_axis_param.ref;
	 tick_z_above =>x_axis_param.ref-x_axis_param.limits[0];
	 minor_ticks = 0;
	 minor_scale = 1;
	 ndig => <-.axis_coord_editor_params.decimal;
	 float+nres+Port2 off_anno => <-.axis_coord_editor_params.axis3.num_offset;
	 y_anno => (-1)*off_anno;
	 z_anno => off_anno;
	 float+nres+Port2 labeloff_anno => <-.axis_coord_editor_params.axis3.label_offset;
	 float+nres+Port2 labely_anno => (-1)*labeloff_anno;
	 float+nres+Port2 labelz_anno => labeloff_anno;
	 axis_name => <-.axis_coord_editor_params.axis[2].label;
         int origin_point => <-.axis_coord_editor_params.axis[2].origin_point;
      };

      DefaultXform+nonotify x_xform {
  	 xlate=>{0,<-.y_axis_param.ref,
	   	   <-.z_axis_param.ref}; 
      };
      DefaultXform+nonotify y_xform {
 	 xlate=>{<-.x_axis_param.ref,0,
	 	 <-.z_axis_param.ref}; 
	 mat => {{0,1,0,0},
       		{-1,0,0,0},
       		{0,0,1,0},
         	{0,0,0,1}};
      };
      DefaultXform+nonotify z_xform {
   	 xlate=>{<-.x_axis_param.ref,
	  	 <-.y_axis_param.ref, 0};
	 mat => {{0,0,1,0},
       	 	 {0,1,0,0},
            	 {-1,0,0,0},
       	 	 {0,0,0,1}};
      };

#ifdef OLDOLD
      DVconcat_xform DVconcat_xform_x {
   	 xform_in2+nres => <-.in_field.xform;
	 xform_in1+nres => <-.x_xform;
      };

      DVconcat_xform DVconcat_xform_y {
  	 xform_in2+nres => <-.in_field.xform;
	 xform_in1+nres => <-.y_xform;
      };

      DVconcat_xform DVconcat_xform_z {
  	 xform_in2+nres => <-.in_field.xform;
	 xform_in1+nres => <-.z_xform;
      };
#endif

      group set_power {
         float x_start => <-.x_axis_param.start;
         float x_end   => <-.x_axis_param.end;
         float x_1     => .x_start < 0 && .x_end > 0;
         float x_2     => .x_start > 0 && .x_end < 0;
         int   x_      => .x_1 == .x_2 == 0;
         float start_x => switch(x_ + 1,<-.x_axis_param.start,(<-.x_axis_param.start * <-.axis_coord_editor_params.axis1.pow));
         float y_start => <-.y_axis_param.start;
         float y_end   => <-.y_axis_param.end;
         float y_1     => .y_start < 0 && .y_end > 0;
         float y_2     => .y_start > 0 && .y_end < 0;
         int   y_      => .y_1 == .y_2 == 0;
         float start_y => switch(y_ + 1, <-.y_axis_param.start,(<-.y_axis_param.start * <-.axis_coord_editor_params.axis2.pow));
         float z_start => <-.z_axis_param.start;
         float z_end   => <-.z_axis_param.end;
         float z_1     => .z_start < 0 && .z_end > 0;
         float z_2     => .z_start > 0 && .z_end < 0;
         int   z_      => .z_1 == .z_2 == 0;
         float start_z => switch(z_ + 1, <-.z_axis_param.start, (<-.z_axis_param.start * <-.axis_coord_editor_params.axis3.pow));
      };
       
      MADVaxis axis_x {
 	 //in { nspace = 3; } => <-.in_field;
	 limits=> <-.x_axis_param.limits;
	 reference=> <-.x_axis_param.ref;
	 tick_step=> <-.x_axis_param.step;
	 tick_y_below=> <-.x_axis_param.tick_y_below;
	 tick_y_above=> <-.x_axis_param.tick_y_above;
	 tick_z_below=> <-.x_axis_param.tick_z_below;
	 tick_z_above=> <-.x_axis_param.tick_z_above;
	 minor_ticks=> <-.x_axis_param.minor_ticks;
	 minor_scale=> <-.x_axis_param.minor_scale;
	 ndig => <-.x_axis_param.ndig;
	 y_anno => <-.x_axis_param.y_anno;
	 z_anno => <-.x_axis_param.z_anno;
	 float+nres+Port2 label_anno => <-.x_axis_param.label_anno;
	 axis_name => <-.x_axis_param.axis_name;
         axis_labels => <-.x_axis_param.axis_labels;
         float label_xyz[3] => {.name_xyz[0],label_anno,label_anno};
    	 out {
	      //&xform => <-.<-.DVconcat_xform_x.xform_out;
	      &xform => <-.<-.x_xform;
	 };
	 out_anno {
	      text_values => switch((<-.<-.axis_coord_editor_params.num_height != 0),<-.<-.axis_x_label.labels);
	 };
	 out_name {
	   coordinates.values => <-.<-.label_xyz;
	   text_values => switch((<-.<-.axis_coord_editor_params.title_height != 0),<-.name);
	 };
      };
      MADVaxis axis_x_label {
 	 //in { nspace = 3; } => <-.in_field;
         limits => {<-.set_power.start_x,
                       (<-.x_axis_param.end * <-.axis_coord_editor_params.axis1.pow)};
         reference => <-.set_power.start_x;
	 tick_step=> <-.x_axis_param.step * <-.axis_coord_editor_params.axis1.pow;
	 tick_y_below=> <-.x_axis_param.tick_y_below;
	 tick_y_above=> <-.x_axis_param.tick_y_above;
	 tick_z_below=> <-.x_axis_param.tick_z_below;
	 tick_z_above=> <-.x_axis_param.tick_z_above;
	 minor_ticks=> <-.x_axis_param.minor_ticks;
	 minor_scale=> <-.x_axis_param.minor_scale;
	 ndig => <-.x_axis_param.ndig;
	 y_anno => <-.x_axis_param.y_anno;
	 z_anno => <-.x_axis_param.z_anno;
	 axis_name => <-.x_axis_param.axis_name;
         axis_labels => <-.x_axis_param.axis_labels;
         origin_point => <-.x_axis_param.origin_point;
      };
      
      MADVaxis axis_y {
 	 //in { nspace = 3; } => <-.in_field;
	 limits=> <-.y_axis_param.limits;
	 reference=> <-.y_axis_param.ref;
	 tick_step=> <-.y_axis_param.step;
	 tick_y_below=> <-.y_axis_param.tick_y_below;
	 tick_y_above=> <-.y_axis_param.tick_y_above;
	 tick_z_below=> <-.y_axis_param.tick_z_below;
	 tick_z_above=> <-.y_axis_param.tick_z_above;
	 minor_ticks=> <-.y_axis_param.minor_ticks;
	 minor_scale=> <-.y_axis_param.minor_scale;
	 ndig => <-.y_axis_param.ndig;
	 y_anno => <-.y_axis_param.y_anno;
	 z_anno => <-.y_axis_param.z_anno;
	 float+nres+Port2 labely_anno => <-.y_axis_param.labely_anno;
	 float+nres+Port2 labelz_anno => <-.y_axis_param.labelz_anno;
	 axis_name => <-.y_axis_param.axis_name;
         axis_labels => <-.y_axis_param.axis_labels;
         float+nres+Port2 label_xyz[3] => 
                               {.name_xyz[0],.labely_anno,.labelz_anno};
	 out {
	      //&xform => <-.<-.DVconcat_xform_y.xform_out;
	      &xform => <-.<-.y_xform;
	 };
         out_anno {
	      text_values => switch((<-.<-.axis_coord_editor_params.num_height != 0),<-.<-.axis_y_label.labels);
         };
         out_name {
	   coordinates.values => <-.<-.label_xyz;
	   text_values => switch((<-.<-.axis_coord_editor_params.title_height != 0),<-.name);
         };
      }; 

      MADVaxis axis_y_label {
 	 //in { nspace = 3; } => <-.in_field;
	 limits=> {<-.set_power.start_y,
	              (<-.y_axis_param.end * <-.axis_coord_editor_params.axis2.pow)};
	 reference=> <-.set_power.start_y;
	 tick_step=> <-.y_axis_param.step * <-.axis_coord_editor_params.axis2.pow;
	 tick_y_below=> <-.y_axis_param.tick_y_below;
	 tick_y_above=> <-.y_axis_param.tick_y_above;
	 tick_z_below=> <-.y_axis_param.tick_z_below;
	 tick_z_above=> <-.y_axis_param.tick_z_above;
	 minor_ticks=> <-.y_axis_param.minor_ticks;
	 minor_scale=> <-.y_axis_param.minor_scale;
	 ndig => <-.y_axis_param.ndig;
	 y_anno => <-.y_axis_param.y_anno;
	 z_anno => <-.y_axis_param.z_anno;
	 axis_name => <-.y_axis_param.axis_name;
         axis_labels => <-.y_axis_param.axis_labels;
         origin_point => <-.y_axis_param.origin_point;
      }; 

      MADVaxis axis_z {
 	 //in { nspace = 3; } => <-.in_field;
	 limits=> <-.z_axis_param.limits;
	 reference=> <-.z_axis_param.ref;
	 tick_step=> <-.z_axis_param.step;
	 tick_y_below=> <-.z_axis_param.tick_y_below;
	 tick_y_above=> <-.z_axis_param.tick_y_above;
	 tick_z_below=> <-.z_axis_param.tick_z_below;
	 tick_z_above=> <-.z_axis_param.tick_z_above;
	 minor_ticks=> <-.z_axis_param.minor_ticks;
	 minor_scale=> <-.z_axis_param.minor_scale;
	 ndig => <-.z_axis_param.ndig;
	 y_anno => <-.z_axis_param.y_anno;
	 z_anno => <-.z_axis_param.z_anno;
	 float+nres+Port2 labely_anno => <-.z_axis_param.labely_anno;
	 float+nres+Port2 labelz_anno => <-.z_axis_param.labelz_anno;
	 axis_name => <-.z_axis_param.axis_name;
         axis_labels => <-.z_axis_param.axis_labels;
         float+nres+Port2 label_xyz[3] =>
              {.name_xyz[0],.labely_anno,.labelz_anno};
	 out {
	    //&xform => <-.<-.DVconcat_xform_z.xform_out;
	      &xform => <-.<-.z_xform;
	 };
	 out_anno {
	      text_values => switch((<-.<-.axis_coord_editor_params.num_height != 0),<-.<-.axis_z_label.labels);
	 };
	 out_name {
	   coordinates.values => <-.<-.label_xyz;
	   text_values => switch((<-.<-.axis_coord_editor_params.title_height != 0),<-.name);
	 };
      }; 
      
      MADVaxis axis_z_label {
 	 //in { nspace = 3; } => <-.in_field;
	 limits=> {<-.set_power.start_z, 
	              (<-.z_axis_param.end * <-.axis_coord_editor_params.axis3.pow)};
	 reference=> <-.set_power.start_z;
	 tick_step=> <-.z_axis_param.step * <-.axis_coord_editor_params.axis3.pow;
	 tick_y_below=> <-.z_axis_param.tick_y_below;
	 tick_y_above=> <-.z_axis_param.tick_y_above;
	 tick_z_below=> <-.z_axis_param.tick_z_below;
	 tick_z_above=> <-.z_axis_param.tick_z_above;
	 minor_ticks=> <-.z_axis_param.minor_ticks;
	 minor_scale=> <-.z_axis_param.minor_scale;
	 ndig => <-.z_axis_param.ndig;
	 y_anno => <-.z_axis_param.y_anno;
	 z_anno => <-.z_axis_param.z_anno;
	 axis_name => <-.z_axis_param.axis_name;
         axis_labels => <-.z_axis_param.axis_labels;
         origin_point => <-.z_axis_param.origin_point;
      }; 

      int+Port major_line_mode = 0;
      int+Port minor_line_mode = 2;
      string+Port label_font => axis_coord_editor_params.title_font_list;
      string+Port axis_font  => axis_coord_editor_params.num_font_list;

      MAdataObjectLite obj_x {
         in => axis_x.out;
	 Props.line_style => <-.<-.major_line_mode;
	 Obj {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name = "NOOBJLIST x axis";
	 };
      };
      MAdataObjectLite obj_y {
         in => axis_y.out;
	 Props.line_style => <-.<-.major_line_mode;
	 Obj {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name ="NOOBJLIST y axis";
	 };
      };
      MAdataObjectLite obj_z {
       	 in => axis_z.out;
	 Props.line_style => <-.<-.major_line_mode;
	 Obj {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name ="NOOBJLIST z axis";
	 };
      };
      MAdataObjectLite obj_x_minor {
         in => axis_x.out_minor;
	 Props.line_style => <-.<-.minor_line_mode;
	 Obj {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name ="NOOBJLIST x minor grid";
	 };
      };
      MAdataObjectLite obj_y_minor {
         in => axis_y.out_minor;
	 Props.line_style => <-.<-.minor_line_mode;
	 Obj {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name ="NOOBJLIST y minor grid";
	 };
      };
      MAdataObjectLite obj_z_minor {
         in => axis_z.out_minor;
	 Props.line_style => <-.<-.minor_line_mode;
	 Obj {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name ="NOOBJLIST z minor grid";
	 };
      };
      MAdataObjectLite obj_x_anno {
         in => axis_x.out_anno;
	 Props.font => <-.<-.axis_font;
	 Obj {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name ="NOOBJLIST x labels";
	 };
      };
      MAdataObjectLite obj_y_anno {
         in => axis_y.out_anno;
	 Props.font => <-.<-.axis_font;
	 Obj {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name ="NOOBJLIST y labels";
	 };
      };
      MAdataObjectLite obj_z_anno {
         in => axis_z.out_anno;
	 Props.font => <-.<-.axis_font;
	 Obj {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name ="NOOBJLIST z labels";
	 };
      };
      MAdataObjectLite obj_x_name {
         in => axis_x.out_name;
	 Props.font => <-.<-.label_font;
	 Obj {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name ="NOOBJLIST x name";
	 };
      };
      MAdataObjectLite obj_y_name {
         in => axis_y.out_name;
	 Props.font => <-.<-.label_font;
	 Obj {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name ="NOOBJLIST y name";
	 };
      };
      MAdataObjectLite obj_z_name {
         in => axis_z.out_name;
	 Props.font => <-.<-.label_font;
	 Obj {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name ="NOOBJLIST z name";
	 };
      };
      MAgroupObject obj {
         link red => <-.axis_coord_editor_params.red;
         link green => <-.axis_coord_editor_params.green;
         link blue => <-.axis_coord_editor_params.blue;
         
         child_objs => {obj_x.obj, obj_y.obj,  obj_z.obj,
			obj_x_minor.obj, obj_y_minor.obj,  obj_z_minor.obj, 
			obj_x_anno.obj, obj_y_anno.obj, obj_z_anno.obj,
			obj_x_name.obj, obj_y_name.obj, obj_z_name.obj};
	 Top {
	      xform_mode = GD_XFORM_MODE_PARENT;
	      name ="NOOBJLIST _top";
	      visible => <-.<-.vis;
	 };
	 Props {
	        col => {<-.red, <-.green, <-.blue};
	        jitter = 1;
	 };
	 Xform {
	    xlate => {<-.<-.axis_coord_editor_params.x_pos,
	              <-.<-.axis_coord_editor_params.y_pos,
	              <-.<-.axis_coord_editor_params.z_pos};
	 };
      };

      olink out_obj => obj.obj;
   };
   
   UI {
        parent.width = 260;
        EditorCommonUI.panel.width => parent.clientWidth;
        MAaxiscoordEditorUI AxisGraphEditorUI {
           parent => <-.parent;
           axis_coord_editor_params => <-.<-.Params.axis_editor_params;
           y => EditorCommonUI.y + EditorCommonUI.height;
        };
        height => EditorCommonUI.height + AxisGraphEditorUI.height + 5;
    };
    olink out_obj => MAaxisObj.out_obj;
};
