/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/backcol.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/backcol.v#1 $
*/
//
// Background Color Editor
//
MAparams MAbackcolor_editor_params {
   float red   = 0;
   float green = 0;
   float blue  = 0;
   boolean palette_vis = 1;
   init_commands => "";
   reset_commands =
       "backcolor_editor_params.red=0;"
      +"backcolor_editor_params.green=0;"
      +"backcolor_editor_params.blue=0;"
      +"backcolor_editor_params.palette_vis=1;";
};

MAmacroUI MAbackcolorEditorUI {
   MAviewer_common_params &viewer_params;
   MAbackcolor_editor_params &backcolor_editor_params;
   height = 210;

   MAcolorEditorUI ColorEditorUI {
      parent      => <-.parent;
      red         => <-.backcolor_editor_params.red;
      green       => <-.backcolor_editor_params.green;
      blue        => <-.backcolor_editor_params.blue;
      palette_vis => <-.backcolor_editor_params.palette_vis;
      y           => <-.y + 5;
   };
};

MAeditor MAbackcolorEditor {
   title = "MAVBACKCOL_TITLE";
   MAGDview_templ+IPort2 &view_in;

   Params {
      params.name = "backcolor";
      params.help_name => switch(viewer_params.viewer3d+1, "imbcol","gebcol");

      MAbackcolor_editor_params backcolor_editor_params;
      init_params.init_commands => backcolor_editor_params.init_commands;
      reset_params.reset_commands => backcolor_editor_params.reset_commands;
#ifdef MICROAVS_DEV_KIT
#else
      GMOD.parse_v this_is_workaround {
        relative => <-.backcolor_editor_params;
        on_inst = 1;
        v_commands => "$push\n"
                     +   switch(!is_valid(backcolor_editor_params.red), "red = 0;\n")
                     +   switch(!is_valid(backcolor_editor_params.green), "green = 0;\n")
                     +   switch(!is_valid(backcolor_editor_params.blue), "blue = 0;\n")
                     +"$pop\n";
      };
#endif //MICROAVS_DEV_KIT
   };

/*  for MicroAVS 6.0 lݒ */
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_init_params {
     v_commands => "$push\n"
                  +"Params.backcolor_editor_params.red   = <-.env_params.background.back_col[0];\n"
                  +"Params.backcolor_editor_params.green = <-.env_params.background.back_col[1];\n"
                  +"Params.backcolor_editor_params.blue  = <-.env_params.background.back_col[2];\n"
                  +"$pop\n"
                  +"$push\n"
                  +"get_init_params.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_init_params.active =  0;\n"
                  +"$pop\n";
     relative   => <-;
     on_inst    = 1;
   };
   GMOD.parse_v get_init_params {
     v_commands    => "$push\n"
                     +"Params.env_params.background.back_col[] = {MicroAVS.MAviewer.MAviewerEditors.BackcolorEditor.Params.backcolor_editor_params.red
                                                                 ,MicroAVS.MAviewer.MAviewerEditors.BackcolorEditor.Params.backcolor_editor_params.green
                                                                 ,MicroAVS.MAviewer.MAviewerEditors.BackcolorEditor.Params.backcolor_editor_params.blue};\n"
                     +"$pop\n"
                     +"$push\n"
                     +"Control.SetenvParams.setenv_params.Go =  1;\n"
                     +"$pop\n";
     trigger+nres  => MicroAVScontroller.Params.params.env_params;
     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
#else
   GMOD.parse_v set_init_params;
   GMOD.parse_v get_init_params;
#endif //MICROAVS_DEV_KIT

/*  for MicroAVS 6.0 lݒ */

// workaround begin
   macro Workaround {
      float+nosave &back_col[] => <-.view_in.back_col;
      GMOD.parse_v this_is_workaround {
        relative => <-;
        on_inst = 1;
        v_commands => "$push\n"
                     +"back_col={"
                     +   "<-.Params.backcolor_editor_params.red,"
                     +   "<-.Params.backcolor_editor_params.green,"
                     +   "<-.Params.backcolor_editor_params.blue"
                     +"};"
                     +"$pop\n";
      };
   };
// workaround end
   MAGDview_edit BackcolorEditor {
      view      => <-.view_in;
      red       => <-.Params.backcolor_editor_params.red;
      green     => <-.Params.backcolor_editor_params.green;
      blue      => <-.Params.backcolor_editor_params.blue;
      shell_vis => <-.viewer_params.backcolor_vis;
   };

   UI {
      visible => <-.viewer_params.backcolor_vis;
      MAbackcolorEditorUI BackcolorEditorUI {
         parent => <-.parent;
         viewer_params => <-.viewer_params;
         backcolor_editor_params => <-.<-.Params.backcolor_editor_params;
         y => EditorCommonUI.y + EditorCommonUI.height;
      };
      height => EditorCommonUI.height + BackcolorEditorUI.height + 5;
   };
};
