/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/camera.v#1 $
*/
//
// Camera Editor
//
MAparams MAcamera_editor_params {
   boolean+nosave reset;
   boolean perspec     = 0;
   float   wsize       = GD_DEFAULT_WSIZE;
   float   fov         = GD_DEFAULT_VIEW_ANGLE;
   boolean hither      = 0;
   float   front       = GD_DEFAULT_FRONT_PAR;
   float   back        = GD_DEFAULT_BACK;
   float   norm_scale  = GD_DEFAULT_NORM_SCALE;
   boolean depth_cue   = 0;
   float   depth_front = GD_DEFAULT_DEPTH_FRONT;
   float   depth_back  = GD_DEFAULT_DEPTH_BACK;
   float   depth_scale = GD_DEFAULT_DEPTH_SCALE;
   init_commands = "";
   reset_commands =
       "camera_editor_params.perspec=0;"
      +"camera_editor_params.wsize=GD_DEFAULT_WSIZE;"
      +"camera_editor_params.fov=GD_DEFAULT_VIEW_ANGLE;"
      +"camera_editor_params.hither=0;"
      +"camera_editor_params.front=GD_DEFAULT_FRONT_PAR;"
      +"camera_editor_params.back=GD_DEFAULT_BACK;"
      +"camera_editor_params.norm_scale=GD_DEFAULT_NORM_SCALE;"
      +"camera_editor_params.depth_cue=0;"
      +"camera_editor_params.depth_front=GD_DEFAULT_DEPTH_FRONT;"
      +"camera_editor_params.depth_back=GD_DEFAULT_DEPTH_BACK;"
      +"camera_editor_params.depth_scale=GD_DEFAULT_DEPTH_SCALE;"
      ;
};

MAmacroUI MAcameraEditorUI {
   MAviewer_common_params &viewer_params;
   MAcamera_editor_params &camera_editor_params;

   height => camera_editor_panel.height;
   MAUIframe camera_editor_panel {
      parent => <-.parent;
      y => <-.y;
      height = 280;
   };
   MAUItoggle pers_toggle {
      parent => <-.camera_editor_panel;
      label = "MAV3CAM_PERS";
      width = 120;
      x = 10;
      y = 10;
      set => <-.camera_editor_params.perspec;
   };
   MAUIslider pers_fov_slider {
      title = "MAV3CAM_FOV";
      parent => <-.camera_editor_panel;
      x = 25;
      width = 185;
#ifdef MSDOS
      y => <-.pers_toggle.y + <-.pers_toggle.height + 10;
#else
      y => <-.pers_toggle.y + <-.pers_toggle.height;
      height = 60;
#endif //MSDOS
      value => <-.camera_editor_params.fov;
      min =   0.01;
      max = 179.99;
      active = 0;
   };
   // active no effect, when instanced
   GMOD.copy_on_change set_active_pers {
      input => <-.camera_editor_params.perspec;
      output => <-.pers_fov_slider.active;
      on_inst = 1;
#ifdef MSDOS
      copy_on_change<weight=4>; //make sure running after slider
#endif //MSDOS
   };
   MAUItoggle dep_toggle {
      parent => <-.camera_editor_panel;
      label = "MAV3CAM_DEP";
      x = 10;
      y = 115;
      width = 120;
      set => <-.camera_editor_params.depth_cue;
   };
   macro depth_cueUI {
      ilink parent => <-.camera_editor_panel;
      link visible = 1;
      link y => <-.dep_toggle.y + <-.dep_toggle.height + 5;
      MAcamera_editor_params &camera_editor_params => <-.camera_editor_params;

      boolean active = 0;
      // active no effect, when instanced
      GMOD.copy_on_change set_active {
         input => <-.camera_editor_params.depth_cue;
         output => <-.active;
         on_inst = 1;
#ifdef MSDOS
         copy_on_change<weight=4>; //make sure running after slider
#endif //MSDOS
      };
      MAUIframe dep_frame {
         parent => <-.parent;
         x = 10;
         y => <-.y;
         width = 210;
         //height = 120;
         height => <-.dep_back_slider.y + <-.dep_back_slider.height + 10;
         visible => <-.visible;
      };
      MAUIslider dep_front_slider {
         parent => <-.dep_frame;
         title = "MAV3CAM_DEP_FRONT";
         x = 10;
         width = 185;
#ifdef MSDOS
         y = 5;
#else
         y = 0;
         height = 60;
#endif //MSDOS
         value => <-.camera_editor_params.depth_front;
         min = 0;
         max = 20;
         active => <-.active;
      };
      dep_front_slider dep_back_slider {
         title = "MAV3CAM_DEP_BACK";
#ifdef MSDOS
         y => dep_front_slider.y  + dep_front_slider.height + 5;
#else
         y => dep_front_slider.y  + dep_front_slider.height;
#endif //MSDOS
         value => <-.camera_editor_params.depth_back;
      };
   };
};

MAeditor MAcameraEditor {
   title = "MAV3CAM_TITLE";
   MAGDview_templ+IPort2 &view_in;

   Params {
      params.name = "camera";
      params.help_name = "gecamera";
      MAcamera_editor_params camera_editor_params{
//         perspec    => <-.env_params.camera.perspective;
//         fov        => <-.env_params.camera.fov;
         front      => switch(perspec + 1, GD_DEFAULT_FRONT_PAR, 1);
//         depth_cue  => <-.env_params.camera.depth_cue;
//         depth_front => <-.env_params.camera.depth_front;
//         depth_back  => <-.env_params.camera.depth_back;
      };
      init_params.init_commands => camera_editor_params.init_commands;
      reset_params.reset_commands => camera_editor_params.reset_commands;
   };
/* workaround begin
   macro Workaround {
      boolean perspec     => <-.view_in.picked_camera.perspec;
      float   wsize       => <-.view_in.picked_camera.wsize;
      float   fov         => <-.view_in.picked_camera.fov;
      boolean hither      => <-.view_in.picked_camera.hither;
      float   front       => <-.view_in.picked_camera.front;
      float   back        => <-.view_in.picked_camera.back;
      float   norm_scale  => <-.view_in.picked_camera.norm_scale;
      boolean depth_cue   => <-.view_in.picked_camera.depth_cue;
      float   depth_front => <-.view_in.picked_camera.depth_front;
      float   depth_back  => <-.view_in.picked_camera.depth_back;
      float   depth_scale => <-.view_in.picked_camera.depth_scale;
      GMOD.parse_v this_is_workaround {
        relative => <-;
        active = 0;
        on_inst = 1;
        v_commands => "$push\n"
                     +"perspec=<-.Params.env_params.camera.perspective;"
                     +"wsize=<-.Params.camera_editor_params.wsize;"
                     +"hither=<-.Params.camera_editor_params.hither;"
                     +"fov=<-.Params.env_params.camera.fov;"
                     +"front=<-.Params.camera_editor_params.front;"
                     +"back=<-.Params.camera_editor_params.back;"
                     +"norm_scale=<-.Params.camera_editor_params.norm_scale;"
                     +"depth_cue=<-.Params.env_params.camera.depth_cue;"
                     +"depth_front=<-.Params.env_params.camera.depth_front;"
                     +"depth_back=<-.Params.env_params.camera.depth_back;"
                     +"depth_scale=<-.Params.camera_editor_params.depth_scale;"
                     +"$pop\n";
      };
   };
 workaround end
*/
   MAGDcamera_edit CameraEditor {
      camera      => <-.view_in.picked_camera;
      shell_vis   => <-.Params.viewer_params.camera_vis;
      perspec     => <-.Params.camera_editor_params.perspec;
      wsize       => <-.Params.camera_editor_params.wsize;
      hither      => <-.Params.camera_editor_params.hither;
      fov         => <-.Params.camera_editor_params.fov;
      front       => switch(perspec + 1, GD_DEFAULT_FRONT_PAR, 1);
      back        => <-.Params.camera_editor_params.back;
      norm_scale  => <-.Params.camera_editor_params.norm_scale;
      depth_cue   => <-.Params.camera_editor_params.depth_cue;
      depth_front => <-.Params.camera_editor_params.depth_front;
      depth_back  => <-.Params.camera_editor_params.depth_back;
      depth_scale => <-.Params.camera_editor_params.depth_scale;
      //reset       => <-.Params.camera_editor_params.reset;
   };
      GMOD.parse_v this_is_workaround {
         v_commands => "$push\n"
                      +"shell_vis   => <-.Params.viewer_params.camera_vis;"
                      +"perspec     => <-.Params.camera_editor_params.perspec;"
                      +"wsize       => <-.Params.camera_editor_params.wsize;"
                      +"hither      => <-.Params.camera_editor_params.hither;"
                      +"fov         => <-.Params.camera_editor_params.fov;"
                      +"front       => switch(perspec + 1, GD_DEFAULT_FRONT_PAR, 1);"
                      +"back        => <-.Params.camera_editor_params.back;"
                      +"norm_scale  => <-.Params.camera_editor_params.norm_scale;"
                      +"depth_cue   => <-.Params.camera_editor_params.depth_cue;"
                      +"depth_front => <-.Params.camera_editor_params.depth_front;"
                      +"depth_back  => <-.Params.camera_editor_params.depth_back;"
                      +"depth_scale => <-.Params.camera_editor_params.depth_scale;"
                      +"$pop\n";
         active     = 1;
         relative   => <-.CameraEditor;
      };

/*  for MicroAVS 6.0 lݒ */
#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_init_params {
     v_commands => "$push\n"
                  +"Params.camera_editor_params.perspec     = <-.env_params.camera.perspective;\n"
                  +"Params.camera_editor_params.fov         = <-.env_params.camera.fov;\n"
                  +"Params.camera_editor_params.depth_cue   = <-.env_params.camera.depth_cue;\n"
                  +"Params.camera_editor_params.depth_front = <-.env_params.camera.depth_front;\n"
                  +"Params.camera_editor_params.depth_back  = <-.env_params.camera.depth_back;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"get_init_params.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_init_params.active =  0;\n"
                  +"$pop\n";
     relative   => <-;
     on_inst    = 1;
   };
   GMOD.parse_v get_init_params {
     v_commands    => "$push\n"
                     +"Params.env_params.camera.perspective = MicroAVS.MAviewer.MAviewer3Editors.CameraEditor.Params.camera_editor_params.perspec;\n"
                     +"Params.env_params.camera.fov         = MicroAVS.MAviewer.MAviewer3Editors.CameraEditor.Params.camera_editor_params.fov;\n"
                     +"Params.env_params.camera.depth_cue   = MicroAVS.MAviewer.MAviewer3Editors.CameraEditor.Params.camera_editor_params.depth_cue;\n"
                     +"Params.env_params.camera.depth_front = MicroAVS.MAviewer.MAviewer3Editors.CameraEditor.Params.camera_editor_params.depth_front;\n"
                     +"Params.env_params.camera.depth_back  = MicroAVS.MAviewer.MAviewer3Editors.CameraEditor.Params.camera_editor_params.depth_back;\n"
                     +"$pop\n"
                     +"$push\n"
                     +"Control.SetenvParams.setenv_params.Go =  1;\n"
                     +"$pop\n";
     trigger+nres  => MicroAVScontroller.Params.params.env_params;
     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
#else
   GMOD.parse_v set_init_params;
   GMOD.parse_v get_init_params;
#endif //MICROAVS_DEV_KIT

/*  for MicroAVS 6.0 lݒ */

   UI {
      visible => <-.viewer_params.camera_vis;
      MAcameraEditorUI CameraEditorUI {
         parent => <-.parent;
         viewer_params => <-.viewer_params;
         camera_editor_params => <-.<-.Params.camera_editor_params;
         y => EditorCommonUI.y + EditorCommonUI.height;
      };
      height => EditorCommonUI.height + CameraEditorUI.height + 5;
   };
};
