/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/colored.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/colored.v#1 $
*/
macro+nosave MAcolorEditorUI {
   ilink parent;
   ilink visible = 1;
   link x = 0;
   link y = 55;
   link active = 1;
   int index = 0;
   float red = 0.0;
   float green = 0.0;
   float blue = 0.0;
   int palette_vis = 1;
   string label = "      ";
   link height => .slider_palette.height + rgb_frame.height;

   MAUIOptionMenuLabel slider_palette {
      parent => <-.parent;
      options => { "MAUI_SLIDER", "MAUI_PALETTE" };
      x => <-.x + 10;
      y => <-.y;
      width = 170 - .x;
      height = 30;
      selectedItem => <-.palette_vis;
      label => <-.label;
      active => <-.active;
   };
   MAUIframe sample_palette {
      parent => <-.parent;
      visible => <-.active;
#ifdef MSDOS
      x => <-.slider_palette.x + slider_palette.width + 10;
      y => <-.y;
      width = 48;
      height = 25;
#else
      x => <-.slider_palette.x + slider_palette.width + 20;
      y => <-.y;
      width = 40;
      height = 30;
#endif //MSDOS
      color.backgroundColor
         => str_format("#%02x%02x%02x", red*255, green*255, blue*255);
   };
   MAUIframe rgb_frame {
      parent => <-.parent;
      x => <-.x;
      width = 232;
#ifdef MSDOS
      y => 30 + <-.y;
      height = 168;
#else
      y => <-.sample_palette.y + <-.sample_palette.height + 10;
      height = 180+4;
      color.backgroundColor => switch(palette_vis, MAVS_DEF_GRAY);
#endif //MSDOS
   };
   GMOD.instancer InstancerSliders {
      Value => !<-.palette_vis;
      Group => <-.color_sliders;
   };
   MAUIcolor_sliders color_sliders<instanced=0> {
      parent => <-.rgb_frame;
      visible => !<-.palette_vis;
#ifdef MSDOS
      y = 15;
#else
      y = 0;
#endif //MSDOS
      red => <-.red;
      green => <-.green;
      blue => <-.blue;
      immediateMode = 0;
      active => <-.active;
   };
   GMOD.instancer InstancerPal {
      Value => <-.palette_vis;
      Group => <-.MAUIcolor_palette64;
   };
   macro MAUIcolor_palette64<instanced=0> {
      ilink parent => <-.rgb_frame;
      ilink visible => <-.palette_vis;
      link active => <-.active;
      int+IPort2 index => <-.index;
      link x = -1;
#ifdef MSDOS
      link y = -1;
#else
      link y = 7;
#endif //MSDOS
      float+IPort2 red => <-.red;
      float+IPort2 green => <-.green;
      float+IPort2 blue => <-.blue;

      MAUIcolor_palette_buttons color_palette_buttons {
         parent => <-.parent;
         visible => <-.visible;
         pixmap = "pal64.x";
         pixmap_off = "offpal64.x";
         x      => <-.x;
         y      => <-.y;
         unitx  = 29;
         unity  = 21;
         ncols  = 8;
         rows   = 8;
         index  => <-.index;
         active => <-.active;
      };
      GMOD.parse_v set_color {
         trigger => <-.index;
         v_commands = "$push -usr\n"
                     +"red=color_table[index][0];"
                     +"green=color_table[index][1];"
                     +"blue=color_table[index][2];\n"
                     +"$pop\n";
         on_inst = 0;
         relative => <-.<-;
      };
      float color_table[64][3] = {
            { 1.00, 0.50, 0.50 },
            { 1.00, 1.00, 0.50 },
            { 0.50, 1.00, 0.50 },
            { 0.00, 1.00, 0.50 },
            { 0.50, 1.00, 1.00 },
            { 0.00, 0.50, 1.00 },
            { 1.00, 0.50, 0.75 },
            { 1.00, 0.50, 1.00 },
            { 1.00, 0.00, 0.00 },
            { 1.00, 1.00, 0.00 },
            { 0.50, 1.00, 0.00 },
            { 0.00, 1.00, 0.25 },
            { 0.00, 1.00, 1.00 },
            { 0.00, 0.50, 0.75 },
            { 0.50, 0.50, 0.75 },
            { 1.00, 0.00, 1.00 },
            { 0.50, 0.25, 0.25 },
            { 1.00, 0.50, 0.25 },
            { 0.00, 1.00, 0.00 },
            { 0.00, 0.50, 0.50 },
            { 0.00, 0.25, 0.50 },
            { 0.50, 0.50, 1.00 },
            { 0.50, 0.00, 0.25 },
            { 1.00, 0.00, 0.50 },
            { 0.50, 0.00, 0.00 },
            { 1.00, 0.50, 0.00 },
            { 0.00, 0.50, 0.00 },
            { 0.00, 0.50, 0.25 },
            { 0.00, 0.00, 1.00 },
            { 0.00, 0.00, 0.63 },
            { 0.50, 0.00, 0.50 },
            { 0.50, 0.00, 1.00 },
            { 0.25, 0.00, 0.00 },
            { 0.50, 0.25, 0.00 },
            { 0.00, 0.25, 0.00 },
            { 0.00, 0.25, 0.25 },
            { 0.00, 0.00, 0.50 },
            { 0.00, 0.00, 0.25 },
            { 0.25, 0.00, 0.25 },
            { 0.25, 0.00, 0.50 },
            { 0.00, 0.00, 0.00 },
            { 0.50, 0.50, 0.00 },
            { 0.50, 0.50, 0.25 },
            { 0.50, 0.50, 0.50 },
            { 0.25, 0.50, 0.50 },
            { 0.75, 0.75, 0.75 },
            { 0.25, 0.00, 0.25 },
            { 1.00, 1.00, 1.00 },
            { 0.03, 0.03, 0.03 },
            { 0.09, 0.09, 0.09 },
            { 0.16, 0.16, 0.16 },
            { 0.22, 0.22, 0.22 },
            { 0.28, 0.28, 0.28 },
            { 0.35, 0.35, 0.35 },
            { 0.41, 0.41, 0.41 },
            { 0.47, 0.47, 0.47 },
            { 0.53, 0.53, 0.53 },
            { 0.60, 0.60, 0.60 },
            { 0.66, 0.66, 0.66 },
            { 0.72, 0.72, 0.72 },
            { 0.78, 0.78, 0.78 },
            { 0.85, 0.85, 0.85 },
            { 0.91, 0.91, 0.91 },
            { 0.97, 0.97, 0.97 }
      };
   };
};
