/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/funcs.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/funcs.v#1 $
*/
//
// Modes Select
//
module MAmodes_select {
   int points;
   int lines;
   int surf;
   int volume;
   int bounds;
   int normals;
   int hidden_line;
   int index;
   int+nonotify+nosave old_index<NEvisible=0>;
   int+nonotify+nosave old_hidden_line<NEvisible=0>;
   omethod+notify_val update1
                      (index+read, old_index+read+write,
                       hidden_line+read, old_hidden_line+read+write,
                       points+write, lines+write, surf+write,
                       surf+write, volume+write, bounds+write, normals+write)
      = "MAmodes_select_update1";
   omethod+notify_val update2
                      (index+write, old_index+read,
                       hidden_line+write, old_hidden_line+read,
                       points+read, lines+read, surf+read,
                       surf+read, volume+read, bounds+read, normals+read)
      = "MAmodes_select_update2";
};
//
// Object name Select
//
module MAobjname_select {
   string+Iparam  &objnames[];
   string+opt     &objname;
   int+opt        &index;
   int+nonotify+nosave old_index<NEvisible=0>;
   boolean+Oparam result;
   omethod+notify_val update1
      (objnames+read, objname+read, old_index+read+write,
       index+write, result+write)
      = "MAobjname_select_update1";
   omethod+notify_val update2
      (objnames+read, objname+write, old_index+read+write,
       index+read, result+write)
      = "MAobjname_select_update2";
};
//
// Object Selector MicroAVS special version
//
MAGDobj_sel_templ MAGDobj_sel
{
   ptr+nonotify local_ptr<NEvisible=0>;
   sdims = 0;
   curobj_name = "";
   int+write obj_list_changed = 0;
   string+nonotify except_name = "NOOBJLIST"; // new one
   method+notify_inst+notify_val upd_func = "MAGDobj_sel_update";
   method+notify_deinst del_func = "MAGDobj_sel_delete";
};
//
// Get Object Extent (deeply)
//
module MAget_extent
{
   prim+read+notify &trigger;
   MAGDobject_templ+Iparam *object;
   string+nonotify except_name = "NOOBJLIST";

   double+write+nonotify xmin;
   double+write+nonotify ymin;
   double+write+nonotify zmin;
   double+write+nonotify xmax;
   double+write+nonotify ymax;
   double+write+nonotify zmax;
   omethod+notify_val update = "MAget_extent_update";
};
//
// Generate Sphere
//
#ifdef NOT_GOOD
macro MAgen_sphere
{
   int    &subdiv = 5;
   float  &radius = 0.5;
   float  radius2<NEvisible=0> => radius * 2.0;
   Field_Spher_Unif sphere { // this sphere do NOT good.
      int nnodes => prod(dims);
      int nspace = 3;
      int ndim = 3;
      int dims[ndim] => {2, subdiv, subdiv};
      float points[npoints][nspace] = {
            {0., 0., 0.},{radius, 3.14159 * radius2, 6.28318 * radius2}
      };
   };
   olink fld_out => sphere;
};
#else
module MAgen_sphere
{
   int+read+notify+req   &subdiv = 5;
   float+read+notify+opt &radius = 0.5;
   Mesh+OPort2 fld_out {
      nspace = 3;
      ncell_sets = 1;
      Polyhedron cell_set;
   };
   omethod+notify_val+notify_inst update<status=1> = "MAgen_sphere_update";
};
#endif
group MAGDxform_edit_notify_templ {
   float x_rot; 
   float y_rot;
   float z_rot;
   float x_trans;
   float y_trans;
   float z_trans;
   float x_cent;
   float y_cent;
   float z_cent;
   float scale;
   float x_scale;
   float y_scale;
   float z_scale;
};

MAGDxform_edit_notify_templ MAGDxform_edit2 {
   int+IPort2 shell_vis;
   int absolute;
   int reset;
   float abs_x_rot; 
   float abs_y_rot;
   float abs_z_rot;
   float abs_x_trans;
   float abs_y_trans;
   float abs_z_trans;
   float abs_x_cent;
   float abs_y_cent;
   float abs_z_cent;
   float abs_scale;
   float abs_x_scale;
   float abs_y_scale;
   float abs_z_scale;
   GDxform_templ+IPort2+read &xform;
   omethod+notify_inst+notify_val upd_func = "MAGDxform_edit_update";
};
module MAset_altobj
{
   prim+read+notify        &trigger;
   MAGDobject_templ+Iparam *object;
   string+nonotify         except_name =;
   boolean+read+notify+req &use_altobj;

   omethod+notify_val update = "MAset_altobj_update";
};

#ifdef MICROAVS_DEV_KIT
$include MicroAVS/GD/MAGDcall_window_default.v
$include MicroAVS/GD/MAGDset_window_default.v
$include MicroAVS/GD/MAGDget_window_default.v
$include MicroAVS/GD/set_default.v
#endif //MICROAVS_DEV_KIT
$include MicroAVS/GD/MAGDxform_file_dlg.v
$include MicroAVS/GD/MAGDxform_sub_obj.v
