/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/light.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/light.v#1 $
*/
//
// Light Editor
//
MAparams MAlight_editor_params {
   boolean+nosave xform_reset;
   boolean        xform_editor_vis = 0;
   double         rotate_val = 45.0;
   double         x_rot = 0;
   double         y_rot = 0;
   double         z_rot = 0;
   int+nosave     current_light = 0;
   boolean        show_lights = 0;
   boolean+nosave light_state = 1;
   int+nosave     light_type = 3;	// Bi-Directional
   double+nosave  light_red = 1.0;
   double+nosave  light_green = 1.0;
   double+nosave  light_blue = 1.0;
   boolean+nosave ambient_light_state = 1;
   double+nosave  ambient_light_red = 1.0;
   double+nosave  ambient_light_green = 1.0;
   double+nosave  ambient_light_blue = 1.0;
   init_commands = "";
   reset_commands =
       "light_editor_params.current_light=0;"
      +"light_editor_params.show_lights=0;"
      +"light_editor_params.ambient_light_state=1;"
      +"light_editor_params.ambient_light_red=1;"
      +"light_editor_params.ambient_light_green=1;"
      +"light_editor_params.ambient_light_blue=1;"
      +"light_editor_params.rotate_val=45;"
      +"light_editor_params.xform_editor_vis=0;"
      ;
};

MAmacroUI MAlightEditorUI {
   MAviewer_common_params &viewer_params;
   MAlight_editor_params &light_editor_params;

   boolean active = 0;
   int current_light => .light_editor_params.current_light;

   height => light_editor_panel.height;
   MAUIframe light_editor_panel {
      parent => <-.parent;
      y => <-.y;
#ifdef MSDOS
      height = 365;
#else
      height = 385;
#endif //MSDOS
   };
   GMOD.copy_on_change set_active {
      input => <-.LightState.selectedItem;
      output => <-.active;
      copy_on_change<weight=3>;
   };
   MAUIframe AmbLightFrame {
      parent => <-.light_editor_panel;
      x = -1;
      y = -1;
      width = 232;
      height = 35;
   };
   MAUIOptionMenuLabel AmbLight {
      parent => <-.AmbLightFrame;
      options => { "MAUI_OFF", "MAUI_ON" };
      selectedItem => <-.light_editor_params.ambient_light_state;
      x = 5;
      y = 3;
      width = 220;
      height = 30;
      label = "MAV3LIT_AMB";
   };
   MAUIOptionMenuLabel Select {
      parent => <-.light_editor_panel;
      options => {
         "MAV3LIT" + " 1",
         "MAV3LIT" + " 2",
         "MAV3LIT" + " 3",
         "MAV3LIT" + " 4"
      };
      selectedItem => <-.light_editor_params.current_light;
      label = "MAV3LIT_SEL";
      x = 5;
      y = 40;
      width = 220;
      height = 30;
   };
   MAUIOptionMenuLabel LightState {
      parent => <-.light_editor_panel;
      options => { "MAUI_OFF", "MAUI_ON" };
      selectedItem => <-.light_editor_params.light_state;
      x = 10;
      y => <-.Select.y + <-.Select.height + 2;
      width = 210;
      height = 30;
      label = "MAV3LIT_STATE";
   };
//
   UIoption Directional    { label = "MAV3LIT_DIR"; };
   UIoption Bi_Directional { label = "MAV3LIT_BIDIR"; };
   MAUIoptionMenu LightType {
      parent => <-.light_editor_panel;
      cmdList => {<-.Directional, <-.Bi_Directional};
      x = 10;
      y => <-.LightState.y + <-.LightState.height;
      width = 210;
      height = 30;
      selectedItem = 1;
      label = "MAV3LIT_TYPE";
   };
   GMOD.copy_on_change set_type {
      input => <-.light_editor_params.light_type;
      boolean output => <-.LightType.selectedItem; // make sure 0 or 1
      on_inst = 0;
   };
   GMOD.copy_on_change set_dir_type {
      input => switch(<-.Directional.set+1, 3, 0);
      output => <-.light_editor_params.light_type;
      on_inst = 0;
   };
   MAcolorEditorUI LightColorEditorUI {
      MAlight_editor_params &light_editor_params => <-.light_editor_params;
      parent => <-.light_editor_panel;
      y => <-.LightType.y + <-.LightType.height;
      active => <-.active;
      label = "MAV3LIT_COL";
      int current_light => <-.light_editor_params.current_light;
      red   => <-.light_editor_params.light_red;
      green => <-.light_editor_params.light_green;
      blue  => <-.light_editor_params.light_blue;
   };
   MAUIbutton TransformEditorButton {
      parent => <-.light_editor_panel;
      x = 10;
      y => <-.light_editor_panel.height - .height - 5;
      width = 210;
      height = 20;
      active => <-.active;
      do => <-.light_editor_params.xform_editor_vis;
      label => "MAV3LIT_TRANS"+" ...";
   };
   GMOD.instancer TransformEditorUIinstancer {
      Group => <-.TransformEditorUI;
      Value => <-.TransformEditorButton.do;
      active = 2;
   };
   macro TransformEditorUI<instanced=0> {
      ilink viewer_params => <-.viewer_params;
      ilink light_editor_params => <-.light_editor_params;
      MAeditor_common_params params {
         reset => <-.light_editor_params.xform_reset;
         name = "litxform";
         help_name = "gelidir";
      };
      MAmime HelpViewer {
         trigger => <-.params.help;
         stFilename => MAVS_HELP_PATH+"/viewer/"+params.help_name+".htm";
      };
      MAUIcloseDialog mod_panel {
         title = "MAV3LIT_TRANS";
         width = 240;
         height = 280;
         visible => <-.light_editor_params.xform_editor_vis;
      };
      MAeditorCommonUI CommonUI {
         parent => <-.mod_panel;
         params => <-.params;
         y = 0;
      };
      MAUIOptionMenuLabel ShowLights {
         parent => <-.mod_panel;
         options => { "MAUI_OFF", "MAUI_ON" };
         selectedItem => <-.light_editor_params.show_lights;
         y = 55;
#ifdef MSDOS
         x = 30;
         width = 230;
         height = 20;
         OPmenu.width = 80;
         OPlabel.width = 110;
#else
         x = 0;
         height = 40;
         OPlabel.x = 0;
         OPlabel.width = 180;
         OPmenu.x = 180;
         OPmenu.width = 50;
#endif //MSDOS
         label = "MAV3LIT_SHOW";
      };
      MAUIframe RotateFrame {
         parent => <-.mod_panel;
#ifdef MSDOS
         y = 80;
#else
         y => <-.ShowLights.y + <-.ShowLights.height;
#endif //MSDOS
         width = 234;
         height = 130;
      };
      MAUIbutton Xminus {
         parent => <-.RotateFrame;
         x = 30; y = 25;
         width = 48;
         height = 40;
         label => "-X " + "MAUI_ROTA";
         labelPixmap.filename = MAVS_ICON_PATH + "grotx2.x";
         labelPixmap.fileType = "avs_image";
         toolTip.enable = "always";
      };
      Xminus Yminus {
         x = 80; y = 45;
         label => "-Y " + "MAUI_ROTA";
         labelPixmap.filename = MAVS_ICON_PATH + "groty2.x";
      };
      Xminus Zplus {
         x = 55; y = 85;
         label => "+Z " + "MAUI_ROTA";
         labelPixmap.filename = MAVS_ICON_PATH + "grotz2.x";
      };
      Xminus Xplus {
         x = 130;
         label => "+X " + "MAUI_ROTA";
         labelPixmap.filename = MAVS_ICON_PATH + "grotx1.x";
      };
      Xplus Yplus {
         x = 80; y = 5;
         label => "+Y " + "MAUI_ROTA";
         labelPixmap.filename = MAVS_ICON_PATH + "groty1.x";
      };
      Xplus Zminus {
         x = 105; y = 85;
         label => "-Z " + "MAUI_ROTA";
         labelPixmap.filename = MAVS_ICON_PATH + "grotz1.x";
      };
      MAUIlabel RotateLabel {
         parent => <-.RotateFrame;
         x = 0;
         y = 95;
         width = 50;
         label = "MAUI_ROTA";
      };
      MAUIfield RotateValue {
         parent => <-.RotateFrame;
         x = 155;
         y = 90;
         width = 55;
         value => <-.light_editor_params.rotate_val;
         min = 0.0;
         max = 360.0;
      };
      GMOD.parse_v IncrX {
         trigger => <-.Xplus.do;
         v_commands = "x_rot = rotate_val;\n";
         relative => <-.light_editor_params;
         on_inst = 0;
      };
      IncrX DecrX {
         trigger => <-.Xminus.do;
         v_commands = "x_rot = -rotate_val;\n";
      };
      IncrX IncrY {
         trigger => <-.Yplus.do;
         v_commands = "y_rot = rotate_val;\n";
      };
      IncrY DecrY {
         trigger => <-.Yminus.do;
         v_commands = "y_rot = -rotate_val;\n";
      };
      IncrX IncrZ {
         trigger => <-.Zplus.do;
         v_commands = "z_rot = rotate_val;\n";
      };
      IncrZ DecrZ {
         trigger => <-.Zminus.do;
         v_commands = "z_rot = -rotate_val;\n";
      };
   };
};

MAeditor MAlightEditor {
   title = "MAV3LIT_TITLE";
   MAGDview_templ+IPort2 &view_in { GDlight_info_templ+OPort2 &light_info; };
   int current_light => Params.light_editor_params.current_light;

   Params {
      ilink view_in => <-.view_in;
      params.name = "light";
      params.help_name = "gelight";
      MAlight_editor_params light_editor_params;
      init_params.init_commands => light_editor_params.init_commands;
      reset_params.reset_commands => light_editor_params.reset_commands;
      GMOD.parse_v reset_lights {
         trigger => <-.params.reset;
         v_commands => 
 "$push -usr\n"
+"Light1.state=1;Light1.type=3;Light1.col=1;"
+"Light2.state=0;Light2.type=3;Light2.col=1;"
+"Light3.state=0;Light3.type=3;Light3.col=1;"
+"Light4.state=0;Light4.type=3;Light4.col=1;"
+"LightXform1.mat={1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1};"
+"LightXform2.mat={1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1};"
+"LightXform3.mat={1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1};"
+"LightXform4.mat={1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1};\n"
+"$pop\n";
         on_inst = 0;
         relative => <-.<-.viewer_params;
      };
   };

   MAGDlinfo_edit+nosave LinfoEditor {
      shell_vis  => <-.Params.viewer_params.light_vis;
      show       => <-.Params.light_editor_params.show_lights;
      amb_onoff  => <-.Params.light_editor_params.ambient_light_state;
      amb_red    => <-.Params.light_editor_params.ambient_light_red;
      amb_green  => <-.Params.light_editor_params.ambient_light_green;
      amb_blue   => <-.Params.light_editor_params.ambient_light_blue;
      cur_light  => <-.Params.light_editor_params.current_light;
      light_info => <-.view_in.light_info;
   };
   MAGDlight_edit+nosave LightEditor {
      shell_vis  => <-.Params.viewer_params.light_vis;
      state      => <-.Params.light_editor_params.light_state;
      type       => <-.Params.light_editor_params.light_type;
      light      => <-.LinfoEditor.sel_light;
      red        => <-.Params.light_editor_params.light_red;
      green      => <-.Params.light_editor_params.light_green;
      blue       => <-.Params.light_editor_params.light_blue;
   };

   MAGDxform_edit+nosave XformEditor {
      shell_vis  => <-.Params.light_editor_params.xform_editor_vis;
      scale      = 1;
      absolute   = 0;
      xform+nres => <-.LinfoEditor.sel_light.xform;
      reset      => <-.Params.light_editor_params.xform_reset;
      x_rot      => <-.Params.light_editor_params.x_rot;
      y_rot      => <-.Params.light_editor_params.y_rot;
      z_rot      => <-.Params.light_editor_params.z_rot;
   };
   GMOD.copy_on_change off_show_lights {
      trigger => <-.Params.light_editor_params.xform_reset;
      input = 0;
      output => <-.Params.light_editor_params.show_lights;
      on_inst = 0;
   };

   UI {
      visible => <-.viewer_params.light_vis;
      MAlightEditorUI LightEditorUI {
         parent => <-.parent;
         viewer_params => <-.viewer_params;
         light_editor_params => <-.<-.Params.light_editor_params;
         y => EditorCommonUI.y + EditorCommonUI.height;
      };
      height => EditorCommonUI.height + LightEditorUI.height + 5;
   };
};
