/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/mode.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/mode.v#1 $
*/
//
// Mode Editor
//
MAparams MAmode_editor_params {
   int index =;
   int+nosave points;
   int+nosave lines;
   int+nosave surf;
   int+nosave volume;
   int+nosave bounds;
   int+nosave normals;
   int+nosave line_style = GD_DEFAULT_LINE_STYLE;
   int+nosave hidden_line = 0;
   boolean+nosave reset;
   init_commands => "";
   reset_commands =
       "mode_editor_params.index=9;"
      +"mode_editor_params.line_style="+GD_DEFAULT_LINE_STYLE+";"
      +"mode_editor_params.hidden_line=0;"
      ;
};

MAmacroUI MAmodeEditorUI {
   MAviewer_common_params &viewer_params;
   MAmode_editor_params &mode_editor_params;
 
   height => mode_editor_panel.height;
   MAUIframe mode_editor_panel {
      parent => <-.parent;
      y => <-.y;
      height = 300;
   };
   UIpanel mode_frame {
      parent => <-.mode_editor_panel;
      pixmap.filename = MAVS_ICON_PATH + "modes.x";
      pixmap.fileType = "avs_image";
      x = 17;
      y = 10;
      width = 194;
      height = 220;
   };
   MAUIlabel unvisible {
      parent => <-.mode_frame;
      label = "MAV3MODE_INVIS";
      x = 60;
      y = 11;
      width = 130;
      height = 18;
      fontAttributes.family = "times";
      fontAttributes.height = 16;
      alignment = "left";
   };
   unvisible point        { y = 13+ 20; label = "MAV3MODE_PT"; };
   unvisible line         { y = 13+ 40; label = "MAV3MODE_LINE"; };
   unvisible no_light     { y = 13+ 60; label = "MAV3MODE_NOLIT"; };
   unvisible flat         { y = 13+ 80; label = "MAV3MODE_FLAT"; };
   unvisible facet        { y = 13+100; label = "MAV3MODE_FACET"; };
   unvisible gouraud      { y = 13+120; label = "MAV3MODE_GOURAUD"; };
   unvisible line_gouraud { y = 13+140; label = "MAV3MODE_OUTGOURAUD"; };
   unvisible bounds       { y = 13+160; label = "MAV3MODE_BOUNDS"; };
   unvisible inherit      { y = 13+180; label = "MAV3MODE_INHERIT"; };
   UIonePoint choicer { view => <-.mode_frame; runEvent = "<Btn1Down>"; };
   UIpanel radio_on {
      parent => <-.mode_frame;
      x = 37;
      y => <-.mode_editor_params.index * 20 + 13;
      width = 18;
      height = 18;
      pixmap.filename => MAVS_ICON_PATH+"mode_on.x";
      pixmap.fileType => "avs_image";
   };
   MAUIOptionMenuLabel line_mode_select {
      parent => <-.mode_editor_panel;
#ifdef MSDOS
      x = -60;
#else
      x = -40;
#endif //MSDOS
      y => <-.mode_frame.y + <-.mode_frame.height + 10;
      width => <-.mode_frame.width * 1.4; 
      height = 25;
      label => "MAV3LINE";
      options => {"MAV3LINE_SOLID", "MAV3LINE_DASHED",
                  "MAV3LINE_DOTTED", "MAV3LINE_DASHED_DOTTED"};
      selectedItem => <-.mode_editor_params.line_style;      
   };
   MAUItoggle hidden_line_toggle {
      parent =><-.mode_editor_panel;
      x = 37;
      y => <-.line_mode_select.y + <-.line_mode_select.height + 5;
      label => "MAV3LINE_HIDE";
      set => <-.mode_editor_params.hidden_line;      
      active => <-.mode_editor_params.index == 1 ||
                <-.mode_editor_params.index == 2;
   };
   //boolean range_check => (.choicer.x > 40) && (.choicer.x < 50);
   int state => .choicer.state;
   GMOD.copy_on_change set_radio_on {
      input => switch(<-.state, (<-.choicer.y - 11) / 20);
      output => <-.mode_editor_params.index;
      on_inst = 0;
   };
};

MAeditor MAmodeEditor {
   title = "MAV3MODE_TITLE";
   GDobject_templ+IPort2 &obj_in { 
	GDmodes_templ+OPort2 &modes; 
   };

   Params {
      params.name = "mode";
      params.help_name = "gemode";
      MAmode_editor_params mode_editor_params;
      init_params.init_commands => mode_editor_params.init_commands;
      reset_params.reset_commands => mode_editor_params.reset_commands;
   };

   MAmodes_select modes_select {
      index       => <-.Params.mode_editor_params.index;
      points      => <-.Params.mode_editor_params.points;
      lines       => <-.Params.mode_editor_params.lines;
      surf        => <-.Params.mode_editor_params.surf;
      volume      => <-.Params.mode_editor_params.volume;
      bounds      => <-.Params.mode_editor_params.bounds;
      normals     => <-.Params.mode_editor_params.normals;
      hidden_line => <-.Params.mode_editor_params.hidden_line;
   };
   GDmodes_edit ModeEditor {
      shell_vis => <-.Params.viewer_params.mode_vis;
      modes     => <-.obj_in.modes;
      points    => <-.Params.mode_editor_params.points;
      lines     => <-.Params.mode_editor_params.lines;
      surf      => <-.Params.mode_editor_params.surf;
      volume    => <-.Params.mode_editor_params.volume;
      bounds    => <-.Params.mode_editor_params.bounds;
      normals   => <-.Params.mode_editor_params.normals;
      //reset     => <-.Params.mode_editor_params.reset;
   };
   GDprops_edit PropsEditor {
      shell_vis  => <-.Params.viewer_params.mode_vis;
      props      => <-.obj_in.props;
      line_style => <-.Params.mode_editor_params.line_style;
   };
   UI {
      visible => <-.viewer_params.mode_vis;
      MAmodeEditorUI ModeEditorUI {
         parent => <-.parent;
         viewer_params => <-.viewer_params;
         mode_editor_params => <-.<-.Params.mode_editor_params;
         y => EditorCommonUI.y + EditorCommonUI.height;
      };
      height => EditorCommonUI.height + ModeEditorUI.height + 5;
   };
};
