/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/precisio.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/precisio.v#1 $
*/
//
// Precision Editor
//
MAparams MAprecision_editor_params {
   int subdiv = GD_DEFAULT_SUBDIV;
   int line_width = GD_DEFAULT_LINE_WIDTH;
   int jitter = GD_DEFAULT_JITTER;
   boolean line_aa = 0; //GD_DEFAULT_LINE_AA;
   boolean+nosave subdiv_reset;
   boolean+nosave line_width_reset;
   boolean+nosave jitter_reset;
   init_commands => "";
   reset_commands =
       "precision_editor_params.subdiv_reset=1;"
      +"precision_editor_params.line_width_reset=1;"
      +"precision_editor_params.jitter_reset=1;"
      +"precision_editor_params.line_aa=0;"
      ;
};

MAmacroUI MAprecisionEditorUI {
   MAviewer_common_params &viewer_params;
   MAprecision_editor_params &precision_editor_params;

#ifdef ACTIVE_BUG_NOT_FIXED
   GMOD.copy_on_change set_active {
      input => (<-.viewer_params.renderer != 0);
      output => <-.active;
      on_inst = 1;
#ifdef MSDOS
      copy_on_change<weight=3>;
#endif //MSDOS
   };
   boolean active = 0;
#else
    boolean active => (<-.viewer_params.renderer != 0);
#endif //ACTIVE_BUG_NOT_FIXED

   height => precision_editor_panel.height;
   MAUIframe precision_editor_panel {
      parent => <-.parent;
      y => <-.y;
      height = 230+30;
   };
   MAUIframe SubdivFrame {
      parent => <-.precision_editor_panel;
      x = 5;
      y = 10;
      width = 220;
#ifdef MSDOS
      height = 75;
#else
      height = 80;
#endif //MSDOS
   };
#ifdef MSDOS
   MAUIlabel SubdivLabel {
      parent => <-.SubdivFrame;
      label = "MAV3PRE_SUBDIV";
      visible => !<-.active;
      x = 5;
      y = 5;
      width = 160;
      height = 40;
      active => <-.active;
   };
#endif //MSDOS
   MAUIslider SubdivSlider {
      title = "MAV3PRE_SUBDIV";
      parent => <-.SubdivFrame;
      x = 5;
#ifdef MSDOS
      y = 5;
      width = 160;
      height = 40;
      visible => <-.active;
#else
      y = 0;
      width = 150;
      height = 60;
      active => <-.active;
#endif //MSDOS
      min = 3;
      max = 40;
      value => <-.precision_editor_params.subdiv;
      immediateMode = 0;
      decimalPoints = 0;
      mode = 1;
   };
   MAUIlabel SubdivLabelRoughSmooth {
      parent => <-.SubdivFrame;
#ifdef MSDOS
      x = 5;
      y => <-.SubdivSlider.y + <-.SubdivSlider.height + 5;
      width = 160;
      height = 20;
#else
      x = 0;
      y => <-.SubdivSlider.y + <-.SubdivSlider.height;
      width = 175;
      height = 14;
#endif //MSDOS
      active => <-.active;
      label = "MAV3PRE_ROUGH_SMOOTH";
   };
   MAUIbutton SubdivResetB {
      parent => <-.SubdivFrame;
      x => <-.SubdivSlider.x + <-.SubdivSlider.width + 5;
      y = 24;
#ifdef MSDOS
      width = 40;
#else
      width = 58;
#endif //MSDOS
      label = "MAUI_SMALLRESET";
      do => <-.precision_editor_params.subdiv_reset;
      active => <-.active;
   };

   MAUIframe LineWidthFrame {
      parent => <-.precision_editor_panel;
      x => <-.SubdivFrame.x;
      y => <-.SubdivFrame.y + <-.SubdivFrame.height + 5;
      width = 220;
      height = 60;
   };
   SubdivSlider LineWidthSlider {
      parent => <-.LineWidthFrame;
      title = "MAV3PRE_LINEW";
      min = 0;
      max = 10;
      value => <-.precision_editor_params.line_width;
      visible => 1;
      active  => 1;
   };
   SubdivResetB LineWidthResetB {
      parent => <-.LineWidthFrame;
      x => <-.LineWidthSlider.x + <-.LineWidthSlider.width + 5;
      do => <-.precision_editor_params.line_width_reset;
      active => 1;
   };

   LineWidthFrame JitterFrame {
      y => <-.LineWidthFrame.y + <-.LineWidthFrame.height + 5;
   };
   LineWidthSlider JitterSlider {
      parent => <-.JitterFrame;
      title = "MAV3PRE_JITTER";
      min = -5;
      max =  5;
      value => <-.precision_editor_params.jitter;
   };
   LineWidthResetB JitterResetB {
      parent => <-.JitterFrame;
      x => <-.JitterSlider.x + <-.JitterSlider.width + 5;
      do => <-.precision_editor_params.jitter_reset;
   };
   MAUItoggle SmoothLines {
      label => "MAV3PRE_SMOOTH_LINES";
      parent => <-.precision_editor_panel;
      x = 10;
      y => <-.JitterFrame.y + <-.JitterFrame.height + 5;
      width = 220;
      set => <-.precision_editor_params.line_aa;
      active => <-.active;
   };
};

MAeditor MAprecisionEditor {
   title = "MAV3PRE_TITLE";
   MAGDobject_templ+IPort2 &obj_in { GDprops_templ+OPort2 &props; };

   Params {
      params.name = "precisio";
      params.help_name = "gepreci";
      MAprecision_editor_params precision_editor_params;
      init_params.init_commands => precision_editor_params.init_commands;
      reset_params.reset_commands => precision_editor_params.reset_commands;
   };

   MAGDprops_edit PrecisionEdit {
      props      => <-.obj_in.props;
      shell_vis  => <-.Params.viewer_params.precision_vis;
      subdiv     => <-.Params.precision_editor_params.subdiv;
      line_width => <-.Params.precision_editor_params.line_width;
      jitter     => <-.Params.precision_editor_params.jitter;
      line_aa    => <-.Params.precision_editor_params.line_aa;
   };
   GMOD.copy_on_change reset_subdiv {
      trigger => <-.Params.precision_editor_params.subdiv_reset;
      input = GD_DEFAULT_SUBDIV;
      output => <-.Params.precision_editor_params.subdiv;
      on_inst = 0;
   };
   GMOD.copy_on_change reset_line_width {
      trigger => <-.Params.precision_editor_params.line_width_reset;
      input = GD_DEFAULT_LINE_WIDTH;
      output => <-.Params.precision_editor_params.line_width;
      on_inst = 0;
   };
   GMOD.copy_on_change reset_jitter {
      trigger => <-.Params.precision_editor_params.jitter_reset;
      input = GD_DEFAULT_JITTER;
      output => <-.Params.precision_editor_params.jitter;
      on_inst = 0;
   };

   UI {
      visible => <-.viewer_params.precision_vis;
      MAprecisionEditorUI PrecisionEditorUI {
         parent => <-.parent;
         viewer_params => <-.viewer_params;
         precision_editor_params => <-.<-.Params.precision_editor_params;
         y => EditorCommonUI.y + EditorCommonUI.height;
      };
      height => EditorCommonUI.height + PrecisionEditorUI.height + 5;
   };
};
