/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/templ.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/templ.v#1 $
*/
//
// MicroAVS 4.0 uses components of GD Kit
//
GDtrack_edit+nosave		MAGDtrack_edit;
GDview_edit+nosave		MAGDview_edit;
GDmodes_edit+nosave		MAGDmodes_edit;
GDcamera_edit+nosave		MAGDcamera_edit;
GDprops_edit+nosave		MAGDprops_edit;
GDobj_edit+nosave		MAGDobj_edit;
GDxform_edit+nosave		MAGDxform_edit;
GDlinfo_edit+nosave		MAGDlinfo_edit;
GDlight_edit+nosave		MAGDlight_edit;
GDobj_sel_templ+nosave		MAGDobj_sel_templ;
GDcamera_templ+nosave		MAGDcamera_templ;
GDxform_templ+nosave		MAGDxform_templ;
GDobject_templ+nosave		MAGDobject_templ;
DefaultCamera2D			MAdefaultCamera2D { norm_invisible=1;};
DefaultCamera3D			MAdefaultCamera3D { norm_invisible=1;};
DefaultCamera			MAdefaultCamera   { norm_invisible=1;};
DefaultView			MAdefaultView;
DefaultFieldOutput		MAdefaultFieldOutput;
DefaultVpsOutput		MAdefaultVpsOutput;
DefaultVrmlOutput		MAdefaultVrmlOutput;
DefaultObject			MAdefaultObject {
                                   cache_size = 256;
                                   MAcut_plane_params cut_plane_params;
                                   MAcut_plane_params &top_cut_plane_params;
                                   MAs2t_params &s2t_params;
                                };
DefaultMinMax			MAdefaultMinMax;
AltObject			MAaltObject;
DefaultTexture			MAdefaultTexture;
DataObjectLite			MAdataObjectLite;
DataObjectNoTexture		MAdataObjectNoTexture;
//
// MicroAVS 2.0 Custom Components
//
GDview_templ MAGDview_templ<NEportLevels={2,1},NEcolor0=0xff00ff> {
   UIrenderView &render_view { // render_view in view required
      x =; width =; height =;
   };
   UItwoPoint &two_point;
   UImouseEvents &mouse_events;
};
//
// MAdataObject 2D, 3D and MAgroupObject
//
#ifdef OLD
// Note1:
// use_altobj+nres => MicroAVS.dataObj.use_altobj3d;
// We use the name, MicroAVS directly!
#endif
// Note2:
// Obj.visible =>(<-.<-.Obj.use_altobj) * <-.<-.Obj.visible; // for MicroAVS
// to be or not to be visible alt object, if object visible == 0
//
macro MAdataObject2D<locked=0> {
   group &in<NEportLevels={2,1},NEnumColors=4,NEcolor0=0xff> {
      int ndim = 2;
      int nspace = 2;
      MAGDxform_templ &xform;
      method render;
   };
   imlink child_objs;

   DefaultProps+OPort Props<export_all=1>;
   DefaultModes+OPort Modes<export_all=1>;
   DefaultPickInfo+OPort PickInfo<export_all=1>;
   GMOD.instancer AltObjectInstancer {
      Value => <-.Obj.use_altobj;
      Group => <-.AltObject;
   };
   MAaltObject AltObject<export_all=1, instanced=0> {
      alt_in => in;
      Obj.visible =><-.<-.Obj.use_altobj; // for MicroAVS
   };
   //DefaultXform+OPort Xform<export_all=1>;
   MAdefaultObject+OPort Obj<export_all=2> {
      input => in;
      objects => child_objs;
      altobj => AltObject.obj;
      modes => Modes;
      props => Props;
      xform => ;//Xform;
      pick_info => PickInfo;
      name => name_of(<-.<-);
#ifdef OLD
      use_altobj+nres => MicroAVS.dataObj.use_altobj2d;
#endif
   };
   olink obj => Obj;
};
macro MAdataObject<locked=0> {
   group &in<NEportLevels={2,1},NEnumColors=4,NEcolor0=0xff> {
      GDxform_templ &xform;
      method render;
   };
   imlink child_objs;

   DefaultLinear+OPort2+nosave Datamap<export_all=1> {
        dataMin+nres => <-.MinMax.min_value;
        dataMax+nres => <-.MinMax.max_value;
   };
   MAdefaultMinMax MinMax {
      input => <-.in;
      min_value =;
      max_value =;
   };
   DefaultProps+OPort Props<export_all=1>;
   DefaultModes+OPort Modes<export_all=1>;
   Modes.outline = "On"; // for MicroAVS3.0
   DefaultPickInfo+OPort PickInfo<export_all=1>;
   GMOD.instancer AltObjectInstancer {
      Value => <-.Obj.use_altobj;
      Group => <-.AltObject;
   };
   MAaltObject AltObject<export_all=1, instanced=0> {
      alt_in => in;
      Obj.visible =><-.<-.Obj.use_altobj; // for MicroAVS
   };
   //DefaultXform+OPort Xform<export_all=1>;
   MAdefaultObject+OPort Obj<export_all=2> {
      input => in;
      objects => child_objs;
      altobj => AltObject.obj;
      dmap => Datamap;
      props => Props;
      modes => Modes;
      xform => in.xform; //Xform;
      pick_info => PickInfo;
      name => name_of(<-.<-);
#ifdef OLD
      use_altobj+nres => MicroAVS.dataObj.use_altobj3d;
#endif
   };
   olink obj => Obj;
};

GroupObject MAgroupObject {
   Datamap+nosave { !DataRange[0] { selectValues = 1; }; };
   Modes.outline = "On"; // for MicroAVS3.0
/* for MicroAVS5.0 cut_plane  start */
   MAcut_plane_params Top_cut_plane_params;
   Top+MAdefaultObject{
      &cut_plane_params<NEportLevels={2,0}> => <-.Top_cut_plane_params;
      &top_cut_plane_params => <-.Top_cut_plane_params;
   };
/* for MicroAVS5.0 cut_plane  end */
};

//
// MAlabelObject
//
macro MAlabelObject {
   float red = 1;
   float green = 1;
   float blue = 1;
   int height = 20;
   string label = "";
   float x_pos = 0;
   float y_pos = 0;
   boolean front = 1;
   boolean state;
   boolean underline;
   int nspace = front + 2;
   int font_index = 0;
   int style = 0;
   float  z_pos => switch(front+1, -0.99, 1);
   string font => FontTable[font_index];
   string &FontTable[];
   string bold_style[]   => { "medium", "bold" };
   string italic_style[] => { "r", "i" };
   int bold   => (style == 1) || (style == 3);
   int italic => (style == 2) || (style == 3);
   string style_str => bold_style[bold] + "-" + italic_style[italic];
   string font_list => "-*-"+font+"-"
                      +style_str+"-*-*-"+height+"-*-*-*-*-*-*-*";

   Text_NoXform Text_NoXform<NEportLevels={0,1}> {
      str<NEportLevels={2,0}> => <-.label;
      nspace => <-.nspace;
      position[.nspace] => 
       switch(nspace-1, {<-.x_pos,<-.y_pos},
                        {<-.x_pos,<-.y_pos, <-.z_pos}
             );
      underline => <-.underline;
   };
   MAdefaultObject Obj<NEportLevels={0,1}> {
      input => <-.Text_NoXform;
      props => <-.Props;
      // Workaround: geom_capture can NOT save no cached objects begin
      //cached = 0;
      // Workaround: geom_capture can NOT save no cached objects end
      xform_mode = "Locked";
      name = "";
      visible => <-.state;
   };
   DefaultProps Props {
      col<NEportLevels={2,0}>  => {<-.red,<-.green,<-.blue};
      font<NEportLevels={2,0}> => <-.font_list;
      inherit = 0;
   };
   olink obj => Obj;
};
