/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/viewer.v#1 $
*/
//
// MicroAVS Viewer
//
MAviewer_common_params MAviewer_params {
   visible       = 1;
#ifdef MSDOS
   render_x      = 0;
#else
   render_x      = 4;
#endif //MSDOS
   render_y      = 25;
   render_width  = 300;
   render_height = 300;
   width         => .render_width <+> 8;
   height        => .render_height <+> 
                   ( .render_y
#ifdef MSDOS
                    + 57			  // title height+border
#else
                    + 37			  // title height+border
#endif //MSDOS
                    + selobj_height * .selobj_vis // object selector height
                    + 20 * .showStatusBar	  // status bar height
                    + switch((.width<242)+(.width<137)+(.width<124)+1,
                            0, 18, 36, 44)	  // menu height
                   );
   volume_rendering = 0;
   stereo_on        = 0;
   stereo_balance   = 1;
   stereo_offset    = 1;
#ifdef MICROAVS_DEV_KIT
   stereo_enable    => MicroAVScontroller.Params.params.stereo;
   load_update      => MicroAVScontroller.Params.params.load_update;
   read_update      => MicroAVScontroller.Params.params.read_update;
   view_index       => MicroAVScontroller.Params.params.view_index;
#else
   stereo_enable;
   load_update;
   read_update;
   view_index;
#endif //MICROAVS_DEV_KIT
   default_renderer = 1;
   default_width    = 300;
   default_height   = 288;
   showStatusBar    = 1;
   selobj_vis       = 1;
   transform_vis    = 0;
   mode_vis         = 0;
   props_vis        = 0;
   light_vis        = 0;
   label_vis        = 0;
   view_vis         = 0;
   camera_vis       = 0;
   backcolor_vis    = 0;
   precision_vis    = 0; // 0 for instancer
   cut_vis          = 0; // for MicroAVS5.0 cut_plane
   cut_plane_item   = 0; // for MicroAVS5.0 cut_plane
   scale_vis        = 0; // for MicroAVS6.0 Zoom Editor
   s2t_vis          = 0; // for MicroAVS7.0 Scalar2Texture
   auto_norm        = 1;
   norm_scale       = 0.8;
   bounding_box     = 0;
   axis             = 0;
   axis_coord       = 0;
   viewer3d         = -1;
   just_fit         = 0;
   copy             = ;
   copy_region      = ;
   unit_vis         = 0;

   DefaultXform   LightXform1;
   DefaultLightOn Light1 { xform => <-.LightXform1; type = 3; };
   DefaultXform   LightXform2;
   DefaultLight   Light2 { xform => <-.LightXform2; type = 3; };
   DefaultXform   LightXform3;
   DefaultLight   Light3 { xform => <-.LightXform3; type = 3; };
   DefaultXform   LightXform4;
   DefaultLight   Light4 { xform => <-.LightXform4; type = 3; };
   mlink Lights  => {Light1, Light2, Light3, Light4};

   GMOD.parse_v set_default_renderer {
      on_inst    = 1;
      trigger    => Templates.CONFIG.gd_default_renderer;
      v_commands => "$push\n"
// bug-fixes begin
                  + switch(is_valid(renderer)+1,
                    "old_renderer=Templates.CONFIG.gd_default_renderer;",
                    "old_renderer=renderer;")
// bug-fixes end
                  + "$pop\n";
      relative   => <-;
      parse_v_relative<weight=0>;
   };
   MAs2t_params s2t_params{
      s2t_on       = 0;
      texture_size = 256;
   };
};
//
// Viewer
//
macro MAviewer<NEopenable=MAVS_OPENABLE>
{
   imlink          objs_in<export=2>  => {MAviewerEditors.label_objs};
   MAdataObj+nres  &dataObj<NEvisible=0> => <-.dataObj;
   MAviewer_params viewer_params;
   MAenv_params+nres &env_params => MicroAVScontroller.Params.env_params;

   string titles<NEvisible=0>[]    => { "MAV2_TITLE","MAV3_TITLE" };
   string top_names<NEvisible=0>[] => { "MAV2TOP_NAME","MAV3TOP_NAME" };
   string title<NEvisible=0>       => titles[viewer_params.viewer3d];
   string message<NEvisible=0>     => titles[viewer_params.viewer3d];
   string top_name<NEvisible=0>    => top_names[viewer_params.viewer3d];
#ifdef OLD
   boolean use_altobj<NEvisible=0> => switch(viewer_params.viewer3d+1,
                                dataObj.use_altobj2d,
                                dataObj.use_altobj3d);
#endif

   macro+nosave MAviewerSetSpecialParams {
      MAviewer_params &viewer_params => <-.viewer_params;

      GMOD.copy_on_change set_renderer_for2D {
         input   => switch(viewer_params.viewer3d == 0, 0);
         output  => <-.viewer_params.renderer; // software renderer
         on_inst = 1;
      };
      GMOD.copy_on_change set_norm_scale_for2Dand3D {
         input   => switch(viewer_params.viewer3d == 0, 1, 0.8);
         output  => <-.viewer_params.norm_scale;
         on_inst = 1;
      };
      GMOD.parse_v set_renderer_forVolumeRendering {
         on_inst    = 1;
         trigger    => <-.viewer_params.volume_rendering;
         active     => <-.viewer_params.viewer3d == 1;
         relative   => <-.viewer_params;
         v_commands => switch((viewer_params.volume_rendering == 1)+1,
             "$push\nrenderer=old_renderer;$pop\n"	//restore
            ,
             "$push\nold_renderer=renderer;$pop\n"	//save
            +"$push -usr\nrenderer=0;$pop\n"		//software renderer
            +"$push\nMAview.view.refresh=1;$pop\n"	// magic
            +"$push\nMAviewerUI.Shell.visible=1;$pop\n"	// for redraw
            );
      };
      GMOD.parse_v switch_axis_coord {
         on_inst = 0;
         relative => <-.<-.<-;
         string cmds[] = {
            "$del_obj_ref objs_in MAviewer3Editors.axis_objs\n",
            "$link        objs_in MAviewer3Editors.axis_objs\n"
         };
         v_commands =>
              "$push -usr\n"
            + cmds[viewer_params.axis_coord]
            + "$pop\n";
      };
/* add by yasu v7.0 eNX`[ER^[̃p[^Zbg */
#ifdef MICROAVS_DEV_KIT
/* ォZbgƂɕۑp[^ɃZbgȂ߁Aڌ悤ɂB
      GMOD.parse_v set_s2t_params {
           v_commands    ="s2t_params+nres => MicroAVS.MAviewer.viewer_params.s2t_params;\n";
           on_inst       = 1;
           relative+nres => MicroAVScontroller.Params.ModuleParams;
      };
*/
#else
      GMOD.parse_v set_s2t_params {
           v_commands    =>"$push \n"
                          +"s2t_on+nres       = " + .s2t_on + ";\n"
                          +"texture_size+nres = " + .texture_size + ";\n"
                          +"$pop \n";
           trigger       => (viewer_params.s2t_params.s2t_on || viewer_params.s2t_params.texture_size);
           on_inst       = 1;
           relative+nres => MicroAVS.Params.ModuleParams.s2t_params;
           string s2t_on       => str_format("%d", <-.viewer_params.s2t_params.s2t_on);
           string texture_size => str_format("%d", <-.viewer_params.s2t_params.texture_size);
      };
#endif //MICROAVS_DEV_KIT
/* add by yasu v7.0 */
   };
   macro+nosave MAviewerUI {
      ilink title         => <-.title;
      ilink message       => <-.message;
      ilink viewer_params => <-.viewer_params;

      AU.AUcmdTool Tool { hconn_list.offer = "viewer_toolbar";
         label   => <-.title;
         message => <-.message;
         do      => <-.viewer_params.visible;
      };
      MAUIhelpButton HelpButton { int n = 1;
         parent => <-.Shell;
         x      => <-.viewer_params.render_width - .width * .n;
         y      = 0;
         label  = "MAVTOOLBAR_HELP_MENU";
         &do    => <-.viewer_params.toolbar_help;
      };
      HelpButton AutoNormButton { n = 4;
         do =;
         string tlabel        = "MAVAUTO_NORM_MENU";
         string labels[]      = { "MAUI_ON", "MAUI_OFF" };
         label                => .tlabel+" "+labels[OnOffInd];
         labelPixmap.filename => OnOffIcons[OnOffInd];
         labelPixmap.fileType = "avs_image";
         string OnOffIcons[2] = {
            MAVS_ICON_PATH+"bnorm1.x",
            MAVS_ICON_PATH+"bnorm0.x"
         };
         GMOD.parse_v ParseOnOff {
            on_inst    = 0;
            v_commands = "$push -usr\nOnOffInd=!OnOffInd;$pop\n";
            trigger    => <-.do;
            relative   => <-.<-;
            parse_v_relative<interruptable=0,status=0>;
         };
         boolean OnOffInd => !(<-.viewer_params.auto_norm);
      };
      AutoNormButton BoundingBoxButton { n = 3;
         tlabel     = "MAVBBOX_MENU";
         OnOffIcons = {
            MAVS_ICON_PATH+"bbox1.x",
            MAVS_ICON_PATH+"bbox0.x"
         };
         OnOffInd   => !(<-.viewer_params.bounding_box);
      };
      HelpButton MouseButton { n = 2;
         label                = "MAVMOUSEHELP_MENU";
         labelPixmap.filename = MAVS_ICON_PATH+"bmouse.x";
         &do                  => <-.viewer_params.mouse_help;
      };
      HelpButton JustFitButton { n = 5; visible => !<-.viewer_params.viewer3d;
         label                = "MAV2JUST_FIT_MENU";
         labelPixmap.filename = MAVS_ICON_PATH+"bjustfit.x";
         &do                  => <-.viewer_params.just_fit;
         &active              => <-.viewer_params.just_fit_active;
      };
      AutoNormButton AxisButton{ n = 5; visible => <-.viewer_params.viewer3d;
         tlabel     = "MAV3AXIS_MENU";
         OnOffIcons = {
            MAVS_ICON_PATH+"baxis1.x",
            MAVS_ICON_PATH+"baxis0.x"
         };
         OnOffInd   => !(<-.viewer_params.axis);
      };
      HelpButton ShuffleButton { n = 6; visible => <-.viewer_params.viewer3d;
         label                = "MAV3SHUFFLE_MENU";
         labelPixmap.filename = MAVS_ICON_PATH+"bshuffle.x";
         &do                  => <-.viewer_params.shuffle;
      };
      AutoNormButton UnitButton{ n = 7; visible => <-.viewer_params.viewer3d;
         tlabel     = "MAV3UNITVEC_MENU";
         OnOffIcons = {
            MAVS_ICON_PATH+"uvec1.x",
            MAVS_ICON_PATH+"uvec0.x"
         };
         OnOffInd   => !(<-.viewer_params.unit_vis);
      };

      MAUIrenderView RenderView {
         parent => <-.Shell;
         x      => <-.viewer_params.render_x;
         y      => <-.viewer_params.render_y;
         width  => <-.viewer_params.render_width;   // never changed
         height => <-.viewer_params.render_height; // using <+>, see Shell
         CopyToClipboard => <-.viewer_params.copy;
         CopyRegion      => <-.viewer_params.copy_region;
      };
      MAUIOptionMenuLabel ObjectSelector {
         parent                => <-.Shell;
         options               => <-.<-.MAviewerEditors.ObjSelector.strings;
#ifndef MSDOS
// workaround begin
         UIoption OPcmdList[<-.<-.MAviewerEditors.ObjSelector.sdims] {
            label => <-.options[index_of(OPcmdList)];
         };
// workaround end
#endif //!MSDOS
         string labels[]       => { "MAV2SEL_TITLE", "MAV3SEL_TITLE" };
         label                 => labels[<-.viewer_params.viewer3d];
         selectedItem          => <-.viewer_params.curobj_index;
         numShowItems          => min_array({10, array_size(options)});
         selectedText          => <-.viewer_params.curobj_name;
         x                     = 0;
         y                     => <-.RenderView.y + <-.RenderView.height + 2;
         width                 => <-.RenderView.width;
         height                => <-.viewer_params.selobj_height;
         visible               => <-.viewer_params.selobj_vis;
         color.foregroundColor = MAVS_BLUE;
      };
      GMOD.instancer Menu2Dinstancer {
         Group => <-.Menu2D;
         Value => !<-.viewer_params.viewer3d;
      };
      macro Menu2D<instanced=0> {
         ilink viewer_params => <-.viewer_params;

         UImenuSeparator MenuSeparator;

         UIcmd Help          { &do => <-.viewer_params.help;
            label = "MAVHELP_MENU"; message = "MAVHELP_MSG";
         };
         UIcmd ToolbarHelp   { &do => <-.viewer_params.toolbar_help;
            label = "MAVTOOLBAR_HELP_MENU"; message = "MAVTOOLBAR_HELP_MSG";
         };
         UIcmd MouseHelp     { &do => <-.viewer_params.mouse_help;
            label = "MAVMOUSEHELP_MENU"; message = "MAVMOUSEHELP_MSG";
         };
         UIcmdList HelpCmdList {
            cmdList => { <-.Help, <-.ToolbarHelp, <-.MouseHelp };
            label = "MAVHELP_MENU";
         };
         UIcmd ObjTrans      { &do => <-.viewer_params.transform_vis;
            label = "MAV2TRANS_MENU"; message = "MAV2TRANS_MSG";
         };
         UIcmdList ObjCmdList {
            cmdList => { <-.ObjTrans };
            label = "MAV2OBJ_MENU";
         };
         UIcmd ViewEditor    { &do => <-.viewer_params.view_vis;
            label = "MAVVIEW_MENU"; message = "MAVVIEW_MSG";
         };
         UIcmd LabelEditor   { &do => <-.viewer_params.label_vis;
            label = "MAVLABEL_MENU"; message = "MAVLABEL_MSG";
         };
         UIcmd BackcolEditor { &do => <-.viewer_params.backcolor_vis;
            label = "MAVBACKCOL_MENU"; message = "MABACKCOL_MSG";
         };
         UIcmdList SceneCmdList {
            cmdList => {
               <-.ViewEditor,
               <-.BackcolEditor,
               <-.MenuSeparator,
               <-.LabelEditor
            };
            label = "MAVSCENE_MENU";
         };
         UIcmd OptionsJustFit        { &do => <-.viewer_params.just_fit;
            label = "MAV2JUST_FIT_MENU"; message = "MAV2JUST_FIT_MSG";
            &active => <-.viewer_params.just_fit_active;
         };
         UIoption OptionsAutoNorm    { &set => <-.viewer_params.auto_norm;
            label = "MAVAUTO_NORM_MENU"; message = "MAVAUTO_NORM_MSG";
         };
         UIoption OptionsBoundingBox { &set => <-.viewer_params.bounding_box;
            label = "MAVBBOX_MENU"; message = "MAVBBOX_MSG";
         };
         UIoption OptionsObjSelect   { &set => <-.viewer_params.selobj_vis;
            label = "MAV2SEL_MENU"; message = "MAV2SEL_MSG";
         };
         UIoption OptionsStatusBar   { &set => <-.viewer_params.showStatusBar;
            label = "MAVSBAR_MENU"; message = "MAVSBAR_MSG";
         };
         UIcmdList OptionsCmdList {
            cmdList => {
               <-.OptionsBoundingBox,
               <-.OptionsAutoNorm,
               <-.OptionsJustFit,
               <-.MenuSeparator,
               <-.OptionsObjSelect,
               <-.MenuSeparator,
               <-.OptionsStatusBar
            };
            label = "MAVOPTS_MENU";
         };
         UIcmd CopyCmd { &do => <-.viewer_params.copy;
            label = "MAVCOPY_MENU"; message = "MAVCOPY_MSG";
            accelerator = "Ctrl <Key>C";
            acceleratorText = "Ctrl+C";
#ifdef MSDOS
            active = 1;
#else
            active = 0;
#endif //MSDOS
         };
         UIcmd CopyRegionCmd { &do => <-.viewer_params.copy_region;
            label = "MAVCOPY_REGION_MENU"; message = "MAVCOPY_REGION_MSG";
            accelerator = "Ctrl Shift <Key>C";
            acceleratorText = "Ctrl+Shift+C";
#ifdef MSDOS
            active = 1;
#else
            active = 0;
#endif //MSDOS
         };
         UIcmdList EditCmdList {
            cmdList => {
               <-.CopyCmd,
               <-.CopyRegionCmd
            };
            label = "MAVEDIT_MENU";
         };
         UIcmdList CmdLists {
            cmdList => {
               <-.ObjCmdList,
               <-.SceneCmdList,
               <-.OptionsCmdList,
               <-.EditCmdList,
               <-.HelpCmdList
            };
         };
      };
      GMOD.instancer Menu3Dinstancer {
         Group => <-.Menu3D;
         Value => <-.viewer_params.viewer3d;
      };
      Menu2D Menu3D<instanced=0> {
         ObjTrans            {
            label = "MAV3TRANS_MENU"; message = "MAV3TRANS_MSG";
         };
         OptionsObjSelect    {
            label = "MAV3SEL_MENU"; message = "MAV3SEL_MSG";
         };
         UIcmd ObjMode       { &do => <-.viewer_params.mode_vis;
            label = "MAV3MODE_MENU"; message = "MAV3MODE_MSG";
         };
         UIcmd ObjProps      { &do => <-.viewer_params.props_vis;
            label = "MAV3PROPS_MENU"; message = "MAV3PROPS_MSG";
         };
         UIcmd ObjPrecision  { &do => <-.viewer_params.precision_vis;
            label = "MAV3PRE_MENU"; message = "MAV3PRE_MSG";
         };
/* version 6.0 ADD_START ------< Y[̎w >--------------------------------*/
         UIcmd ObjScale      { &do => <-.viewer_params.scale_vis;
            label = "MAV3SCALE_MENU"; message = "MAV3SCALE_MSG";
         };
/* version 6.0 ADD_START ------< Y[̎w >--------------------------------*/
         UIcmd ObjPrecision  { &do => <-.viewer_params.precision_vis;
            label = "MAV3PRE_MENU"; message = "MAV3PRE_MSG";
         };
/* version 5.0 ADD_START ------< Jbg̐ݒ >--------------------------------*/
         UIcmd ObjCut  { &do => <-.viewer_params.cut_vis;
            label = "MAV3CUT_TITILE";
            message = "MAV3CUT_MESSAGE";
         };
/* version 5.0 ADD_START ------< Jbg̐ݒ >--------------------------------*/
/* version 7.0 ADD_START ------< Scalar2Texture̐ݒ >------------------------*/
         UIcmd ObjS2T  { &do => <-.viewer_params.s2t_vis;
            label = "MAV3S2T_TITLE";
            message = "MAV3S2T_MESSAGE";
         };
/* version 7.0 ADD_END ------< Scalar2Texture̐ݒ >-------------------------*/

         ObjCmdList {
            cmdList => { <-.ObjTrans, <-.ObjMode, <-.ObjProps, <-.ObjScale,
                         <-.MenuSeparator,
                         <-.ObjPrecision,
                         <-.ObjCut,
                         <-.ObjS2T
                       };
            label = "MAV3OBJ_MENU";
         };
         UIcmd LightEditor   { &do => <-.viewer_params.light_vis;
            label = "MAV3LIT_MENU"; message = "MAV3LIT_MSG";
         };
         UIcmd CameraEditor  { &do => <-.viewer_params.camera_vis;
            label = "MAV3CAM_MENU"; message = "MAV3CAM_MSG";
         };
/* version 5.0 ADD_START ------< p̕ۑ >--------------------------------*/
         UIcmd ObjXform  {
            &do => <-.viewer_params.xform_vis;
            label = "MAVMATRIX_TITLE";
         };
         SceneCmdList {
            cmdList => {
               <-.ViewEditor,
               <-.BackcolEditor,
               <-.MenuSeparator,
               <-.CameraEditor,
               <-.MenuSeparator,
               <-.LightEditor,
               <-.MenuSeparator,
               <-.LabelEditor,
               <-.ObjXform
            };
         };
/*-----------------------------------------------------  version 5.0 ADD_END */
         UIoption OptionsAxis { &set => <-.viewer_params.axis;
            label = "MAV3AXIS_MENU"; message = "MAV3AXIS_MSG";
            //accelerator = "Ctrl <Key>C";
            //acceleratorText = "Ctrl+C";
         };
         UIoption OptionsAxisGraph { &set => <-.viewer_params.axis_coord;
            label = "MAV3AXISG_MENU"; message = "MAV3AXISG_MSG";
            accelerator = "Ctrl <Key>3";
            acceleratorText = "Ctrl+3";
         };
         UIcmd OptionsShuffle { &do => <-.viewer_params.shuffle;
            label = "MAV3SHUFFLE_MENU"; message = "MAV3SHUFFLE_MSG";
         };
         UIoption OptionsScale { &set => <-.viewer_params.unit_vis;
            label = "MAV3UNITVEC_MENU"; message = "MAV3UNITVEC_MSG";//LATER
         };
         OptionsCmdList {
            cmdList => {
               <-.OptionsBoundingBox,
               <-.OptionsAutoNorm,
               <-.OptionsAxis,
               <-.OptionsAxisGraph,
               <-.OptionsShuffle,
               <-.OptionsScale,
               <-.MenuSeparator,
               <-.OptionsObjSelect,
               <-.MenuSeparator,
               <-.OptionsStatusBar
            };
         };
      };
      UIshell Shell {
         title         => <-.title;
         showStatusBar => <-.viewer_params.showStatusBar;
         visible       => <-.viewer_params.visible;
         x             => <-.viewer_params.x;
         y             => <-.viewer_params.y;
         width         => <-.RenderView.width <+> 8;
         height        => <-.RenderView.height <+> 
           ( <-.viewer_params.selobj_height * <-.viewer_params.selobj_vis
#ifdef MSDOS
           + 57 // title height+border
#else
           + 37 // title height+border
#endif //MSDOS
           + 20 * <-.viewer_params.showStatusBar
           + RenderView.y + switch((.width < 180) + 1, 0, 18));
         menu+nres     => switch(<-.viewer_params.viewer3d+1,
                             Menu2D.CmdLists, Menu3D.CmdLists);
      };
      MAmouseHelpPanel MouseHelpPanel {
         parent  => <-.Shell;
         visible => <-.viewer_params.mouse_help;
      };
      olink render_view => RenderView;
   };
   macro MAviewer2DEditors {
      ilink viewer_params => <-.viewer_params;
      ilink cur_obj       => <-.MAviewerEditors.cur_obj;
      int+nres width      => .cur_obj.input.dims[0];
      int+nres height     => .cur_obj.input.dims[1];

      GMOD.copy_on_change set_active {
         input   => is_valid(<-.width);
         output  => <-.viewer_params.just_fit_active;
         on_inst = 1;
      };
      GMOD.parse_v set_just_size {
         trigger    => <-.viewer_params.just_fit;
         active     => <-.viewer_params.just_fit;
         v_commands => "$push -usr\n"
                      +"render_width="+<-.width+";"
                      +"render_height="+<-.height+";"
                      +"$pop\n"
                      +"$push\n"
                      +"just_fit=0;"
                      +"$pop\n"
                      ;
         relative   => <-.<-.viewer_params;
      };
   };
   macro MAviewerEditors {
      ilink viewer_params   => <-.viewer_params;
#ifdef OLD
      ilink use_altobj      => <-.use_altobj;
#endif
      ilink view_in         => <-.MAview.view;
       link camera_in       => .view_in.picked_camera;
      ilink top_obj       => <-.TopObject.obj;
      MAmime HelpViewer {
         trigger    => <-.viewer_params.help;
         stFilename => MAVS_HELP_PATH+"/viewer/"
                      + switch(<-.viewer_params.viewer3d+1,
                               "viewer2d.htm","viewer3d.htm");
      };
      MAmime ToolbarHelpViewer {
         trigger    => <-.viewer_params.toolbar_help;
         stFilename => MAVS_HELP_PATH+"/viewer/"
                      + switch(<-.viewer_params.viewer3d+1,
                               "imtoolb.htm","getoolb.htm");
      };
      MAobjname_select ObjnameSelect {
         objnames => <-.ObjSelector.strings;
         objname  => <-.ObjSelector.curobj_name;
         index    => <-.viewer_params.curobj_index;
      };
      MAGDobj_sel+nosave ObjSelector {
         view        => <-.view_in;
         all_cameras = 0;
         string &curobj_name;
         ///so bad !!! //&strings => <-.ObjnameSelect.objnames;
      };
      MAtransformEditor TransformEditor {
         viewer_params => <-.viewer_params;
         camera_in     => <-.camera_in;
         obj_in        => <-.ObjSelector.cur_obj;
/* version 5.0 ADD_START ------< p̕ۑ >--------------------------------*/
         MAGDxform_sub_obj MAGDxform_sub_obj {
            MAGDxform_file_dlg {
               MAxeditor {
                  Params {
                     params {
                        visible => <-.<-.<-.<-.<-.<-.viewer_params.xform_vis;
                     };
                 };
               };
            };
         };
/*-----------------------------------------------------  version 5.0 ADD_END */
      };
      MAtrackEditor+nosave TrackEditor {
         view_in   => <-.view_in;
         camera_in => <-.camera_in;
         obj_in    => <-.ObjSelector.cur_obj;
      };
      MAbackcolorEditor BackcolorEditor {
         viewer_params => <-.viewer_params;
         view_in       => <-.view_in;
      };
      MAviewEditor ViewEditor {
         viewer_params => <-.viewer_params;
         view_in       => <-.view_in;
/* version 5.0 ADD_START ------< l̐ݒ >------------------------------*/
#ifdef MICROAVS_DEV_KIT
         MAGDget_window_default MAGDget_window_default;
         group+nosave window_params{
            int+nres render  => <-.viewer_params.renderer;
            int+nres width   => <-.viewer_params.render_width;
            int+nres height  => <-.viewer_params.render_height;
            int+nres stereo  => <-.viewer_params.stereo_enable;
         };
         set_default set_default{
            load_update => <-.viewer_params.load_update;
            read_update => <-.viewer_params.read_update;
            in_render   => <-.MAGDget_window_default.renderer;
            in_width    => <-.MAGDget_window_default.width;
            in_height   => <-.MAGDget_window_default.height;
            in_stereo   => <-.viewer_params.stereo_enable;
         };
         GMOD.parse_v  set_default_update {
            v_commands => "$push\n"
                        + "window_params.render = set_default.out_render;\n"
                        + "$pop\n"
                        + "$push\n"
                        + "window_params.width  = set_default.out_width;\n"
                        + "$pop\n"
                        + "$push\n"
                        + "window_params.height = set_default.out_height;\n"
                        + "$pop\n";
            trigger    => <-.set_default.update;
            on_inst    =  0;
            active     => is_valid(<-.set_default.update) &&   // MicroAVSIcan't reallocateɂȂȂ
                          (<-.set_default.update == 1);
            relative   => <-;
         };
         GMOD.parse_v  window_default_update {
            v_commands => "go = 1;\n";
            trigger    => set_default.read_update;
            on_inst    =  0;
            active     => (<-.set_default.flag == 1) &&
                          !is_valid(<-.MAGDset_window_default.renderer);
            relative   => <-.MAGDget_window_default;
         };
         MAGDset_window_default MAGDset_window_default ;
         GMOD.parse_v  call_function_trigger {
            on_inst = 0;
            v_commands+nres = "$push\n"
                        + "MAGDset_window_default.index= viewer_params.view_index;"
                        + "MAGDset_window_default.renderer= viewer_params.renderer;"
                        + "MAGDset_window_default.width = viewer_params.render_width;"
                        + "MAGDset_window_default.height = viewer_params.render_height;"
                        + "MAGDset_window_default.stereo = viewer_params.stereo_on;"
                        + "$pop\n"
                        + "$push\n"
                        + "MAGDset_window_default.go= UI.ViewEditorUI.updata_b.do;"
                        + "$pop\n";
            trigger => UI.ViewEditorUI.updata_b.do;
            relative => <-.<-;
         };
         MAGDcall_window_default MAGDcall_window_default ;
         GMOD.parse_v  dialog_trigger {
            on_inst = 0;
            v_commands+nres = "$push\n"
                        + "MAGDcall_window_default.go= UI.ViewEditorUI.default_b.do;"
                        + "$pop\n";
            trigger => UI.ViewEditorUI.default_b.do;
            relative => <-.<-;
         };
#endif //MICROAVS_DEV_KIT
/*-----------------------------------------------------  version 5.0 ADD_END */
      };
      MAlabelEditor LabelEditor {
         viewer_params => <-.viewer_params;
      };
/* version 6.0 ADD_START ------< Y[̎w >------------------------------*/
      MAzoomEditor ZoomEditor {
         viewer_params => <-.viewer_params;
         obj_in    => <-.ObjSelector.cur_obj;
      };
/*-----------------------------------------------------  version 6.0 ADD_END */
      olink label_objs => LabelEditor.label_objs;

#ifdef OLD
      GMOD.copy_on_change set_altobj {
         input   => <-.viewer_params.bounding_box;
         output  => <-.use_altobj;
         on_inst = 1;
      };
#endif
      olink cur_obj => .ObjSelector.cur_obj;

#ifdef OLD
#ifdef MSDOS
      MAclipboardCopy clipboard_copy {
         UIwinHandle => <-.view_in.render_view.handle;
         Copy        => <-.viewer_params.copy;
         CopyRegion  => <-.viewer_params.copy_region;
         On          => <-.viewer_params.visible;
      };
#endif //MSDOS
#endif //OLD
      MAunitvectorEditor UnitVectorEditor {
         viewer_params => <-.viewer_params;
         Params.params.visible => <-.viewer_params.unit_vis;
      };
      MAset_altobj SetAltObjs {
         trigger    => <-.viewer_params.list_update;
         object     => <-.top_obj;
         use_altobj => <-.viewer_params.bounding_box;
      };

 /* for MicroAVS5.0 cut_plane editor  */

      MAcutEditor MAcutEditor{
         obj_in                => <-.ObjSelector.cur_obj;
         viewer_params         => <-.viewer_params;
         cut_plane_params+nres => obj_in.cut_plane_params; /* nresȂƃG[ɂȂ */
      };

 /* for MicroAVS5.0 cut_plane editor  */
 /* for MicroAVS7.0 scalar2texture editor  */

      MAs2tEditor MAs2tEditor{
         obj_in                => <-.ObjSelector.cur_obj;
         viewer_params         => <-.viewer_params;
      };

 /* for MicroAVS7.0 scalar2texture editor  */

   };
   GMOD.instancer MAviewer3EditorsInstancer {
      Group => <-.MAviewer3Editors;
      Value => <-.viewer_params.viewer3d;
   };
   macro MAviewer3Editors <instanced=0> {
      ilink viewer_params => <-.viewer_params;
      ilink view_in       => <-.MAview.view;
      ilink cur_obj       => <-.MAviewerEditors.cur_obj;
      ilink top_obj       => <-.TopObject.obj;

      MAget_extent top_extent {
         trigger => <-.viewer_params.list_update;
         object  => <-.top_obj;
         update+notify_inst;
         xmin => <-.viewer_params.top_extent.xmin;
         ymin => <-.viewer_params.top_extent.ymin;
         zmin => <-.viewer_params.top_extent.zmin;
         xmax => <-.viewer_params.top_extent.xmax;
         ymax => <-.viewer_params.top_extent.ymax;
         zmax => <-.viewer_params.top_extent.zmax;
      };
      MApropsEditor PropsEditor {
         viewer_params => <-.viewer_params;
         obj_in        => <-.cur_obj;
      };
      MAmodeEditor ModeEditor {
         viewer_params => <-.viewer_params;
         obj_in        => <-.cur_obj;
      };
      MAcameraEditor CameraEditor {
         viewer_params => <-.viewer_params;
         view_in       => <-.view_in;
      };
      MAlightEditor LightEditor {
         viewer_params => <-.viewer_params;
         view_in       => <-.view_in;
      };
      MAprecisionEditor PrecisionEditor {
         viewer_params => <-.viewer_params;
         obj_in        => <-.cur_obj;
      };
      MAaxisEditor AxisEditor {
         viewer_params => <-.viewer_params;
      };
      MAaxiscoordEditor AxisGraphEditor {
         viewer_params => <-.viewer_params;
         //top_obj       => <-.top_obj;
      };
      MAshuffleEditor ShuffleEditor {
         viewer_params => <-.viewer_params;
      };
      olink axis_objs => AxisGraphEditor.out_obj;
   };
   MAgroupObject TopObject {
      child_objs     => <-.objs_in;
      &Xform         => <-.viewer_params.top_xform;
      DefaultProps &Props { boolean inherit = 1; }
                     => <-.viewer_params.top_props;
      Top.name       => <-.<-.top_name;
      Top.use_altobj = 0; // never on AltObj
   };
   macro MAcamera {
      ilink viewer_params => <-.viewer_params;
      ilink top_obj       => <-.TopObject.obj;

#ifdef LATER
      GMOD.copy_on_change+nosave set_front { // workaround for Outline
         trigger => <-.Camera.perspec;
         input   = 1.0;
         output  => <-.Camera.front;
         on_inst = 0;
      };
#endif //LATER
      GMOD.copy_on_change+nosave set_norm {
         //input   => <-.viewer_params.auto_norm * 2;
         input   => <-.viewer_params.auto_norm * 3;
         output  => <-.Camera.auto_norm;
         on_inst = 1;
         copy_on_change<weight=4>;
      };
      DefaultXform+nosave CameraXform {
         xlate = {0.0, 0.0, -12.0};
      };
      MAdefaultCamera+OPort+nosave Camera {
         type       => 
            switch(viewer_params.viewer3d+1, GD_CAMERA_2D, GD_CAMERA_3D);
         image_pass => !viewer_params.viewer3d;
         xform      => CameraXform;
         objects    => { top_obj };
         auto_norm  = 0;
         norm_scale => viewer_params.norm_scale;
      };
   };
   macro MAview {
      ilink viewer_params => <-.viewer_params;
      imlink Cameras      => {<-.MAcamera.Camera,
                              <-.MAviewer3Editors.AxisEditor.axis_camera};
      UIrenderView+IPort2+OPort &render_view {
         UIwinHandle+OPort2 handle;
      }                   => <-.MAviewerUI.render_view;

      UItwoPoint+nosave InterPick {
         view       => <-.render_view;
         startEvent = "Control<Btn1Down>";
         runEvent   = "Control<Btn1Motion>";
         stopEvent  = "Control<Btn1Up>";
      };
      DefaultPickCtrl+OPort+nosave PickCtrl {
         x        => <-.InterPick.x;
         y        => <-.InterPick.y;
         event    => <-.InterPick.state;
         on_start = 1;
      };
      BestVirtPal+nosave VirtPal {
         share = 1;
         gamma => <-.viewer_params.gamma;
      };
      DefaultLightInfo+OPort LightInfo {
         lights => <-.viewer_params.Lights;
      };
      MAdefaultView+nosave View {
         handle     => <-.render_view.handle;
         virtpal    => <-.VirtPal;
         light_info => <-.LightInfo;
         pick_ctrl  => <-.PickCtrl;
         cameras    => <-.Cameras;
         renderer   => <-.viewer_params.renderer;
         aspect     = 0;

    // stereo view for MicroAVS5.0
         stereo_enable  => <-.viewer_params.stereo_enable;
         stereo         => <-.viewer_params.stereo_on;
         stereo_balance => <-.viewer_params.stereo_balance;
         stereo_offset  => <-.viewer_params.stereo_offset;
    // stereo view for MicroAVS5.0

         full_view_width  => <-.viewer_params.full_render_width;
         full_view_height => <-.viewer_params.full_render_height;
         list_update => <-.viewer_params.list_update;

      // NOTES:
      // See GDM.view_link
      // view sub-objects is added
      // to connect to OutputVPS or OutputVRML etc...
      // require &render_view
         UIrenderView &render_view => <-.render_view;
         UItwoPoint &two_point => <-.InterPick;
         UImouseEvents &mouse_events;
      };
      olink view => View;
   };
   olink view<export=2> => MAview.view;
   olink picked_obj<export=2> => .view.picked_obj;
};
