/*
	"$Id: //depot/express/fcs70/v/MicroAVS/GD/zoom.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/GD/zoom.v#1 $
*/
//
// Zoom Editor
//
module MAxform_zoom_editor {
    float+Iparam x_scale=1.0;
    float+Iparam y_scale=1.0;
    float+Iparam z_scale=1.0;
    boolean reset=;
	GDxform_templ+nonotify xform_in1 {
	   mat => {
         <-.x_scale,0.,        0.,        0.,
         0.,        <-.y_scale,0.,        0.,
         0.,        0.,        <-.z_scale,0.,
         0.,        0.,        0.,        1.
      };
      xlate ={0,0,0};
      center ={0,0,0};
	};
	GDxform_templ+nonotify+Iparam &xform_in2 ;
	DefaultXform+nonotify+Oparam &xform_out;
	method+notify_val+notify_inst upd_concat_scale = "MAVSconcat_scale_update";
}; 
MAparams MAzoom_editor_params {
   boolean+nosave reset;
   double  x_scale      = 1.0;
   double  y_scale      = 1.0;
   double  z_scale      = 1.0;
   double  scale_val    = 1.1;
   init_commands = "";
   reset_commands =
       "zoom_editor_params.reset=1;"
      +"$push\n"
      +"zoom_editor_params.x_scale=1.0;"
      +"zoom_editor_params.y_scale=1.0;"
      +"zoom_editor_params.z_scale=1.0;"
      +"$pop\n"
      +"zoom_editor_params.scale_val=1.1;"
      ;
};

MAmacroUI MAzoomEditorUI {
   MAviewer_common_params &viewer_params;
   MAzoom_editor_params &zoom_editor_params;

   height => zoom_editor_panel.height;
   MAUIframe zoom_editor_panel {
      parent => <-.parent;
      y => <-.y;
      width = 220;
      height = 230;
   };
   MAUIlabel XZoomLabel {
      parent => <-.zoom_editor_panel;
      x = 15;
      y = 45;
      width = 60;
      height => 40;
      label = "MAUI_XZOOM";
   };
   XZoomLabel YZoomLabel {
      y => XZoomLabel.y + XZoomLabel.height+10;
      label = "MAUI_YZOOM";
   };
   XZoomLabel ZZoomLabel {
      y => YZoomLabel.y + YZoomLabel.height+10;
      label = "MAUI_ZZOOM";
   };
   XZoomLabel ZoomInLabel {
      x =>XZoomIn.x;
      y = 10;
      width=54;
      label = "MAUI_ZOOMIN";
   };
   XZoomLabel ZoomOutLabel {
      x =>XZoomOut.x;
      y => ZoomInLabel.y;
      width=54;
      label = "MAUI_ZOOMOUT";
   };
   XZoomLabel ZoomRateLabel {
      y => ZZoomLabel.y + ZZoomLabel.height+10;
      label = "MAUI_ZOOMRATE";
   };
   MAUIbutton XZoomIn {
      parent => <-.zoom_editor_panel;
      x => XZoomLabel.x + XZoomLabel.width+5;
      y => XZoomLabel.y -10;
      width = 54;
      height = 46;
      label = "MAUI_XZOOMIN";
      labelPixmap.filename = MAVS_ICON_PATH + "gxbig.x";
      labelPixmap.fileType = "avs_image";
      toolTip.enable = "always";
   };
   XZoomIn XZoomOut {
      x => XZoomIn.x + XZoomIn.width+5;
      label = "MAUI_XZOOMOUT";
      labelPixmap.filename = MAVS_ICON_PATH + "gxsmall.x";
   };
   XZoomIn YZoomIn {
      y => YZoomLabel.y - 10;
      label = "MAUI_YZOOMIN";
      labelPixmap.filename = MAVS_ICON_PATH + "gybig.x";
   };
   XZoomIn YZoomOut {
      x => XZoomIn.x + XZoomIn.width+5;
      y => YZoomLabel.y - 10;
      label = "MAUI_YZOOMOUT";
      labelPixmap.filename = MAVS_ICON_PATH + "gysmall.x";
   };
   XZoomIn ZZoomIn {
      y => ZZoomLabel.y - 10;
      label = "MAUI_ZZOOMIN";
      labelPixmap.filename = MAVS_ICON_PATH + "gzbig.x";
   };
   XZoomIn ZZoomOut {
      x => XZoomIn.x + XZoomIn.width+5;
      y => ZZoomLabel.y - 10;
      label = "MAUI_ZZOOMOUT";
      labelPixmap.filename = MAVS_ICON_PATH + "gzsmall.x";
   };
   GMOD.parse_v IncrX {
      trigger => <-.XZoomIn.do;
      v_commands = "$push\n
                    x_scale = scale_val;\n
                    $pop\n
                   ";
      relative => <-.zoom_editor_params;
      on_inst = 0;
   };
   IncrX DecrX {
      trigger => <-.XZoomOut.do;
      v_commands = "$push\n
                    x_scale = 1.0 / scale_val;\n
                    $pop\n
                   ";
   };
   IncrX IncrY {
      trigger => <-.YZoomIn.do;
      v_commands = "$push\n
                    y_scale = scale_val;\n
                    $pop\n
                   ";
   };
   IncrX DecrY {
      trigger => <-.YZoomOut.do;
      v_commands = "$push\n
                    y_scale = 1.0 / scale_val;\n
                    $pop\n
                   ";
   };
   IncrX IncrZ {
      trigger => <-.ZZoomIn.do;
      v_commands = "$push\n
                    z_scale = scale_val;\n
                    $pop\n
                   ";
   };
   IncrX DecrZ {
      trigger => <-.ZZoomOut.do;
      v_commands = "$push\n
                    z_scale = 1.0 / scale_val;\n
                    $pop\n
                   ";
   };
   MAUIfield2 ZoomValue {
      parent => <-.zoom_editor_panel;
      x => ZZoomIn.x;
      y => ZZoomIn.y + ZZoomIn.height + 10;
      allwidth = 55;
      min = 0.000001;
      max = 100.0;
      value => <-.zoom_editor_params.scale_val;
      decimalPoints = 2;
   };
};
MAeditor MAzoomEditor {
   title = "MAVZOOM_TITLE";
   //MAGDcamera_templ+IPort2 &camera_in;
   MAGDobject_templ+IPort2 &obj_in { MAGDxform_templ+OPort2 &xform; };

   Params {
      params.name = "scale";
      params.help_name => "gezoom";
      MAzoom_editor_params zoom_editor_params;
      init_params.init_commands => zoom_editor_params.init_commands;
      reset_params.reset_commands
         => zoom_editor_params.reset_commands;
   };
   MAxform_zoom_editor xform_zoom_editor {
      x_scale =><-.Params.zoom_editor_params.x_scale;
      y_scale =><-.Params.zoom_editor_params.y_scale;
      z_scale =><-.Params.zoom_editor_params.z_scale;
      reset   =><-.Params.zoom_editor_params.reset;
      xform_in2 => switch(<-.UI.visible,<-.obj_in.xform);
      &xform_out => switch(<-.UI.visible,<-.obj_in.xform);
   };
   UI {
      visible+nres => <-.viewer_params.scale_vis;
      EditorCommonUI.resetHelpButtons.reset_button.x = 120;
      EditorCommonUI.resetHelpButtons.help_button.x  = 180;
      EditorCommonUI.resetHelpButtons.panel.width    = 220;
      parent.width = 227;
      MAzoomEditorUI ZoomEditorUI {
         parent => <-.parent;
         viewer_params => <-.viewer_params;
         zoom_editor_params => <-.<-.Params.zoom_editor_params;
         y => EditorCommonUI.y + EditorCommonUI.height;
      };
      height => EditorCommonUI.height + ZoomEditorUI.height + 5;
   };
};
