/*
	"$Id: //depot/express/fcs70/v/MicroAVS/UI/boxes.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/UI/boxes.v#1 $
*/
//
// MicroAVS Boxes
//
UI.UIradioBox+MAUItempl   MAUIradioBox;
UI.UIoptionBox+MAUItempl  MAUIoptionBox;
//
// UIcombBox+
//
#ifdef MSDOS
UI.UIcomboBox+MAUItempl   MAUIcomboBox
#else
UI.UIoptionMenu+MAUItempl MAUIcomboBox
#endif //MSDOS
{
   // style NOT YET supported
   int &windowStyle<NEvisible=0>
      = 0x40000000+0x10000000+0x0040+0x0003+0x0200+0x00800000;
#ifdef MSDOS
   inst   = "MAUIcomboBoxInstance";	// override
   update = "MAUIcomboBoxUpdate";	// override
#else
   string+IPort2 &strings[];
   optionLabel<NEvisible=0> = 0;
   int numShowItems = 4;
   UIoption _cmdList<NEvisible=0>[array_size(strings)] {
      label => <-.strings[index_of(_cmdList)];
   };
   cmdList<NEportLevels=0> => _cmdList;
#endif //MSDOS
};
macro+nosave MAUIradioBoxLabel {
   ilink    parent;
   string   title => name_of(<-,1);
   string   &labels<NEportLevels={2,1}>[];
   int      dims => array_size(labels);
   int      x = 0;
   int      y = 0;
   int      width = 220;
   int+nres height => (dims+3.0) * UIdata.UIfonts[0].lineHeight ;
   //int      height  => .RBradioBox.y + .RBradioBox.height + 10;
   int      selectedItem;
   string+nres+IPort2 selectedString=>labels[selectedItem];
   int      visible = 1;
   int      active = 1;

   MAUIpanel RBframe {
      parent  => <-.parent;
      x       => <-.x;
      y       => <-.y;
      width   => <-.width;
      height  => <-.height;
      visible => <-.visible;
   };
   MAUIlabel RBtitle {
      parent    => <-.RBframe;
      x         =  4;
      y         =  4;
      width     => <-.width - 8;
      label     => <-.title;
      alignment = "center";
      active    => <-.active;
   };
   UIoption+nosave RBcmdList[dims] {
      label  => <-.labels[index_of(RBcmdList)];
      active => <-.active;
   };
   GMOD.instancer RBradioBoxinstancer {
      Group => <-.RBradioBox;
      Value => array_size(<-.RBcmdList) > 0;
   };
   MAUIradioBox RBradioBox<instanced=0> {
      parent       => <-.RBframe;
      cmdList      => <-.RBcmdList;
      x            =  4;
      y            => <-.RBtitle.y + <-.RBtitle.height;
      width        => <-.RBframe.clientWidth - 8;
      height       => <-.height;
      selectedItem => <-.selectedItem;
   };
};
macro+nosave MAUIoptionBoxLabel {
   ilink  parent;
   imlink labels;
   string title => name_of(<-,1);
   int visible  =  1;
   int selectedItems[];
   int max;
   int x =  0;            // input
   int y =  0;            // input
   int width =  220;
   int height => .UIoptionBox.y + .UIoptionBox.height;

   label_cmd label_cmd {
      labels => <-.labels;
      int+read+nonotify+opt inItem[] => <-.selectedItems;
      int+write+nonotify+opt outItem[];
   };
   MAUIpanel UIpanel {
      parent  => <-.parent;
      x       => <-.x;
      y       => <-.y;
      width   => <-.width;
      height  => <-.height;
      visible => <-.visible;
   };
   MAUIlabel UIlabel {
      parent    => <-.UIpanel;
      label     => <-.title;
      alignment = "center";
      y         =  0;
      width     => <-.UIpanel.width;
   };
   MAUIoptionBox UIoptionBox {
      parent        => <-.UIpanel;
      max           => <-.max;
      cmdList       => <-.label_cmd.cmd;
      selectedItems => <-.label_cmd.outItem;
      y             => <-.UIlabel.y + UIlabel.height + 4;
      width         => <-.UIpanel.width;
   };
};
