/*
	"$Id: //depot/express/fcs70/v/MicroAVS/UI/dialogs.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/UI/dialogs.v#1 $
*/
//
// MicroAVS Dialogs
//
#ifdef MSDOS
module MAUImessageBoxEx {
   UIdecorContainer+IPort2+read *parent;
   int                    &x =;
   int                    &y =;
   int                    &width =;
   int                    &height =;
   string                 &title => name_of(<-,1);
   string                 &message = "MAUImessageBoxEx Message";
   int                    &style = 0;// MB_OK|MB_DEFBUTTON1|MB_MODALAPPL etc..
                                     // See %DevStudio%/VC/include/winuser.h
   int                    &primaryLanguage = 0; // default NUTRAL
   int                    &subLanguage = 0;     // default NUTRAL
   int+read+write+IPort2  visible = 0;
   int+write+nonotify     abort;
   int+write+nonotify     cancel;
   int+write+nonotify     ignore;
   int+write+nonotify     no;
   int+write+nonotify     ok;
   int+write+nonotify     retry;
   int+write+nonotify     yes;
   omethod+notify_val     update = "MAUImessageBoxExUpdate";
};

MAUImessageBoxEx MAUImessageDialogClass {
   int type          = 0;	// MB_OK;
   int icon_type     = 0;	// MB_ICONNONE;
   int defaultButton = 0;	// MB_DEFBUTTON1;
   int modal         = 8192;	// MB_MODALTASK;
   int modal         = 0;	// MB_MODALAPPL;
   int mode          = 65536;	// MB_SETFOREGROUND
   style => type|icon_type|defaultButton|modal|mode;
};
MAUImessageDialogClass	MAUIerrorDialog {
   icon_type = 16;	// MB_ICONSTOP;
};
MAUImessageDialogClass	MAUIinfoDialog {
   icon_type = 64;	// MB_ICONINFORMATION;
};
MAUImessageDialogClass	MAUImessageDialog {
   icon_type = 0;	// MB_ICONNONE;
};
MAUImessageDialogClass	MAUIquestionDialog {
   icon_type = 32;	// MB_ICONQUESTION;
   type      = 1;	// MB_OKCANCEL;
};
MAUImessageDialogClass	MAUIwarningDialog {
   icon_type = 48;	// MB_ICONEXCLAMATION;
};
#else
// Motif Dialog is good.
UI.UIerrorDialog	MAUIerrorDialog {
   isModal      = 1;
   okButton     = 1;
   cancelButton = 0;
};
UI.UIinfoDialog		MAUIinfoDialog {
   isModal      = 1;
   okButton     = 1;
   cancelButton = 0;
};
UI.UImessageDialog	MAUImessageDialog {
   isModal      = 1;
   okButton     = 1;
   cancelButton = 0;
};
UI.UIquestionDialog	MAUIquestionDialog {
   isModal      = 1;
   okButton     = 1;
   cancelButton = 1;
};
UI.UIwarningDialog	MAUIwarningDialog {
   isModal      = 1;
   okButton     = 1;
   cancelButton = 0;
};
#endif //MSDOS
//
// UIfileDialog+
//
#ifdef MSDOS
module+nosave MAUIfileDialog
#else
UI.UIfileSB+nosave MAUIfileDialog
#endif //MSDOS
{
   UIdecorContainer+nonotify+IPort2 *parent;
   string &title             => name_of(<-,1);
   boolean+IPort2 &visible   = 0;
   boolean ok;
   boolean cancel;
   boolean &isModal          = 1;
   boolean &confirmFileWrite;
   string  &all_types_name   = "MAFT_ALL_NAME";
   string  &field_types_name = "MAFT_FIELD_NAME";
   string  &geom_types_name  = "MAFT_GEOM_NAME";
   string  &image_types_name = "MAFT_IMAGE_NAME";
   string  &ucd_types_name   = "MAFT_UCD_NAME";
   string  &mavs_types_name  = "MAFT_MAVS_NAME";
   int     &nNO              = 1;
   string  &all_types        = "*.*";
   string  &field_types;
   string  &geom_types;
   string  &image_types;
   string  &ucd_types;
   string  &mavs_types;
   string  &current_directory;
   string  &searchPattern;
   string+OPort2 filetitle;
   string+OPort2 filename;
#ifdef MSDOS
   int                &x =;
   int                &y =;
   int                &width =;
   int                &height =;
   UIwinHandle        handle;
/* version 5.0 ADD_START --------------------------------------*/
   omethod+req update (
      title+read+req,
      visible+read+write+req+notify,
      ok+write, cancel+write,
      all_types_name+read+req,
      field_types_name+read+req, geom_types_name+read+req,
      image_types_name+read+req, ucd_types_name+read+req,
      mavs_types_name+read+req,
      nNO+read+req,
      all_types+read+req,
      field_types+read+opt, geom_types+read+opt,
      image_types+read+opt, ucd_types+read+opt, mavs_types+read+opt,
      isModal+read+opt,confirmFileWrite+read+opt,
      current_directory+read+write,
      filetitle+read+write,
      filename+read+write
   ) = "MAUIfileDialogUpdate";
/*---------------------------------------  version 5.0 ADD_END */
#else
// next version
//      inst   = "MAUIfileDialogInstance";	// override
//      update = "MAUIfileDialogUpdate";	// override
#endif //MSDOS
};
//
// simpleDialog
//
MAUIshell MAUIsimpleDialog {
   parent<NEportLevels=0>;
   windowExStyle = 1; // WS_EX_DLGMODALFRAME;
   windowStyle   = 0|0x00C00000|0x80000|0x80|0x00020000;
      // WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|DS_MODALFRAME|WS_MINIMIZEBOX;
   showStatusBar = 0;
   sysMenuMode   = 0x002+0x008+0x020+0x040;// Move Minimize/Close
};
//
// sizeMinDialog
//
MAUIsimpleDialog MAUIsizeMinDialog {
   windowStyle   = 0|0x00C00000|0x80000|0x80|0x00020000|0x00040000;
   sysMenuMode   = 0x002+0x004+0x008+0x020+0x040;// Move Minimize Size/Close
};
//
// sizeMinNoCloseDialog
//
MAUIsimpleDialog MAUIsizeMinNoCloseDialog {
   windowStyle   = 0|0x00C00000|0x80000|0x80|0x00020000|0x00040000;
   sysMenuMode   = 0x002+0x004+0x008+0x020;// Move Minimize Size
};
//
// sizeDialog
//
MAUIsimpleDialog MAUIsizeDialog {
   windowStyle   = 0|0x00C00000|0x80000|0x80|0x00040000;
   sysMenuMode   = 0x002+0x004+0x020+0x040;	// Move Size/Close
};
//
// closeDialog
//
#ifdef MSDOS
#define HOFFS	30
#else
#define HOFFS	15
#endif //MSDOS
MAUIsimpleDialog MAUIcloseDialog {
   boolean+nonotify okButton       = 1;
   string+nonotify  okLabelString  = "MAUI_CLOSE";
   boolean+nonotify ok;
   MAUIbutton+nonotify Close {
      visible => <-.okButton;
      parent  => <-.<-;
      x       => (.parent.width - width) / 2;
      y       => .parent.height - HOFFS - height - 5;
      width   = 70;
      height  = 20;
      do      => <-.ok;
      label   => <-.okLabelString;
   };
   GMOD.copy_on_change+nonotify visible_off {
      trigger => <-.Close.do;
      input   => 0;
      output  => <-.visible;
      on_inst = 0;
   };
};
//
// okCancelDialog
//
MAUIcloseDialog MAUIokCancelDialog {
   string+nonotify  cancelLabelString  = "MAUI_CANCEL";
   boolean+nonotify cancelButton       = 1;
   boolean+nonotify cancel;
   okLabelString  = "MAUI_OK";
   Close+nonotify {
      visible => <-.okButton;
      parent  => <-.<-;
      int x   => (.parent.width - width) / 4;
      int y   => .parent.height - HOFFS - height - 5;
      width   = 70;
      height  = 20;
      do      => <-.ok;
      label   => <-.okLabelString;
   };
   MAUIbutton+nonotify Cancel {
      parent  => <-.<-;
      visible => <-.cancelButton;
      int x   => ((.parent.width - width) * 3) / 4;
      int y   => .parent.height - HOFFS - height - 5;
      width   = 70;
      height  = 20;
      label   => <-.cancelLabelString;
      do      => <-.cancel;
   };
   visible_off.trigger => <-.Cancel.do|<-.Close.do;
};
//
// moveDialog
//
MAUIsizeDialog MAUImoveDialog {
   windowExStyle = 1|8;		// Top Most
   sysMenuMode   = 0x002;	// Move Only
};

//
// Common Dialog
//
module+nosave MAUIcommonDialogTempl
<
   cxx_members = <"public: OMXgroup *parent;">
>
{
   UIdecorContainer+IPort2+read *parent<export=0,export_cxx=0>;
   string+read title => name_of(<-,);
   boolean+Iparam+write visible = 0;
   boolean+Oparam ok;
   boolean+Oparam cancel;
};
#ifdef MSDOS
//
// Windows Color Common Dialog
//
MAUIcommonDialogTempl MAUIcolorDialog {
   float+read+write red;
   float+read+write green;
   float+read+write blue;
   float+read+write cust_colors[16][3];
   string+write+nonotify cust_colors_str[16];
   omethod+notify_val update = "MAUIcolorDialogUpdate";

#define MAVS_CUSTOM_COLOR_FILE	MAVS_XP_PATH+"/runtime/colors16.v"
   GMOD.parse_v load_custom_colors<NEvisible=0> {
      on_inst = 1;
      relative => <-.<-;
      v_commands = "$include "+MAVS_CUSTOM_COLOR_FILE+"\n";
   };
   string colors<NEvisible=0>[] => 
      concat_array({"// MicroAVS 3.0 Custom 16 Colors",
                    "//",
                    "cust_colors = {"
                   }, 
                   cust_colors_str,
                   {"};"}
     );
   GMOD.parse_v save_custom_colors<NEvisible=0> {
      trigger => <-.ok;
      on_inst = 0;
      relative => <-.<-;
      v_commands = "$push\n"
                 + "$get_str_array colors >"+MAVS_CUSTOM_COLOR_FILE+"\n"
                 + "$pop\n";
   };
#undef MAVS_CUSTOM_COLOR_FILE
};
#endif //MSDOS

//
// Font Common Dialog
//
MAUIcommonDialogTempl MAUIfontDialog {
   float+read+write    red;
   float+read+write    green;
   float+read+write    blue;
   boolean+read+write  strikeout;
   boolean+read+write  underline;
   byte+read+write     charset;
   int+read            &mask; // charFormat.dwMask;
                              // See %DevStudio%/VC/include/richedit.h
   string+write        font;
   //Later boolean+read        &applyButton;
#ifdef MSDOS
#else //Unix
   string font_list[];
#endif //MSDOS
   omethod+notify_val  update = "MAUIfontDialogUpdate";
};

module+nosave MAUIlabelMoveDialog {
   ilink parent;
   boolean &visible = 0;
   string &title = "MAUI_TRANS";
   float &xpos = 0.0;
   float &ypos = 0.0;
   boolean &front = 1;
   boolean &front_back_vis = 1;
   boolean &front_back_active = 1;
   string reset_commands = "";

   GMOD.parse_v reset_params<NEvisible=0> {
      trigger => <-.ResetHelp.reset;
      on_inst = 0;
      v_commands => "$push -usr\n"
                   +"xpos=0.0;ypos=0.0;front=1;"
                   + <-.reset_commands
                   +"$pop\n";
      relative => <-;
   };
   MAUIcloseDialog Dialog<NEvisible=0> {
      parent  => <-.parent;
      title   => <-.title;
      visible => <-.visible;
      width => 240;
      height  => 170 + 65 + 15;
   };
   MAUIresetHelpButtons ResetHelp<NEvisible=0> {
      parent  => <-.Dialog;
      y = 0;
   };
   MAUItoggle Front<NEvisible=0> {
      parent => <-.Dialog;
      x = 10;
      y => <-.ResetHelp.y + <-.ResetHelp.height + 5;
      width = 100;
      set => <-.front;
      visible => <-.front_back_vis;
      active  => <-.front_back_active;
      label = "MAVLAB_FRONT";
   };
   MAUIslider Vertical<NEvisible=0> {
      parent => <-.Dialog;
      x = 5;
      y => <-.Front.y + <-.Front.height + 5;
      min = -1.0;
      max =  1.0;
      value => <-.ypos;
      title = "MAUI_TATE";
   };
   MAUIslider Horizontal<NEvisible=0> {
      parent => <-.Dialog;
      x = 5;
      y => <-.Vertical.y + <-.Vertical.height + 5;
      min = -1.0;
      max =  1.0;
      value => <-.xpos;
      title = "MAUI_YOKO";
   };
};
//
// directory Dialog
//
#ifdef MSDOS
MAUIcommonDialogTempl MAUIdirectoryDialog {
   string+read        title;
   string+read+write  directory;
   omethod+notify_val update = "MAUIdirectoryDialogUpdate";
};
#else
UIdirectoryDialog MAUIdirectoryDialog {
   filename => .directory;
   string+read+write directory;
};
#endif //MSDOS
//
// save Dialog
//
#ifdef MSDOS
MAUIcommonDialogTempl+nosave MAUIsaveDialog {
   int+read+notify+req        &camera_type =; // 2:2D;3:3D
   string+read+nonotify       &current_directory;
   string+read+nonotify       &locale = "$XP_LANG_DIR";
   boolean+read+nonotify      &confirm = 1; // 1:confirmation overwrite
                                            // 0:overwrite
   string+read+write+nonotify &filename;
   int+read+write+nonotify    &selectedItem = 0;
   int+write+nonotify         out_type = ;  // 1:image;2:vps;3:vrml
   group image_options {
      int+read+write+nonotify     &quality = 75;
      int+read+write+nonotify     &ncolors =;
      int+read+write+nonotify     &size    = 0;
      int+read+write+nonotify     &width   = 200;
      int+read+write+nonotify     &height  = 200;
   };
#ifdef VPS_RENDERER
   group+nonotify vps_options
   < disabled => Templates.CONFIG.gd_vps_disabled >
   {
      boolean+read+write+nonotify &indent  = 0;
      enum+read+write+nonotify    &format {
         choices = { "Color", "Greyscale" };
      } = "Color";
      enum+read+write+nonotify    &backMode {
         choices = { "White", "Black", "Keep" };
      } = "White";
      enum+read+write+nonotify    &orientation {
         choices = { "Landscape", "Portrait" };
      } = "Landscape";
      enum+read+write+nonotify    &size {
         choices = { "EPS", "A", "B", "A4", "A3", "A0" };
      } = "A4";
      float+read+write+nonotify   &widthMM  { min = 1; } = 160.0;
      float+read+write+nonotify   &heightMM { min = 1; } = 120.0;
      int+read+write+nonotify     &floatPrec { min = 1; max = 8; };
      int+read+write+nonotify     &xformPrec { min = 1; max = 8; };
      int+read+write+nonotify     &colorPrec { min = 1; max = 8; };
      enum+read+write+nonotify    &colorSub {
         choices = { "None", "Pre", "Post" };
      } = "None";
      enum+read+write+nonotify    &depthSort {
         choices = { "Default", "NNS" };
      } = "Default";
      float+read+write+nonotify   &colorTol  { min = 0.01; max = 1.0; } = 0.10;
   };
#endif // VPS_RENDERER
#ifdef VRML_RENDERER
   group+nonotify vrml_options
   < disabled => Templates.CONFIG.gd_vrml_disabled >
   {
      boolean+read+write+nonotify &indent  = 0;
      enum+read+write+nonotify    &protocol {
         choices = {       "VRML1",      "VRML2" };
         values  = { GD_WWW_VRML1, GD_WWW_VRML2  };
      } = "VRML1";
      int+read+write+nonotify     &floatPrec { min = 1; max = 8; } = 8.0;
      int+read+write+nonotify     &xformPrec { min = 1; max = 8; } = 8.0;
      int+read+write+nonotify     &colorPrec { min = 1; max = 8; } = 3.0;
   };
#endif //VRML_RENDERER
   method+notify_inst instance = "MAUIsaveDialogInstance";
   omethod+notify_val update   = "MAUIsaveDialogUpdate";
   method+notify_del  delete   = "MAUIsaveDialogDelete";
};
#endif //MSDOS
