/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/UI/macros.v#1 $
*/
//
// MicroAVS UI convenience macros
//
//
// min/max/value of Slider and Field Editor
//
module+nosave MAUISetvalMinMax {
   double+read+write+req  value_in;
   double+read+write+req  min_in;
   double+read+write+req  max_in;
   int+read+write+req precision_in;
   omethod+notify_inst+req MAUI_set_val_fromat_update = "MAUISetvalMinMaxUpdate";
};

macro+nosave MAUIvalEditor {
   boolean+IPort2 vis;
   string title            = "";
   boolean value_oonly     = 0;
   boolean min_oonly       = 0;
   boolean max_oonly       = 0;
   boolean precision_oonly = 0;
   int+nres x              =;
   int+nres y              =;
   boolean active          = 0;
   double value_in         = 0;
   double min_in           = 0;
   double max_in           = 0;
   int precision_in        = 0;

   MAUISetvalMinMax set_val_minmax {
      value_in            => <-.value_in;
      min_in              => <-.min_in;
      max_in              => <-.max_in;
      precision_in        => <-.precision_in;
   };

   GMOD.instancer Instancer {
      Value => <-.vis;
      Group => <-.UI;
   };
   macro UI<instanced=0> {
      link title               => <-.title;
      link vis                 => <-.vis;
      link value_in            => <-.value_in;
      link min_in              => <-.min_in;
      link max_in              => <-.max_in;
      link precision_in        => <-.precision_in;
      link value_oonly         => <-.value_oonly;
      link min_oonly           => <-.min_oonly;
      link max_oonly           => <-.max_oonly;
      link precision_oonly     => <-.precision_oonly;
      link active              => <-.active;
      link x                   => <-.x;
      link y                   => <-.y;
      boolean value_active     = 0;
      boolean min_active       = 0;
      boolean max_active       = 0;
      boolean precision_active = 0;
      GMOD.parse_v set_active {
         parse_v_relative<weight=3>;
         relative   => <-;
         on_inst    = 1;
         v_commands => "$push\n"
            +"value_active="+!value_oonly+"*active;"
            +"min_active="+!min_oonly+"*active;"
            +"max_active="+!max_oonly+"*active;"
            +"precision_active="+!precision_oonly+"*active;"
            +"$pop\n";
      };
      MAUIcloseDialog editor_shell {
         title   => "MAUI_VALEDITOR" + " ("+<-.title+")";
         x       => <-.x;
         y       => <-.y;
         width   = 250;
         height  = 220;
         visible => <-.vis;
      };
      MAUIlabel value_label {
         parent    => <-.editor_shell;
         y         => <-.value_field.y + (<-.value_field.height - height)/2;
         label     => " " + "MAUI_VALUE";
         width     = 120;
         alignment = "right";
         active    => <-.value_active;
      };
      MAUIfield value_field {
         parent        => <-.editor_shell;
         x             => <-.value_label.x + <-.value_label.width + 3;
         y             = 10;
         width         => .parent.clientWidth - x -10;
         visible       => .parent.visible;
         format        = "fixed";
         nullString    = "";
         active        => <-.value_active;
         double value  => <-.value_in;
         double min    => <-.min_in;
         double max    => <-.max_in;
         decimalPoints => <-.precision_field.value;
         mode          = "real";
      };
      MAUIlabel min_label {
         parent    => <-.editor_shell;
         alignment = "right";
         x         => <-.value_label.x;
         y         => <-.min_field.y + (<-.min_field.height - height)/2;
         width     => <-.value_label.width;
         label     => " " + "MAUI_MIN";
         active    => <-.min_active;
      };
      MAUIfield min_field {
         parent        => <-.editor_shell;
         visible       => .parent.visible;
         x             => <-.min_label.x + <-.min_label.width + 3;
         y             => <-.value_field.y + <-.value_field.height + 5;
         width         => <-.value_field.width;
         active        => <-.min_active;
         decimalPoints = 15;
         format        = "fixed";
         nullString    = "";
         double value  => <-.min_in;
         double min    =;
         double max    => <-.max_in;
         mode          = "real";
      };
      min_label max_label {
         y         => <-.max_field.y + (<-.max_field.height - height)/2;
         label     => " " + "MAUI_MAX";
         active    => <-.max_active;
      };
      min_field max_field {
         x             => <-.max_label.x + <-.max_label.width + 3;
         y             => <-.min_field.y + <-.min_field.height + 5;
         active        => <-.max_active;
         double value  => <-.max_in;
         double min    => <-.min_in;
         double max    =;
      };
      max_label precision_label {
         y         => <-.precision_field.y
                     + (<-.precision_field.height - height)/2;
         label     => " "+"MAUI_DECI";
         active    => <-.precision_active;
      };
      MAUIfield precision_field {
         parent     => <-.editor_shell;
         visible    => .parent.visible;
         x          => <-.precision_label.x + <-.precision_label.width + 3;
         y          => <-.max_field.y + <-.max_field.height + 5;
         width      => <-.max_field.width;
         active     => <-.precision_active;
         nullString = "";
         int value  => <-.precision_in;
         min        = 0;
         max        = 15;
         mode       = "integer";
      };
   };
};
//
// MAUIfield with min/max/value Editor
//
MAUIfield+nosave MAUIfield2 {
   string+nonotify title = "";
   int+nonotify allwidth = 220;
   x                     = 0;
   y                     = 0;
#ifdef MSDOS
   width                 => allwidth - button.width -1;
   height                = 30;
#else
   GMOD.copy_on_change set_width { // for Unix version bugs
      input => allwidth - button.width -1;
      output => <-.width;
      on_inst = 1;
      copy_on_change<weight=4>;
   };
   width                 =;
   height                = 33;
#endif //MSDOS
   decimalPoints         = 2;
   mode                  = "real";
   double value;
   double min;
   double max;
   float                 = 0.0;
   nullString            = "";
   format                = "fixed";
   MAUIbutton+nonotify button {
      visible               => <-.visible;
      parent                => <-.parent;
      height                => <-.height;
      label                 => "MAUI_VALEDITOR"+" ...";
      x                     => <-.x + <-.allwidth - .width;
      y                     => <-.y;
      width                 = 15;
      active                => <-.active;
      labelPixmap.filename  = MAVS_ICON_PATH +"valedit.x";
      labelPixmap.fileType  = "avs_image";
      toolTip.enable        => "automatic";
#ifdef MSDOS
#else
      color.backgroundColor = MAVS_DEF_GRAY;
#endif //MSDOS
   };
   active                           = 1;
   boolean+nonotify value_oonly     = 0;
   boolean+nonotify min_oonly       = 0;
   boolean+nonotify max_oonly       = 0;
   boolean+nonotify precision_oonly = 0;
   MAUIvalEditor+nonotify valEditor {
      title           => <-.title;
      vis             => <-.button.do;
      value_in        => <-.value;
      x               => <-.parent.x + <-.button.x;
      y               => min_array({360, <-.parent.y + <-.button.y});
      min_in          => <-.min;
      max_in          => <-.max;
      precision_in    => <-.decimalPoints;
      value_oonly     => <-.value_oonly;
      min_oonly       => <-.min_oonly;
      max_oonly       => <-.max_oonly;
      precision_oonly => <-.precision_oonly;
      active          => <-.active;
   };
};
//
// MAUIslider with min/max/value Editor
//
MAUIslider+nosave MAUIslider2 {
   string+nonotify title = "";
   int+nonotify allwidth = 220;
   int x                 = 0;
   int y                 = 0;

   int decimalPoints     = 2;
   double value          = 0.0;
   double min            = 0.0;
   double max            = 100.0;

#ifdef MSDOS
   int width             => allwidth - button.width -1;
#else
   GMOD.copy_on_change set_width { // for Unix version bugs
      input => allwidth - button.width -1;
      output => <-.width;
      on_inst = 1;
      copy_on_change<weight=4>;
   };
   int width             =;
#endif //MSDOS
   MAUIbutton+nonotify button {
      parent                => <-.parent;
      visible               => <-.visible;
      label                 => "MAUI_VALEDITOR"+" ...";
      x                     => <-.x + <-.allwidth - .width;
      y                     => <-.y;
      width                 = 15;
      height                => <-.height;
      labelPixmap.filename  = MAVS_ICON_PATH + "valedit.x";
      labelPixmap.fileType  = "avs_image";
      toolTip.enable        => "automatic";
      active                => <-.active;
#ifdef MSDOS
#else
      color.backgroundColor = MAVS_DEF_GRAY;
#endif //MSDOS
   };
   active                           = 1;
   boolean+nonotify value_oonly     = 0;
   boolean+nonotify min_oonly       = 0;
   boolean+nonotify max_oonly       = 0;
   boolean+nonotify precision_oonly = 0;
   MAUIvalEditor+nonotify valEditor {
      title           => <-.title;
      vis             => <-.button.do;
      value_in        => <-.value;
      x               => <-.parent.x + <-.button.x;
      y               => min_array({360, <-.parent.y + <-.button.y});
      min_in          => <-.min;
      max_in          => <-.max;
      precision_in    => <-.decimalPoints;
      value_oonly     => <-.value_oonly;
      min_oonly       => <-.min_oonly;
      max_oonly       => <-.max_oonly;
      precision_oonly => <-.precision_oonly;
      active          => <-.active;
   };
};
//
// RGB color sliders
//
macro+nosave MAUIcolor_sliders {
   UIconnection *parent<NEportLevels={2,1}> { int clientWidth; };
   link decimalPoints = 2;
   link x = 10;
   link y = 5;
   link width => .parent.clientWidth - 20;
#ifdef MSDOS
   link height = 35;
#else
   link height = 60;
#endif //MSDOS
   link visible = 1;
   link immediateMode = 1;
   link active =;
   float red = 1.0;
   float green = 1.0;
   float blue = 1.0;
   string red_title => "MAUI_RED";
   string green_title => "MAUI_GREEN";
   string blue_title => "MAUI_BLUE";

   MAUIslider red_slider {
      parent => <-.parent;
      title => <-.red_title;
      x => <-.x;
      y => <-.y;
      width => <-.width;
      height => <-.height;
      color.foregroundColor = MAVS_RED;
      min = 0.;
      max = 1.;
      decimalPoints => <-.decimalPoints;
      value => <-.red;
      immediateMode => <-.immediateMode;
      active => <-.active;
      visible => <-.visible;
   };
   red_slider green_slider {
      title => <-.green_title;
#ifdef MSDOS
      y => <-.red_slider.y + <-.red_slider.height + 10;
#else
      y => <-.red_slider.y + <-.red_slider.height;
#endif //MSDOS
      color.foregroundColor = MAVS_GREEN;
      value => <-.green;
   };
   red_slider blue_slider {
      title => <-.blue_title;
#ifdef MSDOS
      y => <-.green_slider.y + <-.green_slider.height + 10;
#else
      y => <-.green_slider.y + <-.green_slider.height;
#endif //MSDOS
      value => <-.blue;
      color.foregroundColor = MAVS_BLUE;
   };
};
//
// color palette 64 buttons
//
macro+nosave MAUIcolor_palette_buttons {
   ilink parent;
   ilink visible;
   link x          = 0;
   link y          = 0;
   link pixmap     = "pal64.x";
   link pixmap_off = "offpal64.x";
   link width      => unitx * ncols;
   link height     => unity * rows;
   link ncols      = 8;
   link rows       = 8;
   link unitx      = 29;
   link unity      = 21; // 19
   link active     = 1;

   UIpanel panel {
      parent  => <-.parent;
      visible => <-.visible;
      x       => <-.x - 5;
      y       => <-.y;
      width   => <-.width + 5;
      height  => <-.height;
      active => <-.active;
      pixmap.filename => switch(active+1,
         MAVS_ICON_PATH+<-.<-.pixmap_off,
         MAVS_ICON_PATH+<-.<-.pixmap
      );
      pixmap.fileType = "avs_image";
   };
   UIonePoint pick {
      view => <-.panel;
      runEvent => switch(<-.active+1, "", "<Btn1Down>");
   };
   GMOD.copy_on_change set_index {
      input => (pick.x+<-.panel.x) / <-.unitx
             + (pick.y / <-.unity) * <-.ncols;
      output => <-.index;
      on_inst = 0;
   };
   int index; // 0 base
};
//
// Selector Template
//
macro+nosave MAUIselectorTempl {
   ilink    parent;
   int      x = 0;
   int      y = 0;
   int      width = 220;
   int+nres height => 3.5 * UIdata.UIfonts[0].lineHeight + 35;
   string   title;
   string   selected;

   MAUIframe Frame {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.y;
      width  => <-.width;
      height => <-.height;
   };
   MAUIlabel Title {
      parent      => <-.Frame;
      label       => <-.title;
      x           = 4;
      y           = 4;
      width       => <-.Frame.width - 12;
      height      = 20;
#ifdef MSDOS
      fontAttributes.height = 18;
#else
      fontAttributes.height = 16;
#endif //MSDOS
   };
   MAUItext Text {
      parent      => <-.Frame;
      x           =  4;
      y+nres      => <-.Title.y + <-.Title.height + 4;
      width       => <-.Frame.width - 12;
      height+nres => 1.5 * UIdata.UIfonts[0].lineHeight;
      text        => <-.selected;
      updateMode  = 3;
   };
   MAUIbutton Browse {
      parent      => <-.Frame;
      label       =  "MAUI_BROWSE";
      x           =  4;
      y           => <-.Text.y + <-.Text.height + 4;
      width       => <-.Frame.width - 12;
      height+nres => UIdata.UIfonts[0].lineHeight + 10;
   };
};
//
// fileSelector
//
MAUIselectorTempl MAUIFileSelector {
   string file;
   string filetype = "*";
   string filetype_name = "";
   selected => .file;

   MAUIfileDialog fileFB {
      parent        => <-.Frame;
      title         => <-.title;
      x             =  250;
      y             =  45;
      visible       => <-.Browse.do;
      filename      => <-.file;
      searchPattern =>  "*." + <-.filetype;
      all_types     => "*." + <-.filetype;
      all_types_name => <-.filetype_name;
   };
   };
//
// directorySelector
//
MAUIselectorTempl MAUIDirectorySelector {
   string directory;
   selected => .directory;

   Title.fontAttributes.height = 14;
   MAUIdirectoryDialog dirFB {
      parent        => <-.Frame;
      title         => <-.title;
      x             =  250;
      y             =  45;
      visible       => <-.Browse.do;
      directory     => <-.directory;
   };
};
//
// OptionMenuLabel
//
macro+nosave MAUIOptionMenuLabel {
   ilink  parent;
   string options<NEportLevels={2,1}>[];
   int    x = 0;
   int    y = 0;
   int    width = 220;
#ifdef MSDOS
   int    width2 => width/2;
#else
   int    width2 => (width - 20)/2;
#endif //MSDOS
   int    height = 37;
   int    selectedItem;
   string selectedText;
   int    numShowItems;
   boolean visible = 1;
   boolean active = 1;
   string label;
   boolean optionLabel = 1;
   group color { string foregroundColor; string backgroundColor; };

#ifdef MSDOS
   MAUIcomboBox OPmenu {
      parent       => <-.parent;
      x            => <-.x + <-.width2 * <-.optionLabel;
      y            => <-.y;
      width        => <-.width - <-.optionLabel * <-.width2;
      height       => <-.height;
      strings      => <-.options;
      selectedItem => <-.selectedItem;
      selectedText => <-.selectedText;
      numShowItems => <-.numShowItems;
      visible      => <-.visible;
      active       => <-.active;
      color.foregroundColor => <-.<-.color.foregroundColor;
      color.backgroundColor => <-.<-.color.backgroundColor;
      numShowItems = 10;
   };
   MAUIlabel OPlabel {
      parent       => <-.parent;
      x 	      => <-.x;
      y 	      => <-.y + 5;
      width 	      => (<-.width2 - 5) * <-.optionLabel;
      visible      => <-.visible * <-.optionLabel;
      active	      => <-.active;
      label	      => <-.label;
      alignment    = "right";
      color.foregroundColor => <-.<-.color.foregroundColor;
      color.backgroundColor => <-.<-.color.backgroundColor;
   };
#else
   UIoption OPcmdList[array_size(options)] {
      label => <-.options[index_of(OPcmdList)];
   };
   MAUIoptionMenu OPmenu {
      parent       => <-.parent;
      x            => <-.x + <-.width2 * <-.optionLabel;
      y            => <-.y;
      width        => <-.width - <-.optionLabel * <-.width2;
      height       => <-.height;
      cmdList      => <-.OPcmdList;
      selectedItem => <-.selectedItem;
      optionLabel  =  0; // not good this is!
      label        =  "";
      visible      => <-.visible;
      active       => <-.active;
      color.foregroundColor => <-.<-.color.foregroundColor;
      color.backgroundColor => <-.<-.color.backgroundColor;
   };
   MAUIlabel OPlabel {
      parent       => <-.parent;
      x 	      => <-.x;
      y 	      => <-.y + 3;
      width 	      => (<-.width2 - 5) * <-.optionLabel;
      visible      => <-.visible * <-.optionLabel;
      active	      => <-.active;
      label	      => <-.label;
      alignment    = "right";
      color.foregroundColor => <-.<-.color.foregroundColor;
      color.backgroundColor => <-.<-.color.backgroundColor;
   };
#endif //MSDOS
};
//
// FieldFrameLabel
//
macro+nosave MAUIField {
   ilink parent;
   int x = 0;
   int y = 0;
   int width = 200;
   int+nres height => UIdata.UIfonts[0].lineHeight + 20;
   string label = "";
   float value<NEportLevels={1,2}>;
   float min<NEportLevels={1,2}>;
   float max<NEportLevels={1,2}>;
   int active = 1;
   int visible = 1;
   int decimalPoints = 2;
   int mode = 2;

   MAUIframe UIframe {
      parent => <-.parent;
      x      => <-.x;
      y      => <-.y;
      width  => <-.width;
      height => <-.height;
      visible => <-.visible;
   };
   MAUIlabel UIlabel {
      x      = 4;
      y      = 7;
      width  => <-.width / 2;
      height => (<-.height - 12);
      parent    => <-.UIframe;
      label     => <-.label;
      alignment = "right";
      active    => <-.active;
   };
   MAUIfield UIfield {
      parent => <-.UIframe;
      x      => <-.UIlabel.x + <-.UIlabel.width;
      y      = 4;
      width  => <-.width - <-.UIlabel.width - 12;
#ifdef MSDOS
      height => <-.height - 12;
#else
      height => <-.height - 7;
#endif //MSDOS
      value<NEportLevels={2,2}> => <-.value;
      min    => <-.min;
      max    => <-.max;
      active => <-.active;
      decimalPoints => <-.decimalPoints;
      mode => <-.mode;
   };
};
//
// FieldLabel
//
macro+nosave MAUIFieldLabel {
   ilink parent;
   int x = 0;
   int y = 0;
   int width = 200;
   int+nres height => UIdata.UIfonts[0].lineHeight + 5;
   string label = "";
   float value<NEportLevels={1,2}>;
   float min<NEportLevels={1,2}>;
   float max<NEportLevels={1,2}>;
   int active = 1;
   int visible = 1;
   int decimalPoints = 2;
   int mode = 2; // real
   boolean immediateMode = 0;

   MAUIlabel UIlabel {
      x         = 4;
      y         => <-.y + 3;
      width     => <-.width / 2;
      height    => <-.height;
      parent    => <-.parent;
      label     => <-.label;
      alignment = "right";
      active    => <-.active;
      visible   => <-.visible;
   };
   MAUIfield UIfield {
      parent => <-.parent;
      x      => <-.UIlabel.x + <-.UIlabel.width;
      y      => <-.y;
      width  => <-.width - <-.UIlabel.width - 12;
#ifdef MSDOS
      height => <-.height;
#else
      height => <-.height;
#endif //MSDOS
      value<NEportLevels={2,2}> => <-.value;
      min    => <-.min;
      max    => <-.max;
      active => <-.active;
      decimalPoints => <-.decimalPoints;
      mode => <-.mode;
      visible => <-.visible;
   };
};
//
// MicroAVS.MAUIfield with min/max/value Editor and PlusMinus Go Button
//
MAUIfield+nosave MAUIfieldRelative {
   string+nonotify title  = "";
   string+nonotify plabel = "+";
   string+nonotify nlabel = "-";
   int+nonotify allwidth  = 60;
   int+nonotify allheight = 45;
   int+nonotify ally      = 0;
   double+nonotify true_value = ;
   x                     = 0;
   y<NEvisible=0>        => ally + n_button.height;
   width<NEvisible=0>    => allwidth - button.width - 1;
   height<NEvisible=0>   = 30;
   decimalPoints         = 2;
   mode                  = "real";
   double value;
   double min            = 0.0;
   double max;
   float                 = 0.0;
   nullString            = "";
   format                = "fixed";

   // Minus Button //
   MAUIbutton+nonotify n_button {
      visible               => <-.visible;
      active                => <-.active;
      parent                => <-.parent;
      height                =>(<-.allheight - <-.height);
      width                 =>allwidth/2;
      label                 =><-.nlabel;
      x                     =><-.x;
      y                     =><-.ally;
   };

   // Plus Button //
   n_button p_button {
      x =><-.x + width;
      label =><-.plabel;
   };

   // Set Plus Value out //
   GMOD.parse_v set_plus<NEvisible=0> {
      v_commands =  "$push\n
                     color.foregroundColor = MAVS_BLUE;
                     true_value = value;
                     p_button.do = 0;
                     $pop\n
                    ";
      trigger =>active;
      active =><-.p_button.do;
      relative =><-;
   };

   // Set Minus Value out //
   set_plus set_minus<NEvisible=0> {
      v_commands =  "$push\n
                     color.foregroundColor = MAVS_RED;
                     true_value = value*(-1);
                     n_button.do = 0;
                     $pop\n
                    ";
      active =><-.n_button.do;
   };

   GMOD.parse_v set_defaultColor<NEvisible=0> {
      v_commands = "color.foregroundColor = \"black\";";
      trigger => value;
      relative =><-;
   };

   // Value Editor Button //
   MAUIbutton+nonotify button {
      visible               => <-.visible;
      parent                => <-.parent;
      height                => <-.height - 2;
      label                 => "MAUI_VALEDITOR"+" ...";
      x                     => <-.x + <-.allwidth - .width;
      y                     => <-.y + 1;
      width                 = 15;
      active                => <-.active;
      labelPixmap.filename  = MAVS_ICON_PATH +"valedit.x";
      labelPixmap.fileType  = "avs_image";
      toolTip.enable        => "automatic";
   };
   active                           = 1;
   boolean+nonotify value_oonly     = 0;
   boolean+nonotify min_oonly       = 1;
   boolean+nonotify max_oonly       = 0;
   boolean+nonotify precision_oonly = 0;
   MAUIvalEditor+nonotify valEditor<NEvisible=0> {
      title           => <-.title;
      vis             => <-.button.do;
      value_in        => <-.value;
      x               => <-.parent.x + <-.button.x;
      y               => min_array({360, <-.parent.y + <-.button.y});
      min_in          => <-.min;
      max_in          => <-.max;
      precision_in    => <-.decimalPoints;
      value_oonly     => <-.value_oonly;
      min_oonly       => <-.min_oonly;
      max_oonly       => <-.max_oonly;
      precision_oonly => <-.precision_oonly;
      active          => <-.active;
   };
};
//
// Null/Min/Max value Editor
//
macro+nosave MAUInullMinMaxValEditor {
   boolean+IPort2 visible;
   string title             = "";
   boolean null_active      = 1;
   boolean min_active       = 1;
   boolean max_active       = 1;
   boolean precision_active = 1;
   int+nres x               =;
   int+nres y               =;
   double null_value        = 0;
   double min_value         = 0;
   double max_value         = 0;
   int precision_value      = 6;
   boolean null_enabled     = 0;
   boolean min_enabled      = 0;
   boolean max_enabled      = 0;
   GMOD.instancer Instancer {
      Value => <-.visible;
      Group => <-.UI;
   };
   macro UI<instanced=0> {
      link title            => <-.title;
      link vis              => <-.visible;
      link null_value       => <-.null_value;
      link min_value        => <-.min_value;
      link max_value        => <-.max_value;
      link precision_value  => <-.precision_value;
      link null_active      => <-.null_active;
      link min_active       => <-.min_active;
      link max_active       => <-.max_active;
      link precision_active => <-.precision_active;
      link x                => <-.x;
      link y                => <-.y;
      link null_enabled     => <-.null_enabled;
      link min_enabled      => <-.min_enabled;
      link max_enabled      => <-.max_enabled;

      MAUIcloseDialog editor_shell {
         title   => <-.title;
         x       => <-.x;
         y       => <-.y;
         width   = 250;
         height  = 220;
         visible => <-.vis;
      };
      MAUItoggle null_toggle {
         parent => <-.editor_shell;
         x     = 5;
         y     = 16;
         width = 70;
         label = "MAUI_ENABLED";
         set   => <-.null_enabled;
      };
      MAUIlabel null_label {
         parent    => <-.editor_shell;
         x         => 75;
         y         => 16;
         width     => 60;
         alignment = "right";
         active    => <-.null_active;
         label     => "MAUI_NULL_VALUE";
      };
      MAUIfield null_field {
         parent        => <-.editor_shell;
         x             => <-.null_label.x + <-.null_label.width + 3;
         y             = 10;
         width         => .parent.clientWidth - x -10;
         visible       => .parent.visible;
         format        = "fixed";
         nullString    = "";
         active        => <-.null_active;
         double value  => <-.null_value;
         double min    = MAVS_DBL_MIN;
         double max    = MAVS_DBL_MAX;
         decimalPoints => <-.precision_field.value;
         mode          = "real";
      };
      null_toggle min_toggle {
         y   => min_label.y;
         set => <-.min_enabled;
      };
      MAUIlabel min_label {
         parent    => <-.editor_shell;
         alignment = "right";
         x         => <-.null_label.x;
         y         => <-.min_field.y + (<-.min_field.height - height)/2;
         width     => <-.null_label.width;
         label     => " " + "MAUI_MIN";
         active    => <-.min_active;
      };
      MAUIfield min_field {
         parent        => <-.editor_shell;
         visible       => .parent.visible;
         x             => <-.min_label.x + <-.min_label.width + 3;
         y             => <-.null_field.y + <-.null_field.height + 5;
         width         => <-.null_field.width;
         active        => <-.min_active;
         decimalPoints => <-.precision_field.value;
         format        = "fixed";
         nullString    = "";
         double value  => <-.min_value;
         double min    = MAVS_DBL_MIN;
         double max    = MAVS_DBL_MAX;
         double max    => <-.max_value;
         mode          = "real";
      };
      null_toggle max_toggle {
         y   => max_label.y;
         set => <-.max_enabled;
      };
      min_label max_label {
         y      => <-.max_field.y + (<-.max_field.height - height)/2;
         label  => " " + "MAUI_MAX";
         active => <-.max_active;
      };
      min_field max_field {
         x             => <-.max_label.x + <-.max_label.width + 3;
         y             => <-.min_field.y + <-.min_field.height + 5;
         active        => <-.max_active;
         double value  => <-.max_value;
         double min    = MAVS_DBL_MIN;
         double min    => <-.min_value;
         double max    = MAVS_DBL_MAX;
      };
      MAUIlabel precision_label {
         parent    => <-.editor_shell;
         alignment = "right";
         x         = 15;
         y         => <-.precision_field.y
                     + (<-.precision_field.height - height)/2;
         width     = 120;
         label     => " "+"MAUI_DECI";
         active    => <-.precision_active;
      };
      MAUIfield precision_field {
         parent     => <-.editor_shell;
         visible    => .parent.visible;
         x          => <-.precision_label.x + <-.precision_label.width + 3;
         y          => <-.max_field.y + <-.max_field.height + 5;
         width      => .parent.clientWidth - x - 10;
         active     => <-.precision_active;
         nullString = "";
         int value  => <-.precision_value;
         min        = 0;
         max        = 15;
         mode       = "integer";
      };
   };
};
