/*
	"$Id: //depot/express/fcs70/v/MicroAVS/UI/widgets.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/UI/widgets.v#1 $
*/
//
// MicroAVS Widgets
//
UI.UIlist+MAUItempl MAUIlist;
UI.UImultiList+MAUItempl MAUImultiList;
UI.UIoptionMenu+MAUItempl MAUIoptionMenu;
UI.UIslider+MAUItempl MAUIslider {
#ifdef MSDOS
   // for big font
   height+nres => UIdata.UIfonts[0].lineHeight + 22;
#endif //MSDOS
};
UI.UIdial+MAUItempl MAUIdial;
UI.UIlabel+MAUItempl MAUIlabel {
   alignment = "center";
};
UI.UIdynamic_toggle+MAUItempl MAUIdynamic_toggle {
   alignment = "left";
};
UI.UItoggle+MAUItempl MAUItoggle {
   alignment = "left";
};
UI.UItext+MAUItempl MAUItext {
   updateMode = 3; //enter or keyboard focus lossed
   multiLine  = 0;
};
UI.UIfield+MAUItempl  MAUIfield {
   height     = 33;
   updateMode = 3; //enter or keyboard focus lossed
   resizeMode = 0;
   nullString = "";
};
UI.UIbutton+MAUItempl MAUIbutton {
   alignment         = "center";
   toolTip.enable    = "automatic"; // or "always"
   toolTip.delayTime = 1000;
   toolTip.placement = "south";
};
MAUIbutton MAUIhelpButton {
   width                = 24;
   height               = 24;
   label                = "MAUI_HELP";
   labelPixmap.filename = MAVS_ICON_PATH + "bhelp.x";
   labelPixmap.fileType = "avs_image";
   toolTip.enable       => "automatic";
};
group+nosave MAUImethodButton {
   link     parent;
   int      x;
   int      y;
   int      width;
   int      height;
   string   label;
   string   message;
   UIpixmap &labelPixmap;
   boolean  do;
   MAUItoggle button<NEvisible=0> {
      parent          => <-.parent;
      x               => <-.x;
      y               => <-.y;
      width           => <-.width;
      height          => <-.height;
      label           = "";
      //bad !!label   => <-.label;
      //bad !!message => <-.message;
      pixmap.filename => <-.<-.labelPixmap.filename;
      pixmap.fileType => <-.<-.labelPixmap.fileType;
      set             => <-.do;
   };
};
//
// MAUIspinField
//
MAUIfield MAUIspinField {
   int all_width = 85;
   mode = "integer";
   decimalPoints = 0;
   double increment = 1;
   immediateMode = 0;
#ifdef MSDOS
   height = 25;
#else
   // On Unix, UIfield's width bugs!!!
   GMOD.copy_on_change set_all_width {
      input => <-.all_width - <-.spin_width;
      output => <-.width;
      copy_on_change<weight=2>;
   };
   height = 30;
#endif //MSDOS
   width => .all_width - spin_width;
   int spin_x => .x + .width;
   int spin_y => .y;
   int spin_width = 15;
   int spin_height => .height;
   value = 0;
   MAUIslider UpDown<NEvisible=0> {
      parent => <-.parent;
      x => <-.spin_x;
      y => <-.spin_y;
      width => <-.spin_width;
      height => <-.spin_height;
      title = "";
      showValue = 0;
      horizontal = 0;
      immediateMode => <-.immediateMode;
      min => <-.min;
      max => <-.max;
      value => <-.value;
      mode => <-.mode;
      decimalPoints => <-.decimalPoints;
      &color => <-.color;
      mode => <-.mode;
      active => <-.active;
      visible => <-.visible;
      processingDirection = "up";
      increment => <-.increment;
   };
};
//
// resetHelpButtons
//
macro+nosave MAUIresetHelpButtons {
   ilink parent;
   int x = 0;
   int y =;
   int width = 234;
   int height = 50;
   boolean reset_active;
   boolean help_active;
   boolean visible = 1;
   MAUIframe panel<NEvisible=0> {
      parent => <-.parent;
      x => <-.x;
      y => <-.y;
      width => <-.width;
      height => <-.height;
      visible => <-.visible;
   };
   MAUIbutton reset_button<NEvisible=0> {
      parent => <-.panel;
      x => <-.panel.clientWidth - (.width + 62);
      y = 10;
#ifdef MSDOS
      width = 50;
#else
      width = 60;
#endif //MSDOS
      height = 24;
      label = "MAUI_RESET";
      do => <-.reset;
      active => <-.reset_active;
   };
   MAUIhelpButton help_button<NEvisible=0> {
      parent => <-.panel;
      x => <-.panel.clientWidth - (.width + 10);
      y => <-.reset_button.y;
      toolTip.enable => "automatic";
      do => <-.help;
      active => <-.help_active;
   };
   boolean+OPort2 reset;
   boolean+OPort2 help;
};
