/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Ucd/advect.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Ucd/advect.v#1 $
*/
MAnetwork UCDAdvect3D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_ADVECT_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_ADVECT_T";
   Params {
      params.help_name = "advect3d";
      params.name = "advect";
      MAcombine_vect3d_params combine_vect_params;
      MAfplane_params fplane_params;
      MAadvector_params advector_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => combine_vect_params.init_commands
                                 + fplane_params.init_commands
                                 + advector_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => combine_vect_params.reset_commands
                                 + fplane_params.reset_commands
                                 + advector_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MAcombine_vect MAcombine_vect {
         combine_vect_params =><-.<-.Params.combine_vect_params;
         fld_in =><-.fld_in;
      };
      MAadvector MAadvector {
         advector_params =><-.<-.Params.advector_params;
         fld_in =><-.MAcombine_vect.fld_out;
         probe_in =><-.MAfplane.fld_out;
#ifdef OLD
         GMOD.parse_v set_trace_viz {
            on_inst = 0;
            trigger => <-.advector_params.tracer;
            relative => <-.<-.<-.<-;
            v_commands =>
                 "$push\n"
                 + switch(<-.advector_params.tracer+1,
                   "$del_obj_ref DataObject.child_objs Modules.trace_out\n",
                   "$link        DataObject.child_objs Modules.trace_out\n")
                 + "$pop\n";
         };
#endif //OLD
      };
      MAfplane MAfplane {
         fplane_params =><-.<-.Params.fplane_params;
         fld_in =><-.fld_in;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAadvector.fld_out;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
       MAdataObjectLite tracer_obj {
         in => <-.MAadvector.trace_out;
         Obj.name => "NOOBJLIST LINE_UNIT_OBJ";
         Obj.pickable = 0;
      };
      fld_out => MAadvector.fld_out;
      olink trace_out => .tracer_obj.obj;
      olink plane_out => MAfplane.obj_out;
      olink legend_out => MAcmapLegendSet.legend_out;
   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAcombine_vectUI.height 
               + MAfplaneUI.height 
               + MAadvectorUI.height 
               + MAmaplegendUI.height
               + 5;
      MAcombine_vectUI MAcombine_vectUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         combine_vect_params =><-.<-.Params.combine_vect_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAfplaneUI MAfplaneUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         fplane_params =><-.<-.Params.fplane_params;
         y =><-.MAcombine_vectUI.y + <-.MAcombine_vectUI.height;
      };
      MAadvectorUI MAadvectorUI {
         parent => <-.parent;
         advector_params =><-.<-.Params.advector_params;
         y =><-.MAfplaneUI.y + <-.MAfplaneUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAadvectorUI.y + <-.MAadvectorUI.height;
         active => <-.<-.Params.advector_params.color;
      };
   };
   DataObject{
      child_objs => switch(Params.advector_params.tracer+1,
                    {<-.Modules.plane_out, <-.Modules.legend_out},
                    {<-.Modules.plane_out, <-.Modules.legend_out, <-.Modules.trace_out});

      Props.cull = "Back";
   };

};


MAnetwork UCDAdvect2D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_ADVECT_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_ADVECT_T";
   Params {
      params.help_name = "advect2d";
      params.name = "advect";
      MAcombine_vect2d_params combine_vect_params;
      MAuline_params uline_params;
      MAadvector_params advector_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => combine_vect_params.init_commands
                                 + uline_params.init_commands
                                 + advector_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => combine_vect_params.reset_commands
                                 + uline_params.reset_commands
                                 + advector_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      MAcombine_vect MAcombine_vect {
         combine_vect_params =><-.<-.Params.combine_vect_params;
         fld_in =><-.fld_in;
      };
      MAadvector MAadvector {
         advector_params =><-.<-.Params.advector_params;
         fld_in =><-.MAcombine_vect.fld_out;
         probe_in =><-.MAuline.fld_out;
#ifdef OLD
         GMOD.parse_v set_trace_viz {
            on_inst = 0;
            trigger => <-.advector_params.tracer;
            relative => <-.<-.<-.<-;
            v_commands =>
                 "$push\n"
                 + switch(<-.advector_params.tracer+1,
                   "$del_obj_ref DataObject.child_objs Modules.trace_out\n",
                   "$link        DataObject.child_objs Modules.trace_out\n")
                 + "$pop\n";
         };
#endif //OLD
      };
      MAuline2d MAuline {
         uline_params =><-.<-.Params.uline_params;
         fld_in =><-.fld_in;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAadvector.fld_out;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
       MAdataObjectLite tracer_obj {
         in => <-.MAadvector.trace_out;
         Obj.name => "NOOBJLIST LINE_UNIT_OBJ";
         Obj.pickable = 0;
      };
      fld_out => MAadvector.fld_out;
      olink trace_out => .tracer_obj.obj;
      olink line_out => MAuline.obj_out;
      olink legend_out => MAcmapLegendSet.legend_out;
   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAcombine_vectUI.height 
               + MAulineUI.height 
               + MAadvectorUI.height 
               + MAmaplegendUI.height
               + 5;
      MAcombine_vectUI MAcombine_vectUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         combine_vect_params =><-.<-.Params.combine_vect_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAuline2dUI MAulineUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         uline_params =><-.<-.Params.uline_params;
         y =><-.MAcombine_vectUI.y + <-.MAcombine_vectUI.height;
      };
      MAadvectorUI MAadvectorUI {
         parent => <-.parent;
         advector_params =><-.<-.Params.advector_params;
         y =><-.MAulineUI.y + <-.MAulineUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAadvectorUI.y + <-.MAadvectorUI.height;
         active => <-.<-.Params.advector_params.color;
      };
   };
   DataObject.child_objs =>
   switch(Params.advector_params.tracer+1,
      {<-.Modules.line_out, <-.Modules.legend_out},
      {<-.Modules.line_out, <-.Modules.legend_out, <-.Modules.trace_out});
   DataObject.Props.cull = "Back";
};
MAnetwork UCDArAdvect3D 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_ADVECT_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_ADVECT_T";
   MAGDobject_templ-nosave+IPort2 &picked_obj;
   Params {
      params.help_name = "advect3d";
      params.name = "advect";
      MAcombine_vect3d_params combine_vect_params;
      MAnew_slice_plane_params new_slice_plane_params;
      MAadvector_params advector_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      MAcut_plane_params cut_plane_params;
      init_params.init_commands => combine_vect_params.init_commands
                                 + new_slice_plane_params.init_commands
                                 + advector_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => combine_vect_params.reset_commands
                                 + new_slice_plane_params.reset_commands
                                 + advector_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
   Modules {
      ilink pick_in =><-.picked_obj;
      MAcombine_vect MAcombine_vect {
         combine_vect_params =><-.<-.Params.combine_vect_params;
         fld_in =><-.fld_in;
      };
      MAadvector MAadvector {
         advector_params =><-.<-.Params.advector_params;
         fld_in =><-.MAcombine_vect.fld_out;
         probe_in =><-.MAnew_slice_plane.fld_out;
#ifdef OLD
         GMOD.parse_v set_trace_viz {
            on_inst = 0;
            trigger => <-.advector_params.tracer;
            relative => <-.<-.<-.<-;
            v_commands =>
                 "$push\n"
                 + switch(<-.advector_params.tracer+1,
                   "$del_obj_ref DataObject.child_objs Modules.trace_out\n",
                   "$link        DataObject.child_objs Modules.trace_out\n")
                 + "$pop\n";
         };
#endif //OLD
      };
      MAnew_slice_plane MAnew_slice_plane {
         in_pick =><-.pick_in;
         new_slice_plane_params => <-.<-.Params.new_slice_plane_params;
         fld_in => <-.MAcombine_vect.fld_out;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAadvector.fld_out;
         legend_params =><-.<-.Params.legend_params;
         MAcolmap_params &colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
       MAdataObjectLite tracer_obj {
         in => <-.MAadvector.trace_out;
         Obj.name => "NOOBJLIST LINE_UNIT_OBJ";
         Obj.pickable = 0;
      };

   /*  for MicroAVS5.0 cut_plane */

      MAcut_plane_params &cut_plane_params => Params.cut_plane_params;
      MAcut_plane+nosave MAcut_plane{                          /* f[^Jbg郂W[ */
         in_field => <-.MAadvector.fld_out;
         in_pick  => <-.pick_in;
         cut_plane_params => <-.<-.Params.cut_plane_params;
      };
      olink+nres plane_axis_obj => MAcut_plane.plane_axis_obj;
      fld_out => MAcut_plane.out_fld;

      GMOD.parse_v set_tracer_active {
         on_inst = 0;
         trigger => <-.cut_plane_params.cut_on;
         relative => <-.set_tracer_active;
         v_commands => "$push\n"
                       +switch(<-.cut_plane_params.cut_on + 1,
                        "tracer_active = 1;\n",
                        "tracer_active = 0;\n")
                       + "$pop\n";
         int tracer_active => <-.Params.advector_params.tracer_active;
      };

   /*  for MicroAVS5.0 cut_plane */

      olink trace_out => .tracer_obj.obj;
      olink legend_out => .MAcmapLegendSet.legend_out;
      olink pick_obj_out => .MAnew_slice_plane.out_pick_obj;
      olink slice_obj_out => .MAnew_slice_plane.out_slice_obj;
      olink axis_obj_out => .MAnew_slice_plane.out_axis_obj;
   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAcombine_vectUI.height 
               + MAnew_slice_planeUI.height 
               + MAadvectorUI.height 
               + MAmaplegendUI.height
               + 5;
      MAcombine_vectUI MAcombine_vectUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         combine_vect_params =><-.<-.Params.combine_vect_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAnew_slice_planeUI MAnew_slice_planeUI {
         fld_in =><-.fld_in;
         parent => <-.parent;
         new_slice_plane_params =><-.<-.Params.new_slice_plane_params;
         y =><-.MAcombine_vectUI.y + <-.MAcombine_vectUI.height;
      };
      MAadvectorUI MAadvectorUI {
         parent => <-.parent;
         advector_params =><-.<-.Params.advector_params;
         y =><-.MAnew_slice_planeUI.y + <-.MAnew_slice_planeUI.height;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAadvectorUI.y + <-.MAadvectorUI.height;
         active => <-.<-.Params.advector_params.color;
      };
   };

/*  for MicroAVS 6.0 lݒ */

#ifdef MICROAVS_DEV_KIT
   GMOD.parse_v set_init_params {
     v_commands => "$push\n"
                  +"Params.new_slice_plane_params.dim1            = <-.env_params.particl.dim1;\n"
                  +"Params.new_slice_plane_params.dim2            = <-.env_params.particl.dim2;\n"
                  +"Params.new_slice_plane_params.x_vector.x      = <-.<-.env_params.particl.x_vector.x;\n"
                  +"Params.new_slice_plane_params.x_vector.y      = <-.<-.env_params.particl.x_vector.y;\n"
                  +"Params.new_slice_plane_params.x_vector.z      = <-.<-.env_params.particl.x_vector.z;\n"
                  +"Params.new_slice_plane_params.y_vector.x      = <-.<-.env_params.particl.y_vector.x;\n"
                  +"Params.new_slice_plane_params.y_vector.y      = <-.<-.env_params.particl.y_vector.y;\n"
                  +"Params.new_slice_plane_params.y_vector.z      = <-.<-.env_params.particl.y_vector.z;\n"
                  +"Params.new_slice_plane_params.z_vector.x      = <-.<-.env_params.particl.z_vector.x;\n"
                  +"Params.new_slice_plane_params.z_vector.y      = <-.<-.env_params.particl.z_vector.y;\n"
                  +"Params.new_slice_plane_params.z_vector.z      = <-.<-.env_params.particl.z_vector.z;\n"
                  +switch(is_valid(<-.Params.env_params.particl.center.x) + 1
                         ," "
                         ,"Params.new_slice_plane_params.center.x        = <-.<-.env_params.particl.center.x;\n")
                  +switch(is_valid(<-.Params.env_params.particl.center.y) + 1
                         ," "
                         ,"Params.new_slice_plane_params.center.y        = <-.<-.env_params.particl.center.y;\n")
                  +switch(is_valid(<-.Params.env_params.particl.center.z) + 1
                         ," "
                         ,"Params.new_slice_plane_params.center.z        = <-.<-.env_params.particl.center.z;\n")
                  +"Params.new_slice_plane_params.vector_complete = 1;\n"
                  +"Params.advector_params.tracer                 = <-.env_params.particl.tracer;\n"
                  +"$pop\n"
                  +"$push\n"
                  +switch((strlen(Params.env_params.particl.colormap) != 0) + 1
                    , "Params.colmap_params.rd_filename;\n"
                    , "Params.colmap_params.rd_filename = <-.env_params.particl.colormap;\n"
                     +"Params.colmap_params.rd_ok       = 1;\n")
                  +"$pop\n"
                  +"$push\n"
                  +"get_init_params.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_rd_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_wt_filename.active =  1;\n"
                  +"$pop\n"
                  +"$push\n"
                  +"set_init_params.active =  0;\n"
                  +"$pop\n";
     relative   => <-;
     trigger    => is_valid(<-.Modules.MAadvector.fld_in);
     on_inst    = 0;
   };
   string+nres local_colormap => MicroAVScontroller.Params.env_params.particl.colormap;
   GMOD.parse_v set_rd_filename {
     v_commands    => "local_colormap = Params.colmap_params.rd_filename;\n";
     trigger+nres  => Params.colmap_params.rd_ok;
     relative+nres => <-.<-;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v set_wt_filename {
     v_commands    => "local_colormap = Params.colmap_params.wt_filename;\n";
     trigger+nres  => Params.colmap_params.wt_ok;
     relative+nres => <-.<-;
     active        = 0;
     on_inst       = 0;
   };
   GMOD.parse_v get_init_params {
     v_commands    => "$push\n"
                     +"MicroAVScontroller.Params.env_params.particl.dim1       =" + Params.new_slice_plane_params.dim1 + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.dim2       =" + Params.new_slice_plane_params.dim2 + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.x_vector.x =" + Params.new_slice_plane_params.x_vector.x + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.x_vector.y =" + Params.new_slice_plane_params.x_vector.y + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.x_vector.z =" + Params.new_slice_plane_params.x_vector.z + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.y_vector.x =" + Params.new_slice_plane_params.y_vector.x + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.y_vector.y =" + Params.new_slice_plane_params.y_vector.y + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.y_vector.z =" + Params.new_slice_plane_params.y_vector.z + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.z_vector.x =" + Params.new_slice_plane_params.z_vector.x + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.z_vector.y =" + Params.new_slice_plane_params.z_vector.y + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.z_vector.z =" + Params.new_slice_plane_params.z_vector.z + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.center.x   =" + Params.new_slice_plane_params.center.x + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.center.y   =" + Params.new_slice_plane_params.center.y + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.center.z   =" + Params.new_slice_plane_params.center.z + ";\n"
                     +"MicroAVScontroller.Params.env_params.particl.tracer     =" + Params.advector_params.tracer + ";\n"
                     +"$pop\n"
                     +"$push\n"
                     +"MicroAVScontroller.Control.SetenvParams.setenv_params.Go =  1;\n"
                     +"$pop\n";
     trigger+nres  => MicroAVScontroller.Params.params.env_params;
//     relative+nres => MicroAVScontroller;
     active        = 0;
     on_inst       = 0;
   };
#endif //MICROAVS_DEV_KIT

/*  for MicroAVS 6.0 lݒ */

   DataObject{
      MAcut_plane_params &cut_plane_params => <-.Modules.MAcut_plane.cut_plane_params;
      &Obj.cut_plane_params => <-.cut_plane_params;
      child_objs => switch(Params.advector_params.tracer+1,
                    {<-.Modules.legend_out,
                     <-.Modules.pick_obj_out,
                     <-.Modules.slice_obj_out,
                     <-.Modules.axis_obj_out,
                     <-.Modules.MAcut_plane.plane_axis_obj},
                    {<-.Modules.legend_out,
                     <-.Modules.pick_obj_out,
                     <-.Modules.slice_obj_out,
                     <-.Modules.axis_obj_out,
                     <-.Modules.trace_out});
      Props.cull = "Back";
   };

   //MAnew_slice_planeW[g߂̃p[^l̐ݒ
   Params.new_slice_plane_params.plane_style=1;
   Params.new_slice_plane_params.dim1=8;
   Params.new_slice_plane_params.dim2=8;

   //p[^Zbgl̐ݒ
   Params.new_slice_plane_params.reset_commands =
     "new_slice_plane_params{"
    +   "marker_scale = 1.0;"
    +   "specify_type = 0;"
    +   "plane_style = 1;" // 0  1ɕύX
    +   "plane_axis_vis = 1;"
    +   "rot_trans_reset = 1;"
    +   "all_nodes = 0;"
    +   "plane_or_mesh = 0;"
    +   "dim1_scale = 1.0;"
    +   "dim2_scale = 1.0;"
    +   "dim1 = 8;" // 2  8ɕύX
    +   "dim2 = 8;" // 2  8ɕύX
    +   "separate = 0;"
    +   "marker_vis = 1;"
    +   "pick_clear=1;"
    +   "marker_scale = 1.0;"
    +   "pressed_button = 0;"
    +   "selected = 0;"
    +   "pick_b1_status=0;"
    +   "pick_b2_status=0;"
    +   "pick_b3_status=0;"
    +   "x_rot_ui = 45.0;"
    +   "y_rot_ui = 45.0;"
    +   "z_rot_ui = 45.0;"
    +   "x_trans_ui = 1.0;"
    +   "y_trans_ui = 1.0;"
    +   "z_trans_ui = 1.0;"
    +   "x_rot_ui_local = 45.0;"
    +   "y_rot_ui_local = 45.0;"
    +   "z_rot_ui_local = 45.0;"
    +   "x_trans_ui_local = 1.0;"
    +   "y_trans_ui_local = 1.0;"
    +   "z_trans_ui_local = 1.0;"
    +   "axis_scale = 1.0;"
    +   "world_or_local = 0;"
    +"};"
    ;
};
