/*
			Copyright (c) 1998 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Ucd/extline.v#1 $
*/
MAnetwork UCDExtline 
#ifdef MAVS_USE_USER_NAME
< user_name="ME_EXTLINE_T" >
#endif // MAVS_USE_USER_NAME
{
   title = "ME_EXTLINE_T";
   Params {
      params.name = "extline";
      params.help_name = "extline";
      MAextract_scalar_params extract_scalar_params;
      MAisoline_params isoline_params;
      MAlegend_params legend_params { title => <-.<-.title; };
      MAcolmap_params colmap_params { title => <-.<-.title; };
      init_params.init_commands => extract_scalar_params.init_commands
                                 + isoline_params.init_commands
                                 + legend_params.init_commands
                                 + colmap_params.init_commands;
      reset_params.reset_commands => extract_scalar_params.reset_commands
                                 + isoline_params.reset_commands
                                 + legend_params.reset_commands
                                 + colmap_params.reset_commands;
   };
/*
   DataObject {
      Props {
         line_width =><-.<-.Params.isoline_params.linewidth;
         line_aa =><-.<-.Params.isoline_params.smoothline;
         jitter =><-.<-.Params.isoline_params.jitterlevel;
      };
   };
*/
   Modules {
      MAextract_scalar MAextract_scalar {
         fld_in =><-.fld_in;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
      };
      MAext_faces MAext_faces {
         fld_in =><-.MAextract_scalar.fld_out;
      };
      MAisoline MAisoline {
         fld_in =><-.MAext_faces.fld_out;
         isoline_params =><-.<-.Params.isoline_params;
      };
      MAcmapLegendSet MAcmapLegendSet {
         fld_in => <-.MAisoline.fld_out;
         legend_params =><-.<-.Params.legend_params;
         colmap_params =><-.<-.Params.colmap_params;
         obj_in =><-.obj_in;
      };
      fld_out => MAisoline.fld_out;
      olink legend_out => .MAcmapLegendSet.legend_out;
      olink text_out   => MAisoline.text_out;
      olink bounds_out => MAisoline.bounds_out;
   };
   UI {
      help_path = "/ucd";
      height => MAmoduleCommonUI.height
               + MAextract_scalarUI.height
               + MAisolineUI.height
               + MAmaplegendUI.height
               + 5;
      MAextract_scalarUI MAextract_scalarUI {
         parent => <-.parent;
         fld_in =><-.fld_in;
         extract_scalar_params =><-.<-.Params.extract_scalar_params;
         y =><-.MAmoduleCommonUI.y + <-.MAmoduleCommonUI.height;
      };
      MAisolineUI MAisolineUI {
         parent => <-.parent;
         fld_in =><-.<-.Modules.MAisoline.fld_in;
         isoline_params =><-.<-.Params.isoline_params;
         y =><-.MAextract_scalarUI.y + <-.MAextract_scalarUI.height;
         level_label_flag = 0;
      };
      MAmaplegendUI MAmaplegendUI {
         parent => <-.parent;
         colmap_params =><-.<-.Params.colmap_params;
         legend_params =><-.<-.Params.legend_params;
         y =><-.MAisolineUI.y + <-.MAisolineUI.height;
         active => <-.<-.Params.isoline_params.color;
      };
   };
   DataObject.child_objs => {<-.Modules.legend_out,
                             <-.Modules.text_out,
                             <-.Modules.bounds_out
                            };
};
