/*
	"$Id: //depot/express/fcs70/v/MicroAVS/writers.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/writers.v#1 $
*/
//
// MicroAVS Writers
//
flibrary+buffered+sort+global writers <compile_subs=0>
{
#ifdef MSDOS
   macro MAwriteAnyData {
      ilink visible;
      //
      // Write Any Data
      //      out_type:
      //	1) Image
      //	2) Vector PostScript
      //	3) VRML
      //
      MAGDview_templ &view_in<NEportLevels={2,1}>;
      UIrenderView &render_view_in => view_in.render_view;
#ifdef MICROAVS_DEV_KIT
      MAdataObj+nres &dataObj => <-.dataObj;
#else
      MAdataObj dataObj;
#endif // MICROAVS_DEV_KIT

      group Params {
         string filename = "MicroAVS";
         boolean ok = 0;
         int out_type =;
         int width       => <-.render_view_in.width;
         int height      => <-.render_view_in.height;
         MAUIsaveDialog.image_options  image_options;
         MAUIsaveDialog.vps_options    vps_options;
         MAUIsaveDialog.vrml_options   vrml_options;
      };
       macro set_width_height {
         ilink visible => <-.visible;
         ilink Params => <-.Params;
         boolean trigger => (is_valid((<-.render_view_in.width || <-.render_view_in.height))
                             && (Params.image_options.size == 0));
#ifdef MSDOS
         int width   => switch(is_valid(<-.render_view_in.width)+1,
                               200, <-.render_view_in.width-1);
         int height  => switch(is_valid(<-.render_view_in.height)+1, 
                               200, <-.render_view_in.height-1);
#else
         int width   => switch(is_valid(<-.render_view_in.width)+1,
                               200, <-.render_view_in.width);
         int height  => switch(is_valid(<-.render_view_in.height)+1, 
                               200, <-.render_view_in.height);
#endif //MSDOS
         GMOD.parse_v set_default_wh {
            trigger => <-.trigger;
            active => <-.trigger;
            v_commands =>"$push\n
                          Params.image_options.width =" + width +";
                          Params.image_options.height =" + height + ";
                          $pop\n";
            relative =><-;
            on_inst = 0;
         };
      };
      macro UI {
         ilink parent => <-.dataObj.topWindow;
         ilink visible => <-.visible;
         ilink Params => <-.Params;
         int+nres &camera_type => (<-.view_in.cameras[0].type == 0)+2;

         MAUIsaveDialog WriteDialog {
            current_directory => MAVS_WRITE_DATA_PATH;
            visible           => <-.visible;
            parent            => <-.parent;
            camera_type       => <-.camera_type;
            filename          => <-.Params.filename;
            ok                => <-.Params.ok;
            out_type          => <-.Params.out_type;
            &image_options    => <-.Params.image_options;
            &vps_options      => <-.Params.vps_options;
            &vrml_options     => <-.Params.vrml_options;
         };
      };
      UIrenderView renderView {
         parent+nres => <-.render_view_in.parent;
         visible = 0;
         x = 0;
         y = 0;
         width   => <-.Params.image_options.width;
         height  => <-.Params.image_options.height;
/*
#ifdef MSDOS
         width   => switch(is_valid(<-.render_view_in.width)+1,
                           200, <-.render_view_in.width-1);
         height  => switch(is_valid(<-.render_view_in.height)+1, 
                           200, <-.render_view_in.height-1);
#else
         width   => switch(is_valid(<-.render_view_in.width)+1,
                           200, <-.render_view_in.width);
         height  => switch(is_valid(<-.render_view_in.height)+1, 
                           200, <-.render_view_in.height);
#endif //MSDOS
*/
      };
      BestVirtPal VirtPal {
         vclass    => view_in.virtpal.vclass;
         vid       => view_in.virtpal.vid;
         share     = 0;
         cube_size => view_in.virtpal.cube_size;
         gamma     = 1.0;
      };
   // for image
      MAfilename_to_type filename_to_type {
         filename => <-.imageOutput.file;
         modules => dataObj.write_module;
         executables => dataObj.write_executable;
         file_suffixes => dataObj.write_file_suffix;
         data_types => dataObj.write_data_type;
         comments => dataObj.write_comment;
         helps => dataObj.write_help;
      };
      MAimage_writer imageWriter {
         in => <-.imageOutput.output;
         module => <-.filename_to_type.module;
         executable => <-.filename_to_type.executable;
         data_type => <-.filename_to_type.data_type;
      };
      MAdefaultFieldOutput imageOutput {
         string file => <-.Params.filename;
      };
   // VPS
      MAdefaultVpsOutput vpsOutput {
         //file        => <-.Params.filename;
         format      => <-.Params.vps_options.format;
         orientation => <-.Params.vps_options.orientation;
         backMode    => <-.Params.vps_options.backMode;
         size        => <-.Params.vps_options.size;
         widthMM     => <-.Params.vps_options.widthMM;
         heightMM    => <-.Params.vps_options.heightMM;
         colorSub    => <-.Params.vps_options.colorSub;
         depthSort   => <-.Params.vps_options.depthSort;
         colorTol    => <-.Params.vps_options.colorTol;
      };
   // VRML
      MAdefaultVrmlOutput vrmlOutput {
         //file        => <-.Params.filename;
         protocol    => <-.Params.vrml_options.protocol;
         indent      => <-.Params.vrml_options.indent; 
         floatPrec   => <-.Params.vrml_options.floatPrec;
         colorPrec   => <-.Params.vrml_options.colorPrec; 
         xformPrec   => <-.Params.vrml_options.xformPrec;
         width       => <-.renderView.width;
         height      => <-.renderView.height;
      };
      // this needs to force the view to VPS/VRML
      // since the GD sometimes defaults to SW !
      // Cannot use #defines in parse v in a runtime
      //7:GD_VPS_RENDERER;
      //6:GD_VRML_RENDERER;
      GMOD.parse_v doSetRenderer {
         trigger  => <-.Params.ok;
         active   => <-.Params.ok;
         on_inst = 0;
         relative => <-.<-;
         v_commands-notify+nonotify =>
                    "$push\n"
                   +"Scheduler.percent_done=10;"
                   +"$pop\n"
                   +"$push\n"
                   +switch(Params.out_type,
                    "$push\n"
                   +"imageView.renderer = 0;"
                   +"imageView.refresh = 1;"
                   +"filename_to_type.filename=imageOutput.file;"
                   +"$pop\n"
                   +"$push\n"
                   +"Scheduler.percent_done=50;"
                   +"imageWriter.filename=filename_to_type.ok_filename;"
                   +"$pop\n"
                   ,
                    "$push\n"
                   +"vpsView.renderer=7;"
                   +"vpsView.handle=><-.renderView.handle;"
                   +"vpsView.virtpal=><-.VirtPal;"
                   +"vpsView.back_col=><-.view_in.back_col;"
                   +"vpsView.light_info=><-.view_in.light_info;"
                   +"vpsView.cameras=><-.view_in.cameras;"
                   //+"vpsView.aspect=><-.view_in.aspect;"
                   +"Scheduler.percent_done=50;"
                   +"vpsOutput.file=<-.Params.filename;"
                   +"Scheduler.percent_done=60;"
                   +"$pop\n"
                   +"$push\n"
                   +"vpsView.refresh=1;"
                   +"$pop\n"
                   +"$push\n"
                   +"vpsView.handle=>;"
                   +"vpsView.virtpal=>;"
                   +"vpsView.back_col=>;"
                   +"vpsView.light_info=>;"
                   +"vpsView.cameras=>;"
                   //+"vpsView.aspect=>;"
                   +"Scheduler.percent_done=70;"
                   +"$pop\n"
                   ,
                    "$push\n"
                   +"vrmlView.renderer=6;"
                   +"vrmlView.handle=><-.renderView.handle;"
                   +"vrmlView.virtpal=><-.VirtPal;"
                   +"vrmlView.back_col=><-.view_in.back_col;"
                   +"vrmlView.light_info=><-.view_in.light_info;"
                   +"vrmlView.cameras=><-.view_in.cameras;"
                   +"vrmlView.aspect=><-.view_in.aspect;"
                   +"Scheduler.percent_done=50;"
                   +"vrmlOutput.file=<-.Params.filename;"
                   +"Scheduler.percent_done=60;"
                   +"$pop\n"
                   +"$push\n"
                   +"vrmlView.refresh=1;"
                   +"$pop\n"
                   +"$push\n"
                   +"vrmlView.handle=>;"
                   +"vrmlView.virtpal=>;"
                   +"vrmlView.back_col=>;"
                   +"vrmlView.light_info=>;"
                   +"vrmlView.cameras=>;"
                   +"vrmlView.aspect=>;"
                   +"Scheduler.percent_done=70;"
                   +"$pop\n"
                   )
                   +"$pop\n"
                   +"$push\n"
                   +"Params.ok=0;"
                   +"Scheduler.percent_done=100;"
                   +"$pop\n";
      };
      MAdefaultView imageView {
         mode           =  0;
         renderer       =  0;
         handle         => <-.renderView.handle;
         virtpal        => <-.VirtPal;
         back_col       => <-.view_in.back_col;
         light_info     => <-.view_in.light_info;
         cameras        => <-.view_in.cameras;
         aspect         => <-.view_in.aspect;
         output         => <-.imageOutput;
         output_enabled = 1;
      };
      MAdefaultView vpsView {
         mode           =  0;
         renderer       =  7;
         output         => <-.vpsOutput;
         output_enabled =  0; // doesn't generate color or z buffers
      };
      MAdefaultView vrmlView {
         mode           =  0;
         renderer       =  6;
         output         => <-.vrmlOutput;
         output_enabled =  0; // doesn't generate color or z buffers
      };
   };
//////////////////////////////////////////////////////////////////////////
#else // Unix
   macro MAwriteAnyData {
      //
      // Write Any Data
      //	1) Image
      //	2) Vector PostScript
      //	3) VRML
      //
      MAGDview_templ &view_in<NEportLevels={2,1}>;
      UIrenderView &render_view_in => view_in.render_view;
      MAdataObj+nres &dataObj => <-.dataObj;
      int+nres camtype => view_in.cameras[0].type == 0;
      string Suffix[] =>switch(camtype+1,dataObj.write_file_suffix,
         concat_array(dataObj.write_file_suffix, { "PS", "WRL" }));
      string Comment[] =>switch(camtype+1,dataObj.write_comment, 
         concat_array(dataObj.write_comment,
            { "Vector PostScript", "Virtual Reality Modeling Language" }));
   
      int deno =>UI.FileType.selectedItem/array_size(dataObj.write_file_suffix);
      int subs =>UI.FileType.selectedItem-array_size(dataObj.write_file_suffix)+1;
      link out_type => deno * subs + 1; //1:image, 2:VPS, 3:VRML

      MAUImod_panel WriteDialog {
         title = "MAMWRITE_DATA_TITLE";
         height => switch(out_type, 250, 450, 300);
      };
      macro UI {
         ilink parent => <-.WriteDialog;
         MAdataObj+nres &dataObj => <-.dataObj;
         ilink filename => switch(out_type,
                                  imageOutput.file,
                                  vpsOutput.file,
                                  vrmlOutput.file);
         olink ok => OKbutton.do;
         MAUIbutton OKbutton {
            parent => <-.parent;
            label = "MAUI_OUTPUT";
            x = 10;
            y = 10;
            active => is_valid(render_view_in);
            do = 0; //init. zero
         };

         MAUIOptionMenuLabel FileType {
            label        =  "MAUI_FILETYPE";
            parent       => <-.parent;
            options      => "    " + Suffix;
            x = 0;
            y => <-.OKbutton.y + <-.OKbutton.height + 15;
            width = 300;
            height = 32;
            selectedItem = 0;
            color.foregroundColor = MAVS_BLUE;
            color.foregroundColor = MAVS_BLUE;
         };
         GMOD.copy_on_change set_suggestion {
            input => "MicroAVS."+ Suffix[FileType.selectedItem];
            output => <-.filename;
            on_inst = 1; //
         };
         MAUIFileSelector File {
            title 
               => switch(is_valid(Comment[FileType.selectedItem])+1,
                         "",
                         Comment[FileType.selectedItem]
                  );
            parent              => <-.parent;
            x                   =  4;
            y                   => FileType.y + FileType.height;
            width               => <-.parent.width - 15;
            filetype            => Suffix[FileType.selectedItem];
            file                => <-.filename;
            Text.updateMode = 7;
            fileFB.confirmFileWrite = 1;
            fileFB.current_directory => MAVS_WRITE_DATA_PATH;
            Title.color.foregroundColor = MAVS_GREEN;
            Title.color.backgroundColor = "black";
         };
         GMOD.instancer imageUIinstancer {
            Group => <-.imageUI;
            Value => out_type == 1;
         };
         macro imageUI<instanced=0> {
            ilink File => <-.File;
            ilink parent => <-.parent;
         };
         GMOD.instancer vpsUIinstancer {
            Group => <-.vpsUI;
            Value => out_type == 2;
         };
         macro vpsUI<instanced=0> {
            ilink File => <-.File;
            ilink parent => <-.parent;
            MAUIOptionMenuLabel vpsColor {
               label        =  "MAMW_VPS_COL_MODE";
               parent       => <-.parent;
               x            => <-.File.x;
               y+nres       => <-.File.y + <-.File.height + 8;
               width        => <-.File.width;
               options      => { "Color", "Greyscale" };
               selectedItem => <-.<-.<-.vpsOutput.format;
            };
            MAUIOptionMenuLabel vpsBgmode {
               label        =  "MAMW_VPS_BACK_MODE";
               parent       => <-.parent;
               x            => <-.vpsColor.x;
               y+nres       => <-.vpsColor.y + <-.vpsColor.height;
               width        => <-.vpsColor.width;
               options      => { "White", "Black", "Keep" };
               selectedItem => <-.<-.<-.vpsOutput.backMode;
            };
            MAUIOptionMenuLabel vpsOrient {
               label        =  "MAMW_VPS_ORIENT";
               parent       => <-.parent;
               x            => <-.vpsBgmode.x;
               y+nres       => <-.vpsBgmode.y + <-.vpsBgmode.height;
               width        => <-.vpsBgmode.width;
               options      => { "Landscape", "Portrait" };
               selectedItem => <-.<-.<-.vpsOutput.orientation;
            };
            MAUIOptionMenuLabel vpsSize {
               label        =  "MAMW_VPS_SIZE";
               parent       => <-.parent;
               x            => <-.vpsOrient.x;
               y+nres       => <-.vpsOrient.y + <-.vpsOrient.height;
               width        => <-.vpsOrient.width;
               options      => { "EPS (user)", "A (letter)", "B", "A4", "A3" };
               selectedItem => <-.<-.<-.vpsOutput.size;
            };
      
            GMOD.copy_on_change set_active {
               input => (<-.vpsSize.selectedItem == 0);
               output => <-.active;
            };
            boolean active = 0;
            MAUIField vpsWidthMM {
               label        => "MAUI_WIDTH" + "(mm) ";
               parent       => <-.parent;
               y+nres       => <-.vpsSize.y + <-.vpsSize.height + 2;
               x            => <-.vpsSize.x;
               width        => <-.vpsSize.width;
               min          =  1;
               mode         =  2; 
               value        => <-.<-.<-.vpsOutput.widthMM;
               active       => <-.active;
            };
            MAUIField vpsHeightMM {
               label        => "MAUI_HEIGHT" + "(mm) ";
               parent       => <-.parent;
               x            => <-.vpsWidthMM.x;
               y+nres       => <-.vpsWidthMM.y + <-.vpsWidthMM.height + 4;
               width        => <-.vpsWidthMM.width;
               min          =  1;
               mode         =  2; 
               value        => <-.<-.<-.vpsOutput.heightMM;
               active       => <-.active;
            };
         }; // vpsUI
         GMOD.instancer vrmlUIinstancer {
            Group => <-.vrmlUI;
            Value => out_type == 3;
         };
         macro vrmlUI<instanced=0> {
            ilink File => <-.File;
            ilink parent => <-.parent;
            MAUIOptionMenuLabel vrmlVersion {
               label        =  "MAMW_VRML_VERSION";
               parent       => <-.parent;
               x            => <-.File.x;
               y+nres       => <-.File.y + <-.File.height + 10;
               width        => <-.File.width;
               options      => { "     VRML 1.0", "     VRML 2.0" };
               selectedItem => <-.<-.<-.vrmlOutput.protocol;
            };
            MicroAVS.MAUIOptionMenuLabel vrmlIndent {
               label        =  "MAMW_VRML_INDENT";
               parent       => <-.parent;
               x            => <-.vrmlVersion.x;
               y+nres       => <-.vrmlVersion.y + <-.vrmlVersion.height;
               width        => <-.vrmlVersion.width;
               options      => { "     "+"MAUI_OFF", "     "+"MAUI_ON" };
               selectedItem => <-.<-.<-.vrmlOutput.indent;
            };
         };
      };
      UIrenderView renderView {
         parent+nres => <-.render_view_in.parent;
         x = 0;
         y = 0;
         width   => switch(is_valid(<-.render_view_in.width)+1,
                           200, <-.render_view_in.width);
         height  => switch(is_valid(<-.render_view_in.height)+1, 
                           200, <-.render_view_in.height);
         visible = 0;
      };
      BestVirtPal VirtPal {
         vclass    => view_in.virtpal.vclass;
         vid       => view_in.virtpal.vid;
         share     = 0;
         cube_size => view_in.virtpal.cube_size;
         gamma     = 1.0;
      };
   // for image
      MAfilename_to_type filename_to_type {
         filename => <-.imageOutput.file;
         modules => dataObj.write_module;
         executables => dataObj.write_executable;
         file_suffixes => dataObj.write_file_suffix;
         data_types => dataObj.write_data_type;
         comments => dataObj.write_comment;
         helps => dataObj.write_help;
      };
      MAimage_writer imageWriter {
         in => <-.imageOutput.output;
         module => <-.filename_to_type.module;
         executable => <-.filename_to_type.executable;
         data_type => <-.filename_to_type.data_type;
      };
      MAdefaultFieldOutput imageOutput {
         string file =;
      };
   // VPS
      MAdefaultVpsOutput vpsOutput {
         file        <NEportLevels={0,2}> = "MicroAVS.ps";
         format      <NEportLevels={0,2}>;
         orientation <NEportLevels={0,2}>;
         backMode    <NEportLevels={0,2}>;
         size        <NEportLevels={0,2}> = "A4";
         widthMM     <NEportLevels={0,2}>; 
         heightMM    <NEportLevels={0,2}>; 
      };
   // VRML
      MAdefaultVrmlOutput vrmlOutput {
         file      <NEportLevels={0,2}> = "MicroAVS.wrl";
         protocol  <NEportLevels={0,2}>;
         floatPrec <NEportLevels={0,2}> = 8; // MicroAVS 3.0
         colorPrec <NEportLevels={0,2}> = 3; // MicroAVS 3.0
         indent    <NEportLevels={0,2}>;
         xformPrec => floatPrec;
         width     => <-.renderView.width;
         height    => <-.renderView.height;
      };
      // this needs to force the view to VPS/VRML
      // since the GD sometimes defaults to SW !
      // Cannot use #defines in parse v in a runtime
      //7:GD_VPS_RENDERER;
      //6:GD_VRML_RENDERER;
      GMOD.parse_v doSetRenderer {
         trigger  => <-.UI.ok;
         active   => <-.UI.ok;
         on_inst = 0;
         relative => <-.<-;
         v_commands-notify+nonotify =>
                    "$push\n"
                   +"Scheduler.percent_done=10;"
                   +"$pop\n"
                   +"$push\n"
                   +switch(out_type,
                    "$push\n"
                   +"imageView.renderer = 0;"
                   +"imageView.refresh = 1;"
                   +"filename_to_type.filename=imageOutput.file;"
                   +"$pop\n"
                   +"$push\n"
                   +"Scheduler.percent_done=50;"
                   +"imageWriter.filename=filename_to_type.ok_filename;"
                   +"$pop\n"
                   ,
                    "$push\n"
                   +"vpsView.renderer=7;"
                   +"vpsView.handle=><-.renderView.handle;"
                   +"vpsView.virtpal=><-.VirtPal;"
                   +"vpsView.back_col=><-.view_in.back_col;"
                   +"vpsView.light_info=><-.view_in.light_info;"
                   +"vpsView.cameras=><-.view_in.cameras;"
                   //+"vpsView.aspect=><-.view_in.aspect;"
                   +"Scheduler.percent_done=50;"
                   +"$pop\n"
                   +"$push\n"
                   +"vpsView.refresh=1;"
                   +"$pop\n"
                   +"$push\n"
                   +"vpsView.handle=>;"
                   +"vpsView.virtpal=>;"
                   +"vpsView.back_col=>;"
                   +"vpsView.light_info=>;"
                   +"vpsView.cameras=>;"
                   //+"vpsView.aspect=>;"
                   +"Scheduler.percent_done=70;"
                   +"$pop\n"
                   ,
                    "$push\n"
                   +"vrmlView.renderer=6;"
                   +"vrmlView.handle=><-.renderView.handle;"
                   +"vrmlView.virtpal=><-.VirtPal;"
                   +"vrmlView.back_col=><-.view_in.back_col;"
                   +"vrmlView.light_info=><-.view_in.light_info;"
                   +"vrmlView.cameras=><-.view_in.cameras;"
                   +"vrmlView.aspect=><-.view_in.aspect;"
                   +"Scheduler.percent_done=50;"
                   +"$pop\n"
                   +"$push\n"
                   +"vrmlView.refresh=1;"
                   +"$pop\n"
                   +"$push\n"
                   +"vrmlView.handle=>;"
                   +"vrmlView.virtpal=>;"
                   +"vrmlView.back_col=>;"
                   +"vrmlView.light_info=>;"
                   +"vrmlView.cameras=>;"
                   +"vrmlView.aspect=>;"
                   +"Scheduler.percent_done=70;"
                   +"$pop\n"
                   )
                   +"$pop\n"
                   +"$push\n"
                   +"UI.OKbutton.do=0;"
                   +"Scheduler.percent_done=100;"
                   +"$pop\n";
      };
      MAdefaultView imageView {
         mode           =  0;
         renderer       =  0;
         handle         => <-.renderView.handle;
         virtpal        => <-.VirtPal;
         back_col       => <-.view_in.back_col;
         light_info     => <-.view_in.light_info;
         cameras        => <-.view_in.cameras;
         aspect         => <-.view_in.aspect;
         output         => <-.imageOutput;
         output_enabled = 1;
      };
      MAdefaultView vpsView {
         mode           =  0;
         renderer       =  7;
         output         => <-.vpsOutput;
         output_enabled =  0; // doesn't generate color or z buffers
      };
      MAdefaultView vrmlView {
         mode           =  0;
         renderer       =  6;
         output         => <-.vrmlOutput;
         output_enabled =  0; // doesn't generate color or z buffers
      };
   };
#endif //MSDOS
}; 
