/*
                        Copyright (c) 1994 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/v/UI.v#1 $
*/

/*----------------------------------------------------------------------------
   This V file contains the components of the User Interface Kit.
  ---------------------------------------------------------------------------*/

flibrary+global UI <
   locked=1,
#ifdef MSDOS
   build_dir="nt_ui",
#else
   build_dir="motif_ui",
   // These need to be defined at this level since there are code
   // dependencies on these files from the rest of the libraries
   // on the UIlayout classes in this file
   cxx_hdr_files="ui/layout.h",
#endif
   build_cmd="$(MAKE)",
   dictionary="ui.dct",
   need_cxx=1,
   //
   // UI_GLOBAL defines global UI information
   // WT_OBJS defines global window system tookit info
   // like fonts.  Both of these are needed by any project
   // that uses the UI kit
   //
   need_objs="UI_GLOBAL WT_OBJS",
   // the motif_ui library uses these classes in the code so we must mark them
   libdeps="UI.Cursor_Types PAL",
   out_src_file="ui_gen.cxx",
   out_hdr_file="ui_gen.h",
   hdr_code="int UIinit (int *, char **);",
   init_code="   UIinit(argc,argv);",
   link_files="-lui -lcxxut $(WINLIBS)"
> {

/* An object that is used by the package internally. Its purpose
 * is to provide indirect linkage to the UIedit package.
 */
group UIeditSwitch<NEvisible=0> {
    Boolean     isActive;
    group *     layoutWin;
    int         contextId;
};

#ifdef MSDOS
group UIlayoutEditState<NEvisible=0> {
    int         isActive = 0;
    int         snapToGrid = 1;
    int         group;
    int         ungroup;
    int         saveCurrentShellValues = 1;

    string      edit_obj_path = "NetworkEditor.ObjectEditor.editControl.edit_obj_path";
    string      disp_obj_path = "NetworkEditor.ObjectEditor.editControl.disp_obj_path";

    method+notify_inst init<NEvisible=0,lang="cxx",interruptable=0> =
        "UIlayout_edit_update";
    method+notify_val update<NEvisible=0,lang="cxx",interruptable=0> =
        "UIlayout_edit_update";
};
#else
group UIlayoutEditState<cxx_class="UIlayout", use_src_file=0> {
    int+notify     isActive = 0;
    int+notify     snapToGrid = 1;
    int+notify     group;
    int+notify     ungroup;
    int+notify     xGridSize = 4;
    int+notify     yGridSize = 4;
    int            saveCurrentShellValues = 1;

    string         edit_obj_path = "NetworkEditor.ObjectEditor.editControl.edit_obj_path";
    string         disp_obj_path = "NetworkEditor.ObjectEditor.editControl.disp_obj_path";

    cxxmethod+notify_inst init;
    cxxmethod+notify_inst update;
};
#endif

#ifdef MSDOS

group UIcolor {
    string foregroundColor;
    string backgroundColor;
};

group UIlayoutControl {
    int edit = 1; /* Set to zero (0) to override global widget edit state */
};

/*
 * If we set export_cxx=1 on UIpixmap directly, we can get C++ classes
 * generated for derived copies of UIpixmap
 */
library UI_Export<export_cxx=1> {
   group UIpixmap {
       string+Port         filename;       /* File containing the pixmap data */
       string              fileType;       /* X_BITMAP for .xbm files
                                              AVS_BITMAP for .x files */
   };
};

group UItoolTip {
    string  message;	/* Message to display in popup window */
    int     delayTime;	/* Set to delay time (mSec) to wait before popping up window */
    enum placement {
       choices = {"north", "south", "east", "west"};
    };			/* message position relative to pixmap */
    enum enable {
       choices = {"automatic", "always", "never"};
                 /* Default is automatically show tooltips when label pixmap is used */
    };
};

group UIfontAttributes {
    string  family;
    int     height;
    enum    weight {
       choices = {"medium", "bold" };
    };
    enum    slant {
       choices = {"regular", "oblique"};
    };
    enum    set_width {
       choices = {"normal", "narrow", "semicondensed" };
    };
    string  fontString<NEvisible=0>;
};

#else // not MSDOS

flibrary+global+sort Core<export_cxx=1,out_hdr_file="ui/ui_core.h",
out_src_file="ui_core.cxx">
{

group UIcolor{
    string foregroundColor;
    string backgroundColor;
};

group UIlayoutControl {
    int edit = 1; /* Set to zero (0) to override global widget edit state */
};

group UIpixmap {
    string+Port        filename;       /* File containing the pixmap data */
    string             fileType;       /* X_BITMAP for .xbm files
                                           AVS_BITMAP for .x files */
};

group UIfontAttributes {
    string  family;
    int     height;
    enum    weight {
       choices = {"medium", "bold" };
    };
    enum    slant {
       choices = {"regular", "oblique"};
    };
    enum    set_width {
       choices = {"normal", "narrow", "semicondensed" };
    };
    string  fontString<NEvisible=0>;
};

group UItoolTip {
    string  message;	/* Message to display in popup window */
    int     delayTime;	/* Set to delay time (mSec) to wait before popping up window */
    enum placement {
        choices = {"north", "south", "east", "west"};
    };			/* message position relative to pixmap */
    enum	enable {
        choices = {"automatic", "always", "never"};
                   /* Default is automatically show tooltips when label pixmap is used */
    };
};
};

#endif // not MSDOS

// define cxx_name property to deal with conflict between UI class
group UIwinHandle<cxx_name="UI_UIwinHandle"> {
#ifdef MSDOS
    int                 window; /* native window ID */
    int                 widget; /* native widget ID (
                                   may = window on some systems) */
#else
    int                 window; /* native window ID */
    ptr                 widget; /* native widget ID (
                                   may = window on some systems) */
#endif
    int                 event;  /* window/widget change = 1, 
                                   geometry change = 2, 
                                   expose change = 3 */
#ifdef MSDOS
    int+nonotify        hdc;    /* Need the hdc on an expose event */
#endif
};

group UIevents {
    int      buttonPress;
    ptr      buttonPressData;
    int      buttonRelease;
    ptr      buttonReleaseData;
};

group UIconnection<NEcolor0=0x00ff00> {
    int+read            canHaveChildren<NEvisible=0>;
    int+read            shellParent<NEvisible=0>;
};

group UIcore<cxx_name="UI_UIcore",export_all=1> {
    Boolean+read+IPort2 visible=1;
    Boolean+read        &active;
    UIpixmap+read       pixmap<export_all=2>;
    UIcolor+read        color<export_all=2>;
    UIfontAttributes    fontAttributes<export_all=2>;
    string              fontList<NEvisible=0>;
    ptr+nonotify        cxxhandle<NEvisible=0>=0;
    UIwinHandle+nosave+nonotify   handle<NEvisible=0>;
    string              motif_resources<NEvisible=0>[];
    string              window_resources<NEvisible=0>[];
    UIlayoutControl     layout<NEvisible=0>;
};


library+global+sort Commands<cxx_name="UI"> {

UIcore+OPort UImenuItem<NEcolor0=0x00ffff,export_all=1> {
    string+opt          label => name_of(<-,1);
    fontAttributes<NEvisible=0>;
    pixmap<NEvisible=0>;
    color<NEvisible=0>;
};

UImenuItem UIcmd<NEcolor0=0x00ffff> {
    string               message;
    string               accelerator;
    string               acceleratorText;
    int+opt+OPort2       do=0;
    Boolean              active;

#ifdef MSDOS
    int+nosave+nonotify  id<NEvisible=0>;
#else
    ptr+nosave+nonotify  window<NEvisible=0>;
#endif

    method+opt+notify_deinst delete<NEvisible=0,lang="cxx",interruptable=0> =
        "UIcmdDelete";
    method+opt+notify_val    update<NEvisible=0,lang="cxx",interruptable=0> =
        "UIcmdUpdate";
};

UIcmd UIoption {
    /* This is required to differentiate UIoption from UIcmd */
    Boolean             isUIoption;
    Boolean+opt+OPort2  set=0;

    method+opt+notify_val   update<NEvisible=0,lang="cxx",interruptable=0> =
        "UIoptionUpdate";
};

UImenuItem UImenuSeparator;

group+OPort UIcmdList<NEcolor0=0x00ffff,is_val_func=1,export_all=1> {
    string              label;
    Boolean+opt         radioBehavior;
    Boolean+opt         tearOff<NEvisible=0>;
    int+opt             dims => array_size(cmdList);
    Boolean+opt         isHelpCmd;
    string+opt          accelerator;
    string+opt          acceleratorText;

    group+IPort2        &cmdList<NEcolor0=0x00ffff>[] {
        string              label;
        Boolean+opt         radioBehavior;
        Boolean+opt         tearOff<NEvisible=0>;
        int+opt             dims;
        Boolean+opt         isHelpCmd;
        string+opt          accelerator;
        string+opt          acceleratorText;

        group+opt           &cmdList[] {
            string              label;
            Boolean+opt         radioBehavior;
            Boolean+opt         tearOff<NEvisible=0>;
            int+opt             dims;
            Boolean+opt         isHelpCmd;
            string+opt          accelerator;
            string+opt          acceleratorText;

            group+opt           &cmdList[] {
                string              label;
                Boolean+opt         radioBehavior;
                Boolean+opt         tearOff<NEvisible=0>;
                int+opt             dims;
                Boolean+opt         isHelpCmd;
                string+opt          accelerator;
                string+opt          acceleratorText;
                group+opt           &cmdList[];
            };
        };
    };
};

UIcmdList UIhelpCmdList<NEcolor0=0x00ffff> {
    Boolean                 isHelpCmd=1;
};

UIcmdList UIoptionList {
    int                 &max;
    int                 numSelectedItems => array_size(selectedItems);
    int+Port            selectedItems[];
    // This is now overridden as just a list of options (not cmds or cmdlists)
    UIoption+IPort2     &cmdList[] {
        set+nonotify;
    };
};

UIcmdList UIradioList {
    radioBehavior = 1; /* This is a radio box style menu */
    int+OPort2          &selectedItem;
    UIoption+OPort2     *selectedCmd;
    // This is now overridden as just a list of options (not cmds or cmdlists)
    UIoption+IPort2     &cmdList[] {
        set+nonotify;
    };

    method_val update<NEvisible=0,lang="cxx",interruptable=0> =
        "UIradioListUpdate";
};

}; /* end of Commands */

library+global+sort Base_Types /*<cxx_name="UI">*/ {
/* Place all non-instantiable templates for the UI kit in this library */

group UIgeom<cxx_name="UI_UIgeom"> {
    int+read+nres       x, y;
    int+read+nres      width, height;
};

group UIdecorGeom {
    int+write   clientWidth, clientHeight;
};

group UIvirtualGeom {
    int+read    virtualWidth, virtualHeight;
};


flibrary+global+sort Cursor_Types<
#ifdef MSDOS
    cxx_hdr_files="ui_gen.h ui/UIcursoP.h", 
    cxx_src_files="UIcursoP.cxx",
    src_file="UIcursor.cxx"
#else
    out_src_file="cursor.cxx",
    out_hdr_file="ui/cursor.h", 
    cxx_hdr_files="ui/core.h ui/UIcursorP.h"
#endif
    >
{

/* 
 * Define a UIcursor template so that we don't have to create the
 * UIcursor subobject for each widget
 */
module UIcursorT<NEvisible=0,NEnumColors=2,NEcolor0=0xffff00,NEcolor1=0x008800> {
    Boolean     attach_cursor = 1;
    UIcolor     color;
};

module+OPort UIcursor<cxx_class="UIcursorP",use_src_file=0,
                      NEnumColors=2,NEcolor0=0xffff00,NEcolor1=0x008800> {

    Boolean             attach_cursor = 1;  /* Set to 0 to unset cursor */
    UIcolor             color;  /* Option colors for background and foreground*/

    cxxmethod+notify_inst+req   init<NEvisible=0>;
    cxxmethod+req       update<NEvisible=0>(attach_cursor+notify,
                                            color.foregroundColor+notify,
                                            color.backgroundColor+notify);
};

UIcursor UIfontCursor<cxx_class="UIfontCursorP", use_src_file=0> {

    string              cursor_name;	/* Name of cursor in standard cursor font */
                        		/* see motif_ui/ui/cursornames.h */
    int                 font_index;	/* Index of cursor shape in font table */

    cxxmethod+notify_inst+req    init<NEvisible=0>;
    cxxmethod+req       update<NEvisible=0>(attach_cursor+notify,
                                            color.foregroundColor+notify,
                                            color.backgroundColor+notify,
                                            cursor_name+notify,
                                            font_index+notify);
};

UIcursor UIpixmapCursor<cxx_class="UIpixmapCursorP", use_src_file=0> {

    UIpixmap    cursor_pixmap{ /* Only x_bitmaps supported currently */
        fileType = "x_bitmap";
    };
    UIpixmap    mask_pixmap{   /* Only x_bitmaps supported currently */
        fileType = "x_bitmap";
    };
    int+nonotify        x, y;  /* Cursor hot spot position in bitmap */
    int+nonotify        width, height; /* Size of cursor bitmap */

    cxxmethod+notify_inst+req  init<NEvisible=0>;
    cxxmethod+req       update<NEvisible=0>(attach_cursor+notify,
                                            color.foregroundColor+notify,
                                            color.backgroundColor+notify,
                                            cursor_pixmap+notify,
                                            mask_pixmap+notify);
};

};  // end of Cursor_Types


/* UIwindow is the base template element for all window objects in the
 * UI Kit. 
 * A UIwindow is not instantiable.
 */
UIcore+UIconnection UIwindow<lang="cxx",cxx_name="UI_UIwindow"> {
    canHaveChildren = 0;

    UIevents    events<NEvisible=0>;
    Boolean     groupToParent<val_state=4>;

    shellParent = 0;
    /* This must be set to an element derived from UIwindow. Setting it to
     * something else will be the same as unsetting it. Most UIwindows
     * require a parent and will not show up as windows unless this value
     * is set.
     */
    UIconnection+IPort2 * parent {
        canHaveChildren = 1;
    };
    UIcursorT &cursor<NEvisible=1>;

    method+notify_deinst delete<NEvisible=0,lang="cxx",interruptable=0>() =
        "UIwindDestroy";
};

/* Base for all containers */
UIgeom+UIwindow UIcontainer {
    canHaveChildren = 1;
    string message;
};

/* Base for Containers with Decorations */
UIgeom+UIdecorGeom+UIwindow UIdecorContainer {
    canHaveChildren = 1;
    string message;
};

/* Base for Container with Scrollable area */
UIgeom+UIdecorGeom+UIvirtualGeom+UIwindow UIvirtualContainer {
    canHaveChildren = 1;
    string message;
};


/* UIdialog is the base template element for all dialog objects in the
 * UI Kit. 
 *
 * - A UIdialog is not instantiable.
 * - A UIdialog does not require a parent but it is best to assign one.
 * - UIdialogs will always be stacked on top of their parent. This means
 *   the parent can never obscure its child UIdialogs.
 * - A UIdialog cannot be iconified.
 * - If a UIdialog is modal, windows in the interface of the parent window
 *   will not accept input untill the dialog is popped down.
 * - A UIdialog can be popped down by selecting the OK or the Cancel button,
 *   unless autoUnmanage is set to 0.
 * - Take care; a modal UIdialog without a parent will stop input from getting 
 *   to ANY interface in the same process. 
 */
UIdecorContainer UIdialog<cxx_name="UI_UIdialog"> {

    string+IPort2       title => name_of(<-,1); /* Appears on the window title */
    int+IPort           isModal;		/* 1 -> the dialog is modal */
    Boolean             autoUnmanage = 1;	/* Dflt == True */
    Boolean             destroyOnUmanage = 0; /*Default*/
    int+IPort           ok;		/* OK button has been pressed */
    int                 cancel;		/* Cancel button has been pressed */
                        		/* or window has been closed by WM */

    /* If okButton or cancelButton are not set or have a value of 1 (1)
     * the buttons will be visible.
     */
    Boolean             okButton;
    string              okLabelString;

    /* Effect the text displayed on the OK and Cancel buttons of the dialog.
     */
    Boolean             cancelButton;
    string              cancelLabelString;
    string              display;	/* Can set to another X display name */

    visible = 0;
};

/* Base type for all primitives(widgets) */
UIgeom+UIwindow UIprimitive {
    x =  0;
    string message;
};

/* UIvaluator is the base template element for all valuator objects in the
 * UI Kit. 
 *
 * - A valuator provides an interface to a numerical value. The value may be
 *   integer or real.
 * - It is possible to restrict the values produced by a valuator. Values
 *   can be restricted to be > a value, >= another value, < a value, <=
 *   a value, or unbounded.
 * - The precision produced by a valuator is determined by the number of
 *   of decimal places that are requested by setting the decimalPoints
 *   attribute.
 */
UIprimitive UIvaluator {
    float               &min;   /* min value. If not set -> unbounded */
    float               &max;   /* max value. If not set -> unbounded */
    float+Port2         &value;  /* the current value of the valuator */
    enum                mode {choices = { "real", "integer", "real" };};
                                        /* integer rounds input to integer values */
    int                 &decimalPoints; /* Precision */

    /* Some valuators can produce values contiuously as the mouse is 
     * moved. Set immedateMode to 1 if continuous feedback is required.
     * The default is 0 which causes on the last value. produced when
     * the mouse button is released. to effect a change in value.
     */
    Boolean             &immediateMode;

    /* To exclude an end point in the valuator range, set one or both
     * of these values to 0. The default is 1, include endpoints.
     */
    Boolean             &includeMin<NEvisible = 0> = 1;
    Boolean             &includeMax<NEvisible = 0> = 1;
};

group UIinteractor<lang="cxx"> {
    group+IPort2        &view<NEcolor0=0x00ff00> {
        group handle {
#ifdef MSDOS
            int+read widget;
#else
            ptr+read widget;
#endif
        };
    };
    int         x<val_state=4>;
    int         y<val_state=4>;
    int         time<val_state=4>;
    ptr         local_ptr;

    omethod+notify_deinst delete<NEvisible=0,lang="cxx",interruptable=0> =
        "UIinteractDestroy";
};

}; /* End of base types library */

library+global+sort Shells<cxx_name="UI"> {
/* UIshell is a window that is managed by the window manager.
 *
 * - UIshells do not require a parent.
 * - A UIshell will be displayed on the default screan of the machine where 
 *   its creating process resides. With X Windows the default screen can
 *   be effected by setting the DISPLAY environment variable.
 * - Another display can be selected by setting the displayName attribute.
 */

UIdecorContainer+OPort UIshell<NEvisible=1> {
    x           = ;
    y           = ;
    width       = 300;
    height      = 300;

    string      title => name_of(<-,1);
    string      iconName;
    Boolean     &iconic = 0;
    UIcmdList+IPort2    &menu;
    string      display; /* Can be set to another X display name */

    parent {
       shellParent = 1;  // the parent object must be a shell
    };

    int    cancel; // Set to 1 by the application if the window
                   // is closed via the window manager.

    /* Set the "showStatusBar" to 1 to enable status strings to appear */
    /* Set the "showStatusBar" to 0 to disable all status strings */
    Boolean     showStatusBar = 1;
    string      statusString;

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIshellUpdate";
};

UIshell UIapp {
    Boolean     &tidyWhenIconified = 1;

    shellParent = 1;
    parent<NEportLevels=0> {
        shellParent = -1;  // do not allow any parent connection
    };

    int do;

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIappUpdate";
};

}; /* end of Shells */

library+global+sort StandardDialogs<cxx_name="UI"> {

/* UImessageBox is a dialog that permits messages to be posted. The
 * value of ok (from UIdialog) can be used to determine if a user
 * has accepted the situation described by the posted message.
 *
 * Only one child may be added to this dialog.
 */
UIdialog UImessageBox {
    /* Type determines the bitmap that will show up alongside 
     * the message.
     */
    enum                type {
        choices = {"error", "information", "message", "question", "warning",
                   "working" };
    };
    string+IPort2       message;

    method_inst inst<NEvisible=0,lang="cxx",interruptable=0>= "UImessageBoxInstance";
    method_val update<NEvisible=0,lang="cxx",interruptable=0>= "UImessageBoxUpdate";
#ifdef MSDOS
   method_del delete<NEvisible=0,lang="cxx",interruptable=0> = "UImessageBoxDestroy";
#endif
};

UImessageBox UIerrorDialog {
    type<NEvisible=0> = 0;
};

UImessageBox UIinfoDialog  {
    type<NEvisible=0> = 1;
};

UImessageBox UImessageDialog{
    type<NEvisible=0> = 2;
};

UImessageBox UIquestionDialog{
    type<NEvisible=0> = 3;
};

UImessageBox UIwarningDialog{
    type<NEvisible=0> = 4;
};

UImessageBox UIworkingDialog{
    type<NEvisible=0> = 5;
};

UIdialog+OPort UItemplateDialog {
    width       = 200;
    height      = 200;

    method_inst inst<NEvisible=0,lang="cxx",interruptable=0>= "UItemplateDialogInstance";
    method_val update<NEvisible=0,lang="cxx",interruptable=0>= "UItemplateDialogUpdate";
};

/* UIpromptBox is a dialog that permits a prompt to be issued to the user. 
 * The value of ok (from UIdialog) can be used to determine if a user
 * has accepted the current value in the text attribute.
 *
 * Only one child may be added to this dialog.
 */
UIdialog UIpromptBox {
    int                 applyButton;
    string              applyLabelString;
    string+IPort2       prompt; /* Prompt string issued to the user */
    string+OPort2       text;   /* The value entered in the text window */

    /* The apply button works like the Ok button except that it doesn't
     * cause the dialog to pop down after it is pressed.
     */
    method_inst inst<NEvisible=0,lang="cxx",interruptable=0>= "UIpromptBoxInstance";
    method_val update<NEvisible=0,lang="cxx",interruptable=0>= "UIpromptBoxUpdate";
    ok = 0;
};

UIpromptBox UIpromptDialog;


/* UIfileDialog is a dialog that permits a user to select a file.
 */
UIdialog UIfileDialog {
    /* filterLabelString allows changing the default label in the button */
    string              filterLabelString;
    /* filename is the selected filename. This value is read/write so
     * it can be used to provide a default value.
     */
    int                 applyButton;
    string              applyLabelString;
    string+OPort2       filename;

    /*
     * typeMask is set the type of file to display in the file list;
     * a choice of directories, files, or both types. 
     */
 /* WAITING FOR ENUM'S TO BE FIXED
    enum typeMask{
        choices = {"directory", "file", "any" };
    };
    */

    string typeMask<NEvisible=0> = "file"; /* Temporary use until enums are fixed */

    /* searchPattern is the pattern string used to determine the
     * files that will be displayed by the dialog. A * can be used
     * as a wildcard.
     */
    string              searchPattern;

    /* The searchPatternCache is used to retain the path info 
     * from on instance of the dialog to another.
     */
    string              dirMaskCache<NEvisible=0>;

    /* confirmFileWrite:  If set to a nonzero value, a confirmation dialog
     * is displayed when the OK button is pressed and the selected
     * file already exists.  This is useful when the UIfileDialog is
     * being used to select a file that is to be written.
     */
    int                 confirmFileWrite;

    method_inst inst<NEvisible=0,lang="cxx",interruptable=0>= "UIfileSBInstance";
    method_val update<NEvisible=0,lang="cxx",interruptable=0>= "UIfileSBUpdate";
#ifdef MSDOS
    ok = 0;
    method_del delete<NEvisible=0,lang="cxx",interruptable=0> = "UIfileSBDestroy";
#endif
};

UIfileDialog UIfileSB;

UIfileDialog UIdirectoryDialog {
    typeMask<NEvisible=0> = "directory";
};

#ifdef MSDOS
UIdialog UIprintDialog {
    ok<NEportLevels={0,2}>;

    int colors<NEportLevels={0,2}>; // 0=monochrome(only PS lev1) 1=color
    int orientation<NEportLevels={0,2}>; // 0=landscape 1=portrait
    int size<NEportLevels={0,2}>; // 0=EPS 1=A 2=B 3=A4 4=A3
    float widthMM<NEportLevels={0,2}>;
    float heightMM<NEportLevels={0,2}>;
    float gridSize<NEportLevels={0,2}>; // Number of pixels/grid for 3D image
    float fromRatio; // The aspect ratio of the view to make print from

    ptr+nosave+OPort2 devMode = 0;
    ptr+nosave+OPort2 devNames = 0;

    method_inst inst<NEvisible=0,lang="cxx",interruptable=0>= "UIprintDialogInstance";
    method_val update<NEvisible=0,lang="cxx",interruptable=0>= "UIprintDialogUpdate";
    method_del delete<NEvisible=0,lang="cxx",interruptable=0> = "UIprintDialogDestroy";
};
#endif

/* UIselectionDialog is a dialog that permits a user to select a string
 * from a list of strings.
 *
 *  - listIsEditable : if this is true, typing any string in the text
 *  area will affect the text, add the text to the list of strings and
 *  mark it as the selected list item. If it is false, typeing any string
 *  in the text area will not have an effect unless it matches one of the
 *  list item.
 *
 *  - strings : is the list of strings to be displayed in the dialog.
 */

UIpromptBox UIselectionDialog {
    Boolean             listIsEditable;   /* Default is 0 */
    int+OPort2          &selectedItem;
    int                 stringdims => array_size(strings);
    string+IPort2       strings[];

    method_inst inst<NEvisible=0,lang="cxx",interruptable=0>= "UIselectionBoxInstance";
    method_val update<NEvisible=0,lang="cxx",interruptable=0>= "UIselectionBoxUpdate";
};

UIselectionDialog UIselectionBox;

UIpromptBox UImultiSelBox {
    /* The apply button works like the Ok button except that it doesn't
     * cause the dialog to pop down after it is pressed.
     */
    int                 applyButton;
    string              applyLabelString;

    int+nonotify        numSelectedItems => array_size(selectedItems);
    int+OPort2          selectedItems[];
    string+OPort2       selectedText[];
    int                 stringdims => array_size(strings);
    string+IPort2       strings[];

    method_inst inst<NEvisible=0,lang="cxx",interruptable=0>= "UImultiSelBoxInstance";
    method_val update<NEvisible=0,lang="cxx",interruptable=0>= "UImultiSelBoxUpdate";
};

UImultiSelBox UImultiSelDialog;

UIselectionDialog UIfontDialog {
    method_inst inst<NEvisible=0,lang="cxx",interruptable=0>= "UIfontBoxInstance";
};

#ifdef SCROLLED_HISTORY
UIdialog UIscrolledHistory{
    //
    // This class implements a scrolled history dialog box
    // This is used to implement the main Express VCP processing window
    //
    int clear;          // When value is changed to 1, history window is cleared.
    string newCmd;      // Append newCmd to end of history list. newText is then NULL'ed.
    int maxRows;        // Maximum number of saved history list lines, default maximum is 100.
    int cmdHistSize => array_size(cmdHist); // Current size of command history list
    string cmdHist[];   // command history list
    string status;      // System prompt or messages set here will display above command line

    omethod+notify_inst+notify update<NEvisible=0,lang="cxx",interruptable=0> =
        "UIscrolledHistoryUpdate";
};
#endif


}; /* end of Dialogs */

library+sort Dialogs<NEvisible=0,cxx_name="UI"> {
    UImessageBox UImessageBox;

    UIpromptBox UIpromptBox;
    UIpromptBox UIpromptDialog;


    UIfileDialog UIfileDialog;
    UIfileDialog UIfileSB;

    UIselectionDialog UIselectionDialog;
    UIselectionDialog UIselectionBox;

#ifdef SCROLLED_HISTORY
    UIscrolledHistory UIscrolledHistory;
#endif
};


library+global+sort Panels<cxx_name="UI"> {

UIdecorContainer+OPort UIframe {
    x           = 0;
    width       = 100;
    height      = 100;

    enum      shadowType {
        choices = { "shadow_in","shadow_out", "shadow_etched_in", "shadow_etched_out" };
    };
    int       shadowThickness;
    int       displayFrame;

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
       "UIframeUpdate";
};

UIframe UIframeShadowIn {
    shadowType = 0;
};

UIframe UIframeShadowOut {
    shadowType = 1;
};

UIframe UIframeEtchedIn {
    shadowType = 2;
};

UIframe UIframeEtchedOut {
    shadowType = 3;
};

UIdecorContainer+OPort UIpanel {
    Boolean     rowColumnBehavior<NEvisible = 0>;

    x           = 0;
    width       = 200;
    height      = 200;

#ifdef MSDOS
    method_inst inst<NEvisible=0,lang="cxx",interruptable=0>= "UIpanelInstance";
    method_val update<NEvisible=0,lang="cxx",interruptable=0>= "UIpanelUpdate";
#else
    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIpanelUpdate";
#endif

};

UIvirtualContainer+OPort UIscrolledWindow {
    width               = 200;
    height              = 200;
    virtualWidth        = 300;
    virtualHeight       = 300;

    // Set the mode for the virtual window size.
    enum                resizeMode {
        choices = {"none", "grow", "any" };
    } = "any";
    enum                scrollBars {
        choices = {"none", "always", "as_needed" };
    } = "as_needed";

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx",weight=2> = 
        "UIscrolledWindowUpdate";
};

UIprimitive+OPort UIrenderView {
    width       = 200;
    height      = 200;

    /* promote handle to output port for easy connections to DDview */
    handle+OPort2 <NEvisible=1>;

#ifdef MSDOS
    int+read CopyToClipboard = 0;
#endif

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIrendViewUpdate";
};

}; /* end of Panels */

library+global+sort Controls<cxx_name="UI"> {

UIprimitive UItext {
    width       = 100;
    height      = 30;	// This default is too big, especially on Windows

    string+OPort2       text;
    int                 rows;
    int                 columns;
    int                 resizeToText;
    int                 multiLine;
    int                 outputOnly;
    int                 updateMode;
    int                 showLastPosition<NEvisible=0>=0;

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UItextUpdate";
};

UIprimitive UIlabel {
    width       =  100;
    height      => UIdata.UIfonts[0].lineHeight + 0;

    string+IPort2       label => name_of(<-,1);
    UIpixmap            labelPixmap;
    string              font;
    enum                alignment { choices={"left", "center", "right"};};
    string              accelerator;
    string              acceleratorText;

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIlabelUpdate";
};

UIprimitive   UIlist {
    width       =  75;
    height      => 4 * UIdata.UIfonts[0].lineHeight;

    string+OPort2       selectedText; /* The value entered in the text window*/
    Boolean             listIsEditable;   /* Default is 0 */
    int                 &selectedItem;
    int                 stringdims => array_size(strings);
    string+IPort2       strings[];
    string              font;

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIlistUpdate";
};

UIprimitive   UImultiList {
    width       =  75;
    height      => 4 * UIdata.UIfonts[0].lineHeight;

    int+nonotify        numSelectedItems => array_size(selectedItems);
    int                 selectedItems[];
    string+OPort2       selectedText[];
    int                 stringdims => array_size(strings);
    string+IPort2       strings[];

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UImultiListUpdate";
};

#ifdef MSDOS

UIprimitive   UIcomboBox {
    width       = 100;
    height      = 30;
    string      selectedText; /* The value entered in the text window*/
    Boolean     listIsEditable;   /* Default is 0 */
    int         numShowItems = 4;
    int         &selectedItem;
    int         stringdims => array_size(strings);
    string+IPort2 strings[];

    method_inst inst<NEvisible=0,lang="cxx",interruptable=0>= "UIcomboBoxInstance";
    method_val update<NEvisible=0,lang="cxx",interruptable=0>= "UIcomboBoxUpdate";
};
#endif

UIlabel UIbutton {
    width       = 100;
    height      = 24;

    UIpixmap    armedPixmap;
    UItoolTip   toolTip<export_all=2> {
        message => <-.label;
    };
    int+opt+OPort2       do=0;

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIbuttonUpdate";
};

UIbutton UItoggle {
    width       =  100;
    height      => UIdata.UIfonts[0].lineHeight;

    Boolean+opt+OPort2  &set=0;

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UItoggleUpdate";

};

UIprimitive+UIradioList UIradioBox {
    cmdList+read;
    selectedItem+read;
    enum        orientation {
        choices={ "vertical", "horizontal" }; 
    };
    int         itemWidth;
    int         itemHeight<NEvisible=0>;

    width       =  100;
#ifdef MSDOS
    // On Windows, the +2 is also added by the UI compiled code.
    height      => max_array({ 1, dims * (2 + UIdata.UIfonts[0].lineHeight) });
#else
    height      => max_array({ 1, dims * UIdata.UIfonts[0].lineHeight });
#endif

    label<NEvisible=0>;
    tearOff<NEvisible=0>;

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIradioBoxUpdate";
};

UIdecorContainer+UIradioList UIoptionMenu<is_val_func=0> {

    width       = 200;
    height      =  37;
    int         optionLabel;
    string      label => name_of(<-,1);
    UIpixmap    labelPixmap<NEvisible=0>;
    string      font;
    enum        alignment {
        choices = {"left", "center", "right" };
    };
    int         useSelectedCmd; // Set to 0 to use behavior prior to version 3.1

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIoptionMenuUpdate";
};

UIdecorContainer+UIradioList UIoptionMenu30<is_val_func=0> {

    width       = 200;
    height      =  37;
    int         optionLabel;
    string      label => name_of(<-,1);
    UIpixmap    labelPixmap<NEvisible=0>;
    string      font;
    int         alignment;

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIoptionMenu30Update";

//    method_inst inst<NEvisible=0,lang="cxx",interruptable=0>= "UIoptionMenu30Instance";
//    method_val update<NEvisible=0,lang="cxx",interruptable=0>= "UIoptionMenu30Update";
};


UIprimitive+UIoptionList UIoptionBox {
    cmdList+read;
    selectedItems+read;
    enum        orientation { choices = {"vertical", "horizontal"};};
    int         itemWidth;
    int         itemHeight<NEvisible=0>;

    width       = 100;
#ifdef MSDOS
    // On Windows, the +2 is also added by the UI compiled code.
    height      => max_array({ 1, dims * (2 + UIdata.UIfonts[0].lineHeight) });
#else
    height      => max_array({ 1, dims * UIdata.UIfonts[0].lineHeight });
#endif
    label<NEvisible=0>;

#ifdef MSDOS
    // PC routine needs to notify in this case cause it does not
    // need the optionUpdate method
    cmdList {
        set-nonotify;
    };
#endif

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIoptionBoxUpdate";
};

UIvaluator UIslider {
    width       = 200;
#ifdef MSDOS
    height      =  32;
#else
    height      => (UIdata.UIfonts[0].lineHeight * 25) / 10;
#endif

    string      title => name_of(<-,1);
    Boolean     horizontal;
    enum        processingDirection {
        choices = { "right", "left", "down", "up" };
    };
    double      increment;
    Boolean     showValue = 1; /* If set, displays the slider value */

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIsliderUpdate";
};

UIvaluator UIfield {
    width       = 100;
    height      =  30;
    int         outputOnly;
    int         updateMode;

    /* display format */
    enum        format {
        choices = { "mixed", "fixed", "scientific" };
    } = "fixed";

    /* To display a string when the "value" is unset or undefined set the
    * "nullString" to the string you wish to display
    */
    string      &nullString = "<NULL>";

    /* Set to allow the text widget to resize to fit the length of the value */
    boolean     &resizeMode;

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIfieldUpdate";
};

UIvaluator UIdial {
    width       = 140;
    height      = 180;

    string      title => name_of(<-,1);
    double      valuePerRev;
    Boolean     showValue;
    int         numTicks;
    int         style = 1; /* AVS_STYLE */

    omethod+notify_inst+notify update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UIdialUpdate";
};


}; /* end of Controls */

library+global+sort Interactors<cxx_name="UI"> {

UIinteractor UIonePoint<NEvisible=1> {
    view+notify+read;
    string+read+nowrite+notify runEvent = "Control<Btn1Down>";
    int state<val_state=4> = 1;

    omethod+notify_inst+write inst<NEvisible=0,lang="cxx",interruptable=0> =
        "UIonePointUpdate";
};

UIinteractor UItwoPoint {
    view+notify+read;
    string+read+nowrite+notify startEvent = "<Btn1Down>";
    string+read+nowrite+notify runEvent   = "<Btn1Motion>";
    string+read+nowrite+notify stopEvent  = "<Btn1Up>";
    int state<val_state=4> = 3;

    omethod+notify_inst+write inst<NEvisible=0,lang="cxx",interruptable=0> =
        "UItwoPointUpdate";
};

UIinteractor UImouseEvents {
    // run when view changes
    view+notify+read+nowrite;
    // if true, button must be done for events 
    boolean+read+notify+nowrite onButtonDown = 1;

    /*
     * Bit mask for the buttons that events are delivered for (if 
     * mustBeDown = 1)
     */
    int+read+notify+nowrite buttonRequestMask = 1 | 2 | 4;

    enum buttonType<val_state=4> {
        choices = { "left", "middle", "right" };
    };
    // 0 = none buttons down, 1 = left, 2 = middle, 4 = right 
    int buttonMask<val_state=4>;

    enum modType<val_state=4> {
        choices = { "none", "shift", "ctrl", "alt" };
    };
    // 0=no modifiers, 1=shift, 2=ctrl, 4=alt
    int modMask<val_state=4>;

    enum state<val_state=4> {
        choices = { "down", "motion", "up" };
        values  = { 1, 2, 3 };
    };

    omethod+notify_inst+write update<NEvisible=0,interruptable=0,lang="cxx"> = 
        "UImouseEventsUpdate";
};

}; /* end of Interactors */

group label_cmd {
    string labels[];
    int+nonotify dim => array_size(labels);
    UIoption+nonotify+write cmd[];
    int+read+nonotify+opt inItem;
    int+read+nonotify doSet=1;
    int+write+nonotify+opt outItem;

    method+notify_val+notify_inst upd_label_cmd<interruptable=0,weight=0> =
        "label_cmd";
};

module label_label
{
   omethod+notify_inst+req upd_label_label <interruptable=0,weight=0> (
                                        .labels+read+notify+req,
                                        .xStart+read+notify+req,
                                        .xInc+read+notify,
                                        .yStart+read+notify+req,
                                        .yInc+read+notify,
                                        .width+read+notify+req,
                                        .height+read+notify+req,
                                        .alignment+read+notify+req,
                                        .parent+read+notify,
                                        .UIlabel+write
                                        ) = "label_label";
   string+IPort2 labels[];
   int xStart=10;
   int xInc;
   int yStart=10;
   int yInc;
   int width=100;
   int height=30;
   enum alignment  {
      choices = { "left", "center", "right" };
   };
   UIconnection+IPort2 *parent;
   UIlabel UIlabel[];
};

module label_text
{
   omethod+notify_inst+req upd_label_text <interruptable=0,weight=0> (
                                        .texts+read+req+notify,
                                        .xStart+read+notify+req,
                                        .xInc+read+notify,
                                        .yStart+read+notify+req,
                                        .yInc+read+notify,
                                        .width+read+notify+req,
                                        .height+read+notify+req,
                                        .parent+read+notify,
                                        .outputOnly+read+notify,
                                        .UItext+write
                                        ) = "label_text";
   string+IPort2 texts[];
   int xStart=10;
   int xInc;
   int yStart=10;
   int yInc;
   int width=100;
   int height=30;
   UIconnection+IPort2 *parent;
   int outputOnly;
   UItext UItext[];
};

/* No longer used. */
group add_cmd {
    group+IPort2 *parent;

    method+notify_val+notify_inst upd_add_cmd<interruptable=0> = "UIadd_cmd";
};

/* No longer used. */
group UImodule_init {
    string title => name_of(<-,1);
    string message;
    UIoption UIoption;
    method_inst module_init<interruptable=0> = "UImodule_init";
};

#ifdef NOTDEF
UIpanel+UImodule_init UImod_panel {
    x           =  4;
    y           =  4;
    width       =  250;
    height      =  1500;
};
#endif

/* Must be a macro so that it can be instanced */
/* Used by ModuleStack */
application UImod_register {
    /* Only called from module_init, which is not longer used. */
    func module_register<NEvisible=0> = "UImodule_register";
};

group UIparent_init {
    string parent_class;
    method+notify_inst parent_init = "UIset_parent_inst";
};

group UIdefault_shell_init<need_objs="UIshell"> {
    string parent_class;
    method+notify_inst parent_init = "UIdefault_shell_inst";
};

group UIlist_init {
    string cmd_list_class;
    method+notify_inst list_init = "UIadd_to_list_inst";
};

group UIlist_init_set {
    string cmd_list_class;
    method+notify_inst list_init = "UIadd_to_list_inst_set";
};

UIdefault_shell_init+UIpanel UImod_panel {
    x           =  4;
    y           =  4;
    width       =  250;
    height      =  1500;
    string message;
    string title => name_of(<-,1);
    parent_class = "widget";
    UIlist_init_set+UIoption option {
        label => <-.title;
        cmd_list_class = "Modules";
        message => <-.message;
    };
    visible => option.set;
};

group UIselectionManager {
    UIwinHandle+nosave+nonotify selected;
    string             backgroundColor;
    string             foregroundColor;
    int                setColorIndex;
    string             font;
    int                trigger;

    method+notify_inst init<NEvisible=0,lang="cxx",interruptable=0> =
        "UIselectionManagerUpdate";
    method+notify_val update<NEvisible=0,lang="cxx",interruptable=0> =
        "UIselectionManagerUpdate";
};

//
// Generic browser launcher that can be triggered from
// anywhere on any URL.  Usually the idea is that this
// triggers the viewing of a html help file.
//
module UIlaunchBrowser	// why are all the other modules actually groups?
{
    int+Iparam    trigger;	// Usually connected to UIbutton.do
    string+Iparam filename;	// name of file or a URL
    UIcore+IPort * parent;	// any window
    // Use the standard helppath to search for files that are
    // relative pathnames.  Even if set, filenames that look
    // like URL's or absolute pathnames will be used as is.
    int+IPort     use_helppath = 0;

    omethod+notify_inst+req update(
        .trigger+read+req+notify,
        .filename+read+req,
        .parent+read,
        .use_helppath+read ) = "UIlaunchBrowserUpdate";
};

/** From here on down is dynamic window stuff **/
group UImake_dyn_wind {
    UIwinHandle+IPort2+read &in_handle;
#ifdef MSDOS
    int+nonotify old_widget;
#else
    ptr+nonotify old_widget;
#endif
    method+notify_val+notify_inst dyn_wind_update<interruptable=0,immediate=1> =
        "UIdyn_wind_update";
    method+notify_deinst dyn_wind_destroy<interruptable=0> =
        "UIdyn_wind_destroy";
};

UItoggle UIdynamic_toggle {
    UImake_dyn_wind UImake_dyn_wind {
        in_handle => <-.handle;
    };
};

}; // end of flibrary UI
