/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/acvt.v#1 $
*/
flibrary+buffered+global+sort ACVT <
#ifdef ACKIT
   build_dir="compat/modules/converts",
   build_cmd="$(MAKE)",
#endif
   disabled => Templates.CONFIG.ac_kit_disabled,
#ifdef ACKIT
   link_files="-lacvt -lackit -lgeom -lutil"
#else
   link_files="-lacvt -lac -lgeom -lutil"
#endif
> {


$declare_type avsmod group
$declare_type avsfield ptr
$declare_type avsucd ptr
$declare_type avsgeom ptr
$declare_type avscmap ptr
$declare_type avsudata ptr

group ACavs_to_fld {
	 avsfield+Iparam &in;
	 int convert = 0;
	 int+Iparam vector = 0;
	 int+Iparam flip_y = 0;	// use for images (ignored unless input is 2d)
	 Field_Struct+Oparam	&out;
	 /* 
  	  * need to define the set of templates used by this module
 	  * so that they are compiled in when we build a compiled V file
	  */
	 group+nonotify templates {
	    Field_Unif Field_Unif;
	    Field_Rect Field_Rect;
	 };
	 method+notify_val+notify_inst upd_avs_to_fld<status=1>="ACavs_to_fld";
}; 

group ACfld_to_avs {
	 Mesh_Struct+Iparam	&in {
		ndim+req;
	 };
	 int+Iparam  flip=0;
	 avsfield+Oparam &out;
	 method+notify_val+notify_inst upd_fld_to_avs<status=1>="ACfld_to_avs";
}; 

ACavs_to_fld ACavs_to_image {
	convert = 1;
	vector = 1;
	flip_y = 1;
};

ACfld_to_avs ACimage_to_avs {
	 flip=1;
};

group ACucd_to_fld {
	 avsucd+Iparam &in;
	 Field+Oparam out;
	 method+notify_val+notify_inst upd_ucd_to_fld<status=1>="ACucd_to_fld";
}; 

group ACfld_to_ucd {
	 Mesh+Iparam &in {
		nnodes+req;
	 };
	 avsucd+Oparam out;
	 method+notify_val+notify_inst upd_fld_to_ucd<status=1>="ACfld_to_ucd";
}; 

group ACread_geom {
     string+Iparam                 filename;
     int                           array_flag;
     Field+Oparam                  out_field;
     Field+Oparam                 &out_fields[];
     string+Oparam                 name;
     method+notify_val+notify_inst upd_read_geom<status=1> = "read_geom";
};

// Dynamically creates GDIF.DefaultXXX 
group ACgeoms_to_obj<need_objs="GDIF"> {
     avsgeom+IPort2+notify geoms[];
     int geom_seq;
     Field+IPort2 &texture;
     Field+IPort2 &colormap;
     DefaultProps Props;
     DefaultModes Modes;
     DefaultXform Xform;
     DefaultPickInfo PickInfo;
     // Changed from GD.DefaultObject because of
     // license-related problems with Viz Express.
     GDM.DefaultObject+OPort2 ACtop {
         props => Props;
         modes => Modes;
         xform => Xform;
         pick_info => PickInfo;
     };
     ptr name_table;
     method+notify_val+notify_inst upd_geom_to_obj<status=1> = "ACgeom_to_obj";
     method+notify_del del_geom_to_obj = "ACdestroy_geom_to_obj";
};

/*
 * Supplied for backward compatability with previous version
 */
ACgeoms_to_obj ACgeom_to_obj {
     avsgeom+IPort2+notify geom0;
     avsgeom+IPort2+notify geom1;
     avsgeom+IPort2+notify geom2;
     avsgeom+IPort2+notify geom3;
     avsgeom+IPort2+notify geom4;
     avsgeom+IPort2+notify geom5;
     avsgeom+IPort2+notify geom6;
     avsgeom+IPort2+notify geom7;
     avsgeom+IPort2+notify geom8;
     avsgeom+IPort2+notify geom9;
     geoms => {geom0, geom1, geom2, geom3, geom4, geom5, geom6, geom7, 
               geom8, geom9};
};

};
