//          Copyright (c) 1993 by
//          Advanced Visual Systems Inc.
//          All Rights Reserved
//
//  This software comprises unpublished confidential information of
//  Advanced Visual Systems Inc. and may not be used, copied or made
//  available to anyone, except in accordance with the license
//  under which it is furnished.
//
//  This file is under Perforce control
//  $Id: //depot/express/fcs70/v/ag.v#1 $
//


// ag.v - V definition of the AG kit
 flibrary+global+sort AG <
     build_dir="ag",
     build_cmd="$(MAKE)",
#ifdef MSDOS
     libdeps = "FLD GD",
     link_files="-lag -lcxxut $(AGX_IMPLIB)",
#else
     libdeps = "FLD GD AGXLIB",
     link_files="-lag -lcxxut",
#endif
     needs_edit_lic="GD",
     cxx_hdr_files="avs/ag.hxx fld/Xfld.h",
     out_hdr_file="ag_omx.hxx",
     out_src_file="ag_omx.cxx",
     hdr_code="void AGInit (void);",
     init_code="    AGInit();",
     disabled => Templates.CONFIG.ag_kit_disabled
 > {

$include ../include/$MACHINE/gd_ren.h

//
// Define port colors to be used in the AG kit
//
#define AG_COLOR                0x00ffcc
#define AG_DATAOBJ_COLOR        0x0000ff
#define AG_VIEWPORT_COLOR       0xff00ff
#define AG_WORLD_COLOR          0x7722ff
#define AG_POLAR_WORLD_COLOR    0x9944ff
#define AG_CONTOUR_COLOR        0xff8833
#define AG_GRAPH_COLOR          0xffff00
#define AG_POLAR_GRAPH_COLOR    0xffff44

//
// Define the templates
//
library+global+sort Templates {

    //
    // Parameter type definitions that matches the C++ attribute types
    //

    int+opt+read     AGBoolean;
    float+opt+read   AGFloat;
    int+opt+read     AGInt;
    string+opt+read  AGString;
    string+opt+read  AGColor;
    string+opt+read  AGFont;
    float+opt+read   AGDistance;
    float+opt+read   AGGeometry[][2];
    enum+opt+read  AGLineStyle {
        choices = {
            "solid",
            "dashed",
            "dotted",
            "dasheddotted",
            "______________",
            ". . . . . . .",
            "_ _ _ _ _ _ _",
            "__ __ __ __ __",
            "__ . __ . __ .",
            "_ __ _ __ _ __",
            ".  .  .  .  .",
            "___ ___ ___ __",
            "_ _  _ _  _ _",
            "__ .. __ .. __",
            "__ ... __ ...",
            "__ .... __ ..."
        };
    };
    enum+opt+read    AGContourTypeEnum {
        choices = {
            "filledcontours",
            "filled contours",
            "isolines",
            "datamappedisolines",
            "datamapped isolines"
        };
    };
    enum+opt+read  AGGraphTypeEnum {
        choices = {
            "bars",
            "barlines",
            "area",
            "curve",
            "line",
            "scatter",
            "staircase",
            "stairarea"
        };
    };

    enum+opt+read  AGLabelModeEnum {
        choices = {
            "normal",
            "reversed",
            "right",
            "left"
        };
    };

    enum+opt+read  AGLabelPositionEnum {
        choices = {
            "tickmarks",
            "ticks",
            "intervals"
        };
    };
    enum+opt+read  AGScaleTypeEnum {
        choices = {
            "linear",
            "log10",
            "power"
        };
    };
    enum+opt+read  AGMultiLineJustificationEnum {
        choices = {
            "left",
            "center",
            "right",
            "blocked"
        };
    };
    enum+opt+read  AGHorizontalJustificationEnum {
        choices = {
            "left",
            "center",
            "right"
        };
    };
    enum+opt+read  AGVerticalJustificationEnum {
        choices = {
            "font bottom",
            "fontbottom",
            "font base",
            "fontbase",
            "base",
            "font half",
            "fonthalf",
            "fontcap",
            "font cap",
            "fonttop",
            "font top",
            "top",
            "half",
            "bottom"
        };
    };
    enum+opt+read  AGArcTypeEnum {
        choices = {
            "line",
            "chord",
            "pie"
        };
    };
    enum+opt+read  AGPieLabelJustificationEnum {
        choices = {
            "left",
            "center",
            "right"
        };
    };
    enum+opt+read  AGPieLabelPositionEnum {
        choices = {
            "circular",
            "aligned",
            "inside",
            "outsidecircular",
            "outsidealigned"
        };
    };
    enum+opt+read  AGPieLabelContentEnum {
        choices = {
            "text",
            "percent",
            "value",
            "valuepercent",
            "percentvalue"
        };
    };

    //
    // AGPrimitive is the base class for the AG-kit
    // The member priority is used for both drawing order among children
    // of an AG-kit parent and for notifying parents of updates
    //
    group+OPort AGPrimitive
      <locked=1, NEcolor0=AG_COLOR,
      // Specify coresponding C++ class (abstract means non instantiable)
      cxx_class="AgPrimitive", cxx_abstract=1,
      // Define C++ functions to update different attribute types
      cxx_members=
<"
        AgPrimitive *primitive;
          protected:
        int my_seq_num;
        // Functions to attach to world and viewport
        void attach(OMXgroup_array &children);
        // Define a number of functions to update attribute groups
        void updateIntAttr(const char *attrName, OMXint &attr);
        void updateFloatAttr(const char *attrName, OMXfloat &attr);
        void updateFloatArrAttr(const char *attrName, OMXobj &attr);
        void updateDistanceAttr(const char *attrName, OMXfloat &attr);
        void updateDistanceAttr(const char *attrName, OMXfloat &attr, 
                              AgDistance &value);
        void updateStringAttr(const char *attrName, OMXstr &attr);
        void updateStringArrAttr(const char *attrName, OMXobj &attr);
        void updateEnumAttr(const char *attrName, OMXstr &attr);
        void updateColorAttr(const char *attrName, OMXstr &attr);
        void updateColorArrAttr(const char *attrName, OMXobj &attr);
        void updateFontAttr(const char *attrName, OMXstr &attr);
        void updateLineStyleAttr(const char *attrName, OMXstr &attr);
        void updateGeometryAttr(const char *attrName, OMXobj &attr);
        // The parent is only triggered when AgPrimitive is changed
        // which can be accomplished by changing priority
        void triggerParent() {priority = (int)priority;}
">
        >{

        int+write       priority;
        AGBoolean       visibility = 1;

	// Name of class type used for AGGUISelector
	string+opt      className<NEvisible=0> = "AGPrimitive";

        string+opt updCode<NEvisible=0, export=0> =
<"
        // Check if at instantiation
        if (event_mask & OM_EVENT_INST) {
           my_seq_num = -1;
           // Save pointer to base class (AgPrimitive)
           primitive = (AgPrimitive*)ret_class_ptr("AgPrimitive");
           // Also store the V object so we can find it again if picked
           primitive->setUserData((OMXobj*)this);
        } else {
           my_seq_num = seq_num;
        }
        updateIntAttr(AgNpriority, priority);
        updateIntAttr(AgNvisibility, visibility);
        triggerParent();
">;
    };

    //
    // The AGRenderPrimitive defines the virtual functions for the 2D camera
    //
    AGPrimitive AGRenderPrimitive<indexed=0> {
        int+read priority;
        prim isRenderable<NEvisible=0, export=0>;
        // These are the virtual functions for the 2D camera
        data_method+virtual render = "AGRenderer";
        data_method+virtual pick = "AGPicker";
        data_method+virtual getlimits = "AGgetLimits";
    };

    //
    // AGGeometryPrimitive has a geometry and can connect directly to a 2D
    // camera or a groupObject for transformation in a 2D viewer
    //
    AGPrimitive AGGeometryPrimitive {
        AGGeometry geometry;
        string geometryUpdCode<NEvisible=0, export=0> = AGPrimitive.updCode +
<"
        updateGeometryAttr(AgNgeometry, geometry);
">;
        int+write priority;
        prim isRenderable<NEvisible=0, export=0>;
    };

    //
    // Define different port colors once for all
    //
    atts AGConnectToViewportPort<NEnumColors=2,NEcolor1=AG_VIEWPORT_COLOR>;
    atts AGConnectToWorldPort<NEnumColors=2,NEcolor1=AG_WORLD_COLOR>;
    atts AGConnectToPolarWorldPort<NEnumColors=2,NEcolor1=AG_POLAR_WORLD_COLOR>;
    atts AGConnectToGraphViewportPort<NEnumColors=3,
        NEcolor1=AG_GRAPH_COLOR,NEcolor2=AG_VIEWPORT_COLOR>;
    atts AGConnectToGraphWorldPort<NEnumColors=3,
        NEcolor1=AG_GRAPH_COLOR, NEcolor2=AG_WORLD_COLOR>;
    atts AGConnectToPolarGraphWorldPort<NEnumColors=3,
        NEcolor1=AG_POLAR_GRAPH_COLOR, NEcolor2=AG_POLAR_WORLD_COLOR>;
    atts AGConnectToContourViewportPort<NEnumColors=3,
        NEcolor1=AG_CONTOUR_COLOR,NEcolor2=AG_VIEWPORT_COLOR>;
    atts AGConnectToContourWorldPort<NEnumColors=3,
        NEcolor1=AG_CONTOUR_COLOR,NEcolor2=AG_WORLD_COLOR>;

    // Different groups of parameters (C++ attributes)
    // They all derive from AGPrimitive to allow for using the AGPrimitive
    // C++ class pointer
    group AGViewportParams {
        AGBoolean       clip = 0;
        AGColor         fillColor;
        AGColor         frameColor = "antibackground";
        AGDistance      frameWidth = 0.25;
        AGFloat         limitsX[2] = {-5, 5};
        AGFloat         limitsY[2] = {-5, 5};
        string viewportParamsCode<NEvisible=0, export=0> = 
<"
        updateFloatArrAttr(AgNlimitsX, limitsX);
        updateFloatArrAttr(AgNlimitsY, limitsY);
        updateColorAttr(AgNfillColor, fillColor);
        updateColorAttr(AgNframeColor, frameColor);
        updateDistanceAttr(AgNframeWidth, frameWidth);
        updateIntAttr(AgNclip, clip);
">;
    };
    group AGTextParams {
        AGColor                         color =         "antibackground";
        AGColor                         fillColor =     "transparent";
        AGFont                          font =          "roman-simplex";
        AGColor                         frameColor =    "antibackground";
        AGDistance                      frameWidth =         0.0;
        AGHorizontalJustificationEnum   horizontalJustification = "center";
        AGMultiLineJustificationEnum    multiLineJustification = "center";
        AGFloat                         multiLineSpacingFactor = 0.0;
        AGString+IPort2                 text[];
        AGVerticalJustificationEnum     verticalJustification = "half";
        string textParamsCode<NEvisible=0, export=0> = 
<"
        updateStringArrAttr(AgNtexts, text);
        updateFontAttr(AgNfont, font);
        updateColorAttr(AgNcolor, color);
        updateColorAttr(AgNfillColor, fillColor);
        updateColorAttr(AgNframeColor, frameColor);
        updateDistanceAttr(AgNframeWidth, frameWidth);
        updateEnumAttr(AgNhorizontalJustification, 
                       horizontalJustification);
        updateEnumAttr(AgNverticalJustification, verticalJustification);
        updateEnumAttr(AgNmultiLineJustification, 
                       multiLineJustification);
        updateFloatAttr(AgNmultiLineSpacingFactor, 
                        multiLineSpacingFactor);
">;
};
    group AGTickParams {
        AGColor         majorTickColor;
        AGLineStyle     majorTickLineStyle;
        AGBoolean       majorTickOn;
        AGDistance      majorTickWidth;
        AGColor         minorTickColor;
        AGInt           minorTickCount;
        AGLineStyle     minorTickLineStyle;
        AGDistance      minorTickWidth;
        string tickParamsCode<NEvisible=0, export=0> = 
<"
        updateIntAttr(AgNmajorTickOn, majorTickOn);
        updateDistanceAttr(AgNmajorTickWidth, majorTickWidth);
        updateColorAttr(AgNmajorTickColor, majorTickColor);
        updateLineStyleAttr(AgNmajorTickLineStyle, majorTickLineStyle);
        updateIntAttr(AgNminorTickCount, minorTickCount);
        updateDistanceAttr(AgNminorTickWidth, minorTickWidth);
        updateColorAttr(AgNminorTickColor, minorTickColor);
        updateLineStyleAttr(AgNminorTickLineStyle, minorTickLineStyle);
">;
};
    AGTickParams AGAxisParams {
        AGColor         axleColor;
        AGDistance      axleWidth;
        AGColor         labelColor;
        AGFont          labelFont;
        AGDistance      labelHeight;
        AGColor         textColor;
        AGFont          textFont;
        AGDistance      textHeight;
        string axisParamsCode<NEvisible=0, export=0> = tickParamsCode + 
<"
        updateDistanceAttr(AgNlabelHeight, labelHeight);
        updateColorAttr(AgNlabelColor, labelColor);
        updateFontAttr(AgNlabelFont, labelFont);
        updateDistanceAttr(AgNtextHeight, textHeight);
        updateColorAttr(AgNtextColor, textColor);
        updateFontAttr(AgNtextFont, textFont);
        updateDistanceAttr(AgNaxleWidth, axleWidth);
        updateColorAttr(AgNaxleColor, axleColor);
">;
};
    group AGTickXParams {
        AGFloat         majorReferenceX;
        AGFloat         majorStepX;
        string tickXParamsCode<NEvisible=0, export=0> = 
<"
        updateFloatAttr(AgNmajorReferenceX, majorReferenceX);
        updateFloatAttr(AgNmajorStepX, majorStepX);
">;
};
    group AGTickYParams {
        AGFloat         majorReferenceY;
        AGFloat         majorStepY;
        string tickYParamsCode<NEvisible=0, export=0> = 
<"
        updateFloatAttr(AgNmajorReferenceY, majorReferenceY);
        updateFloatAttr(AgNmajorStepY, majorStepY);
">;
};
    AGAxisParams+AGTickXParams+AGTickYParams AGWorldParams {
        AGBoolean       clip;
        AGFloat         limitsX[2];
        AGFloat         limitsY[2];
	AGFloat         limitsMarginX[2];
	AGFloat         limitsMarginY[2];
        AGBoolean       niceLimits =            1;
        AGBoolean       uniformScaling =        0;
        string worldParamsCode<NEvisible=0, export=0> = 
            axisParamsCode+tickXParamsCode+tickYParamsCode+
<"
        updateFloatArrAttr(AgNlimitsX, limitsX);
        updateFloatArrAttr(AgNlimitsY, limitsY);
        updateFloatArrAttr(AgNlimitsMarginX, limitsMarginX);
        updateFloatArrAttr(AgNlimitsMarginY, limitsMarginY);
        updateIntAttr(AgNniceLimits, niceLimits);
        updateIntAttr(AgNuniformScaling, uniformScaling);
        updateIntAttr(AgNclip, clip);
">;
    };
    group AGTickRParams {
        AGFloat         majorReferenceR;
        AGFloat         majorStepR;
        string tickRParamsCode<NEvisible=0, export=0> = 
<"
        updateFloatAttr(AgNmajorReferenceR, majorReferenceR);
        updateFloatAttr(AgNmajorStepR, majorStepR);
">;
};
    group AGTickTParams {
        AGFloat         majorReferenceT;
        AGFloat         majorStepT;
        string tickTParamsCode<NEvisible=0, export=0> = 
<"
        updateFloatAttr(AgNmajorReferenceT, majorReferenceT);
        updateFloatAttr(AgNmajorStepT, majorStepT);
">;
};
    AGAxisParams+AGTickRParams+AGTickTParams AGPolarWorldParams {
        AGFloat         limitsR[2];
        AGFloat         limitsT[2];
        AGFloat         angle =         0.0;
        AGFloat         originR;
        string polarWorldParamsCode<NEvisible=0, export=0> = 
            axisParamsCode+tickRParamsCode+tickTParamsCode+
<"
        updateFloatArrAttr(AgNlimitsR, limitsR);
        updateFloatArrAttr(AgNlimitsT, limitsT);
        updateFloatAttr(AgNangle, angle);
        updateFloatAttr(AgNoriginR, originR);
">;
    };
    // Parameters for a single Graph
    group AGGraphParams {
        AGFloat         barWidth;
        AGFloat         barFrameWidth;
        AGGraphTypeEnum graphType;
        AGLineStyle     lineStyle;
        AGDistance      lineWidth;
        AGFloat         referenceValue;
        AGString        scatterSymbols[];
        AGFloat         shiftPosition;
        AGFont          symbolFont;
        AGDistance      symbolHeight;
        string graphParamsCode<NEvisible=0, export=0> = 
<"
        updateEnumAttr(AgNgraphType, graphType);
        updateDistanceAttr(AgNlineWidth, lineWidth);
        updateLineStyleAttr(AgNlineStyle, lineStyle);
        updateDistanceAttr(AgNbarWidth, 
                         barWidth, AgDistance().setWorldX(barWidth));
        updateDistanceAttr(AgNbarFrameWidth, barFrameWidth);
        updateFloatAttr(AgNreferenceValue, referenceValue);
        updateFloatAttr(AgNshiftPosition, shiftPosition);
        updateDistanceAttr(AgNsymbolHeight, symbolHeight);
        updateFontAttr(AgNsymbolFont, symbolFont);
        updateStringArrAttr(AgNscatterSymbols, scatterSymbols);
">;
    };
    // Parameters used by a number of Graphs
    group AGGraphListParams {
        AGFloat         barOffsets[];
        AGColor         graphColors[];
        string graphListParamsCode<NEvisible=0, export=0> = 
<"
        updateFloatArrAttr(AgNbarOffsets, barOffsets);
        updateColorArrAttr(AgNgraphColors, graphColors);
">;
    };

    // Parameters for a single Polar Graph
    group AGPolarGraphParams {
        AGGraphTypeEnum graphType;
        AGLineStyle     lineStyle;
        AGDistance      lineWidth;
        AGString        scatterSymbols[];
        AGFont          symbolFont;
        AGDistance      symbolHeight;
        string polarGraphParamsCode<NEvisible=0, export=0> = 
<"
        updateEnumAttr(AgNgraphType, graphType);
        updateDistanceAttr(AgNlineWidth, lineWidth);
        updateLineStyleAttr(AgNlineStyle, lineStyle);
        updateDistanceAttr(AgNsymbolHeight, symbolHeight);
        updateFontAttr(AgNsymbolFont, symbolFont);
        updateStringArrAttr(AgNscatterSymbols, scatterSymbols);
">;
    };
    // Parameters used by a number of Polar Graphs
    group AGPolarGraphListParams {
        AGColor         graphColors[];
        string polarGraphListParamsCode<NEvisible=0, export=0> = 
<"
        updateColorArrAttr(AgNgraphColors, graphColors);
">;
    };

    // Parameters for a single Contour
    group AGContourParams {
//        AGDistance            isoLineFeatheringMinDistance;
//        AGDistance            isoLineFeatheringMinLength;
        AGFloat                 classValues[];
        AGContourTypeEnum       contourType;
        AGColor                 isoLineLabelColor;
        AGFont                  isoLineLabelFont;
        AGDistance              isoLineLabelDistance;
        AGDistance              isoLineLabelHeight;
        AGFloat                 isoLineLabelAngleInterval[2];
        AGInt                   isoLineLabelDecimals;
        AGInt                   isoLineLabelFrequency;
        AGColor                 majorIsoLineColor;
        AGDistance              majorIsoLineWidth;
        AGInt                   majorIsoLineFrequency;
        AGInt                   majorIsoLineReference;
        AGLineStyle             majorIsoLineStyle;
        AGFloat                 maxClass;
        AGFloat                 minClass;
        AGColor                 minorIsoLineColor;
        AGDistance              minorIsoLineWidth;
        AGLineStyle             minorIsoLineStyle;
        AGInt                   numClasses;
        string contourParamsCode<NEvisible=0,export=0> = 
<"
        updateEnumAttr(AgNcontourType, contourType);
        updateIntAttr(AgNisoLineLabelFrequency, isoLineLabelFrequency);
        updateIntAttr(AgNisoLineLabelDecimals, isoLineLabelDecimals);
        updateDistanceAttr(AgNisoLineLabelDistance, isoLineLabelDistance);
        updateColorAttr(AgNisoLineLabelColor, isoLineLabelColor);
        updateFontAttr(AgNisoLineLabelFont, isoLineLabelFont);
        updateDistanceAttr(AgNisoLineLabelHeight, isoLineLabelHeight);
        updateFloatArrAttr(AgNisoLineLabelAngleInterval, 
                           isoLineLabelAngleInterval);
        // updateDistanceAttr(AgNisoLineFeatheringMinDistance,
        //                    isoLineFeatheringMinDistance);
        // updateDistanceAttr(AgNisoLineFeatheringMinLength,
        //                    isoLineFeatheringMinLength);
        updateColorAttr(AgNmajorIsoLineColor, majorIsoLineColor);
        updateLineStyleAttr(AgNmajorIsoLineStyle, majorIsoLineStyle);
        updateDistanceAttr(AgNmajorIsoLineWidth, majorIsoLineWidth);
        updateIntAttr(AgNmajorIsoLineFrequency, majorIsoLineFrequency);
        updateIntAttr(AgNmajorIsoLineReference, majorIsoLineReference);
        updateColorAttr(AgNminorIsoLineColor, minorIsoLineColor);
        updateLineStyleAttr(AgNminorIsoLineStyle, minorIsoLineStyle);
        updateDistanceAttr(AgNminorIsoLineWidth, minorIsoLineWidth);
        updateFloatArrAttr(AgNclassValues, classValues);
        updateFloatAttr(AgNminClass, minClass);
        updateFloatAttr(AgNmaxClass, maxClass);
        updateIntAttr(AgNnumClasses, numClasses);
">;
    };

    // Parent for low level graphics primitives can connect to all
    AGGeometryPrimitive AGGraphics
      <NEnumColors=4,NEcolor1=AG_DATAOBJ_COLOR,
      NEcolor2=AG_VIEWPORT_COLOR,NEcolor3=AG_WORLD_COLOR,export=0> {
        int connectToViewport<NEvisible=0, export=0> =         1;
        int connectToWorld<NEvisible=0, export=0> =            1;
        int connectToPolarWorld<NEvisible=0, export=0> =       1;
        int connectToGraphViewport<NEvisible=0, export=0> =    1;
        int connectToGraphWorld<NEvisible=0, export=0> =       1;
        int connectToContourViewport<NEvisible=0, export=0> =  1;
        int connectToContourWorld<NEvisible=0, export=0> =     1;
    };

    // Axis objects can connect to any world
    AGPrimitive+AGConnectToWorldPort AGAxis
      <export=0>{
        int connectToWorld<NEvisible=0, export=0> =            1;
        int connectToGraphWorld<NEvisible=0, export=0> =       1;
        int connectToContourWorld<NEvisible=0, export=0> =     1;
    };
    // Polar axis objects can connect to any polar world
    AGPrimitive+AGConnectToPolarWorldPort AGPolarAxis
      <export=0>{
        int connectToPolarWorld<NEvisible=0, export=0> =       1;
        int connectToPolarGraphWorld<NEvisible=0, export=0> =  1;
    };
};

//
// Define all the "real" objects with default values grouped into libraries
//

library+global+sort Basic<indexed=1> {

    //
    // Special data object needed to connect to a 2D camera (2D viewer)
    //
    macro AGDataObject {
        AGGeometryPrimitive &in<NEportLevels={2,1}, NEnumColors=2,
        NEcolor0=AG_COLOR, NEcolor1=AG_DATAOBJ_COLOR, NEy=55, NEx=55> {
            data_method render;
        };
        DefaultLinear Datamap<NEy=132, NEx=77> {
            dataMin => <-.DefaultMinMax.min_value;
            dataMax => <-.DefaultMinMax.max_value;
        };
        DefaultMinMax DefaultMinMax<NEx=231,NEy=55> {
            input+Node_Data<NEportLevels={3,0}>;
        };
        DefaultProps Props<NEportLevels={0,1}, NEy=143, NEx=308> {
            inherit = 0;
        };
        DefaultObject Obj<NEportLevels={0,1}, NEy=352, NEx=77,
                                     NEdisplayMode="NEclosed"> {
            input  => in;
            dmap   => <-.Datamap;
            xform  => <-.Xform;
            props  => <-.Props;
            modes  => <-.Modes;
            pick_info  => <-.PickInfo;
            string name => name_of(<-.<-);
        };
        olink obj<NEy=352, NEx=297>  => Obj;
        DefaultModes Modes<NEportLevels={0,1}, NEy=110, NEx=363>;
        DefaultXform Xform<NEportLevels={0,1}, NEy=176, NEx=253>;
        DefaultPickInfo PickInfo<NEportLevels={0,1}, NEy=77, NEx=429>;
    };

    AGGeometryPrimitive+AGViewportParams AGViewport
        <cxx_class="AgViewport",NEnumColors=2,NEcolor1=AG_DATAOBJ_COLOR>
    {

	className =     "AGViewport";

        fillColor =     "transparent";
        geometry =      {-3,-3,3,3};

        AGPrimitive+AGConnectToViewportPort+IPort2+read &children[] {
            int connectToViewport<NEvisible=0, export=0> = 1;
            priority-write+read;
        };

        cxxmethod+notify_inst+notify_val  update = 
            geometryUpdCode+viewportParamsCode+
<"
        attach(children);
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGViewportObj {
        AGDataObject dataObject {
            in => <-.viewport;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGViewport viewport {
            children+IPort3;
        };
    };


    AGPrimitive+AGConnectToViewportPort+AGWorldParams AGWorld
        <cxx_class="AgWorld">
    {

	className =     "AGWorld";

        axleColor =         "antibackground";
        axleWidth =         0.5;
        labelColor =        "antibackground";
        labelFont =         "roman-simplex";
        labelHeight =       3.5;
        majorTickColor =    "antibackground";
        majorTickLineStyle= "solid";
        majorTickOn =       1;
        majorTickWidth =    0.5;
        minorTickColor  =   "grey";
        minorTickCount =    0;
        minorTickLineStyle= "dashed";
        minorTickWidth =    0.25;
        niceLimits =        1;
        textColor =         "antibackground";
        textFont =          "sw:roman-complex";

        int connectToViewport<NEvisible=0, export=0> = 1;
        AGPrimitive+AGConnectToWorldPort+IPort2+read &children[] {
            int connectToWorld<NEvisible=0, export=0> = 1;
            priority-write+read;
        };

        cxxmethod+notify_inst+notify_val  update = updCode+worldParamsCode+
<"
        attach(children);
        primitive->updateAttr();
        return(1);
">;
    };

    AGPrimitive+AGConnectToViewportPort+AGPolarWorldParams AGPolarWorld
        <cxx_class="AgPolarWorld">
    {

	className =     "AGPolarWorld";

        axleColor =         "antibackground";
        axleWidth =         0.5;
        labelColor =        "antibackground";
        labelFont =         "roman-simplex";
        labelHeight =       3.5;
        majorTickColor =    "antibackground";
        majorTickLineStyle= "solid";
        majorTickOn =       1;
        majorTickWidth =    0.5;
        minorTickColor  =   "grey";
        minorTickCount =    0;
        minorTickLineStyle= "dashed";
        minorTickWidth =    0.25;
        textColor =         "antibackground";
        textFont =          "sw:roman-complex";

        int connectToViewport<NEvisible=0, export=0> = 1;
        AGPrimitive+AGConnectToPolarWorldPort+IPort2+read &children[] {
            int connectToPolarWorld<NEvisible=0, export=0> = 1;
            priority-write+read;
        };

        cxxmethod+notify_inst+notify_val  update = updCode+polarWorldParamsCode+
<"
        attach(children);
        primitive->updateAttr();
        return(1);
">;
    };

    // Combine two scalar/array connectToWorlds into one array
    macro AGCombineWorldInput {
        AGPrimitive+IPort2+AGConnectToWorldPort &input1[] {
            int connectToWorld<NEvisible=0, export=0> = 1;
        };
        mlink+IPort2 input2;
        AGPrimitive+AGConnectToWorldPort &temp2[] {
            int connectToWorld<NEvisible=0, export=0> = 1;
        } => input2;
        AGPrimitive+OPort2+AGConnectToWorldPort &output[] 
            => combine_array(input1, temp2);
    };

    AGGraphics AGPoints
        <cxx_class="AgPoints">
    {

	className =     "AGPoints";

        geometry+IPort2 =
                {{0,-2},{2,2},{-2,-1},{3,0},{-1,2},{0,-2}};

        AGColor         color =         "antibackground";
        AGDistance      diameter =      1.0;

        cxxmethod+notify_inst+notify_val  update = geometryUpdCode +
<"
        updateColorAttr(AgNcolor, color);
        updateDistanceAttr(AgNdiameter, diameter);
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGPointsObj {
        AGDataObject dataObject {
            in => <-.points;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGPoints+OPort2 points {
            geometry+IPort3;
        };
    };

    AGGraphics AGArrow
        <cxx_class="AgArrow">
    {

	className =     "AGArrow";

        geometry+IPort2 =               {0,0,1,0};

        AGColor         color =         "antibackground";
        AGDistance      width =         0.5;

        cxxmethod+notify_inst+notify_val  update = geometryUpdCode +
<"
        updateColorAttr(AgNcolor, color);
        updateDistanceAttr(AgNwidth, width);
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGArrowObj {
        AGDataObject dataObject {
            in => <-.arrow;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGArrow+OPort2 arrow {
            geometry+IPort3;
        };
    };

    AGGraphics AGLine
        <cxx_class="AgLine">
    {

	className =     "AGLine";

        geometry+IPort2 =               {-2,-2,2,2};

        AGColor         color =         "antibackground";
        AGLineStyle     lineStyle =     "solid";
        AGDistance      width =         0.25;

        cxxmethod+notify_inst+notify_val  update = geometryUpdCode +
<"
        updateColorAttr(AgNcolor, color);
        updateDistanceAttr(AgNwidth, width);
        updateLineStyleAttr(AgNlineStyle, lineStyle);
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGLineObj {
        AGDataObject dataObject {
            in => <-.line;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGLine+OPort2 line {
            geometry+IPort3;
        };
    };

    AGGraphics AGRectangle
        <cxx_class="AgRectangle">
    {

	className =     "AGRectangle";

        geometry+IPort2 =               {-2,-2, 2,2};

        AGColor         fillColor =     "transparent";
        AGColor         frameColor =    "antibackground";
        AGDistance      frameWidth =    0.25;

        cxxmethod+notify_inst+notify_val  update = geometryUpdCode +
<"
        updateColorAttr(AgNframeColor, frameColor);
        updateColorAttr(AgNfillColor, fillColor);
        updateDistanceAttr(AgNframeWidth, frameWidth);
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGRectangleObj {
        AGDataObject dataObject {
            in => <-.rectangle;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGRectangle+OPort2 rectangle {
            geometry+IPort3;
        };
    };

    AGGraphics AGPolygon
      <cxx_class="AgPolygon"> {

	className =     "AGPolygon";

        geometry+IPort2 =  {-2,0, 2,0, 0,2, 0,-2, -2,0};

        AGColor         fillColor =     "transparent";
        AGColor         frameColor =    "antibackground";
        AGDistance      frameWidth =    0.25;

        cxxmethod+notify_inst+notify_val  update = geometryUpdCode +
<"
        updateColorAttr(AgNframeColor, frameColor);
        updateColorAttr(AgNfillColor, fillColor);
        updateDistanceAttr(AgNframeWidth, frameWidth);
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGPolygonObj {
        AGDataObject dataObject {
            in => <-.polygon;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGPolygon+OPort2 polygon {
            geometry+IPort3;
        };
    };

    AGGraphics AGEllipse
      <cxx_class="AgEllipse"> {

	className =     "AGEllipse";

        geometry+IPort2 =               {2,0,0,2};

        AGColor         fillColor =     "transparent";
        AGColor         frameColor =    "antibackground";
        AGDistance      frameWidth =    0.25;

        cxxmethod+notify_inst+notify_val  update = geometryUpdCode +
<"
        updateColorAttr(AgNfillColor, fillColor);
        updateColorAttr(AgNframeColor, frameColor);
        updateDistanceAttr(AgNframeWidth, frameWidth);
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGEllipseObj {
        AGDataObject dataObject {
            in => <-.ellipse;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGEllipse+OPort2 ellipse {
            geometry+IPort3;
        };
    };

    AGGraphics AGArc
      <cxx_class="AgArc"> {

	className =     "AGArc";

        geometry+IPort2 =                       {2,0,0,2};

        AGColor         fillColor =             "transparent";
        AGColor         frameColor =            "antibackground";
        AGDistance      frameWidth =            0.25;
        AGFloat         arcAngleInterval[2] =   {-45.0,45.0};
        AGArcTypeEnum   arcType =               "line";

        cxxmethod+notify_inst+notify_val  update = geometryUpdCode +
<"
        updateColorAttr(AgNfillColor, fillColor);
        updateColorAttr(AgNframeColor, frameColor);
        updateDistanceAttr(AgNframeWidth, frameWidth);
        updateEnumAttr(AgNarcType, arcType);
        updateFloatArrAttr(AgNangleInterval, arcAngleInterval);
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGArcObj {
        AGDataObject dataObject {
            in => <-.arc;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGArc+OPort2 arc {
            geometry+IPort3;
        };
    };

    AGGraphics+AGTextParams AGText
      <cxx_class="AgText"> {

	className =     "AGText";

        font =                          "roman-simplex";
        geometry+IPort2 =               {0,0};
        text+IPort2[] =                 {"text"};

        AGFloat         angle =         0.0;
        AGDistance      height =        3.0;

        cxxmethod+notify_inst+notify_val  update = 
            geometryUpdCode + textParamsCode +
<"
        updateDistanceAttr(AgNheight, height);
        updateFloatAttr(AgNangle, angle);
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGTextObj {
        AGDataObject dataObject {
            in => <-.text;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGText+OPort2 text {
            geometry+IPort3;
            text+IPort3;
        };
    };

    AGGraphics+AGTextParams AGTransformableText
      <cxx_class="AgTransformableText"> {

	className =     "AGTransformableText";

        geometry+IPort2 =               {0,0};
        font =                          "sw:roman-simplex";
        text+IPort2[] =                 {"transformable text"};

        AGGeometry      upVector =      {0,0.3};

        cxxmethod+notify_inst+notify_val  update = 
            geometryUpdCode + textParamsCode +
<"
        updateGeometryAttr(AgNupVector, upVector);
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGTransformableTextObj {
        AGDataObject dataObject {
            in => <-.transformableText;
            obj<NEportLevels={1,3}>{
                name => name_of(<-.<-.<-);
            };
        };
        AGTransformableText+OPort2 transformableText {
            geometry+IPort3;
            text+IPort3;
        };
    };

    AGGraphics+AGTextParams AGRestrictedText
      <cxx_class="AgRestrictedText"> {

	className =     "AGRestrictedText";

        geometry+IPort2 =               {0,0};
        font =                          "sw:roman-simplex";
        frameWidth =                    0.25;
        text+IPort2[] =                 {"restricted text"};

        AGGeometry      upVector =      {0,0.3};
        AGGeometry      baseVector =    {2,0};

        cxxmethod+notify_inst+notify_val  update = 
            geometryUpdCode + textParamsCode +
<"
        updateGeometryAttr(AgNupVector, upVector);
        updateGeometryAttr(AgNbaseVector, baseVector);
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGRestrictedTextObj {
        AGDataObject dataObject {
            in => <-.restrictedText;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGRestrictedText+OPort2 restrictedText {
            geometry+IPort3;
            text+IPort3;
        };
    };
};

library+global+sort Axes<indexed=1> {

    AGAxis+AGAxisParams+AGTickXParams AGXAxis
      <cxx_class="AgXAxis"> {

	className =     "AGXAxis";

        AGInt                   labelDecimals;
        AGLabelModeEnum         labelMode =     "normal";
        AGInt                   labelPowerFactor;
        AGFloat                 positionY;
        AGString                text =          "X axis";

        cxxmethod+notify_inst+notify_val  update =
            updCode+axisParamsCode+tickXParamsCode +
<"
        updateEnumAttr(AgNlabelMode, labelMode);
        updateStringAttr(AgNtext, text);
        updateIntAttr(AgNlabelDecimals, labelDecimals);
        updateIntAttr(AgNlabelPowerFactor, labelPowerFactor);
        updateFloatAttr(AgNpositionY, positionY);
        primitive->updateAttr();
        return(1);
">;
   };

    AGAxis+AGAxisParams+AGTickYParams AGYAxis
      <cxx_class="AgYAxis"> {

	className =     "AGYAxis";

        AGInt                   labelDecimals;
        AGLabelModeEnum         labelMode =     "normal";
        AGInt                   labelPowerFactor;
        AGFloat                 positionX;
        AGString                text =          "Y axis";

        cxxmethod+notify_inst+notify_val  update =
            updCode+axisParamsCode+tickYParamsCode +
<"
        updateEnumAttr(AgNlabelMode, labelMode);
        updateStringAttr(AgNtext, text);
        updateIntAttr(AgNlabelDecimals, labelDecimals);
        updateIntAttr(AgNlabelPowerFactor, labelPowerFactor);
        updateFloatAttr(AgNpositionX, positionX);
        primitive->updateAttr();
        return(1);
">;
    };

    AGAxis+AGAxisParams+AGTickXParams AGXUserAxis
      <cxx_class="AgXUserAxis"> {

	className =     "AGXUserAxis";

        AGLabelModeEnum         labelMode =     "normal";
        AGLabelPositionEnum     labelPosition = "intervals";
        AGString                labelStrings[] = 
            {"label1", "label2", "label3", "label4", "label5"};
        AGFloat                 positionY;
        AGString                text =          "X user axis";

        cxxmethod+notify_inst+notify_val  update =
            updCode+axisParamsCode+tickXParamsCode +
<"
        updateEnumAttr(AgNlabelMode, labelMode);
        updateStringAttr(AgNtext, text);
        updateFloatAttr(AgNpositionY, positionY);
        updateEnumAttr(AgNlabelPosition, labelPosition);
        updateStringArrAttr(AgNlabelStrings, labelStrings);
        primitive->updateAttr();
        return(1);
">;
    };

    AGAxis+AGAxisParams+AGTickYParams AGYUserAxis
      <cxx_class="AgYUserAxis"> {

	className =     "AGYUserAxis";

        AGLabelModeEnum         labelMode =     "normal";
        AGLabelPositionEnum     labelPosition = "intervals";
        AGString                labelStrings[] =
            {"label1", "label2", "label3", "label4", "label5"};
        AGFloat                 positionX;
        AGString                text =          "Y user axis";

        cxxmethod+notify_inst+notify_val  update = 
            updCode+axisParamsCode+tickYParamsCode +
<"
        updateEnumAttr(AgNlabelMode, labelMode);
        updateStringAttr(AgNtext, text);
        updateFloatAttr(AgNpositionX, positionX);
        updateEnumAttr(AgNlabelPosition, labelPosition);
        updateStringArrAttr(AgNlabelStrings, labelStrings);
        primitive->updateAttr();
        return(1);
">;
    };

    AGAxis+AGTickParams+AGTickXParams AGXTicklines
      <cxx_class="AgXTicklines"> {

	className =     "AGXTicklines";

        cxxmethod+notify_inst+notify_val  update =
            updCode+tickParamsCode+tickXParamsCode +
<"
        primitive->updateAttr();
        return(1);
">;
    };

    AGAxis+AGTickParams+AGTickYParams AGYTicklines
      <cxx_class="AgYTicklines"> {

	className =     "AGYTicklines";

        cxxmethod+notify_inst+notify_val  update = 
            updCode+tickParamsCode+tickYParamsCode +
<"
        primitive->updateAttr();
        return(1);
">;
    };

    AGPolarAxis+AGAxisParams+AGTickRParams AGPolarRAxis
      <cxx_class="AgPolarRAxis"> {

	className =     "AGPolarRAxis";

        AGInt                   labelDecimals;
        AGLabelModeEnum         labelMode =     "right";
        AGInt                   labelPowerFactor;
        AGFloat                 positionT;
        AGString                text =          "R axis";

        cxxmethod+notify_inst+notify_val  update =
            updCode+axisParamsCode+tickRParamsCode +
<"
        updateEnumAttr(AgNlabelMode, labelMode);
        updateStringAttr(AgNtext, text);
        updateIntAttr(AgNlabelDecimals, labelDecimals);
        updateIntAttr(AgNlabelPowerFactor, labelPowerFactor);
        updateFloatAttr(AgNpositionT, positionT);
        primitive->updateAttr();
        return(1);
">;
   };

    AGPolarAxis+AGAxisParams+AGTickTParams AGPolarTAxis
      <cxx_class="AgPolarTAxis"> {

	className =     "AGPolarTAxis";

        AGInt                   labelDecimals;
        AGLabelModeEnum         labelMode =     "right";
        AGInt                   labelPowerFactor;
        AGFloat                 positionR;
        AGString                text =          "T axis";

        cxxmethod+notify_inst+notify_val  update =
            updCode+axisParamsCode+tickTParamsCode +
<"
        updateEnumAttr(AgNlabelMode, labelMode);
        updateStringAttr(AgNtext, text);
        updateIntAttr(AgNlabelDecimals, labelDecimals);
        updateIntAttr(AgNlabelPowerFactor, labelPowerFactor);
        updateFloatAttr(AgNpositionR, positionR);
        primitive->updateAttr();
        return(1);
">;
    };

    AGPolarAxis+AGTickParams+AGTickRParams AGPolarRTicklines
      <cxx_class="AgPolarRTicklines"> {

	className =     "AGPolarRTicklines";

        cxxmethod+notify_inst+notify_val  update =
            updCode+tickParamsCode+tickRParamsCode +
<"
        primitive->updateAttr();
        return(1);
">;
    };

    AGPolarAxis+AGTickParams+AGTickTParams AGPolarTTicklines
      <cxx_class="AgPolarTTicklines"> {

	className =     "AGPolarTTicklines";

        cxxmethod+notify_inst+notify_val  update = 
            updCode+tickParamsCode+tickTParamsCode +
<"
        primitive->updateAttr();
        return(1);
">;
    };

    // 2D axis system to use with a 2D field
    macro AG2DAxisFieldObj<NEx=286,NEy=187,NEwidth=264,NEheight=286> {
        FLD.Grid &Grid<NEx=22,NEy=33,NEportLevels={2,0}> {
           coordinates {
              min_vec<NEportLevels={0,3}>;
              max_vec<NEportLevels={0,3}>;
           };
        };
        float &minVec<NEportLevels=1,NEx=187,NEy=33>[2] => 
            .Grid.coordinates.min_vec;
        float &maxVec<NEportLevels=1,NEx=374,NEy=33>[2] => 
            .Grid.coordinates.max_vec;
        AGViewportObj AGViewportObj<NEx=22,NEy=352> {
           dataObject {
              obj<NEportLevels={1,4}> {
		 name => name_of(<-.<-.<-.<-);
	      };
           };
           viewport {
              children => {<-.<-.AGWorld};
              geometry<NEportLevels={3,0}> => <-.<-.extent;
           };
        };
        AGWorld AGWorld<NEx=22,NEy=286> {
           limitsX<NEportLevels={2,0}> => <-.limitsX;
           limitsY<NEportLevels={2,0}> => <-.limitsY;
           children => {<-.AGXAxis,
              <-.AGYAxis,<-.AGXTicklines,<-.AGYTicklines};
        };
        float &extent<NEportLevels=1,NEx=374,NEy=99>[2][2] => {minVec[0],
           minVec[1],maxVec[0],maxVec[1]};
        float &limitsX<NEportLevels=1,NEx=22,NEy=99>[2] => {minVec[0],
           maxVec[0]};
        float &limitsY<NEportLevels=1,NEx=187,NEy=99>[2] => {minVec[1],
           maxVec[1]};
        AGXAxis AGXAxis<NEx=187,NEy=286> {
           text = "X-Axis";
        };
        AGYAxis AGYAxis<NEx=187,NEy=352> {
           text = "Y-Axis";
        };
        AGXTicklines AGXTicklines<NEx=374,NEy=286>;
        AGYTicklines AGYTicklines<NEx=374,NEy=352>;
     };
};

library+global+sort Graphing<indexed=1> {

    AGViewport+AGGraphParams+AGGraphListParams AGGraphViewport
      <cxx_class="AgGraphViewport"> {

	className =     "AGGraphViewport";

        barOffsets =        {0.4, 0.2, 0.0, -0.2, -0.4};
        barWidth =          0.35;
        barFrameWidth =     0.25;
        fillColor =         "background";
        graphColors =       {"red","green","cyan","orange","purple",
                             "yellow", "brown", "turquoise", "magenta"};
        graphType =         "curve";
        lineStyle =         "solid";
        lineWidth =         1.0;
        scatterSymbols =    {"`25001","`25012","`25013","`25018", 
                            "`25004","`25008","`25005","`25002"};
        shiftPosition =     0.0;
        symbolFont =        "roman-simplex";
        symbolHeight =      3.0;

        AGPrimitive+AGConnectToGraphViewportPort+IPort2+read &children[] {
            int connectToGraphViewport<NEvisible=0, export=0> = 1;
            priority-write+read;
        };

        cxxmethod+notify_inst+notify_val  update2 = 
            updCode + graphParamsCode + graphListParamsCode +
<"
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGGraphViewportObj {
        AGDataObject dataObject {
            in => <-.graphViewport;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGGraphViewport graphViewport {
            children+IPort3;
        };
    };

    AGWorld+AGConnectToGraphViewportPort+AGGraphParams+AGGraphListParams 
        AGGraphWorld<cxx_class="AgGraphWorld"> {

	className =     "AGGraphWorld";

        AGFloat                 powerExponent = 0.27;
        AGScaleTypeEnum         scaleTypeX =    "linear";
        AGScaleTypeEnum         scaleTypeY =    "linear";

        connectToViewport = 0;
        int connectToGraphViewport<NEvisible=0, export=0> = 1;
        AGPrimitive+AGConnectToGraphWorldPort+IPort2+read &children[] {
            int connectToGraphWorld<NEvisible=0, export=0> = 1;
            priority-write+read;
        };

        cxxmethod+notify_inst+notify_val  update2 = 
            updCode+graphParamsCode+graphListParamsCode +
<"
        updateEnumAttr(AgNscaleTypeX, scaleTypeX);
        updateEnumAttr(AgNscaleTypeY, scaleTypeY);
        updateFloatAttr(AgNpowerExponent, powerExponent);
        primitive->updateAttr();
        return(1);
">;
    };

    // Combine two scalar/array connectToWorlds into one array
    macro AGCombineGraphWorldInput {
        AGPrimitive+IPort2+AGConnectToGraphWorldPort &input1[] {
            int connectToGraphWorld<NEvisible=0, export=0> = 1;
        };
        mlink+IPort2 input2;
        AGPrimitive+AGConnectToGraphWorldPort &temp2[] {
            int connectToGraphWorld<NEvisible=0, export=0> = 1;
        } => input2;
        AGPrimitive+OPort2+AGConnectToGraphWorldPort &output[] 
            => combine_array(input1, temp2);
    };

    AGPolarWorld+AGConnectToGraphViewportPort+
        AGPolarGraphParams+AGPolarGraphListParams 
        AGPolarGraphWorld<cxx_class="AgPolarGraphWorld"> {

	className =     "AGPolarGraphWorld";

        connectToViewport = 0;
        int connectToGraphViewport<NEvisible=0, export=0> = 1;
        AGPrimitive+AGConnectToPolarGraphWorldPort+IPort2+read &children[] {
            int connectToPolarGraphWorld<NEvisible=0, export=0> = 1;
            priority-write+read;
        };

        cxxmethod+notify_inst+notify_val  update2 = 
            updCode+polarGraphParamsCode+polarGraphListParamsCode +
<"
        primitive->updateAttr();
        return(1);
">;
    };

    // Combine two scalar/array connectToWorlds into one array
    macro AGCombinePolarGraphWorldInput {
        AGPrimitive+IPort2+AGConnectToPolarGraphWorldPort &input1[] {
            int connectToPolarGraphWorld<NEvisible=0, export=0> = 1;
        };
        mlink+IPort2 input2;
        AGPrimitive+AGConnectToPolarGraphWorldPort &temp2[] {
            int connectToPolarGraphWorld<NEvisible=0, export=0> = 1;
        } => input2;
        AGPrimitive+OPort2+AGConnectToPolarGraphWorldPort &output[] 
            => combine_array(input1, temp2);
    };

    AGPrimitive+AGConnectToGraphWorldPort+AGGraphParams AGGraph
      <cxx_class="AgGraph"> {

        int isGraph<NEvisible=0, export=0> = 1;

	className =     "AGGraph";

        AGFloat                 barOffset;
        AGFloat+IPort2          baseValuesY[];
        AGColor                 color;
        AGString+IPort2         legendText =>   name_of(<-);
        AGColor                 negativeColor;
        AGFloat+IPort2          valuesX[];
        AGFloat+IPort2          valuesY[] =     {0.1,2,3,2,2,4,5,3,2,3};

        int connectToWorld<NEvisible=0, export=0> = 0;
        int connectToGraphWorld<NEvisible=0, export=0> = 1;

        cxxmethod+notify_inst+notify_val  update = updCode+graphParamsCode +
<"
        updateColorAttr(AgNcolor, color);
        updateColorAttr(AgNnegativeColor, negativeColor);
        updateStringAttr(AgNlegendText, legendText);
        updateFloatAttr(AgNbarOffset, barOffset);
        updateFloatArrAttr(AgNvaluesX, valuesX);
        updateFloatArrAttr(AgNvaluesY, valuesY);
        updateFloatArrAttr(AgNbaseValuesY, baseValuesY);
        primitive->updateAttr();
        return(1);
">;
    };

    AGPrimitive+AGConnectToPolarGraphWorldPort+AGPolarGraphParams AGPolarGraph
      <cxx_class="AgPolarGraph"> {

        int isGraph<NEvisible=0, export=0> = 1;

	className =     "AGPolarGraph";

        AGColor                 color;
        AGString+IPort2         legendText =>   name_of(<-);
        AGFloat+IPort2          valuesR[] =     {0.1,2,3,2,2,4,5,3,2,3};
        AGFloat+IPort2          valuesT[];

        int connectToPolarWorld<NEvisible=0, export=0> = 0;
        int connectToPolarGraphWorld<NEvisible=0, export=0> = 1;

        cxxmethod+notify_inst+notify_val  update = 
            updCode+polarGraphParamsCode +
<"
        updateColorAttr(AgNcolor, color);
        updateStringAttr(AgNlegendText, legendText);
        updateFloatArrAttr(AgNvaluesR, valuesR);
        updateFloatArrAttr(AgNvaluesT, valuesT);
        primitive->updateAttr();
        return(1);
">;
    };

    AGGeometryPrimitive+AGConnectToGraphViewportPort AGGraphLegend
      <NEnumColors=4,NEcolor2=AG_DATAOBJ_COLOR,
      NEcolor3=AG_VIEWPORT_COLOR,
      cxx_class="AgGraphLegend",
      cxx_members=
<"
      protected:
        void attachGraphsToLegend();
"> 
      > {

	className =     "AGGraphLegend";

        geometry =   {0,0};

        AGColor         fillColor =     "background";
        AGColor         frameColor =    "antibackground";
        AGDistance      frameWidth =    0.25;
        AGFont          labelFont =     "roman-simplex";
        AGDistance      labelHeight =   2.7;
        AGColor		labelColor = 	"antibackground";
        AGInt           numColumns =    1;
        AGString        title =         "Legend";
        AGFont          titleFont =     "roman-simplex";
        AGDistance      titleHeight =   3.0;
        AGColor		titleColor =    "antibackground";

        int connectToViewport<NEvisible=0, export=0> = 0;
        int connectToGraphViewport<NEvisible=0, export=0> = 1;

        AGPrimitive+IPort2+read+opt &graphs[] {
            int isGraph<NEvisible=0, export=0> = 1;
            priority-write+read;
        };

        cxxmethod+notify_inst+notify_val  update = geometryUpdCode +
<"
        updateColorAttr(AgNfillColor, fillColor);
        updateColorAttr(AgNframeColor, frameColor);
        updateDistanceAttr(AgNframeWidth, frameWidth);
        updateIntAttr(AgNnumColumns, numColumns);
        updateStringAttr(AgNtitle, title);
        updateDistanceAttr(AgNtitleHeight, titleHeight);
        updateFontAttr(AgNtitleFont, titleFont);
        updateColorAttr(AgNtitleColor, titleColor);
        updateDistanceAttr(AgNlabelHeight, labelHeight);
        updateFontAttr(AgNlabelFont, labelFont);
        updateColorAttr(AgNlabelColor, labelColor);
        attachGraphsToLegend();
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGGraphLegendObj {
        AGDataObject dataObject {
            in => <-.graphLegend;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGGraphLegend+OPort2 graphLegend {
            graphs+IPort3;
        };
    };


    // Special AGGraph which tells what index it is in an array
    AGGraph AGGraphInArray<export_cxx=1> {
	int indexOf;
    };

    // Create graphs from fields
    macro AGGraphFieldObj {
        imlink in_field<NEx=55,NEy=22>;
        FLD_MAP.Array_Extractors.extract_data_array 
            extract_data_array<NEx=55,NEy=110>[array_size(in_field)] {
            in => <-.in_field[index_of(extract_data_array)];
        };
	AGGraphInArray 
            graphs<NEvisible=0, NEx=55,NEy=187>[array_size(in_field)] {
            valuesY => <-.extract_data_array[index_of(graphs)].data;
            // Please note the little +"" trick which ensures the field
            // label will not be changed when legendText is changed
            legendText => <-.extract_data_array[index_of(graphs)].label+"";
	    indexOf => index_of(graphs);
        };
        AGXAxis AGXAxis<NEx=253,NEy=187> {
            minorTickCount => AGXTicklines.minorTickCount;
            minorTickLineStyle => AGXTicklines.minorTickLineStyle;
            minorTickColor => AGXTicklines.minorTickColor;
            minorTickWidth => AGXTicklines.minorTickWidth;
            majorTickLineStyle => AGXTicklines.majorTickLineStyle;
            majorTickColor => AGXTicklines.majorTickColor;
            majorTickWidth => AGXTicklines.majorTickWidth;
        };
        AGYAxis AGYAxis<NEx=253,NEy=253> {
            minorTickCount => AGYTicklines.minorTickCount;
            minorTickLineStyle => AGYTicklines.minorTickLineStyle;
            minorTickColor => AGYTicklines.minorTickColor;
            minorTickWidth => AGYTicklines.minorTickWidth;
            majorTickLineStyle => AGYTicklines.majorTickLineStyle;
            majorTickColor => AGYTicklines.majorTickColor;
            majorTickWidth => AGYTicklines.majorTickWidth;
        };
        AGYTicklines AGYTicklines<NEx=253,NEy=286>;
        AGXTicklines AGXTicklines<NEx=253,NEy=220> {
            visibility = 0;
        };
        AGCombineGraphWorldInput combineGraphWorldInput<NEx=55,NEy=286> {
            input1 => <-.graphs;
            input2 => {<-.AGXAxis,<-.AGXTicklines,<-.AGYAxis,<-.AGYTicklines};
        };
        AGGraphWorld graphWorld<NEx=55,NEy=352> {
            children => <-.combineGraphWorldInput.output;
        };
        AGGraphLegend graphLegend<NEx=253,NEy=352> {
            graphs => <-.graphs;
            geometry = {5.1,-5};
            labelHeight = 2.7;
        };
        AGText graphTitle<NEx=253,NEy=418> {
            visibility = 0;
            geometry = {0,5.5};
            verticalJustification = "bottom";
            text = {"Title"};
            font = "Helvetica";
            height = 5;
        };
        AGGraphViewport graphViewport<NEx=55,NEy=418> {
            children => {<-.graphWorld,<-.graphLegend,<-.graphTitle};
        };
        AGDataObject dataObject<NEx=55,NEy=473> {
            in => <-.graphViewport;
            obj<NEportLevels={1,3}> {
	       name => name_of(<-.<-.<-);
            };
        };
    };
    AGGraphics AGPieChart
#ifdef AG_KIT_NO_PIECHART
	<NEvisible=0, export=0>;
#else
        <cxx_class="AgPieChart">
    {

	className =     "AGPieChart";

        geometry+IPort2 =
                {{0,0}};

        AGFloat                 angleInterval[2] =      {0.0,360.0};
        AGColor                 arrowColor = 		"antibackground";
        AGColor                 colors[] = {"red","green","cyan","orange",
                                            "purple", "yellow", "brown", 
                                            "turquoise", "magenta"};
        AGDistance              diameter =              80.0;
        AGDistance              explodeOffset =         5.0;
        AGColor                 frameColor =            "antibackground";
        AGDistance              frameWidth =            0.25;
        AGColor                 labelBoxFillColor = 	"background";
        AGColor                 labelBoxFrameColor = 	"antibackground";
        AGDistance              labelBoxFrameWidth = 	0.25;
        AGColor                 labelColor =    	"antibackground";
        AGPieLabelContentEnum   labelContent = 		"value";
        AGInt                   labelDecimals;
        AGFont                  labelFont =     	"Helvetica";
        AGDistance              labelHeight =    	2.7;
        AGPieLabelJustificationEnum labelJustification = "left";
        AGPieLabelPositionEnum  labelPosition = 	"circular";
        AGString                labelPrefix;
        AGString                labelStrings[];
        AGString                labelSuffix;
        AGFloat+IPort2          values[] =              {3,2,1.573,6.33,-2.5};


        cxxmethod+notify_inst+notify_val  update = geometryUpdCode +
<"
        updateColorArrAttr(AgNcolors, colors);
        updateDistanceAttr(AgNdiameter, diameter);
        updateFloatArrAttr(AgNangleInterval, angleInterval);
        updateDistanceAttr(AgNframeWidth, frameWidth);
        updateColorAttr(AgNframeColor, frameColor);
	updateDistanceAttr(AgNexplodeOffset, explodeOffset);
	updateFloatArrAttr(AgNvalues, values);
	updateDistanceAttr(AgNlabelHeight, labelHeight);
	updateColorAttr(AgNlabelColor, labelColor);
	updateFontAttr(AgNlabelFont, labelFont);
	updateStringArrAttr(AgNlabelStrings, labelStrings);
	updateEnumAttr(AgNlabelJustification, labelJustification);
	updateEnumAttr(AgNlabelPosition, labelPosition);
	updateEnumAttr(AgNlabelContent, labelContent);
	updateColorAttr(AgNlabelBoxFillColor, labelBoxFillColor);
	updateColorAttr(AgNlabelBoxFrameColor, labelBoxFrameColor);
	updateDistanceAttr(AgNlabelBoxFrameWidth, labelBoxFrameWidth);
	updateIntAttr(AgNlabelDecimals, labelDecimals);
	updateStringAttr(AgNlabelSuffix, labelSuffix);
	updateStringAttr(AgNlabelPrefix, labelPrefix);
        updateColorAttr(AgNarrowColor, arrowColor);

        primitive->updateAttr();
        return(1);
">;
    };

    macro AGPieChartObj {
        AGDataObject dataObject {
            in => <-.pieChart;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGPieChart+OPort2 pieChart {
            geometry+IPort3;
        };
    };
#endif

};

library+global+sort Contouring<indexed=1> {

    AGViewport+AGContourParams AGContourViewport
#ifdef AG_KIT_NO_CONTOUR
	<NEvisible=0, export=0>;
#else
        <cxx_class="AgContourViewport">
    {

	className =     "AGContourViewport";

        contourType =                   "filled contours";
        fillColor =                     "background";
        frameWidth =                    0.0;
        isoLineLabelAngleInterval[2] =  {90., -90.};
        isoLineLabelColor =             "antibackground";
        isoLineLabelDistance =          25;
        isoLineLabelFont =              "roman-simplex";
        isoLineLabelFrequency =         1;
        isoLineLabelHeight =            2.7;
        majorIsoLineColor =             "antibackground";
        majorIsoLineFrequency =         2;
        majorIsoLineReference =         1;
        majorIsoLineStyle =             "solid";
        majorIsoLineWidth =             0.5;
        minorIsoLineColor =             "grey";
        minorIsoLineStyle =             "dashed";
        minorIsoLineWidth =             0.35;
        numClasses =                    10;

        AGPrimitive+AGConnectToContourViewportPort+IPort2+read &children[] {
            int connectToContourViewport<NEvisible=0, export=0> = 1;
            priority-write+read;
        };

        cxxmethod+notify_inst+notify_val update2 = 
            updCode + contourParamsCode +
<"
        primitive->updateAttr();
        return(1);
">;
    };
    macro AGContourViewportObj {
        AGDataObject dataObject {
            in => <-.contourViewport;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
            DefaultMinMax {
                input<NEportLevels={4,0}>;
            };
        };
        AGContourViewport contourViewport {
            children+IPort3;
        };
    };
#endif

    AGWorld+AGConnectToContourViewportPort+AGContourParams AGContourWorld
#ifdef AG_KIT_NO_CONTOUR
	<NEvisible=0, export=0>;
#else
        <cxx_class="AgContourWorld">
    {

	className =     "AGContourWorld";

        clip =                  1;
        niceLimits =            0;
        uniformScaling =        1;

        connectToViewport = 0;
        int connectToContourViewport<NEvisible=0, export=0> = 1;
        AGPrimitive+AGConnectToContourWorldPort+IPort2+read &children[] {
            int connectToContourWorld<NEvisible=0, export=0> = 1;
            priority-write+read;
        };

        cxxmethod+notify_inst+notify_val update2 = 
            updCode+contourParamsCode +
<"
        primitive->updateAttr();
        return(1);
">;
    };

    // Combine two scalar/array connectToWorlds into one array
    macro AGCombineContourWorldInput {
        AGPrimitive+IPort2+AGConnectToContourWorldPort &input1[] {
            int connectToContourWorld<NEvisible=0, export=0> = 1;
        };
        mlink+IPort2 input2;
        AGPrimitive+AGConnectToContourWorldPort &temp2[] {
            int connectToContourWorld<NEvisible=0, export=0> = 1;
        } => input2;
        AGPrimitive+OPort2+AGConnectToContourWorldPort &output[] 
            => combine_array(input1, temp2);
    };
#endif

    AGPrimitive+AGConnectToContourWorldPort+AGContourParams AGContour
#ifdef AG_KIT_NO_CONTOUR
	<NEvisible=0, export=0>;
#else
      <cxx_class="AgContour",
      cxx_members=
<"
      protected:
        void updateField();
">
      > {

	className =     "AGContour";

        int connectToWorld<NEvisible=0, export=0> = 0;
        int connectToContourWorld<NEvisible=0, export=0> = 1;

        // Only allow 2D scalar uniform, rectilinear or structured field
        Mesh_Struct+Node_Data+Scalar+Dim2+IPort2+read &field;

        cxxmethod+notify_inst+notify_val update = updCode + contourParamsCode +
<"
        updateField();
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGContourObj {
        AGDataObject dataObject<NEx=220, NEy=230> {
            in => <-.contourViewport;
            DefaultMinMax {
                input => <-.<-.inField;
            };
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        ilink inField;
        AGContour+OPort2 contour {
            field => <-.inField;
        };
        macro combineContourWorldInput {
            AGPrimitive+IPort2 &input1[] {
                int connectToContourWorld<NEvisible=0, export=0> = 1;
            } => {<-.contour};
            mlink+IPort3 input2;
            AGPrimitive+AGConnectToContourWorldPort &temp2[] {
                int connectToContourWorld<NEvisible=0, export=0> = 1;
            } => input2;
            AGPrimitive+OPort2 &output[] => combine_array(input1, temp2);
        };
        AGContourWorld contourWorld {
            children => <-.combineContourWorldInput.output;
        };
        AGContourViewport contourViewport {
            children => {<-.contourWorld};
        };
    };
#endif

    AGGeometryPrimitive+AGConnectToContourViewportPort AGContourLegend
#ifdef AG_KIT_NO_CONTOUR
	<NEvisible=0, export=0>;
#else
      <NEnumColors=4,NEcolor2=AG_DATAOBJ_COLOR,
      NEcolor3=AG_VIEWPORT_COLOR,
      cxx_class="AgContourLegend",
      cxx_members=
<"
      protected:
        void attachContourToLegend();
">
      > {

	className =     "AGContourLegend";

        geometry =      {0,0};

        AGColor         fillColor =     "background";
        AGColor         frameColor =    "antibackground";
        AGDistance      frameWidth =    0.25;
        AGInt           labelDecimals;
        AGFont          labelFont =     "roman-simplex";
        AGDistance      labelHeight =   2.5;
        AGColor		labelColor = 	"antibackground";
        AGString        title =         "Legend";
        AGFont          titleFont =     "roman-simplex";
        AGDistance      titleHeight =   3.0;
        AGColor		titleColor = 	"antibackground";

        int connectToViewport<NEvisible=0, export=0> = 0;
        int connectToContourViewport<NEvisible=0, export=0> = 1;

        AGContour+IPort2+read+opt &contour {
            priority-write+read;
        };

        cxxmethod+notify_inst+notify_val  update = geometryUpdCode +
<"
        updateColorAttr(AgNfillColor, fillColor);
        updateColorAttr(AgNframeColor, frameColor);
        updateDistanceAttr(AgNframeWidth, frameWidth);
        updateStringAttr(AgNtitle, title);
        updateDistanceAttr(AgNtitleHeight, titleHeight);
        updateFontAttr(AgNtitleFont, titleFont);
        updateColorAttr(AgNtitleColor, titleColor);
        updateDistanceAttr(AgNlabelHeight, labelHeight);
        updateFontAttr(AgNlabelFont, labelFont);
        updateIntAttr(AgNlabelDecimals, labelDecimals);
        updateColorAttr(AgNlabelColor, labelColor);
        attachContourToLegend();
        primitive->updateAttr();
        return(1);
">;
    };

    macro AGContourLegendObj {
        AGDataObject dataObject {
            in => <-.contourLegend;
            obj<NEportLevels={1,3}> {
                name => name_of(<-.<-.<-);
            };
        };
        AGContourLegend+OPort2 contourLegend {
            contour+IPort3;
        };
    };
#endif
    macro AGContourFieldObj {
	link in_field<NEportLevels={2,1}>;

	AGContour AGContour {
	    field => <-.in_field;
	};
	AGText AGText {
            visibility = 0;
            geometry = {0,5.5};
            verticalJustification = "bottom";
            text = {"Title"};
            font = "Helvetica";
            height = 5;
	};
        AGXAxis AGXAxis<NEx=253,NEy=187> {
            minorTickCount => AGXTicklines.minorTickCount;
            minorTickLineStyle => AGXTicklines.minorTickLineStyle;
            minorTickColor => AGXTicklines.minorTickColor;
            minorTickWidth => AGXTicklines.minorTickWidth;
            majorTickLineStyle => AGXTicklines.majorTickLineStyle;
            majorTickColor => AGXTicklines.majorTickColor;
            majorTickWidth => AGXTicklines.majorTickWidth;
        };
        AGYAxis AGYAxis<NEx=253,NEy=253> {
            minorTickCount => AGYTicklines.minorTickCount;
            minorTickLineStyle => AGYTicklines.minorTickLineStyle;
            minorTickColor => AGYTicklines.minorTickColor;
            minorTickWidth => AGYTicklines.minorTickWidth;
            majorTickLineStyle => AGYTicklines.majorTickLineStyle;
            majorTickColor => AGYTicklines.majorTickColor;
            majorTickWidth => AGYTicklines.majorTickWidth;
        };
        AGYTicklines AGYTicklines<NEx=253,NEy=286>;
        AGXTicklines AGXTicklines<NEx=253,NEy=220> {
            visibility = 0;
        };
	AGContourWorld AGContourWorld {
	    children => {
		AGContour, AGXAxis, AGYAxis, AGXTicklines, AGYTicklines
	    };

	};
	AGContourLegend AGContourLegend {
	    contour => AGContour;
            geometry = {5.1,-5};
            labelHeight = 2.7;
	};
	AGContourViewport AGContourViewport {
	    children => { AGContourWorld, AGContourLegend, AGText};
	};
	AGDataObject AGDataObject {
	    in => <-.AGContourViewport;
	    DefaultMinMax {
	       input => <-.<-.in_field;
	    };
            obj<NEportLevels={1,3}> {
	       name => name_of(<-.<-.<-);
            };
	};
    };
};

library+global+sort User_Interface<indexed=1> {

    // GUI selector for the AG Kit GUI components
    group AGGUISelector {
	AGPrimitive+IPort2+read &agObj;

	int+OPort2+write isNotAGObj =     0;

	int+OPort2+write isAGArc =        0;
	int+OPort2+write isAGArrow =      0;
	int+OPort2+write isAGContour =    0;
	int+OPort2+write isAGContourLegend = 0;
	int+OPort2+write isAGContourViewport = 0;
	int+OPort2+write isAGContourWorld = 0;
	int+OPort2+write isAGEllipse =    0;
	int+OPort2+write isAGGraph = 0;
	int+OPort2+write isAGGraphLegend = 0;
	int+OPort2+write isAGGraphViewport = 0;
	int+OPort2+write isAGGraphWorld = 0;
	int+OPort2+write isAGLine =       0;
	int+OPort2+write isAGPieChart =   0;
	int+OPort2+write isAGPoints =     0;
	int+OPort2+write isAGPolarGraph = 0;
	int+OPort2+write isAGPolarGraphWorld = 0;
	int+OPort2+write isAGPolarRAxis = 0;
	int+OPort2+write isAGPolarRTicklines = 0;
	int+OPort2+write isAGPolarTAxis = 0;
	int+OPort2+write isAGPolarTTicklines = 0;
	int+OPort2+write isAGPolarWorld = 0;
	int+OPort2+write isAGPolygon =    0;
	int+OPort2+write isAGRectangle =  0;
	int+OPort2+write isAGRestrictedText = 0;
	int+OPort2+write isAGText =       0;
	int+OPort2+write isAGTransformableText = 0;
	int+OPort2+write isAGViewport =   0;
	int+OPort2+write isAGWorld =      0;
	int+OPort2+write isAGXAxis =      0;
	int+OPort2+write isAGXTicklines = 0;
	int+OPort2+write isAGXUserAxis =  0;
	int+OPort2+write isAGYAxis =      0;
	int+OPort2+write isAGYTicklines = 0;
	int+OPort2+write isAGYUserAxis =  0;

	int+nonotify              oldType => isNotAGObj;

        cxxmethod+notify_inst+notify  update = 
<"

        // Clear old type output port
        oldType = 0;

        if (agObj.changed(seq_num) && agObj.valid_obj()) {

           UtString name = (char*)agObj.className;

           // Set output flag based on picked object type 
           if (name == "AGArc") {
               oldType.set_obj_ref((OMobj_id)isAGArc);
               isAGArc = 1;
           }
           else if (name == "AGArrow") {
               oldType.set_obj_ref((OMobj_id)isAGArrow);
               isAGArrow = 1;
           }
           else if (name == "AGEllipse") {
               oldType.set_obj_ref((OMobj_id)isAGEllipse);
               isAGEllipse = 1;
           }
           else if (name == "AGLine") {
               oldType.set_obj_ref((OMobj_id)isAGLine);
               isAGLine = 1;
           }
           else if (name == "AGPoints") {
               oldType.set_obj_ref((OMobj_id)isAGPoints);
               isAGPoints = 1;
           }
           else if (name == "AGPolygon") {
               oldType.set_obj_ref((OMobj_id)isAGPolygon);
               isAGPolygon = 1;
           }
           else if (name == "AGRectangle") {
               oldType.set_obj_ref((OMobj_id)isAGRectangle);
               isAGRectangle = 1;
           }
           else if (name == "AGRestrictedText") {
               oldType.set_obj_ref((OMobj_id)isAGRestrictedText);
               isAGRestrictedText = 1;
           }
           else if (name == "AGText") {
               oldType.set_obj_ref((OMobj_id)isAGText);
               isAGText = 1;
           }
           else if (name == "AGTransformableText") {
               oldType.set_obj_ref((OMobj_id)isAGTransformableText);
               isAGTransformableText = 1;
           }
           else if (name == "AGViewport") {
               oldType.set_obj_ref((OMobj_id)isAGViewport);
               isAGViewport = 1;
           }
           else if (name == "AGWorld") {
               oldType.set_obj_ref((OMobj_id)isAGWorld);
               isAGWorld = 1;
           }
           else if (name == "AGPolarWorld") {
               oldType.set_obj_ref((OMobj_id)isAGPolarWorld);
               isAGPolarWorld = 1;
           }
           else if (name == "AGXAxis") {
               oldType.set_obj_ref((OMobj_id)isAGXAxis);
               isAGXAxis = 1;
           }
           else if (name == "AGXTicklines") {
               oldType.set_obj_ref((OMobj_id)isAGXTicklines);
               isAGXTicklines = 1;
           }
           else if (name == "AGPolarRAxis") {
               oldType.set_obj_ref((OMobj_id)isAGPolarRAxis);
               isAGPolarRAxis = 1;
           }
           else if (name == "AGPolarRTicklines") {
               oldType.set_obj_ref((OMobj_id)isAGPolarRTicklines);
               isAGPolarRTicklines = 1;
           }
           else if (name == "AGXUserAxis") {
               oldType.set_obj_ref((OMobj_id)isAGXUserAxis);
               isAGXUserAxis = 1;
           }
           else if (name == "AGYAxis") {
               oldType.set_obj_ref((OMobj_id)isAGYAxis);
               isAGYAxis = 1;
           }
           else if (name == "AGYTicklines") {
               oldType.set_obj_ref((OMobj_id)isAGYTicklines);
               isAGYTicklines = 1;
           }
           else if (name == "AGPolarTAxis") {
               oldType.set_obj_ref((OMobj_id)isAGPolarTAxis);
               isAGPolarTAxis = 1;
           }
           else if (name == "AGPolarTTicklines") {
               oldType.set_obj_ref((OMobj_id)isAGPolarTTicklines);
               isAGPolarTTicklines = 1;
           }
           else if (name == "AGYUserAxis") {
               oldType.set_obj_ref((OMobj_id)isAGYUserAxis);
               isAGYUserAxis = 1;
           }
           else if (name == "AGGraph") {
               oldType.set_obj_ref((OMobj_id)isAGGraph);
               isAGGraph = 1;
           }
           else if (name == "AGPolarGraph") {
               oldType.set_obj_ref((OMobj_id)isAGPolarGraph);
               isAGPolarGraph = 1;
           }
           else if (name == "AGGraphLegend") {
               oldType.set_obj_ref((OMobj_id)isAGGraphLegend);
               isAGGraphLegend = 1;
           }
           else if (name == "AGGraphViewport") {
               oldType.set_obj_ref((OMobj_id)isAGGraphViewport);
               isAGGraphViewport = 1;
           }
           else if (name == "AGGraphWorld") {
               oldType.set_obj_ref((OMobj_id)isAGGraphWorld);
               isAGGraphWorld = 1;
           }
           else if (name == "AGPolarGraphWorld") {
               oldType.set_obj_ref((OMobj_id)isAGPolarGraphWorld);
               isAGPolarGraphWorld = 1;
           }
           else if (name == "AGPieChart") {
               oldType.set_obj_ref((OMobj_id)isAGPieChart);
               isAGPieChart = 1;
           }
           else if (name == "AGContour") {
               oldType.set_obj_ref((OMobj_id)isAGContour);
               isAGContour = 1;
           }
           else if (name == "AGContourLegend") {
               oldType.set_obj_ref((OMobj_id)isAGContourLegend);
               isAGContourLegend = 1;
           }
           else if (name == "AGContourViewport") {
               oldType.set_obj_ref((OMobj_id)isAGContourViewport);
               isAGContourViewport = 1;
           }
           else if (name == "AGContourWorld") {
               oldType.set_obj_ref((OMobj_id)isAGContourWorld);
               isAGContourWorld = 1;
           }
           else {
               oldType.set_obj_ref((OMobj_id)isNotAGObj);
               isNotAGObj = 1;
           }
        }
        // If not valid agObj then set isNotAGObj
        else {
            oldType.set_obj_ref((OMobj_id)isNotAGObj);
            isNotAGObj = 1;
        }
        return(1);
">;

    };
    // This macro can be connected directly to the picked object port
    // of a viewer and will set a flag telling what the picked object is
    macro AGPickedObjGUISelector {
       DefaultObject &DefaultObject<NEx=132.,NEy=121.,NEportLevels={2,1}>;
       AGPrimitive &AGPrimitive<NEx=198.,NEy=176.> => 
	   DefaultObject.pick_info.pick_data[0].values_id;
       AGGUISelector AGGUISelector<NEx=88.,NEy=286.> {
	  agObj => <-.AGPrimitive;
	  isNotAGObj<NEportLevels={0,3}>;
	  isAGArc<NEportLevels={0,3}>;
	  isAGArrow<NEportLevels={0,3}>;
	  isAGEllipse<NEportLevels={0,3}>;
	  isAGLine<NEportLevels={0,3}>;
	  isAGPoints<NEportLevels={0,3}>;
	  isAGPolygon<NEportLevels={0,3}>;
	  isAGRectangle<NEportLevels={0,3}>;
	  isAGRestrictedText<NEportLevels={0,3}>;
	  isAGText<NEportLevels={0,3}>;
	  isAGTransformableText<NEportLevels={0,3}>;
	  isAGViewport<NEportLevels={0,3}>;
	  isAGWorld<NEportLevels={0,3}>;
	  isAGPolarWorld<NEportLevels={0,3}>;
	  isAGXAxis<NEportLevels={0,3}>;
	  isAGXTicklines<NEportLevels={0,3}>;
	  isAGPolarRAxis<NEportLevels={0,3}>;
	  isAGPolarRTicklines<NEportLevels={0,3}>;
	  isAGXUserAxis<NEportLevels={0,3}>;
	  isAGYAxis<NEportLevels={0,3}>;
	  isAGYTicklines<NEportLevels={0,3}>;
	  isAGPolarTAxis<NEportLevels={0,3}>;
	  isAGPolarTTicklines<NEportLevels={0,3}>;
	  isAGYUserAxis<NEportLevels={0,3}>;
	  isAGGraph<NEportLevels={0,3}>;
	  isAGPolarGraph<NEportLevels={0,3}>;
	  isAGGraphLegend<NEportLevels={0,3}>;
	  isAGGraphViewport<NEportLevels={0,3}>;
	  isAGGraphWorld<NEportLevels={0,3}>;
	  isAGPolarGraphWorld<NEportLevels={0,3}>;
	  isAGPieChart<NEportLevels={0,3}>;
	  isAGContour<NEportLevels={0,3}>;
	  isAGContourLegend<NEportLevels={0,3}>;
	  isAGContourViewport<NEportLevels={0,3}>;
	  isAGContourWorld<NEportLevels={0,3}>;
       };
    };
    group AGAnyLegend {
	string title;
	int visibility;
	float titleHeight;
	float labelHeight;
	int+opt numColumns;
	AGGeometry geometry;
    };
    module AGEditorShell {
	GDobject_templ+notify+read+IPort2 *cur_obj;
	group+read+notify *cur_ag_obj;
	int+notify+read trigger;
	int+write ag_active = 0;

	AGGraphWorld+noevents &worlds[];
	// Use AGAxis here so that we can hook up to either AGXAxis or 
	// AGXUserAxis
        AGAxis+AGAxisParams+AGTickXParams+noevents &xaxes[];
	AGXTicklines+noevents &xticks[];
        AGAxis+AGAxisParams+AGTickYParams+noevents &yaxes[];
	AGYTicklines+noevents &yticks[];
	AGAnyLegend+noevents &legends[];
	AGText+noevents &texts[];
	AGGraph+noevents &graphs[];
	AGContourViewport+noevents &contour_views[];
	AGContour+noevents &contours[];
        AGGraphViewport+noevents &graph_views[];
        AGViewport+noevents &views[];

	/* Make this method run later. When a pick occurs, we
	   want the object selector to run first. Else, we
	   will run twice.
        */
	omethod+notify_inst update<weight=2> = "AGEditorShell";
    };
};

// This is the list of macros that are available to Viz/Express customers
flibrary Macros<user_library=0,indexed=1> {
   AGGraphFieldObj AGGraphFieldObj;
   AGContourFieldObj AGContourFieldObj;
};

// Undefine port colors
#undef AG_COLOR
#undef AG_DATAOBJ_COLOR
#undef AG_VIEWPORT_COLOR
#undef AG_WORLD_COLOR
#undef AG_POLAR_WORLD_COLOR
#undef AG_CONTOUR_COLOR
#undef AG_GRAPH_COLOR

};
