/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ag_examp/contour1.v#1 $
*/

APPS.MultiWindowApp contour1<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "An orthoslice module is used here to create a 2D plane in a 3D dataset which can then be graphed using the AG kit. The example shows how some of the standard AG kit macros are used.";
      helpfile = "examples/examples_help.htm";
   };

   MODS.Readers.Read_Field Read_Field<NEx=242,NEy=77> {
      read_field_ui {
         file_browser {
	    filename = "$XP_PATH<0>/data/field/wind.fld";
         };
      };
   };
   MODS.Mappers.orthoslice orthoslice<NEx=242,NEy=132> {
      in_field => <-.Read_Field.field;
   };
   Contouring.AGContourObj AGContourObj<NEx=253,NEy=253> {
      inField<NEx=198,NEy=33> => <-.orthoslice.out_fld;
      contour<NEx=374,NEy=121> {
         isoLineLabelColor = "black";
         majorIsoLineColor = "black";
         minorIsoLineColor = "black";
         minClass = -20;
         maxClass = 50;
         numClasses = 15;
      };
      combineContourWorldInput {
         input2 => {<-.<-.AGXAxis,
            <-.<-.AGYAxis};
      };
      dataObject<NEx=176,NEy=407>;
   };
   Axes.AGXAxis AGXAxis<NEx=55,NEy=187> {
      text = "X Position";
   };
   Axes.AGYAxis AGYAxis<NEx=55,NEy=242> {
      text = "Y Position";
   };
   Contouring.AGContourLegendObj AGContourLegendObj<NEx=440,NEy=253> {
      contourLegend<NEx=220,NEy=55,NEwidth=209,NEheight=231> {
         contour => <-.<-.AGContourObj.contour;
         title = "Temperature";
         titleHeight = 2.5;
         labelHeight = 2;
         geometry = {2,-3};
      };
   };
   Basic.AGTextObj AGTextObj<NEx=649,NEy=253> {
      text {
         text = {"Heat Distribution"};
         height = 4;
         geometry = {0,4};
      };
   };

   GDM.Uviewer2D Uviewer2D<NEx=671.,NEy=484.> {
      Scene {
         Top {
            child_objs => {
               AGContourObj.dataObject.obj,
	       AGContourLegendObj.dataObject.obj,
               AGTextObj.dataObject.obj};
         };
         Camera {
            Camera {
	       auto_norm = 0;
            };
         };
      };
   };

};
