/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ag_examp/gphUI.v#1 $
*/

APPS.MultiWindowApp graphUI<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "graphUI shows how you can create your own user interface to control the standard functionality of the AG kit. A standard AGGraph object is used and the graphType parameter is connected to UIradioBoxLabel.selectedItem.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer2D Uviewer2D<NEx=671.,NEy=484.> {
      Scene {
         Top {
            child_objs => {
               AGGraphViewportObj.dataObject.obj,
	       AGTextObj.dataObject.obj};
         };
         Camera {
            Camera {
               auto_norm = 0;
            };
         };
      };
   };

   Graphing.AGGraphViewportObj AGGraphViewportObj<NEx=429,NEy=484> {
      graphViewport<NEx=11,NEy=55,NEwidth=297,NEheight=385> {
         children => {<-.<-.AGGraphWorld};
      };
   };
   Graphing.AGGraphWorld AGGraphWorld<NEx=429,NEy=418> {
      children => {
         <-.AGYAxis,<-.AGGraph,<-.AGXAxis,<-.AGXTicklines,<-.AGYTicklines,
         <-.AGGraph_Curve,<-.AGGraph_Barlines
      };
   };
   Axes.AGYAxis AGYAxis<NEx=99,NEy=418>;
   Graphing.AGGraph AGGraph<NEx=440,NEy=143> {
      graphType<NEportLevels={2,0}> => UIradioBoxLabel.selectedItem;
      valuesY => <-.Base_Values;
   };
   UIapp UIapp<NEx=22,NEy=77> {
      x = 300;
      y = 10;
      width = 200;
      title = "Graph Controls";
      height = 300;
   };
   UIpanel UIpanel<NEx=209,NEy=55> {
      parent => <-.UIapp;
      y = 0;
      height => .parent.clientHeight;
   };
   UI_MACROS.UIradioBoxLabel UIradioBoxLabel<NEx=396,NEy=55> {
      parent => <-.UIpanel;
      labels => AGGraph.graphType.choices;
      UIlabel {
         label = "Graph Types // Visibility";
      };
      title = "Graph Types";
   };
   Axes.AGXAxis AGXAxis<NEx=99,NEy=385>;
   Axes.AGXTicklines AGXTicklines<NEx=99,NEy=330> {
      visibility<NEportLevels={2,0}> => <-.X_Toggle.set;
      majorTickLineStyle = "dotted";
   };
   Axes.AGYTicklines AGYTicklines<NEx=275,NEy=253> {
      visibility<NEportLevels={2,0}> => <-.Y_Toggle.set;
      majorTickLineStyle = "dotted";
   };
   UItoggle X_Toggle<NEx=187,NEy=198> {
      parent => <-.UIpanel;
      y = 200;
      width => <-.UIpanel.width;
      label = "X Ticklines";
   };
   UItoggle Y_Toggle<NEx=22,NEy=198> {
      parent => <-.UIpanel;
      y = 225;
      label = "Y Ticklines";
      width => <-.UIpanel.width;
   };
   Graphing.AGGraph AGGraph_Curve<NEx=605,NEy=198> {
      valuesY => <-.float#1;
   };
   float Base_Values<NEportLevels=1,NEx=550,NEy=22>[] = {7,4,5,9,6,2,5};
   float float#1<NEportLevels=1,NEx=781,NEy=11>[] = {1,2,6,11,9,12,5};
   Graphing.AGGraph AGGraph_Barlines<NEx=748,NEy=154> {
      valuesY => <-.float#1;
      baseValuesY => <-.Base_Values;
      graphType = "barlines";
      barOffset = 0;
   };
   Basic.AGTextObj AGTextObj<NEx=99,NEy=495> {
      text<NEx=11,NEy=66> {
         text = {"Graph Types"};
         geometry = {0,4};
         height = 4;
         font = "sw:Helvetica";
      };
   };
};
