/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ag_examp/rainfall.v#1 $
*/

APPS.MultiWindowApp rainfall<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "rainfall shows how you can plot two series against two different axis systems in the same coordinate space. Note this uses an approach that requires two AGGraphWorld and AGGraph modules.";
      helpfile = "examples/examples_help.htm";
   };

   Graphing.AGGraph AGGraph<NEx=209,NEy=55> {
      valuesY => <-.Temperature;
      color = "orange";
      graphType = "staircase";
   };
   Graphing.AGGraphViewportObj AGGraphViewportObj<NEx=352,NEy=429> {
      graphViewport {
         children => {<-.<-.RainWorld,
            <-.<-.AGText,<-.<-.TempWorld};
      };
   };
   AGGraphWorld TempWorld<NEx=297,NEy=330> {
      children => {
         <-.AGYAxis,<-.AGYTicklines,<-.AGGraph,<-.AGXUserAxis,
         <-.AGXTicklines,<-.Hurricane_Alert,<-.LeftArrow,<-.RightArrow
      };
      labelHeight = 3;
      majorReferenceX = 0.5;
      majorStepX = 1;
      majorReferenceY = 88;
      majorStepY = 2;
      limitsY = {80,90};
   };

   GDM.Uviewer2D Uviewer2D<NEx=671.,NEy=484.> {
      Scene {
         Top {
            child_objs => {AGGraphViewportObj.dataObject.obj};
         };
         Camera {
            Camera {
               auto_norm = 0;
            };
         };
      };
   };

   float Temperature<NEportLevels=1,NEx=209,NEy=11>[] = {
      83,82.5,85,88,87,86.5,87,88,88,88,85,83
   };
   float Rainfall<NEportLevels=1,NEx=418,NEy=22>[] = {
      3.8,2.7,2.4,3.2,4.8,6.3,8.5,8.9,9.3,8.8,9.2,4.9
   };
   Graphing.AGGraph AGGraph#1<NEx=418,NEy=66> {
      valuesY => <-.Rainfall;
      color = "cyan";
      graphType = "staircase";
   };
   AGGraphWorld RainWorld<NEx=495,NEy=330> {
      children => {<-.AGGraph#1,
         <-.AGYAxis#1,<-.AGYTicklines#1};
      limitsY = {1,10};
   };
   Axes.AGYAxis AGYAxis<NEx=22,NEy=88> {
      majorTickColor = "orange";
      majorTickLineStyle = "dashed";
      labelColor = "orange";
      textColor = "white";
      text = "Temperature in \r2218F";
   };
   Axes.AGYTicklines AGYTicklines<NEx=22,NEy=121> {
      majorTickColor = "orange";
      majorTickLineStyle = "dashed";
   };
   Axes.AGXUserAxis AGXUserAxis<NEx=22,NEy=154> {
      labelStrings = {
         "Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov",
         "Dec"
      };
      majorTickOn = 1;
      text = "1999";
   };
   Axes.AGXTicklines AGXTicklines<NEx=22,NEy=187> {
      majorTickLineStyle = "dashed";
   };
   Axes.AGYAxis AGYAxis#1<NEx=418,NEy=110> {
      labelMode = "reversed";
      majorTickColor = "cyan";
      majorTickLineStyle = "dotted";
      labelColor = "cyan";
      textColor = "white";
      text = "Rainfall in Inches";
   };
   Axes.AGYTicklines AGYTicklines#1<NEx=418,NEy=176> {
      majorTickColor = "cyan";
      majorTickLineStyle = "dotted";
   };
   Basic.AGText AGText<NEx=682,NEy=330> {
      text = {
         "Climate: Greater Antilles"};
      geometry = {0,6.5};
      height = 5;
   };
   AGArrow LeftArrow<NEx=22,NEy=330> {
      geometry = {8,83.5,6,81};
      color = "red";
      priority = 1;
   };
   AGArrow RightArrow<NEx=22,NEy=297> {
      geometry = {8,83.5,11,81};
      color = "red";
      priority = 1;
   };
   Basic.AGText Hurricane_Alert<NEx=22,NEy=264> {
      text = {
         "Hurricane\nSeason"};
      geometry = {8,84};
      font = "century-bold";
      color = "white";
      fillColor = "red";
      height = 5;
      priority = 2;
   };
   Graphing.AGGraph AGGraph#2<NEx=627,NEy=88> {
      graphType = "scatter";
      color = "green";
   };
};
