/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/ag_examp/simpGph.v#1 $
*/

APPS.MultiWindowApp simpleGraph<NEdisplayMode="NEmaximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "simpleGraph is a standard AG kit example showing how to build your first graph visualization. Note the use of an AGGraphWorld module and AGGraphViewportObj macro to place the AG graphics into a standard viewer.";
      helpfile = "examples/examples_help.htm";
   };

   Graphing.AGGraph AGGraph<NEx=308,NEy=22> {
      color = "yellow";
   };
   Graphing.AGGraphViewportObj AGGraphViewportObj<NEx=330,NEy=264> {
      graphViewport {
         children => {<-.<-.AGGraphWorld};
         geometry = {-3.,-3.,2.5,3.0};
      };
   };
   Graphing.AGGraphWorld AGGraphWorld<NEx=330,NEy=132> {
      children => {
         <-.AGGraph,<-.AGYAxis,<-.AGXTicklines,<-.AGYTicklines,
         <-.AGXUserAxis
      };
      majorReferenceX = 0;
      majorStepX = 2;
      limitsX = {0,10};
      textColor = "cyan";
   };
   Axes.AGYAxis AGYAxis<NEx=132,NEy=99> {
      axleColor = "green";
      textColor = "yellow";
      majorStepY = 0.5;
   };
   Graphing.AGGraphLegendObj AGGraphLegendObj<NEx=528,NEy=209> {
      graphLegend {
         graphs => {<-.<-.AGGraph};
         geometry = {2.7,-3};
         fillColor = "blue";
         frameColor = "cyan";
         title = "A Legend";
         labelHeight = 2.3;
         titleHeight = 2.7;
      };
   };
   Axes.AGXTicklines AGXTicklines<NEx=132,NEy=209> {
      majorStepX = 2;
   };
   Axes.AGYTicklines AGYTicklines<NEx=132,NEy=154>;
   Axes.AGXUserAxis AGXUserAxis<NEx=132,NEy=44> {
      labelStrings = {
         "1990","1991","1992","1993","1994","1994"
      };
      textColor = "yellow";
      text = "X User Axis";
   };
   Basic.AGTextObj AGTextObj<NEx=528,NEy=330> {
      text {
         text = {"A Simple Graph"};
         geometry = {0,4};
         font = "Roman-Complex";
      };
   };

   GDM.Uviewer2D Uviewer2D<NEx=671.,NEy=484.> {
      Scene {
         Top {
            child_objs => {
               AGGraphViewportObj.dataObject.obj,
	       AGGraphLegendObj.dataObject.obj,
               AGTextObj.dataObject.obj};
         };
         Camera {
            Camera {
               auto_norm = 0;
            };
         };
      };
   };
};
