/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/aghlm_ex/mgraph.v#1 $
*/

APPS.MultiWindowApp MultiGraph<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "MultiGraph shows how you use the GeneralGraph macro to allow multiple graph types to be displayed in the same spatial area.";
      helpfile = "examples/examples_help.htm";
   };

   float float<NEportLevels=1,NEx=11.,NEy=33.>[] = {1.,2.,3.,10.,20.,30.};
   float float#1<NEportLevels=1,NEx=165.,NEy=33.>[] = {1.,2.,3.,4.,3.,2.};
   float float#2<NEportLevels=1,NEx=330.,NEy=33.>[] = {6.,5.,4.,3.,2.,10.};

   AGHLM.General_Graph General_Graph<NEx=176.,NEy=110.> {
      ValuesX => <-.float;
      ValuesY1 => <-.float#1;
      ValuesY2 => <-.float#2;
      Graph#1 {
         UIframe<instanced=0>;
         Gparams {
           Graph_params1 {
             graphtype = 2;
           };
         };
      };
      Graph#2 {
         Gparams {
           Graph_params2 {
             priority = 10;
             graphtype = 4;
             line_color = 5;
           };
         };
      };
      Graph#3 {
         UIframe<instanced=0>;
      };
      Graph#4 {
         UIframe<instanced=0>;
      };
      Graph#5 {
         UIframe<instanced=0>;
      };
      GraphParam {
         selectedItem = 1;
      };
   };
   GDM.Uviewer2D Uviewer2D<NEx=500,NEy=250> {
      Scene {
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 614;
                        defaultY = 27;
                        defaultWidth = 429;
                        defaultHeight = 411;
                     };
                  };
               };
            };
         };
         Top {
            child_objs => {
               <-.<-.<-.General_Graph.GraphViewport.obj};
         };
      };
   };
};
