/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/aghlm_ex/mgraph2.v#1 $
*/

APPS.MultiWindowApp MultiGraph2<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "MultiGraph2 shows how you can use standard AVS/Express modules to read and extract the required data arrays for the AG kit to plot appropriate graphs. A macro called GeneralGraph has been used which consists of low level AG kit modules.";
      helpfile = "examples/examples_help.htm";
   };

   AGHLM.General_Graph General_Graph<NEx=242.,NEy=209.> {
      ValuesY1 => <-.extract_data_array.data;
      ValuesY2 => <-.extract_data_array#1.data;
      Graph#1 {
         Gparams {
           Graph_params1 {
             priority = -10;
             graphtype = 2;
           };
         };
      };
      Graph#2 {
         UIframe<instanced=0>;
         Gparams {
           Graph_params2 {
             priority = 10;
             graphtype = 4;
             line_color = 5;
           };
         };
      };
      Graph#3 {
         UIframe<instanced=0>;
      };
      Graph#4 {
         UIframe<instanced=0>;
      };
      Graph#5 {
         UIframe<instanced=0>;
      };
      GraphParam {
         label_cmd {
            cmd = {
               {
                  set=1,
               },
               {
                  set=0,
               },,,
            };
         };
      };
   };
   MODS.Read_Field Read_Field<NEx=33.,NEy=11.> {
      read_field_ui {
         filename = "$XP_PATH<0>/data/field/hydrogen.fld";
      };
      DVread_field {
         Mesh_Unif+Node_Data Output_Field;
      };
   };
   MODS.orthoslice orthoslice<NEx=33.,NEy=55.> {
      in_field => <-.Read_Field.field;
      OrthoSliceParam {
         axis = 1;
      };
   };
   MODS.orthoslice orthoslice#1<NEx=33.,NEy=99.> {
      in_field => <-.orthoslice.out_fld;
      OrthoSliceParam {
         plane => 5;
      };
   };
   MODS.orthoslice orthoslice#2<NEx=231.,NEy=99.> {
      in_field => <-.orthoslice.out_fld;
      OrthoSliceParam {
         plane => 32;
      };
   };
   FLD_MAP.extract_data_array extract_data_array<NEx=33.,NEy=143.> {
      in => <-.orthoslice#1.out_fld;
   };
   FLD_MAP.extract_data_array extract_data_array#1<NEx=231.,NEy=143.> {
      in => <-.orthoslice#2.out_fld;
   };

   GDM.Uviewer2D Uviewer2D<NEx=500,NEy=250> {
      Scene {
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 594;
                        defaultY = 0;
                        defaultWidth = 429;
                        defaultHeight = 411;
                     };
                  };
               };
            };
         };
         Top {
            child_objs => {
               <-.<-.<-.General_Graph.GraphViewport.obj};
         };
      };
   };
};
