/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/aghlm_ex/mpolar.v#1 $
*/

APPS.MultiWindowApp MultiPolar<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "MultiPolar demonstrates the use of the GeneralPolarGraph macro which is used to construct a visualization consisting of multiple polar graphs.";
      helpfile = "examples/examples_help.htm";
   };

   float float<NEportLevels=1,NEx=55.,NEy=88.>[] => init_array(100,1000,0);
   float float#1<NEportLevels=1,NEx=55.,NEy=33.>[] => init_array(100,0,1000);

   AGHLM.General_PolarGraph General_PolarGraph<NEx=231.,NEy=143.> {
      ValuesR1 => <-.float;
      ValuesR2 => <-.float#1;
      PolarGraph#1 {
         UIframe<instanced=0>;
      };
      PolarGraph#2 {
         GraphUI {
            graphtype {
               label_cmd {
                  cmd = {,
                     {
                        set=1,
                     }};
               };
            };
            color = {
               ,,
               {
                  set=0
               },,
               {
                  set=1
               },,,,
            };
         };
         Gparams {
           Graph_params2 {
              graphtype = 1;
              line_color = 4;
              Scatter_size = 6.;
           };
         };
      };
      PolarGraph#3 {
         UIframe<instanced=0>;
      };
      PolarGraph#4 {
         UIframe<instanced=0>;
      };
      PolarGraph#5 {
         UIframe<instanced=0>;
      };
      GraphParam {
         label_cmd {
            cmd = {
               {
                  set=0,
               },
               {
                  set=1,
               },,,
            };
         };
         selectedItem = 1;
      };
   };

   GDM.Uviewer2D Uviewer2D<NEx=500,NEy=250> {
      Scene {
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultX = 447;
                        defaultY = 22;
                     };
                  };
               };
            };
         };
         Top {
            child_objs => {
               <-.<-.<-.General_PolarGraph.GraphViewport.obj};
         };
      };
   };
};
