/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/aghlm_ex/polar.v#1 $
*/

APPS.MultiWindowApp PolarGraph<NEdisplayMode="maximized",NEhelpFile="examples/examples_help.htm"> {

   UIsummaryPanel Summary_Panel {
      demo_text = "PolarGraph demonstrates the use of the PolarGraph macro. This macro simplifies the creation of a polar graph with its constituent axes.";
      helpfile = "examples/examples_help.htm";
   };

   GDM.Uviewer2D Uviewer2D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.GraphViewport.AGGraphViewportObj.dataObject.obj,
               <-.<-.<-.GraphViewport.obj};
            Xform {
               mat = {
                  1.33333,0.,0.,0.,0.,1.33333,0.,0.,0.,0.,1.33333,0.,0.,
0.,0.,1.
               };
            };
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     panel {
                        defaultWidth = 364;
                        defaultHeight = 415;
                        defaultX = 416;
                        defaultY = 413;
                     };
                  };
               };
            };
            View {
               trigger = 1;
            };
         };
      };
   };
   float float<NEportLevels=1>[] => init_array(100,0,1000);
   AGHLM.PolarGraph PolarGraph {
      AGPolarGraph {
         valuesR => <-.<-.float;
      };
      GraphUI<instanced=0>;
   };
   AGHLM.GraphViewport GraphViewport {
      AGGraphViewportObj {
         graphViewport {
            children => {<-.<-.<-.PolarWorld.out};
         };
      };
      GraphViewport_UI<instanced=0>;
   };
   AGHLM.PolarAxis PolarAxis {
      Graph_in => <-.PolarGraph.output;
      R_Axis_params {
         Steps_for_Major = 500;
         Steps_for_Minor => ;
      };
   };
   AGHLM.PolarWorld PolarWorld {
      AGCombinePolarGraphWorldInput {
         input1 => {
            <-.<-.PolarGraph.output};
         input2 => <-.<-.PolarAxis.mlink;
      };
      PolarWorld_UI<instanced=0>;
   };
};
