/*
                        Copyright (c) 1994 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/v/anim_m.v#1 $
*/

flibrary+buffered+sort ANIM_MACROS<
   disabled => Templates.CONFIG.anim_kit_disabled>
{
   // User interface for common loop controls used in animator and capture,
   // replay modules
   macro PlaybackControlsCommon {
      UI.UIframe PlaybackFrame<NEx=55.,NEy=55.> {
         width = 250;
      };
      UI.UIlabel UIlabel<NEx=55.,NEy=99.> {
         parent => <-.PlaybackFrame;
         label => "Playback Controls";
         y = 0;
         width => parent.width;
         alignment = "center";
      };
      UI.UIbutton RunBack<NEx=55.,NEy=187.> {
         parent => <-.PlaybackFrame;
         height = 27;
         label => "Run Backwards";
         x = 55;
         y = 54;
         width = 27;
         labelPixmap {
            filename<NEdisplayMode="open"> = "$XP_PATH<0>/runtime/pixmaps/rev.bmp";
            fileType = "bitmap";
         };
	 toolTip.enable = 1;
      };
      UI.UIbutton StepBack<NEx=198.,NEy=187.> {
         parent => <-.PlaybackFrame;
         height = 27;
         label => "Step Backwards";
         x => ((<-.RunBack.x + <-.RunBack.width) + 2);
         y = 54;
         width = 27;
         labelPixmap {
            filename<NEdisplayMode="open"> = "$XP_PATH<0>/runtime/pixmaps/revstep.bmp";
            fileType = "bitmap";
         };
	 toolTip.enable = 1;
      };
      UI.UIbutton Stop<NEx=341.,NEy=187.> {
         parent => <-.PlaybackFrame;
         height = 27;
         label => "Stop";
         x => ((<-.StepBack.x + <-.StepBack.width) + 2);
         y = 54;
         width = 27;
         labelPixmap {
            filename = "$XP_PATH<0>/runtime/pixmaps/stop.bmp";
            fileType = "bitmap";
         };
	 toolTip.enable = 1;
      };
      UI.UIbutton StepForward<NEx=484.,NEy=187.> {
         parent => <-.PlaybackFrame;
         height = 27;
         x => ((<-.Stop.x + <-.Stop.width) + 2);
         y = 54;
         width = 27;
         label => "Step Forward";
         labelPixmap {
            filename = "$XP_PATH<0>/runtime/pixmaps/playstep.bmp";
            fileType = "bitmap";
         };
	 toolTip.enable = 1;
      };
      UI.UIbutton RunForward<NEx=627.,NEy=187.> {
         parent => <-.PlaybackFrame;
         height = 27;
         label => "Run Forwards";
         x => ((<-.StepForward.x + <-.StepForward.width) + 2);
         y = 54;
         width = 27;
         labelPixmap {
            filename = "$XP_PATH<0>/runtime/pixmaps/play.bmp";
            fileType = "bitmap";
         };
	 toolTip.enable = 1;
      };

      UI.UIoption Once<NEx=319.,NEy=275.> {
         label => "Once";
         set = 1;
      };
      UI.UIoption Cycle<NEx=473.,NEy=275.> {
         label => "Cycle";
      };
      UI.UIoption Bounce<NEx=627.,NEy=275.> {
         label => "Bounce";
      };
      UI.UIoptionMenu RunOptions<NEx=253.,NEy=352.> {
         parent => <-.PlaybackFrame;
         cmdList => {<-.Once,<-.Cycle,<-.Bounce};
         label => "Run";
         x => ((GoToStart.x + GoToStart.width) + 12);
         y = 96;
         width = 100;
         alignment = "left";
      };
      UI.UIlabel Current<NEx=55.,NEy=143.> {
         parent => <-.PlaybackFrame;
         height => 30;
         y = 20;
         width => parent.width;
         fontAttributes {
            height = 30;
         };
         alignment = "center";
      };

      GMOD.parse_v ParseStop<NEx=341.,NEy=231.> {
         trigger => <-.Stop.do;
         on_inst = 0;
         relative => "<-.<-";
      };
      UI.UIbutton GoToStart<NEx=55.,NEy=319.> {
         parent => <-.PlaybackFrame;
         height = 27;
         x = 35;
         y = 94;
         width = 27;
         label => "Go To Start";
         labelPixmap {
            filename = "$XP_PATH<0>/runtime/pixmaps/reset.bmp";
            fileType = "bitmap";
         };
         toolTip.enable = 1;
      };
      UI.UIbutton GoToEnd<NEx=55.,NEy=275.> {
         parent => <-.PlaybackFrame;
         height = 27;
         x => ((RunOptions.x + RunOptions.width) + 12);
         y = 94;
         width = 27;
         label => "Go To End";
         labelPixmap {
            filename = "$XP_PATH<0>/runtime/pixmaps/gotoend.bmp";
            fileType = "bitmap";
         };
	 toolTip.enable = 1;
      };
   };

   // used for the capture and replay modules
   macro PlaybackDelay {
      UI.UIslider Delay {
	 title = "Delay";
	 x = 4;
         y = 136;
         width => parent.width - 16;
         min = 0.;
         max = 100.;
	 value = 0.;
	 mode = 1;
      };
   };

   // User interface for controlling keyframes in the animator module
   macro KeyframeControls {
      UI.UIframe KeyframeFrame<NEx=55.,NEy=44.> {
         width = 250;
         height = 380;
      };
      UI.UIlabel KeyframeControls<NEx=55.,NEy=88.> {
         parent => <-.KeyframeFrame;
         label => "Keyframe Controls";
         y = 0;
         width => parent.width;
      };
      UI.UIbutton Add<NEx=55.,NEy=143.> {
         parent => <-.KeyframeFrame;
         x = 40;
	 y => KeyframeControls.height + 4;
         width = 27;
         height = 27;
         labelPixmap {
            filename = "$XP_PATH<0>/runtime/pixmaps/add.bmp";
            fileType = "bitmap";
         };
	 toolTip.enable = 1;
      };
      UI.UIbutton Delete<NEx=198.,NEy=143.> {
         parent => <-.KeyframeFrame;
         x => ((<-.Add.x + <-.Add.width) + 2);
	 y => KeyframeControls.height + 4;
         width = 27;
         height = 27;
         labelPixmap {
            filename = "$XP_PATH<0>/runtime/pixmaps/del.bmp";
            fileType = "bitmap";
         };
         toolTip.enable = 1;
      };
      GMOD.parse_v ParseDeleteButton<NEx=572.,NEy=341.> {
         trigger => Delete.do;
         v_commands = "animCompute.AnimControl.timeListIndex = 0;";
         on_inst = 0;
         relative => ".";
      };
      UI.UIbutton Complete<NEx=341.,NEy=143.> {
         parent => <-.KeyframeFrame;
         x => ((<-.Delete.x + <-.Delete.width) + 2);
	 y => KeyframeControls.height + 4;
         width = 27;
         height = 27;
         labelPixmap {
            filename = "$XP_PATH<0>/runtime/pixmaps/complete.bmp";
            fileType = "bitmap";
         };
	 toolTip.enable = 1;
      };
      UI.UIbutton Clear<NEx=484.,NEy=143.> {
         parent => <-.KeyframeFrame;
         x => ((<-.Complete.x + <-.Complete.width) + 2);
	 y => KeyframeControls.height + 4;
         width = 27;
         height = 27;
         labelPixmap {
            filename = "$XP_PATH<0>/runtime/pixmaps/clear.bmp";
            fileType = "bitmap";
         };
	 toolTip.enable = 1;
      };
      UI.UIquestionDialog ClearQuestion<NEx=484.,NEy=187.> {
         parent => <-.KeyframeFrame;
	 x = 65;
         y = 225;
	 width = 300;
	 message = "Do you want to clear all keyframes ?";
	 isModal = 1;
	 visible => Clear.do;
      };
      UI.UIbutton ReScan<NEx=341.,NEy=143.> {
         parent => <-.KeyframeFrame;
         x => ((<-.Clear.x + <-.Clear.width) + 2);
	 y => KeyframeControls.height + 4;
         width = 27;
         height = 27;
         labelPixmap {
            filename = "$XP_PATH<0>/runtime/pixmaps/rescan.bmp";
            fileType = "bitmap";
         };
	 toolTip.enable = 1;
      };
      UI.UIbutton ReInitialize<NEx=341.,NEy=143.> {
         parent => <-.KeyframeFrame;
         x => ((<-.ReScan.x + <-.ReScan.width) + 2);
	 y => KeyframeControls.height + 4;
         width = 27;
         height = 27;
         labelPixmap {
            filename = "$XP_PATH<0>/runtime/pixmaps/reinit.bmp";
            fileType = "bitmap";
         };
	 toolTip.enable = 1;
      };
      UI.UIerrorDialog ReInitError<NEx=484.,NEy=187.> {
         parent => <-.KeyframeFrame;
	 x = 65;
         y = 225;
	 message = "Re-initialize only valid before adding keyframes.";
	 isModal = 1;
      };
      int number_of_frames<NEx=253.,NEy=198.>;
      UI.UIlabel NumberOfFrames<NEx=55.,NEy=198.> {
         parent => <-.KeyframeFrame;
         label => "Total Frames: ";
         x = 4;
	 y => Add.y + Add.height + 6;
         width = 100;
         alignment = "left";
      };
      UI.UIlabel FrameDeltaLabel<NEx=55.,NEy=253.> {
         parent => <-.KeyframeFrame;
         label => "Frame Delta";
         x = 120;
	 y => Add.y + Add.height + 6;
	 width = 75;
         alignment = "left";
      };
      UI.UIfield FrameDelta<NEx=253.,NEy=253.> {
         parent => <-.KeyframeFrame;
         value = 1.;
         x => FrameDeltaLabel.x + FrameDeltaLabel.width + 4;
	 y => Add.y + Add.height + 4;
         width = 40;
         min = 0.;
         decimalPoints = 2;
	 updateMode = 2;
      };
      UI.UIlabel FrameTimes<NEx=55.,NEy=297.> {
         parent => <-.KeyframeFrame;
         label => "Frame Times";
         x = 4;
         y => FrameDelta.y + FrameDelta.height + 4;
         width = 125;
         alignment = "center";
      };
      UI.UIlist TimesList<NEx=55.,NEy=341.> {
         parent => <-.KeyframeFrame;
         x = 4;
         y => FrameTimes.y + FrameTimes.height + 4;
         width = 125;
         height = 105;
      };
      GMOD.parse_v FramesExist<NEx=572.,NEy=341.> {
         trigger => ReInitialize.do;
	     v_commands = "ReInitError.visible=number_of_frames;";
         on_inst = 0;
         relative => ".";
      };
      GMOD.parse_v ParseList<NEx=572.,NEy=341.> {
         trigger => TimesList.selectedItem;
         v_commands = "CurrentTime.value=animCompute.AnimControl.frameTimes[TimesList.selectedItem];NewTime.value=CurrentTime.value+animCompute.AnimControl.frameDelta;";
         on_inst = 0;
         relative => ".";
      };
      float loopCount<NEportLevels=1,NEx=418.,NEy=341.>;
      GMOD.parse_v ParseTime<NEx=253.,NEy=341.> {
         trigger => (CurrentTime.Dial.value | CurrentTime.Field.value);
         v_commands = "loopCount=CurrentTime.Dial.value;NewTime.value=CurrentTime.value+animCompute.AnimControl.frameDelta;";
         on_inst = 0;
         relative => ".";
      };
      VUI.VUIDial CurrentTime<NEx=253.,NEy=297.> {
         parent => <-.KeyframeFrame;
         x = 160;
         y => FrameDelta.y + FrameDelta.height + 6;
         width = 65;
	 height = 130;
         Dial {
            value<NEportLevels={2,2}>;
            valuePerRev = 10.;
            numTicks = 10;
            DialIncrement => 0.25;
         };
	 Field {
	    updateMode = 2;
         };
         min = 0;
         ParseUp<NEx=407.,NEy=451.>;
         title = "Current Time";
         decimalPoints = 3;
      };
      UI.UIlabel NewTimeLabel<NEx=55.,NEy=385.> {
         parent => <-.KeyframeFrame;
         label => "New Time";
         x = 30;
         y => CurrentTime.y + CurrentTime.height + 8;
	 width = 70;
         alignment = "left";
      };
      UI.UIfield NewTime<NEx=253.,NEy=385.> {
         parent => <-.KeyframeFrame;
         value = 0.;
         x = 100;
         y => CurrentTime.y + CurrentTime.height + 4;
         width = 50;
         min = 0.;
         decimalPoints = 3;
	 updateMode = 2;
      };
      UI.UIbutton Move<NEx=341.,NEy=143.> {
        parent => <-.KeyframeFrame;
         x = 160;
	 y => CurrentTime.y + CurrentTime.height + 6;
         height = 27;
         width = 27;
         labelPixmap {
            filename = "$XP_PATH<0>/runtime/pixmaps/move.bmp";
            fileType = "bitmap";
         };
	 toolTip.enable = 1;
      };

      UI.UIlabel UIlabel#3<NEx=55.,NEy=440.> {
         parent => <-.KeyframeFrame;
         label => "Interpolators";
         x = 4;
         y => NewTime.y + NewTime.height + 4;
	 width => parent.clientWidth - 8;
         alignment = "center";
      };
      UI.UIlist InterpolatorList<NEx=253.,NEy=440.> {
         parent => <-.KeyframeFrame;
         x = 4;
         y => UIlabel#3.y + UIlabel#3.height + 4;
	 width => parent.clientWidth - 8;
         height = 80;
      };
      GMOD.parse_v ParseInterpolatorList<NEx=160.,NEy=290.> {
         trigger => InterpolatorList.selectedItem;
         v_commands = "InterpolatorEditorControls.InterpolatorEditorDialog.visible=1;
                      ";
         on_inst = 0;
         relative => ".";
      };
   };

   // User interface for controlling interpolator editor in the animator module

   macro InterpolatorEditorControls  {
      UI.UItemplateDialog InterpolatorEditorDialog<NEx=88.,NEy=33.> {
         width = 280;
         height => 375 + UIdata.UIfonts[0].lineHeight + 6;
         visible = 0;
         okButton = 1;
         okLabelString = "OK";
         cancelButton = 1;
         cancelLabelString = "Cancel";
      };
      UI.UIpanel InterpolatorEditorPanel {
         x  = 0;
         y  = 0;
         parent => <-.InterpolatorEditorDialog;
         width =>  parent.clientWidth - 10;
         height => parent.clientHeight - 10;
      };

      // this is correct that the InterpEditorDialog has no parent
      // we had problems when I did give it a parent

      UI.UIframe InterpolatorEditorFrame {
         x  = 10;
         y  = 10;
         parent => <-.InterpolatorEditorPanel;
         width =>  parent.clientWidth - 10;
         height => parent.clientHeight - 10;
      };

      UI.UItext InterpolatorName {
         parent => <-.InterpolatorEditorFrame;
         text => animCompute.AnimControl.interpNameStr;
         width => parent.clientWidth - 20;
         height => UIdata.UIfonts[0].lineHeight + 6;
         x = 10;
         y = 10;
         outputOnly = 1;
      };

      UI.UIoption Linear  {
         label => "Linear";
         set = 1;
      };
      UI.UIoption Cubic {
         label => "Cubic";
      };
      UI.UIoption Quintic {
         label => "Quintic";
      };
      UI.UIoption Sinusoidal {
         label => "Sinusoidal";
      };
      UI.UIoptionMenu InterpType {
         parent => <-.InterpolatorEditorFrame;
         cmdList => {<-.Linear,<-.Cubic,<-.Quintic,<-.Sinusoidal};
         label => "Interpolation Method";
         x => 10 ;
         y => InterpolatorName.y + 35;
         width = 200;
      };
      UI.UIoption Quaternion {
         label => "Quaternion";
         set = 1;
      };
      UI.UIoption Euler {
         label => "Euler";
      };

      UI.UIoptionMenu RotMethod  {
         parent => <-.InterpolatorEditorFrame;
         cmdList => {<-.Quaternion,<-.Euler};
         label => "Rotation Method";
         x => 10;
         y => InterpType.y + 40;
         width = 200;
         visible = 0;
      };


      UI.UIlabel TimesLabel {
         parent => <-.InterpolatorEditorFrame;
         label = "Times";
         x => 10;
         y => RotMethod.y + 35;
         width = 70;
      };

      UI.UIlist InterpolatorTimesList {
         parent => <-.InterpolatorEditorFrame;
         x => TimesLabel.x ;
         y => TimesLabel.y + 20;
         width = 70;
         height = 75;
         };
      UI.UIbutton Apply  {
         parent => <-.InterpolatorEditorFrame;
         height = 27;
         label => "Apply";
         width = 27 * 3;
         x => (parent.width - width )/ 2 - 5;
         y => FMatrixPanel.y + 125 + 20;
         fontAttributes.weight = "bold";
         fontAttributes.height = 13;
      };
      // We need this so that when apply button is hit, the view will be updated 
      // to the current time, which is the same time, but with different values
      GMOD.parse_v ParseApplyButton {
         trigger => Apply.do;
         v_commands = "animCompute.AnimControl.timeListIndex=animCompute.AnimControl.timeListIndex;";
         on_inst = 0;
         relative => ".";
      };
      // We need this so that when ok button is hit, the view will be updated 
      // to the current time, which is the same time, but with different values
      GMOD.parse_v ParseOkButton {
         trigger => InterpolatorEditorDialog.ok;
         v_commands = "animCompute.AnimControl.timeListIndex=animCompute.AnimControl.timeListIndex;";
         on_inst = 0;
         relative => ".";
      };

      UI.UIpanel FScalarPanel {
         parent => <-.InterpolatorEditorFrame;
         x => InterpolatorTimesList.width + 60;
         y => TimesLabel.y + 2;
         width => ((InterpolatorEditorFrame.clientWidth - InterpolatorTimesList.width - 30) / 3) + 10;
         height = 75;
      };
      UI.UIlabel FScalarLabel {
         parent => <-.FScalarPanel;
         label => "Scalar";
         y = 0;
         width => parent.width;
         alignment = "center";
      };

      UI.UIframe FScalarFrame {
         parent => <-.FScalarPanel;
         x = 0;
         y = 20;
         width => parent.width;
         height = 40;
      };

      UI.UIfield fScalar {
         parent => <-.FScalarFrame;
         x = 3;
         y = 4;
         width => parent.width - 10;
         updateMode = 2;
      };


      UI.UIpanel IScalarPanel {
         parent => <-.InterpolatorEditorFrame;
         x => InterpolatorTimesList.width + 60;
         y => TimesLabel.y + 2;
         width => ((InterpolatorEditorFrame.clientWidth - InterpolatorTimesList.width - 30) / 3) + 10;
         height = 75;
      };
      UI.UIlabel IScalarLabel {
         parent => <-.IScalarPanel;
         label => "Scalar";
         y = 0;
         width => parent.width;
         alignment = "center";
      };

      UI.UIframe IScalarFrame {
         parent => <-.IScalarPanel;
         x = 0;
         y = 20;
         width => parent.width;
         height = 40;
      };

      UI.UIfield iScalar {
         parent => <-.IScalarFrame;
         x = 3;
         y = 4;
         width => parent.width - 10;
         updateMode = 2;
         decimalPoints = 0;
      };

      UI.UIpanel FVectorPanel {
         parent => <-.InterpolatorEditorFrame;
         x => InterpolatorTimesList.width + 20;
         y => TimesLabel.y + 2;
         width => (InterpolatorEditorFrame.clientWidth - InterpolatorTimesList.width - 30);
         height = 75;
      };

      UI.UIlabel FInterpLabel {
         parent => <-.FVectorPanel;
         label => "Vector";
         y = 0;
         width => parent.width;
         alignment = "center";
      };
      UI.UIframe FVectorFrame {
         parent => <-.FVectorPanel;
         x = 0;
         y = 20;
         width => parent.clientWidth;
         height = 40;
      };
      UI.UIfield fValue1 {
         parent => <-.FVectorFrame;
         x = 2;
         y = 4;
         width => (parent.width - 10) / 3;
         updateMode = 2;
      };

      UI.UIfield fValue2 {
         parent => <-.FVectorFrame;
         x => fValue1.x + ((FVectorFrame.width - 10) / 3) + 2;
         y = 4;
         width => (parent.width - 10) / 3;
         updateMode = 2;
      };
      UI.UIfield fValue3  {
         parent => <-.FVectorFrame;
         x => fValue2.x + ((FVectorFrame.width - 10) / 3) + 2;
         y = 4;
         width => (parent.width - 10) / 3;
         updateMode = 2;
      };

      UI.UIpanel IVectorPanel {
         parent => <-.InterpolatorEditorFrame;
         x => InterpolatorTimesList.width + 20;
         y => TimesLabel.y + 2;
         width => (InterpolatorEditorFrame.clientWidth - InterpolatorTimesList.width - 30);
         height = 75;
      };

      UI.UIlabel IInterpLabel {
         parent => <-.IVectorPanel;
         label => "Vector";
         y = 0;
         width => parent.width;
         alignment = "center";
      };

      UI.UIframe IVectorFrame {
         parent => <-.IVectorPanel;
         x = 0;
         y = 20;
         width => parent.width;
         height = 60;
      };
      UI.UIfield iValue1 {
         parent => <-.IVectorFrame;
         x = 2;
         y = 4;
         width => (parent.width - 10) / 3;
         updateMode = 2;
         decimalPoints = 0;
      };

      UI.UIfield iValue2 {
         parent => <-.IVectorFrame;
         x => iValue1.x + ((IVectorFrame.width - 10) / 3) + 2;
         y = 4;
         width => (parent.width - 10) / 3;
         updateMode = 2;
         decimalPoints = 0;
      };
      UI.UIfield iValue3 {
         parent => <-.IVectorFrame;
         x => iValue2.x + ((IVectorFrame.width - 10) / 3) + 2;
         y = 4;
         width => (parent.width - 10) / 3;
         updateMode = 2;
         decimalPoints = 0;
      };


      UI.UIpanel FMatrixPanel {
         parent => <-.InterpolatorEditorFrame;
         x => InterpolatorTimesList.width + 20;
         y => TimesLabel.y + 2;
	 width => (InterpolatorEditorFrame.clientWidth - InterpolatorTimesList.width - 30);
         height = 135;
      };

      UI.UIlabel InterpLabel2 {
         parent => <-.FMatrixPanel;
         label => "Rotation Vector";
         y = 0;
         width => parent.width;
         alignment = "center";
      };
      UI.UIframe FMatrixFrame1 {
         parent => <-.FMatrixPanel;
         x = 0;
         y => InterpLabel2.height + 2;
	 width => parent.width;
         height = 40;
      };

      UI.UIfield MatValue1 {
         parent => <-.FMatrixFrame1;
         x = 2;
         y = 4;
         // 10:  2 spaces between each mat value and frame + 2 = room for rounding
         // this could be done more elegantly but don't have time now!
         width => (parent.width - 10) / 3;
         updateMode = 2;
      };

      UI.UIfield MatValue2 {
         parent => <-.FMatrixFrame1;
         x => MatValue1.x + ((FMatrixFrame1.width - 10) / 3) + 2;
         y = 4;
         width => (parent.width - 10) / 3;
         updateMode = 2;
      };
      UI.UIfield MatValue3 {
         parent => <-.FMatrixFrame1;
         x => MatValue2.x + ((FMatrixFrame1.width - 10) / 3) + 2;
         y = 4;
         width => (parent.width - 10) / 3;
         updateMode = 2;
      };
      UI.UIlabel InterpLabel3 {
         parent => <-.FMatrixPanel;
         label => "Scale Vector";
         y = 65;
         width => parent.width;
         alignment = "center";
      };

      UI.UIframe FMatrixFrame2 {
         parent => <-.FMatrixPanel;
         x = 0;
         y = 90;
         width => (InterpolatorEditorFrame.clientWidth - InterpolatorTimesList.width - 30);
         height = 40;
      };

      UI.UIfield MatValue4 {
         parent => <-.FMatrixFrame2;
         x = 3;
         y = 4;
         width => ((parent.width - 10) / 3);
         updateMode = 2;
      };

      UI.UIfield MatValue5 {
         parent => <-.FMatrixFrame2;
         x => MatValue4.x + ((FMatrixFrame2.width - 10) / 3) + 2;
         y = 4;
         width => ((parent.width - 10) / 3);
         updateMode = 2;
      };
      UI.UIfield MatValue6 {
         parent => <-.FMatrixFrame2;
         x => MatValue5.x + ((FMatrixFrame2.width - 10) / 3) + 2;
         y = 4;
         width => ((parent.width - 10) / 3);
         updateMode = 2;
      };
   };

   // User interface for controlling the image capture module 
   macro ImageCapControls {
      UI.UIframe ImageCapFrame<NEx=200.,NEy=88.> {
         y = 4;
         x = 4;
         width = 250;
         height = 180;
      };
      UI.UIlabel UIlabel<NEx=210.,NEy=154.> {
         parent => <-.ImageCapFrame;
         label => "Capture Controls";
         y = 0;
         width => parent.width;
         alignment = "center";
      };
      UI.UIoption Inactive<NEx=385.,NEy=10.> {
         label = "Inactive";
         set = 1;
      };
      UI.UIoption CaptureView<NEx=385.,NEy=55.> {
         label = "Capture from View";
      };
      UI.UIoption CaptureFB<NEx=385.,NEy=100.> {
         label = "Capture from Framebuffer";
      };
      UI.UIoption PlaybackView<NEx=385.,NEy=145.> {
         label = "Playback to View";
      };
      UI.UIoption PlaybackFB<NEx=385.,NEy=190.> {
         label = "Playback to Framebuffer";
      };
      UI.UIoptionMenu Mode<NEx=210.,NEy=231.> {
         parent => <-.ImageCapFrame;
         cmdList => {<-.Inactive,<-.CaptureView,
		<-.CaptureFB,<-.PlaybackView,<-.PlaybackFB};
         selectedItem+nosave = 0;
         x = 4;
         y = 24;
         width = 175;
         alignment = "left";
      };
      UI.UIoption Memory<NEx=385.,NEy=286.>;
      UI.UIoption Disk<NEx=385.,NEy=242.> {
         set = 1;
      };
      UI.UIoptionMenu CaptureMode<NEx=209.,NEy=330.> {
         parent => <-.ImageCapFrame;
         cmdList => {<-.Disk,<-.Memory};
         selectedItem = 0;
         label => "Capture Mode";
         x = 4;
         y = 61;
         width = 175;
         alignment = "left";
      };

      UIlabel TempLabel {
         parent      => <-.ImageCapFrame;
         label       => "Temp File Dir";
         x           = 4;
         y           = 98;
         width       = 80;
         height+nres => UIdata.UIfonts[0].lineHeight;
         alignment = "left";
         active => (<-.CaptureMode.selectedItem == 0);
      };

      UItext TempDir {
         parent => <-.ImageCapFrame;
         x = 95;
         //y => <-.CaptureMode.y + <-.CaptureMode.height + 5;
         y = 95;
         width = 130;
         height+nres => 1.5 * UIdata.UIfonts[0].lineHeight;
         showLastPosition = 1;
         active => (<-.CaptureMode.selectedItem == 0);
      };

      UI.UIbutton Clear<NEx=210.,NEy=286.> {
         parent => <-.ImageCapFrame;
         height = 24;
         label => "Clear";
         y = 130;
         x = 4;
         width = 75;
      };
      GMOD.parse_v ParseClear<NEx=341.,NEy=231.> {
         trigger => <-.Clear.do;
         on_inst = 0;
         relative => "<-.<-";
      };
      UI.UIbutton Record<NEx=374.,NEy=385.> {
         parent => <-.ImageCapFrame;
         y => <-.Clear.y;
         x => ((Clear.x + Clear.width) + 4);
         width = 75;
      };
      UI.UIbutton Delete<NEx=539.,NEy=385.> {
         parent => <-.ImageCapFrame;
         y => <-.Record.y;
         x => ((Record.x + Record.width) + 4);
         width = 75;
      };
      UI.UIlabel NumberOfFrames<NEx=210.,NEy=385.> {
         parent => <-.ImageCapFrame;
         label => "Total Frames";
         y => <-.Clear.y + <-.Clear.height + 4;
         x = 4;
         width => parent.width;
         alignment = "left";
      };
   };

   // User interface for controlling movie generation in 
   // the image capture module.
   macro MovieControls {
      UI.UIframe MovieFrame<NEx=200.,NEy=88.> {
         y = 4;
         x = 4;
         width = 250;
	 height => Generate.y + Generate.height + 8;
      };
      UI.UIlabel UIlabel<NEx=210.,NEy=154.> {
         parent => <-.MovieFrame;
         label => "Movie Controls";
         y = 0;
         width => parent.width;
         alignment = "center";
      };

      UI.UIoption AVI<NEx=385.,NEy=10.> {
         label = "AVI";
      };
      UI.UIoption MPEG1_PAL<NEx=385.,NEy=55.> {
         label = "MPEG 1";
	 set = 1;
      };
      UI.UIoptionMenu Mode<NEx=210.,NEy=231.> {
         parent => <-.MovieFrame;
         cmdList => {<-.AVI,<-.MPEG1_PAL};
         selectedItem = 1;
         x = 4;
         y = 24;
         width = 150;
         alignment = "left";
      };

      VUI.VUIFileSelector FileSelector<NEx=210.,NEy=286.> {
         parent => <-.MovieFrame;
	 x = 4;
	 y = 60;
	 width => parent.clientWidth - 8;
	 fileText.updateMode = 2;
	 fileText.width => parent.clientWidth - 8;
	 fileBrowse.width => parent.clientWidth - 8;
	 title = "Movie Name";
      };

      int MPEG_flag => ((Mode.selectedItem == 1) || (Mode.selectedItem == 2));

      // On Unix, you cant choose a video compression codecs, there is
      // just one built-in codec that emulates AVIzlib.

      UI.UItoggle AVICompress {
         parent => <-.MovieFrame;
         label = "Compress AVI";
#ifdef MSDOS
         message = "Compress AVI with VFW codec";
#else
         message = "Compress AVI with AVIzlib";
#endif
         x = 6;
         y => FileSelector.y + FileSelector.height + 8;
         width = 150;
         visible => !<-.MPEG_flag;
         set = 0;
      };

#ifdef MSDOS
      UI.UIbutton AVIChooseCodec {
         parent => <-.MovieFrame;
         label = "Choose Compression Codec";
         x = 4;
         y => AVICompress.y + AVICompress.height + 8;
         width => parent.clientWidth - 8;
         visible => !<-.MPEG_flag;
         active  => AVICompress.set;
         message = "Choose VFW video codec to compress AVI";
      };
#endif

      UI.UIoption ChooseDefaults {
         label = "Default Settings";
         set = 1;
      };
      UI.UIoption ChooseBitrate {
         label = "Specify Bitrate";
         message = "Constant Bitrate, Variable Quality mode";
      };
      UI.UIoption ChooseQuality {
         label = "Specify Quality";
         message = "Variable Bitrate, Constant Quality mode";
      };
      UI.UIoptionMenu BR_QTY_Menu<NEx=210.,NEy=231.> {
         parent => <-.MovieFrame;
         cmdList => {ChooseDefaults, ChooseBitrate, ChooseQuality};
         selectedItem = 0;
         visible => <-.MPEG_flag;
#ifdef MSDOS
         label = "Bitrate/Quality Settings";
#else
         label = "Bitrate/Quality";
#endif
         x = 4;
         y => FileSelector.y + FileSelector.height + 8;
         width => parent.clientWidth - 8;
         alignment = "left";
      };

      UI.UIlabel BR_QTY_Info {
         parent => <-.MovieFrame;
         x = 0;
         y => BR_QTY_Menu.y + BR_QTY_Menu.height;
         width => parent.clientWidth;
         visible => <-.MPEG_flag;
         message => switch( BR_QTY_Menu.selectedItem+1,
                          "",
                          "CBR mode - Constant Bitrate, Variable Quality",
                          "VBR mode - Constant Quality, Variable Bitrate" );

         label => switch( BR_QTY_Menu.selectedItem+1,
                          "",
                          "Constant Bitrate, Variable Quality",
                          "Constant Quality, Variable Bitrate" );
      };

      UI.UIslider Bitrate {
         parent => <-.MovieFrame;
         title  => "Bitrate in mbps";
         message => "CBR Bitrate in million bits per second";
         visible => <-.MPEG_flag && (<-.ChooseBitrate.set == 1);
         x = 4;
         y => BR_QTY_Info.y + BR_QTY_Info.height + 4;
         //width => parent.clientWidth - 20;
         width => parent.clientWidth - 8;
         min   =  0.1; //    100,000 bps
         value =  1.8; //  1,800,000 bps
         max   = 10.0; // 10,000,000 bps
         decimalPoints = 1;
      };

//      VUIslider_typein Bitrate_typein {
//         slider => Bitrate;
//         visible => Bitrate.visible;
//      };

      UI.UIslider Quality {
         parent => <-.MovieFrame;
         title   => "Quality";
         message => "VBR Quality setting. 2 (highest Q) to 31 (lowest Q)";
         visible => <-.MPEG_flag && (<-.ChooseQuality.set == 1);
         x = 4;
         y => BR_QTY_Info.y + BR_QTY_Info.height + 4;
         width => parent.clientWidth - 8;
         min   =  2;
         value =  4;
         max   = 31;
         mode = "integer";
      };
      UI.UIslider Buffer {
         parent => <-.MovieFrame;
         title   = "VBV Buffer Size";
         message = "VBV Buffer Size in multiples of 16 kbits";
         visible => <-.MPEG_flag && 
                 ((<-.ChooseBitrate.set == 1) || (<-.ChooseQuality.set == 1));
         x = 4;
         y => Bitrate.y + Bitrate.height + 6;
         width => parent.clientWidth - 8;
         min   = 20;
         value = 23;
         max   = 200;
         mode = "integer";
      };

      float bitrate_value => switch( ChooseDefaults.set + 1,
                                   Bitrate.value,
                                   0.0 );
      int quality_value => switch( ChooseDefaults.set + 1,
                                   Quality.value,
                                   0 );
      int buffer_value =>  switch( ChooseDefaults.set + 1,
                                   Buffer.value,
                                   0 );

      UI.UIbutton Generate<NEx=210.,NEy=341.> {
         parent => <-.MovieFrame;
         height = 24;
         label => "Generate Movie";
         x = 4;
#ifdef MSDOS
         y => switch( <-.MPEG_flag+1, 
                      (AVIChooseCodec.y + AVIChooseCodec.height + 8),
                      (Buffer.y + Buffer.height + 12) );
#else
         y => switch( <-.MPEG_flag+1, 
                      (AVICompress.y + AVICompress.height + 8),
                      (Buffer.y + Buffer.height + 12) );
#endif
         width => parent.clientWidth - 8;
      };
   };


   // Parameter block for animator
   group animParam {
      int reset = 0;
      int reset_back = 0;
      int run = 0;
      int run_back = 0;
      int step = 0;
      int step_back = 0;
      int run_options = 0;
      int interp_editor_ok;
      int interp_editor_apply;
      int add_frame;
      int delete_frame;
      int clear_frames;
      int complete_frames;
      int move_frame;
      int re_scan;
      int re_init;
      int frames_per_second = 30;
      float frame_delta = 1.;
      float current_time = 0.;
      int interpolator_selected =0;
      int time_selected = 0;
      float new_time = 0.;
      string interpolator_list<export=2,NEportLevels={0,0}>[];
      int quat_or_euler = 0;
      int interp_type = 0;
      int iscalar = 0;
      float fscalar = 0.;
      float fvalue1 = 0.;
      float fvalue2 = 0.;
      float fvalue3 = 0.;
      int ivalue1 = 0;
      int ivalue2 = 0;
      int ivalue3 = 0;
      float mat_value1 = 0.;
      float mat_value2 = 0.;
      float mat_value3 = 0.;
      float mat_value4 = 0.;
      float mat_value5 = 0.;
      float mat_value6 = 0.;
      int fFrame1_visible = 0.;
      int fFrame2_visible = 0.;
      int fFrame3_visible = 0.;
      int iFrame1_visible = 0.;
      int iFrame2_visible = 0.;
      int interp_editor_visible = 0.;
   };

   // Compute macro for animator
   macro animCompute {
      GMOD.loop loop<NEx=110.,NEy=99.> {
         start_val => AnimControl.frameTimes[0];
         end_val => AnimControl.frameTimes[array_size(AnimControl.frameTimes)-1];
         count = 0.0;
      };
      ANIM.AnimControl AnimControl<NEx=242.,NEy=220.> {
	 count => loop.count;
      };
      GMOD.parse_v ParseDone<NEx=77.,NEy=220.> {
         trigger => loop.count;
	 v_commands = "AnimControl.upd_seq = 1;";
         on_inst = 0;
         relative => ".";
	 // set weight so this will run last
	 parse_v_relative<weight=2>;
      };
   };

   // User interface macro for animator
   macro animUI {
      ilink UIparent<NEx=33.,NEy=33.>;
      KeyframeControls KeyframeControls<NEx=143.,NEy=110.> {
         KeyframeFrame {
	    parent<NEportLevels={3,0}> => UIparent;
            x = 4;
            y = 35;
         };
      };
      PlaybackControlsCommon PlaybackControls<NEx=143.,NEy=187.> {
         PlaybackFrame {
	    parent<NEportLevels={3,0}> => UIparent;
            x = 4;
            y = 420;
            height = 175;
         };
	 UI.UIlabel FPS<NEx=44.,NEy=396.> {
	    parent => PlaybackFrame;
	    label => "Frames Per Second";
	    x = 4;
	    y = 136;
	    width = 125;
	    alignment = "left";
	 };
	 UI.UIfield UIfield<NEx=198.,NEy=396.> {
	    parent => PlaybackFrame;
	    x => ((<-.FPS.x + <-.FPS.width) + 4);
	    y = 132;
	    width = 30;
	    min = 1.;
	    max = 60.;
	    decimalPoints = 0;
	    updateMode = 2;
	 };
      };
      InterpolatorEditorControls InterpolatorEditorControls<NEx=143.,NEy=264.> {
         InterpolatorEditorDialog {
            x = 4;
            y = 425;
         };
      };
   };

   // Parameter block for image capture 
   group imcapParam {
      int reset = 0;
      int reset_back = 0;
      int run = 0;
      int run_back = 0;
      int step = 0;
      int step_back = 0;
      int run_options = 0;
      int loop_count = 0;
      int+nosave mode = 0;
      int capture_mode = 1;
      int clear;
      int record;
      int delete;
      int movie_mode = 1;    // 0 = AVI, 1 = MPEG-1
      int movie_vbr  = 0;    // variable bitrate (VBR) flag 
      float movie_bitrate = 0; // bitrate when in constant bitrate (CBR) mode
      int movie_quality = 0; // quantization level when in VBR mode
      int movie_buffer  = 0; // VBV buffer size in multiples of 16 kbit
      int avi_mode = 0;      // 0 = uncompressed, 1 = compressed
      int avi_fourcc;        // e.g. "DIVX", "HFYU", to specify compression.
      int avi_trigger;        // trigger choose codec
      string filename = "/tmp/avs.mpg";
      string tempdir  = "/tmp";
      int gen_movie;
      int current_image = 0;
      int total_images = 0;
      int cycle_type = 0;
      int delay = 0;
      int timer_step = 0;
      int timer_active = 0;
      int timer_frame_step = 1;
      int timer_frame_value = 0;
   };

   // Compute macro for image capture 
   macro imcapCompute {
      GMOD.loop loop<NEx=88.,NEy=121.> {
         start_val = 0.0;
         end_val => ImageCap.LTotalImages - 1;
	 incr = 1.0;
         count+nosave = 0.0;
      };
      GMOD.timer timer {
	 ValStep => imcapParam.timer_frame_step;
	 Val => imcapParam.timer_frame_value;
      };
      ANIM.ImageCap ImageCap<NEx=242.,NEy=220.> {
	 LCurrentImage => switch(timer.Active+1, loop.count, timer.Val);
	 LCycleType => loop.cycle;
      };
   };

   // User interface macro for image capture 
   macro imcapUI {
      ilink UIparent<NEx=33.,NEy=33.>;
      ImageCapControls ImageCapControls<NEx=143.,NEy=99.> {
         ImageCapFrame {
	    parent<NEportLevels={3,0}> => UIparent;
	    x = 4;
	    y = 4;
         };
      };
      PlaybackControlsCommon PlaybackControls<NEx=143.,NEy=165.> {
         PlaybackFrame {
	    parent<NEportLevels={3,0}> => UIparent;
	    x = 4;
	    y => <-.<-.ImageCapControls.ImageCapFrame.y +
	         <-.<-.ImageCapControls.ImageCapFrame.height + 4;
            height = 210;
         };
	 PlaybackDelay PlaybackDelay {
	    Delay.parent => <-.<-.PlaybackFrame;
	 };
      };
      MovieControls MovieControls<NEx=143.,NEy=231.> {
         MovieFrame {
	    parent<NEportLevels={3,0}> => UIparent;
	    x = 4;
	    y => <-.<-.PlaybackControls.PlaybackFrame.y +
	         <-.<-.PlaybackControls.PlaybackFrame.height + 4;
         };
      };
   };

//------------- geom capture -------------------------------------

   // User interface for controlling the geom capture module 
   macro GeomCapControls {
      UI.UIframe GeomCapFrame {
         y = 4;
         x = 4;
         width = 250;
	 height = 160;
      };
      UI.UIlabel UIlabel {
         parent => <-.GeomCapFrame;
         label => "Capture Controls";
         y = 0;
         width => parent.width;
         alignment = "center";
      };

      UI.UIoption Inactive {
         label = "Inactive";
         set = 1;
      };
      UI.UIoption Capture {
         label = "Capture";
      };
      UI.UIoption Playback {
         label = "Playback";
      };
      UI.UIoptionMenu Mode {
         parent => <-.GeomCapFrame;
         cmdList => {<-.Inactive,<-.Capture,<-.Playback};
         selectedItem+nosave = 0;
         x = 4;
         y = 24;
         width = 175;
         alignment = "left";
      };

      UI.UIoption Memory;
      UI.UIoption Disk {
         set = 1;
      };
      UI.UIoptionMenu CaptureMode {
         parent => <-.GeomCapFrame;
         cmdList => {<-.Disk,<-.Memory};
         selectedItem = 0;
         label => "Capture Mode";
         x = 4;
         y = 61;
         width = 175;
         alignment = "left";
      };

      UI.UIbutton Clear {
         parent => <-.GeomCapFrame;
         height = 24;
         label => "Clear";
         y = 100;
         x = 4;
         width = 75;
      };
      GMOD.parse_v ParseClear {
         trigger => <-.Clear.do;
         on_inst = 0;
         relative => "<-.<-";
      };

      UI.UIbutton Record {
         parent => <-.GeomCapFrame;
         y = 100;
         x => ((Clear.x + Clear.width) + 4);
         width = 75;
      };
      UI.UIbutton Delete {
         parent => <-.GeomCapFrame;
         y = 100;
         x => ((Record.x + Record.width) + 4);
         width = 75;
      };
      UI.UIlabel NumberOfFrames {
         parent => <-.GeomCapFrame;
         label => "Total Frames";
         y = 130;
         x = 4;
         width => parent.width;
         alignment = "left";
      };
   };

   // User interface for controlling anim file generation
   macro GeomOutControls {
      ilink filename => geocapParam.filename;
      UI.UIframe GeomOutFrame<NEx=200.,NEy=88.> {
         y = 4;
         x = 4;
         width = 250;
	 height = 160;
      };
      UI.UIlabel UIlabel {
         parent => <-.GeomOutFrame;
         label => "Output Controls";
         y = 0;
         width => parent.width;
         alignment = "center";
      };

      UI.UIoption avs_gfa {
         label = "AVS gfa (32-bit)";
         set = 1;
      };
      UI.UIoption avs_gfa_long {
         label = "AVS gfa (64-bit)";
#ifdef WORDLENGTH_64
         active = 1;
#else
         active = 0;
#endif
      };      
      UI.UIoption vrml2_bin {
         label = "VRML2 binary";
      };
      UI.UIoptionMenu Format {
         parent => <-.GeomOutFrame;
//	 cmdList => {<-.avs_gfa, <-.vrml2_bin};
         cmdList => {<-.avs_gfa, <-.avs_gfa_long};
         selectedItem => geocapParam.format;
         x = 4;
         y = 24;
         width = 175;
         alignment = "left";
      };

      UIlabel Animation_File {
         parent => <-.GeomOutFrame;
	 x = 4;
	 y => 60;
	 width => parent.clientWidth;
      };
      UItext file_name {
         parent => <-.GeomOutFrame;
	 y => Animation_File.y + Animation_File.height;
	 width => parent.clientWidth - 8;
         text => <-.filename;
         showLastPosition = 1;
      };
      UIbutton file_browse {
         parent => <-.GeomOutFrame;
         y => file_name.y + file_name.height + 4;
	 width => parent.clientWidth - 8;
         label = "Browse";
      };
      UIfileSB FileSelector {
         GMOD.copy_on_change copy_on_change {
	    trigger => <-.<-.file_browse.do;
            input => <-.<-.file_browse.do;
            output => <-.visible;
         };
	 title = "Animation File";
         searchPattern = "/tmp/*.gfa";
         filename => <-.filename;
      };
   };

   // Parameter block for geom capture 
   group geocapParam {
      int reset = 0;
      int reset_back = 0;
      int run = 0;
      int run_back = 0;
      int step = 0;
      int step_back = 0;
      int run_options = 0;
      int loop_count = 0;
      int+nosave mode = 0;
      int capture_mode = 1;
      int clear;
      int record;
      int delete;
      int format = 0;
      string filename = "/tmp/avs.gfa";
      int current_frame = 0;
      int total_frames = 0;
      int delay = 0;
      int timer_step = 0;
      int timer_active = 0;
      int timer_frame_step = 1;
      int timer_frame_value = 0;
   };

   // Compute macro for geom capture 
   macro geocapCompute {
      GMOD.loop loop {
         start_val = 0.0;
         end_val => GeomCap.CTotalFrames - 1;
	 incr = 1.0;
         count+nosave = 0.0;
      };
      GMOD.timer timer {
	 ValStep => geocapParam.timer_frame_step;
	 Val => geocapParam.timer_frame_value;
      };
      ANIM.GeomCap GeomCap {
	 CCurrentFrame => switch(timer.Active+1, loop.count, timer.Val);
	 LCycleType => loop.cycle;
      };
   };

   // User interface macro for geom capture 
   macro geocapUI {
      ilink UIparent;
      GeomCapControls GeomCapControls {
         GeomCapFrame {
	    parent<NEportLevels={3,0}> => UIparent;
	    x = 4;
	    y = 4;
         };
      };
      PlaybackControlsCommon PlaybackControls {
         PlaybackFrame {
	    parent<NEportLevels={3,0}> => UIparent;
	    x = 4;
	    y = 170;
            height = 210;
         };
	 PlaybackDelay PlaybackDelay {
	    Delay.parent => <-.<-.PlaybackFrame;
	 };
      };
      GeomOutControls GeomOutControls {
         GeomOutFrame {
	    parent<NEportLevels={3,0}> => UIparent;
	    x = 4;
	    y = 386;
         };
      };
   };


   macro GeomInControls {
      ilink filename => georepParam.filename;
      UI.UIframe GeomInFrame<NEx=200.,NEy=88.> {
         y = 4;
         x = 4;
         width = 250;
	 height => NumberOfFrames.y + NumberOfFrames.height + 8;
      };
      UI.UIlabel UIlabel {
         parent => <-.GeomInFrame;
         label => "Input Controls";
         y = 0;
         width => parent.width;
         alignment = "center";
      };

      UItoggle CacheToggle {
         parent => <-.GeomInFrame;
	 label = "Full Cache";
	 x = 4;
	 y = 30;
         width => parent.width;
	 set = 0;
      };

      UI.UIoption Memory;
      UI.UIoption Disk {
         set = 1;
      };
      UI.UIoptionMenu ReplayMode {
         parent => <-.GeomInFrame;
         cmdList => {<-.Disk,<-.Memory};
         selectedItem = 0;
         label => "Replay Mode";
         x = 4;
         y => CacheToggle.y + CacheToggle.height + 16;
         width = 175;
         alignment = "left";
      };

      UIlabel Animation_File {
         parent => <-.GeomInFrame;
	 x = 4;
	 y => ReplayMode.y + ReplayMode.height;
	 width => parent.clientWidth;
      };
      UItext file_name {
         parent => <-.GeomInFrame;
	 y => Animation_File.y + Animation_File.height;
	 width => parent.clientWidth - 8;
         text => <-.filename;
         showLastPosition = 1;
      };
      UIbutton file_browse {
         parent => <-.GeomInFrame;
         y => file_name.y + file_name.height + 4;
	 width => parent.clientWidth - 8;
         label = "Browse";
      };
      UIfileSB FileSelector {
         GMOD.copy_on_change copy_on_change {
	    trigger => <-.<-.file_browse.do;
            input => <-.<-.file_browse.do;
            output => <-.visible;
         };
	 title = "Animation File";
         searchPattern = "/tmp/*.gfa";
         filename => <-.filename;
      };

      UI.UIlabel NumberOfFrames {
         parent => <-.GeomInFrame;
         label => "Total Frames";
         x = 4;
         y = 190;
         width => parent.width;
         alignment = "left";
      };
   };

   // Parameter block for geom replay
   group georepParam {
      int reset = 0;
      int reset_back = 0;
      int run = 0;
      int run_back = 0;
      int step = 0;
      int step_back = 0;
      int run_options = 0;
      int loop_count = 0;
      string filename = "/tmp/avs.gfa";
      int fullcache = 0;
      int replay_mode = 1;
      int current_frame = 0;
      int total_frames = 0;
      int delay = 0;
      int timer_step = 0;
      int timer_active = 0;
      int timer_frame_step = 1;
      int timer_frame_value = 0;
   };

   // Compute macro for geom replay
   macro georepCompute {
      GMOD.loop loop {
         start_val = 0.0;
         end_val => GeomRep.CTotalFrames - 1;
	 incr = 1.0;
         count+nosave = 0.0;
      };
      GMOD.timer timer {
	 ValStep => georepParam.timer_frame_step;
	 Val => georepParam.timer_frame_value;
      };
      ANIM.GeomRep GeomRep {
	 CCurrentFrame => switch(timer.Active+1, loop.count, timer.Val);
	 LCycleType => loop.cycle;
      };
   };

   // User interface macro for geom replay
   macro georepUI {
      ilink UIparent;
      GeomInControls GeomInControls {
         GeomInFrame {
	    parent<NEportLevels={3,0}> => UIparent;
	    x = 4;
	    y = 4;
         };
      };
      PlaybackControlsCommon PlaybackControls {
         PlaybackFrame {
	    parent<NEportLevels={3,0}> => UIparent;
	    x = 4;
	    y = 230;
            height = 210;
         };
	 PlaybackDelay PlaybackDelay {
	    Delay.parent => <-.<-.PlaybackFrame;
	 };
      };
   };
};

