/*
                        Copyright (c) 1994 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/v/anim_ui.v#1 $
*/

flibrary+buffered+sort ANIM_MODS<  
   disabled => Templates.CONFIG.anim_kit_disabled>
{

     macro animator {
      ANIM_MACROS.animParam animParam<export_all=2,NEx=288.,NEy=88.>;
      int standalone<NEx=561,NEy=88> = 0;
      UI.UIshell UIshell<NEx=561,NEy=143> {
         title => name_of(<-.<-);
	 visible => standalone;
         width = 270;
	 height = 645;
      };
      UI.UImod_panel UImod_panel<NEx=393.,NEy=143.> {
         title => name_of(<-.<-);
         width = 260;
	 height = 650;
      };
      UI.UItoggle sepWindow<NEx=561,NEy=198> {
         parent => switch(standalone+1, UImod_panel, UIshell);
	 x = 4;
	 y = 4;
         label = "Separate Window";
	 width => 127;
	 set => standalone;
      };
      GMOD.instancer instancer<NEx=396.,NEy=231.> {
         Value => switch(standalone+1, UImod_panel.visible, UIshell.visible);
         active = 2; // don't de-instance when visible = 0
         Group => animUI;
      };
      ANIM_MACROS.animUI animUI<instanced=0,NEx=396.,NEy=187.> {
	 //UIparent => UImod_panel;
	 UIparent => switch(standalone+1, UImod_panel, UIshell);
	 KeyframeControls {
	    Add.do => animParam.add_frame;
	    Delete.do => animParam.delete_frame;
	    Move.do => animParam.move_frame;
            Complete.do => animParam.complete_frames;
            ReScan.do => animParam.re_scan;
            ReInitialize.do => animParam.re_init;
	    ClearQuestion.ok => animParam.clear_frames;
	    number_of_frames => array_size(animCompute.AnimControl.frameTimes);
	    NumberOfFrames.label => ("Total Frames: " + number_of_frames);
	    FrameDelta.value => animParam.frame_delta;
	    string TimeStrings[] => str_format("%5.3f", animCompute.AnimControl.frameTimes);
	    TimesList.strings => TimeStrings;
            InterpolatorList.strings => animParam.interpolator_list;
            InterpolatorList.selectedItem => animParam.interpolator_selected;
	    loopCount => animCompute.loop.count;
	    CurrentTime.value => animParam.current_time;
	    NewTime.value => animParam.new_time;
            
	 };

         InterpolatorEditorControls {
            RotMethod.selectedItem => animParam.quat_or_euler;
            InterpType.selectedItem => animParam.interp_type;
            InterpolatorTimesList.selectedItem => animParam.time_selected;
            InterpolatorTimesList.strings => animCompute.AnimControl.interpTimes;
            string InterpolatorTimesStrings[] => str_format("%5.3f", animCompute.AnimControl.interpTimes);
	    InterpolatorTimesList.strings => InterpolatorTimesStrings;
            fScalar.value => animParam.fscalar;
            iScalar.value => animParam.iscalar;
            fValue1.value => animParam.fvalue1;
            fValue2.value => animParam.fvalue2;
            fValue3.value => animParam.fvalue3;
            iValue1.value => animParam.ivalue1;
            iValue2.value => animParam.ivalue2;
            iValue3.value => animParam.ivalue3;
            MatValue1.value => animParam.mat_value1;
            MatValue2.value => animParam.mat_value2;
            MatValue3.value => animParam.mat_value3;
            MatValue4.value => animParam.mat_value4;
            MatValue5.value => animParam.mat_value5;
            MatValue6.value => animParam.mat_value6;
            FScalarPanel.visible=>animParam.fFrame1_visible;
            FVectorPanel.visible=>animParam.fFrame2_visible;
            FMatrixPanel.visible=>animParam.fFrame3_visible;
            RotMethod.visible=>animParam.fFrame3_visible;
            IScalarPanel.visible=>animParam.iFrame1_visible;
            IVectorPanel.visible=>animParam.iFrame2_visible;
            InterpolatorEditorDialog.visible=>animParam.interp_editor_visible;
            InterpolatorName.visible=>animParam.interp_editor_visible;
            InterpType.visible=>animParam.interp_editor_visible;
            TimesLabel.visible=>animParam.interp_editor_visible;
            InterpolatorTimesList.visible=>animParam.interp_editor_visible;
            InterpolatorEditorDialog.ok=>animParam.interp_editor_ok;
            Apply.do=>animParam.interp_editor_apply;

         };
               
	 PlaybackControls {
	    RunBack.do => animParam.run_back;
	    StepBack.do => animParam.step_back;
	    StepForward.do => animParam.step;
	    RunForward.do => animParam.run;
	    GoToEnd.do => animParam.reset_back;
	    RunOptions.selectedItem => animParam.run_options;
	    Current.label => str_format("%5.3f",animCompute.loop.count);
	    UIfield.value => animParam.frames_per_second;
	    ParseStop.v_commands = "animParam.run = 0;";
	    GoToStart.do => animParam.reset;
	 };
      };
      ANIM_MACROS.animCompute animCompute<NEx=176.,NEy=187.> {
         AnimControl {
            addFrameBtn => animParam.add_frame;
            clearFramesBtn => animParam.clear_frames;
            deleteFrameBtn => animParam.delete_frame;
	    moveFrameBtn => animParam.move_frame;
            completeFramesBtn => animParam.complete_frames;
            reScanBtn => animParam.re_scan;
            reInitBtn => animParam.re_init;
            frameDelta => animParam.frame_delta;
            framesPerSec => animParam.frames_per_second;
            currentTime => animParam.current_time;
	    newTime => animParam.new_time;
            count => loop.count;
            interpolatorList => animParam.interpolator_list;
            interpolatorListIndex => animParam.interpolator_selected;
            interpEditorOkBtn => animParam.interp_editor_ok;
            interpEditorApplyBtn => animParam.interp_editor_apply; 
            timeListIndex => animParam.time_selected; 
            quatOrEuler => animParam.quat_or_euler;
            interpType => animParam.interp_type;
            fScalar => animParam.fscalar;
            iScalar => animParam.iscalar;
            fValue1 => animParam.fvalue1; 
            fValue2 => animParam.fvalue2; 
            fValue3 => animParam.fvalue3; 
            iValue1 => animParam.ivalue1; 
            iValue2 => animParam.ivalue2; 
            iValue3 => animParam.ivalue3; 
            matValue1 => animParam.mat_value1; 
            matValue2 => animParam.mat_value2; 
            matValue3 => animParam.mat_value3; 
            matValue4 => animParam.mat_value4; 
            matValue5 => animParam.mat_value5; 
            matValue6 => animParam.mat_value6; 
            fFrame1Visible=>animParam.fFrame1_visible;
            fFrame2Visible=>animParam.fFrame2_visible;
            fFrame3Visible=>animParam.fFrame3_visible;
            iFrame1Visible=>animParam.iFrame1_visible;
            iFrame2Visible=>animParam.iFrame2_visible;
            interpEditorVisible =>animParam.interp_editor_visible;
            
         };
         loop {
            reset => animParam.reset;
            reset_back => animParam.reset_back;
            run => animParam.run;
            run_back => animParam.run_back;
            step => animParam.step;
            step_back => animParam.step_back;
            cycle => animParam.run_options;
            incr => 1.0/animParam.frames_per_second;
            count = 0.0;
         };
      };
   };

   macro image_capture {
      ANIM_MACROS.imcapParam imcapParam<export_all=2,NEx=288.,NEy=88.>;
      UI.UImod_panel UImod_panel<NEx=393.,NEy=143.> {
         title => name_of(<-.<-);
         width = 260;
      };
      GMOD.instancer instancer<NEx=396.,NEy=231.> {
         Value => UImod_panel.visible;
         active = 2; // don't de-instance when visible = 0
         Group => imcapUI;
      };
      ANIM_MACROS.imcapUI imcapUI<instanced=0,NEx=396.,NEy=187.> {
	  UIparent => UImod_panel;
	  PlaybackControls {
	    RunBack.do => imcapParam.run_back;
	    StepBack.do => imcapParam.step_back;
	    StepForward.do => imcapParam.step;
	    RunForward.do => imcapParam.run;
	    GoToEnd.do => imcapParam.reset_back;
	    RunOptions.selectedItem => imcapParam.run_options;
	    Current.label => str_format("%2d",imcapCompute.ImageCap.LCurrentImage);
	    ParseStop.v_commands = "imcapParam.run = 0;";
	    GoToStart.do => imcapParam.reset;
	    PlaybackDelay.Delay.value => imcapParam.delay;
	 };
	 ImageCapControls {
	    Mode.selectedItem => imcapParam.mode;
	    CaptureMode.selectedItem => imcapParam.capture_mode;
	    TempDir.text      => imcapParam.tempdir;
	    ParseClear.v_commands = "imcapParam.clear = 1; imcapParam.reset = 1;";
	    Record.do => imcapParam.record;
	    Delete.do => imcapParam.delete;
	    NumberOfFrames.label => ("Total Frames: " + imcapParam.total_images);
	 };
	 MovieControls {
	    Mode.selectedItem => imcapParam.movie_mode;
	    FileSelector.file => imcapParam.filename;
	    Generate.do       => imcapParam.gen_movie;
	    AVICompress.set    => imcapParam.avi_mode;
#ifdef MSDOS
	    AVIChooseCodec.do  => imcapParam.avi_trigger;
#endif

            //ChooseQuality.set => imcapParam.movie_vbr;
            GMOD.copy_on_change coc_vbr {
               input  => ChooseQuality.set;
               output => imcapParam.movie_vbr;
            };
            //Bitrate.value     => imcapParam.movie_bitrate;
            GMOD.copy_on_change coc_bitrate {
               input  => bitrate_value;
               output => imcapParam.movie_bitrate;
            };
            //Quality.value     => imcapParam.movie_quality;
            GMOD.copy_on_change coc_quality {
               input  => quality_value;
               output => imcapParam.movie_quality;
            };
            //Buffer.value      => imcapParam.movie_buffer;
            GMOD.copy_on_change coc_buffer {
               input  => buffer_value;
               output => imcapParam.movie_buffer;
            };
	 };
     };
     ANIM_MACROS.imcapCompute imcapCompute<NEx=176.,NEy=187.> {
	 ImageCap {
	    LGDView<NEportLevels={4,0}>;
	    LMode => imcapParam.mode;
	    LCaptureMode => imcapParam.capture_mode;
	    LClear => imcapParam.clear;
	    LRecord => imcapParam.record;
	    LDelete => imcapParam.delete;
	    LMovieMode => imcapParam.movie_mode;
	    LMovieVariableRate => imcapParam.movie_vbr;
	    // convert millon bps to bps
	    LMovieBitRate => 1000000 * imcapParam.movie_bitrate;
	    LMovieQuality => imcapParam.movie_quality;
	    LMovieBuffer  => imcapParam.movie_buffer;
	    LAnimOutFile => imcapParam.filename;
	    LAnimTempDir => imcapParam.tempdir;
	    AVImode       => imcapParam.avi_mode;
#ifdef MSDOS
	    AVIfourcc     => imcapParam.avi_fourcc;
	    AVItrigger    => imcapParam.avi_trigger;
#endif
	    LGenMovie => imcapParam.gen_movie;
	    LCurrentImage => switch(timer.Active+1, loop.count, timer.Val);
	    LTotalImages => imcapParam.total_images;
	    LInputFrameBuffer<NEportLevels={4,0}>;
	    LFrameBuffer<NEportLevels={0,4}>;
	    LRunForward => imcapParam.run;
	    LRunBack => imcapParam.run_back;
	    LCycleType => loop.cycle;
	    LLoopCount => loop.count;
	    LPBDelay => imcapParam.delay;
	    LTimerStep => imcapParam.timer_step;
	    LTimerActive => imcapParam.timer_active;
	    LTimerFrameStep => imcapParam.timer_frame_step;
	    LTimerFrameVal => imcapParam.timer_frame_value;
	 };
	 timer {
	    TimeStep => imcapParam.timer_step;
	    Active => imcapParam.timer_active;
	    ValStep => imcapParam.timer_frame_step;
	    Val => imcapParam.timer_frame_value;
	 };
         loop {
            reset => imcapParam.reset;
            reset_back => imcapParam.reset_back;
            run => imcapParam.run;
            run_back => imcapParam.run_back;
            step => imcapParam.step;
            step_back => imcapParam.step_back;
            cycle => imcapParam.run_options;
            count => imcapParam.loop_count;
         };
      };
   };

   macro geom_capture {
      ilink in_view;
      ANIM.GeomSave_GFA GeomSave_GFA {
		SFilename => geocapParam.filename;
		SFormat => geocapParam.format;
                SGDView   => in_view;
      };
      ANIM_MACROS.geocapParam geocapParam<export_all=2>;
      UI.UImod_panel UImod_panel {
         title => name_of(<-.<-);
         width = 260;
	 height = 650;
      };
      GMOD.instancer instancer {
         Value => UImod_panel.visible;
         active = 2; // don't de-instance when visible = 0
         Group => geocapUI;
      };
      ANIM_MACROS.geocapUI geocapUI<instanced=0> {
	 UIparent => UImod_panel;
	 PlaybackControls {
	    RunBack.do => geocapParam.run_back;
	    StepBack.do => geocapParam.step_back;
	    StepForward.do => geocapParam.step;
	    RunForward.do => geocapParam.run;
	    GoToEnd.do => geocapParam.reset_back;
	    RunOptions.selectedItem => geocapParam.run_options;
	    Current.label => str_format("%2d",geocapCompute.GeomCap.CCurrentFrame);
	    ParseStop.v_commands = "geocapParam.run = 0;";
	    GoToStart.do => geocapParam.reset;
	    PlaybackDelay.Delay.value => geocapParam.delay;
	 };
	 GeomCapControls {
	    Mode.selectedItem => geocapParam.mode;
	    CaptureMode.selectedItem => geocapParam.capture_mode;
	    ParseClear.v_commands = "geocapParam.clear = 1; geocapParam.reset = 1;";
	    Record.do => geocapParam.record;
	    Delete.do => geocapParam.delete;
	    NumberOfFrames.label => ("Total Frames: " + geocapParam.total_frames);
	 };
	 GeomOutControls {
	    Format.selectedItem => geocapParam.format;
	    FileSelector.filename => geocapParam.filename;
	 };
      };
      ANIM_MACROS.geocapCompute geocapCompute {
	 GeomCap {
	    CGDView => in_view;
	    CMode => geocapParam.mode;
	    CCaptureMode => geocapParam.capture_mode;
	    CClear => geocapParam.clear;
	    CRecord => geocapParam.record;
	    CDelete => geocapParam.delete;
	    CAnimOutFile => geocapParam.filename;
	    CCurrentFrame => switch(timer.Active+1, loop.count, timer.Val);
	    CTotalFrames => geocapParam.total_frames;
	    LRunForward => geocapParam.run;
	    LRunBack => geocapParam.run_back;
	    LCycleType => loop.cycle;
	    LLoopCount => loop.count;
	    LPBDelay => geocapParam.delay;
	    LTimerStep => geocapParam.timer_step;
	    LTimerActive => geocapParam.timer_active;
	    LTimerFrameStep => geocapParam.timer_frame_step;
	    LTimerFrameVal => geocapParam.timer_frame_value;
	 };
	 timer {
	    TimeStep => geocapParam.timer_step;
	    Active => geocapParam.timer_active;
	    ValStep => geocapParam.timer_frame_step;
	    Val => geocapParam.timer_frame_value;
	 };
         loop {
            reset => geocapParam.reset;
            reset_back => geocapParam.reset_back;
            run => geocapParam.run;
            run_back => geocapParam.run_back;
            step => geocapParam.step;
            step_back => geocapParam.step_back;
            cycle => geocapParam.run_options;
            count => geocapParam.loop_count;
         };
      };
   };

   macro geom_replay {
      ilink in_view;
      ANIM_MACROS.georepParam georepParam<export_all=2>;
      UI.UImod_panel UImod_panel {
         title => name_of(<-.<-);
         width = 260;
	 height = 650;
      };
      GMOD.instancer instancer {
         Value => UImod_panel.visible;
         active = 2; // don't de-instance when visible = 0
         Group => georepUI;
      };
      ANIM_MACROS.georepUI georepUI<instanced=0> {
	 UIparent => UImod_panel;
	 PlaybackControls {
	    RunBack.do => georepParam.run_back;
	    StepBack.do => georepParam.step_back;
	    StepForward.do => georepParam.step;
	    RunForward.do => georepParam.run;
	    GoToEnd.do => georepParam.reset_back;
	    RunOptions.selectedItem => georepParam.run_options;
	    Current.label => str_format("%2d",georepCompute.GeomRep.CCurrentFrame);
	    ParseStop.v_commands = "georepParam.run = 0;";
	    GoToStart.do => georepParam.reset;
	    PlaybackDelay.Delay.value => georepParam.delay;
	 };
	 GeomInControls {
	    FileSelector.filename => georepParam.filename;
	    NumberOfFrames.label => ("Total Frames: " + georepParam.total_frames);
            CacheToggle.set => georepParam.fullcache;
            ReplayMode.selectedItem => georepParam.replay_mode;
	 };
      };
      ANIM_MACROS.georepCompute georepCompute {
	 GeomRep {
	    CGDView => in_view;
	    CAnimInFile => georepParam.filename;
            CFullCache => georepParam.fullcache;
	    CReplayMode => georepParam.replay_mode;
	    CCurrentFrame => switch(timer.Active+1, loop.count, timer.Val);
	    CTotalFrames => georepParam.total_frames;
	    LRunForward => georepParam.run;
	    LRunBack => georepParam.run_back;
	    LCycleType => loop.cycle;
	    LLoopCount => loop.count;
	    LPBDelay => georepParam.delay;
	    LTimerStep => georepParam.timer_step;
	    LTimerActive => georepParam.timer_active;
	    LTimerFrameStep => georepParam.timer_frame_step;
	    LTimerFrameVal => georepParam.timer_frame_value;
	 };
	 timer {
	    TimeStep => georepParam.timer_step;
	    Active => georepParam.timer_active;
	    ValStep => georepParam.timer_frame_step;
	    Val => georepParam.timer_frame_value;
	 };
         loop {
            reset => georepParam.reset;
            reset_back => georepParam.reset_back;
            run => georepParam.run;
            run_back => georepParam.run_back;
            step => georepParam.step;
            step_back => georepParam.step_back;
            cycle => georepParam.run_options;
            count => georepParam.loop_count;
         };
      };
   };

};
