/*
			Copyright (c) 2001 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/cfd.v#1 $
*/

flibrary CFD <
    disabled => Templates.CONFIG.cfd_kit_disabled,
    needs_use_lic="GD", needs_edit_lic="DV"
    >
{

library+buffered CFD_Modules <
    build_dir="cfd",
    build_cmd="$(MAKE)",
    use_src_file=0
    >
{

// CGNS Reader

module CFDread_cgns <link_files="-lcfd_mods -lcgns">
{
    string+IPort2 file_name;
    string+OPort2 status;
    boolean+IPort2 load; // trigger

    int CurrentBase;
    int CurrentActiveZones[];
    int CurrentSolutions[];

    omethod+notify_val+notify_inst+req scan_cgns (
        file_name+read+req,
        BaseInfo+write,
        ZoneInfo+write,
        status+write
    ) = "CFDread_cgns_scan";

    omethod+notify+req base_change_cgns (
        CurrentBase+read+req,
        BaseInfo+write,
        ZoneInfo+write,
        status+write
    ) = "CFDread_cgns_base_change";

    CgnsBaseInfo+OPort2 BaseInfo;
    CgnsZoneInfo+OPort2 ZoneInfo;

    omethod+notify+req load_cgns<status=1> (
        file_name+read+nonotify+req,
        load+read+notify+req,  // trigger
        CurrentBase+read+nonotify+req,
        CurrentActiveZones+nonotify+read,
        CurrentSolutions+nonotify+read,
        BaseInfo+nonotify+read,
        ZoneInfo+nonotify+read,
        Multi_Block+write,
        Multi_Block_Unstr+write,
        status+write
    ) = "CFDread_cgns_load";

    Multi_Block+OPort2+nosave Multi_Block {
        nblocks = 0;
        fields+Cell_Data;
    };

    group+OPort2+nosave Multi_Block_Unstr {
        int nblocks = 0;
        Mesh+Node_Data+Cell_Data+OPort2 fields[nblocks] {
            ncell_sets = 0;
        };
    };
};

// PLOT3D Reader

module CFDread_PLOT3D<link_files="-lcfd_mods"> {
    string+IPort2 filename_xyz;
    string+IPort2 filename_q;
    int+IPort2 format; // 0 = "ascii", 1 = "binary", 2 = "unformatted binary"
    int+IPort2 iblanks;
    int+IPort2 use_q;
    int+IPort2 dims3d;
    int+IPort2 multiblock;
    int+IPort2 trigger;

    Multi_Block+nosave out <NEportLevels={0,2}>;
    link fields <NEportLevels={1,2},export=1> => out.fields;

    omethod+notify_inst+req rd_plot3d_update<status=1> (
        filename_xyz+read+notify,
        filename_q+read+notify,
        format+read+notify+req,
        iblanks+read+notify+req,
        use_q+read+notify+req,
        trigger+read+notify+req,
        dims3d+read+notify+req,
        multiblock+read+notify+req,
        out+write ) = "CFDread_plot3d_update";
};


}; // CFD_Modules;

library+buffered CFD_Macros<compile_subs=0> {

// CGNS Parameter block

group+OPort CgnsParams {
    string+Port2 filename;
    boolean+Port2 load;
    string+Port2 status = "";
};

group+OPort CgnsOutputParams {
    int+Port2 currentBase;
    int+Port2 currentActiveZones[];
    int+Port2 currentSolutions[];
};

group CgnsBaseInfo {
    int nBase = 0;
    group base_info[0] {
        string base_name;
        int cell_dim;
        int phys_dim;
    };
};

group CgnsZoneInfo {
    int nZone = 0;
    group zone_info[0] {
        string zone_name;
        int zone_type;
        string zone_label;
        int index_dim;
        boolean cartesian;
        int VertexSize[index_dim];
        int CellSize[index_dim];
        int VertexSizeBoundary[index_dim];
        int Rind[2*index_dim];
        int XYZ[3];
        string zone_info;
        int nSolution = 0;
        group sol_info[0] {
            string sol_name;
            int Rind[2*<-.index_dim];
            int GridLocation;
        };
        int nSection = 0;
        group sect_info[0] {
            string sect_name;
            int ElementType;
            int ElementRangeStart;
            int ElementRangeEnd;
            int ElementSizeBoundary;
            int ParentFlag;
        };
    };
};

// CGNS Mid-level functional macro

macro ReadCgnsFunc {

    CgnsParams &CgnsParams<NEportLevels={2,1}>;
    CgnsOutputParams &CgnsOutputParams<NEportLevels={2,1}>;

    CFDread_cgns read_cgns {
        file_name => <-.CgnsParams.filename;
        status    => <-.CgnsParams.status;
        load      => <-.CgnsParams.load;

        CurrentBase          => <-.CgnsOutputParams.currentBase;
        CurrentActiveZones[] => <-.CgnsOutputParams.currentActiveZones;
        CurrentSolutions[]   => <-.CgnsOutputParams.currentSolutions;
    };

    olink BaseInfo     => .read_cgns.BaseInfo;
    olink ZoneInfo     => .read_cgns.ZoneInfo;
    olink Multi_Block  => .read_cgns.Multi_Block;
    olink unstr_fields => .read_cgns.Multi_Block_Unstr.fields;
};

// PLOT3D Parameter block

group+Port ReadPlot3dParam {
    // name of Mesh/grid file to read
    string+Port2 filename_xyz <export=2>;
    // name of Result/solution file to read
    string+Port2 filename_q <export=2>;
    // formatted=0 (ASCII), binary=1, unformatted=2 (also binary);
    int+Port2 format;
    int+Port2 iblanks;
    int+Port2 use_q;
    // 3d dataset (1) or 2d dataset (0)
    int+Port2 dims3d;
    // multi-zone (1) or single zone (0)
    int+Port2 multiblock;
    int+Port2 trigger;
};

}; // CFD Macros

library+buffered CFD_Readers<compile_subs=0> {

// CGNS Reader, UI

macro ReadCgnsUI {
    CgnsParams &CgnsParams<NEportLevels={2,1}>;

    CgnsOutputParams CgnsOutputParams<NEportLevels={0,2}>{
        currentBase => <-.currentBase;
        currentActiveZones => <-.CgnsZoneUI.activeArr;
        currentSolutions   => <-.CgnsZoneUI.solutionArr;
    };

    CgnsBaseInfo &BaseInfo<NEportLevels={2,1}>;


    UImod_panel Read_CGNS<NEx=44.,NEy=77.> {
        parent<NEportLevels={4,0}>;
    };
    UIfileDialog Read_CGNS_Browse<NEx=77.,NEy=374.> {
        visible => <-.file_browse_button.do;
        isModal = 1;
        searchPattern = "$XP_PATH<0>/data/cgns/*.cgns";
        //transfer parameter
        filename => <-.CgnsParams.filename;
    };
    UIlabel CGNS_file_name<NEx=77.,NEy=198.> {
        parent => <-.Read_CGNS;
        y = 0;
        width = 120;
    };
    UItext file_name_text<NEx=77.,NEy=253.> {
        parent => <-.Read_CGNS;
        text<NEportLevels={0,0}> => <-.CgnsParams.filename;
        y => (<-.CGNS_file_name.y + <-.CGNS_file_name.height) + 3;
        width => ((parent.clientWidth - <-.file_browse_button.width) - 5);
    };
    UIbutton file_browse_button<NEx=77.,NEy=308.> {
        parent => <-.Read_CGNS;
        height => <-.file_name_text.height;
        label => "Browse...";
        y => <-.file_name_text.y;
        x => (parent.clientWidth - .width);
        width = 55;
    };

    UItext status_text<NEx=528.,NEy=176.> {
        parent => <-.Read_CGNS;
        y => (<-.file_name_text.y + <-.file_name_text.height) + 3;
        width => parent.clientWidth;
        rows = 3;
        multiLine =1;
        outputOnly = 1;
        resizeToText = 0;
        updateMode = 7;
        color {
            foregroundColor = "Blue";
        };

        text => <-.CgnsParams.status;
    };

    int nBase<NEx=682.,NEy=33.> => BaseInfo.nBase;

    UIoption base_options<NEx=517.,NEy=242.>[nBase] {
        label => <-.BaseInfo.base_info[index_of(base_options)].base_name;
    };

    UIoptionMenu base_option_menu<NEx=297.,NEy=242.> {
#ifdef MSDOS
        y => (<-.status_text.y + <-.status_text.height) + 25;
#else
        y => (<-.status_text.y + <-.status_text.height) + 6;
#endif
        parent => <-.Read_CGNS;
        width => parent.clientWidth;
        label = "Base :";
        cmdList => <-.base_options;
    };
    int currentBase<NEx=539.,NEy=33.> =>
        switch(is_valid(base_option_menu.selectedItem)+1, (!(!nBase)),base_option_menu.selectedItem+1);

#ifdef MSDOS
    GMOD.copy_on_change copy_on_change<NEx=682.,NEy=77.> {
        trigger => <-.nBase;
        input = 0;
        output => <-.base_option_menu.selectedItem;
        on_inst = 0;
    };
#endif

    macro CgnsZoneUI<NEx=297.,NEy=319.> {
        ilink parent<NEx=44.,NEy=22.> => <-.Read_CGNS;

        CgnsZoneInfo &ZoneInfo<NEportLevels={3,1},NEx=517.,NEy=22.>;

        int nZone<NEx=682.,NEy=22.> => ZoneInfo.nZone;

        UIlabel nZonesLabel<NEx=11.,NEy=77.> {
            parent => <-.parent;
            label => ("Zones: " + <-.nZone);
            y => (<-.<-.base_option_menu.y + <-.<-.base_option_menu.height) + 3;
            width => (parent.clientWidth / 2);
        };
        UIlabel nActiveLabel<NEx=176.,NEy=77.> {
            parent => <-.parent;
            label => ("active: " + <-.nActive);
            y => <-.nZonesLabel.y;
            x => <-.nZonesLabel.width;
            width => (parent.clientWidth / 2);
        };
        int nActive<NEx=363.,NEy=22.> => sum(.activeArr);
        int activeArr<NEx=363.,NEy=66.>[.nZone];
        int allowedArr<NEx=363.,NEy=110.>[.nZone] => ZoneInfo.zone_info.cartesian;
        int disallowedArr<NEx=363.,NEy=110.>[.nZone] => init_array(nZone, 0, 0);

        int solutionArr<NEx=363.,NEy=154.>[.nZone] => zone.solutionArrEl;

        UIbutton activateAllButton<NEx=11.,NEy=165.> {
            parent => <-.parent;
            y => (<-.nZonesLabel.y + <-.nZonesLabel.height) + 3;
            width => (parent.clientWidth / 2);
            active => nZone;
            label = "activate all";
        };
        UIbutton deactivateAllButton<NEx=176.,NEy=165.> {
            parent => <-.parent;
            x => <-.activateAllButton.width;
            y => <-.activateAllButton.y;
            width => (parent.clientWidth / 2);
            active => nZone;
            label = "deactivate all";
        };
        UIbutton loadButton<NEx=11.,NEy=209.> {
            parent => <-.parent;
            y => (<-.activateAllButton.y + <-.activateAllButton.height) + 3;
            width => parent.clientWidth;
            height = 30;
            active => nActive;
            label = "Load CGNS";
            do => <-.<-.CgnsParams.load;

        };
        GMOD.parse_v V_do_deactivate<NEx=682.,NEy=154.> {
            v_commands = "!activeArr=disallowedArr;";
            trigger => (<-.deactivateAllButton.do + <-.nZone);
            no_errors = 1;
            on_inst = 0;
            relative => <-.activeArr + <-.disallowedArr;
        };
        GMOD.parse_v V_do_activate<NEx=528.,NEy=154.> {
            v_commands = "!activeArr=allowedArr;";
            trigger => (<-.activateAllButton.do + <-.nZone);
            no_errors = 1;
            on_inst = 0;
            relative => <-.activeArr + <-.allowedArr;
        };
        group zone<NEx=198.,NEy=264.>[nZone] {
            UIframe frame {
                parent => <-.<-.zoneWindow;
                x = 1;
                y => 1+height*index_of(zone);
                width => (parent.clientWidth - 5);
#ifdef MSDOS
                height = 90;
#else
                height = 112;
#endif
            };
            UIlabel zone_label {
                parent => frame;
                y = 0;
                width => (parent.clientWidth - 2);
                label => <-.<-.ZoneInfo.zone_info[index_of(zone)].zone_label;
            };
            UItoggle active_toggle {
                parent => frame;
                x => (parent.clientWidth / 2);
                y => zone_label.y + zone_label.height;
                width => (parent.clientWidth / 2);
                set => <-.<-.activeArr[index_of(zone)];
                active => <-.<-.allowedArr[index_of(zone)];
                label = "Active";
            };
            int nSolution => <-.ZoneInfo.zone_info[index_of(zone)].nSolution;

            UIoption sol_options[nSolution] {
                label => <-.<-.ZoneInfo.zone_info[index_of(zone)].sol_info[index_of(sol_options)].sol_name;
            };
            UIoptionMenu sol_option_menu {
                x = 10;
                y => active_toggle.y + active_toggle.height;
                parent => frame;
                width => parent.clientWidth - x;
                label = "Solution :";
                visible => <-.nSolution;
                cmdList => <-.sol_options;
            };
            int solutionArrEl => switch(is_valid(sol_option_menu.selectedItem)+1,
                                        (!(!nSolution)),
                                        sol_option_menu.selectedItem+1);
            UIlabel zone_info {
                parent => frame;
                y => sol_option_menu.y + sol_option_menu.height;
                width => parent.clientWidth;
                label => <-.<-.ZoneInfo.zone_info[index_of(zone)].zone_info;
            };
        };

        UIscrolledWindow zoneWindow<NEx=11.,NEy=264.> {
            parent => <-.parent;
            x = 0;
            y => (<-.loadButton.y + <-.loadButton.height) + 3;
            width => parent.clientWidth;
#ifdef MSDOS
            height => switch((virtualHeight < 401)+1, 401, virtualHeight-1);
            virtualHeight => max_array(<-.zone.frame.y + <-.zone.frame.height + 20);
#else
            height = 400;
            virtualHeight => max_array(<-.zone.frame.y + <-.zone.frame.height + 2);
#endif
        };
    };
};

// CGNS Reader, Top-level user macro

macro Read_CGNS {

    CgnsParams CgnsParams;

    ReadCgnsUI+nosave ReadCgnsUI {
        CgnsParams => <-.CgnsParams;
        BaseInfo => <-.ReadCgnsFunc.BaseInfo;

        UImod_panel {
            parent<NEportLevels={4,0}>;
        };

        CgnsZoneUI{
            ZoneInfo => <-.<-.ReadCgnsFunc.ZoneInfo;
        };
    };

    ReadCgnsFunc+nosave ReadCgnsFunc {
        CgnsParams => <-.CgnsParams;
        CgnsOutputParams => <-.ReadCgnsUI.CgnsOutputParams;
    };

    olink Multi_Block  => ReadCgnsFunc.Multi_Block;
    olink unstr_fields => ReadCgnsFunc.unstr_fields;
};


// PLOT3D Reader, Top-level user macro

macro Read_PLOT3D {

    ReadPlot3dParam ReadPlot3dParam {
        format = 0;
        iblanks = 1;
        use_q = 1;
        dims3d = 1;
        multiblock = 1;
    };

    macro read_plot3d_ui {
        ReadPlot3dParam+IPort2 &param => <-.ReadPlot3dParam;

        UImod_panel panel {
            title = name_of(<-.<-.<-);
            message = "Select Read PLOT3D control panel.";
        };

        UIlabel Plot3dTitle {
            parent => <-.panel;
            y = 0;
            width => 240;
            label = "Read PLOT3D";
       };
       UIlabel XYZ_Filename {
            parent => <-.panel;
            y => <-.Plot3dTitle.height + 5;
            width => 200;
            alignment = 0;
            label = "XYZ (Grid) Filename:";
        };
        UItext XYZ_file_name {
            parent => <-.panel;
            y => XYZ_Filename.y + XYZ_Filename.height + 5;
            text => <-.param.filename_xyz;
            width = 170;
            showLastPosition = 1;
        };
        UIbutton XYZ_visible {
            parent => <-.panel;
            x => XYZ_file_name.x + XYZ_file_name.width + 5;
            y => XYZ_file_name.y;
            width = 65;
            height => <-.XYZ_file_name.height;
            label = "Browse...";
        };
        UIfileSB xyz_file_browser {
            GMOD.copy_on_change copy_on_change {
                trigger => <-.<-.XYZ_visible.do;
                input => <-.<-.XYZ_visible.do;
                output => <-.visible;
            };
            title = "Plot3d XYZ Filename";
            searchPattern = "$XP_PATH<0>/data/plot3d/*.*";
            &filename => <-.param.filename_xyz;
        };
        UIlabel Q_Filename {
            parent => <-.panel;
            y => XYZ_visible.height + XYZ_visible.y + 10;
            width => 200;
            alignment = 0;
            label = "Q (Results) Filename:";
        };
        UItext Q_file_name {
            parent => <-.panel;
            y => Q_Filename.y + Q_Filename.height + 5;
            text => <-.<-.filename_q;
            text => <-.param.filename_q;
            width = 170;
            showLastPosition = 1;
        };
        UIbutton Q_visible {
            parent => <-.panel;
            x => Q_file_name.x + Q_file_name.width + 5;
            y => Q_file_name.y;
            width = 65;
            height => <-.Q_file_name.height;
            label = "Browse...";
        };
        UIfileSB q_file_browser {
            GMOD.copy_on_change copy_on_change {
                trigger => <-.<-.Q_visible.do;
                input => <-.<-.Q_visible.do;
                output => <-.visible;
            };
            x = 0;
            y = 100;
            title = "Plot3d Q Filename";
            searchPattern = "$XP_PATH<0>/data/plot3d/*.*";
            &filename => <-.param.filename_q;
        };
        UItoggle IBlanks {
            parent => <-.panel;
            y => Q_visible.y + Q_visible.height + 5;
            width = 120;
            height => <-.Q_visible.height;
            label = "IBlanks";
            set => <-.param.iblanks;
        };
        UItoggle UseQ {
            parent => <-.panel;
            y => Q_visible.y + Q_visible.height + 5;
            x = 125;
            width = 120;
            height => <-.Q_visible.height;
            label = "Use Q file data";
            set => <-.param.use_q;
        };
        UItoggle Dims3d {
            parent => <-.panel;
            y => UseQ.y + UseQ.height + 5;
            width = 120;
            height => <-.UseQ.height;
            label = "3D";
            set => <-.param.dims3d;
        };
        UItoggle Multiblock {
            parent => <-.panel;
            y => UseQ.y + UseQ.height + 5;
            width = 120;
            height => <-.UseQ.height;
            x = 125;
            label = "Multiblock";
            set => <-.param.multiblock;
        };
        VUIOptionMenuLabel Format {
            parent => <-.panel;
            y => <-.Dims3d.y + <-.Dims3d.height + 5;
            width = 240;
            options => { "ASCII Formatted",
                         "Binary",
                         "Binary w/padding" };
            label = "File Format";
            selectedItem => <-.param.format;
        };
        UIbutton ReadTrigger {
            parent => <-.panel;
            y => <-.Format.y + <-.Format.height + 5;
            width = 120;
            x = 0;
            height => <-.Q_visible.height;
            label = "Read File";
            do => <-.param.trigger;
        };
    };

    CFDread_PLOT3D read_plot3d {
        filename_xyz => <-.ReadPlot3dParam.filename_xyz;
        filename_q   => <-.ReadPlot3dParam.filename_q;
        format       => <-.ReadPlot3dParam.format;
        iblanks      => <-.ReadPlot3dParam.iblanks;
        use_q        => <-.ReadPlot3dParam.use_q;
        dims3d       => <-.ReadPlot3dParam.dims3d;
        multiblock   => <-.ReadPlot3dParam.multiblock;
        trigger      => <-.ReadPlot3dParam.trigger;
    };

    olink mblock <export_all=2>        => read_plot3d.out;
    mlink+OPort2 fields <export_all=2> => read_plot3d.fields;
};


}; // CFD_Readers;

}; // CFD
