//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//	
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//	
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/compat2.v#1 $
//	

library Dummy;

library Data_Input {
string generate_colormap = <"
   colormap_ui {
      string title;		// displayed on toggle button
      width => UItoggle.width;
      height => UItoggle.height; // this is an output parameter
      // A toggle button to pop up the editor
      Controls.UItoggle UItoggle {
	 label => "Pop up color editor";
	 parent => <-.parent;
	 y => <-.y;
	 width = 250;		// XXX: should be ui_text_width(...)
      };

      DATAMAPS.DefaultLinear Datamap {
	 dataMin = 0;
	 dataMax = 255.0;
      };
      AC_UTIL.Utilities.dmap_to_cmap dmap_to_cmap {
	 dmap_in => <-.Datamap;
	 cmap_in<NEportLevels={3,0}>;
	 free_flag = 0;
      };
      VIEW.UI_Editors.StandAloneDatamapEditor datamap_editor {
	 DatamapEditor.vis => <-.<-.UItoggle.set;
	 DefaultObject {
	    dmap => <-.<-.Datamap;
	 };
      };
      out<NEportLevels={1,2}> => dmap_to_cmap.cmap_out;
   };
   generate_colormap_raw.colormap => colormap_ui.out;
">;
};

library Filters;
library Mappers;
library Data_Output {
string geometry_viewer = <"
   ACVT.ACgeoms_to_obj geoms_to_obj {
      geoms => geometry_viewer_raw.i_Geom_Input;
   };
   GDM.Uviewer3D viewer {
      // viewer input is geom_to_obj output
      Scene.Top.child_objs => geoms_to_obj.ACtop; 
   };
   geometry_viewer_raw.i_Geom_Input<NEportLevels={3,2}>[];
">;

string render_geometry = <"
   ACVT.ACgeoms_to_obj geoms_to_obj {
      geoms => render_geometry_raw.i_Geom_Input;
   };
   GDM.Uviewer3D viewer {
      // viewer input is geom_to_obj output
      Scene.Top.child_objs => geoms_to_obj.ACtop; 
   };
   render_geometry_raw.i_Geom_Input<NEportLevels={3,2}>[];
">;

string render_manager = <"
   ACVT.ACgeoms_to_obj geoms_to_obj {
      geoms => render_manager_raw.i_Geom_Input;
   };
   GDM.Uviewer3D viewer {
      // viewer input is geom_to_obj output
      Scene.Top.child_objs => geoms_to_obj.ACtop; 
   };
   render_manager_raw.i_Geom_Input<NEportLevels={3,2}>[];
">;

string display_image = <"
   display_image_raw.i_Image_Input<NEportLevels={3,2}>;
   ACVT.ACavs_to_image avs_to_image {
      in => display_image_raw.i_Image_Input;
   };
   group xfm {
     DefaultXform xform;
   };
   DVset_xform set_xform {
     in => <-.avs_to_image.out;
     in_xfm => <-.xfm;
   };
   VIEW.DataObject object {
      in => <-.set_xform.out;
   };
   GDM.Uviewer2D viewer {
      Scene.Top.child_objs => object.obj;
   };
">;

string image_viewer = <"
   image_viewer_raw.i_Image_Input<NEportLevels={3,2}>;
   mlink image_in<NEportLevels={1,1}> =>image_viewer_raw.i_Image_Input;

   macro xform_image[array_size(image_in)] {
      group xfm<NEportLevels={0,1}> {
        DefaultXform xform;
      };
      ACVT.ACavs_to_image avs_to_image {
	 in<NEportLevels={3,0}> => image_in[index_of(<-.<-.xform_image)];
         out<NEportLevels={0,2}>;
      };
      DVset_xform set_xform {
	 in<NEportLevels={2,0}> => avs_to_image.out;
	 in_xfm<NEportLevels={2,0}> => xfm;
         out<NEportLevels={0,3}>;
      };
   };
   VIEW.DataObjects nobjects {
      in_fields<NEportLevels={2,1}> => xform_image.set_xform.out;
      dos.obj<NEportLevels={0,3}>;
   };
   GDM.Uviewer2D viewer {
Scene.Top.child_objs => nobjects.dos.obj;
   };
">;
};

// Modifications to existing modules to fix bugs, etc.

Data_Input {

// All of these need file browsers, not just strings
string read_field = <"
   -Read_Field_Browser_ui;	// punt this text-line browser
   AC_UTIL.Utilities.ACfile_sel_box Read_Field_Browser_ui {
      parent+nres => <-.UImod_panel;
      searchPattern+nres => (NetworkEditor.dataObj.AVSpaths.DataDirectory +
			     "/field/*.fld");
      filename+nres<NEportLevels={2,0}> => <-.read_field_raw.Read_Field_Browser;
      title => name_of(<-.<-);
      y => <-.UIlabel.y + <-.UIlabel.height + 4;
   };
   Data_Conversion_ui {
      y => <-.Read_Field_Browser_ui.y + <-.Read_Field_Browser_ui.height + 4;
   };
   // this is a 2-line label
   Read_Status_ui.textW.height+nres => (UIdata.UIfonts[0].lineHeight * 2);
">;

string read_image = <"
   -Read_Image_Browser_ui;	// punt this text-line browser
   AC_UTIL.Utilities.ACfile_sel_box Read_Image_Browser_ui {
      parent+nres => <-.UImod_panel;
      searchPattern+nres => (NetworkEditor.dataObj.AVSpaths.DataDirectory +
			     "/image/*.x");
      filename+nres<NEportLevels={2,0}> => <-.read_image_raw.Read_Image_Browser;
      title => name_of(<-.<-);
      y => <-.UIlabel.y + <-.UIlabel.height + 4;
   };
">;

string read_geom = <"
   -filename_ui;	// punt this text-line browser
   AC_UTIL.Utilities.ACfile_sel_box filename_ui {
      parent+nres => <-.UImod_panel;
      searchPattern+nres => (NetworkEditor.dataObj.AVSpaths.DataDirectory +
			     "/geometry/*.geom");
      filename+nres<NEportLevels={2,0}> => <-.read_geom_raw.filename;
      title => name_of(<-.<-);
      y => <-.UIlabel.y + <-.UIlabel.height + 4;
   };
">;

string read_ucd = <"
   -read_file_ui;	// punt this text-line browser
   AC_UTIL.Utilities.ACfile_sel_box read_file_ui {
      parent+nres => <-.UImod_panel;
      searchPattern+nres => (NetworkEditor.dataObj.AVSpaths.DataDirectory +
			     "/ucd/*.inp");
      filename+nres<NEportLevels={2,0}> => <-.read_ucd_raw.read_file;
      title => name_of(<-.<-);
      y => <-.UIlabel.y + <-.UIlabel.height + 4;
   };
">;

string read_volume = <"
   -Read_Volume_Browser_ui;	// punt this text-line browser
   AC_UTIL.Utilities.ACfile_sel_box Read_Volume_Browser_ui {
      parent+nres => <-.UImod_panel;
      filename+nres<NEportLevels={2,0}> => <-.read_volume_raw.Read_Volume_Browser;
      searchPattern+nres => (NetworkEditor.dataObj.AVSpaths.DataDirectory +
			     "/volume/*" +
			     <-.read_volume_raw.max_Read_Volume_Browser);
      title => name_of(<-.<-);
      y => <-.UIlabel.y + <-.UIlabel.height + 4;
   };
">;

};
