//       Copyright (c) 1999 by
//       Advanced Visual Systems Inc.
//       All Rights Reserved
//
// This software comprises unpublished confidential information of
// Advanced Visual Systems Inc. and may not be used, copied or made
// available to anyone, except in accordance with the license
// under which it is furnished.
//
// This file is under Perforce control
// $Id: //depot/express/fcs70/v/db.v#1 $
//
$include ../include/$MACHINE/config.h

flibrary DB <
   hdr_code="void db_xp_init();",
   init_code="db_xp_init();",
   build_dir="db_kit",
   build_cmd="$(MAKE)",
   link_files="-ldbmod -lcxxut",
   libdeps = "DBIL FLD",
   needs_edit_lic="DB",
   use_src_file=0,
   disabled => Templates.CONFIG.db_kit_disabled,
   cxx_hdr_files="fld/Xfld.h",
   out_hdr_file="db_xp_omx.hxx",
   out_src_file="db_xp_omx.cxx"
> {


library+sort+global+buffered Modules<NEdisplayMode="NEopened"> {
   // Define structure to hold an 'array' of attribute data, frequently referred
   // to as a 'column'
   //

   Data_Array DBcolumn<cxx_name="XP_Column"> {
      veclen = 1;
   };

   // Define structure to hold an 'array' of null indicators
   //
   group Null_Array<cxx_name="XP_Nulls"> {
      char+write    values[];
   };

   // Define structure to hold an 'array' of null indicators
   //
   group Simple_DB_Column<cxx_name="XP_Simple_Column"> {
      prim+write    values[];
   };

   // method to set messages and status code
   // serve as base class to all modules
   group DBgroup <cxx_name="XP_Base_Group", cxx_members=
   "\tvoid setStatus(char * msg, int rc); \
    void setDBErrors(void * connect);\n">
   {
      string+write                     message;
      int+write                        return_code;
      int+IPort2+read+write            process_statement;
      int+write                        processing;
      int                              statement_error_offset = 0;
      string+write                     db_specific_error_message;
      int+write                        db_specific_error_code;
   };

   group DBflushEvents<NEx=66,NEy=165> {
     int+Iparam in;
     int+Oparam out = 0;
     method+notify_val update = "DBflushEvents";
   };
   /*------------------------------------------*/
   /*-             DBconnect                  -*/
   /*-                                        -*/
   /*-    Used to create the initial database -*/
   /*-    login and connection structure.     -*/
   /*------------------------------------------*/
   group DBconnect <cxx_name="XP_Connect",cxx_class="DBIL_Connection",
                         cxx_hdr_files="../dbil/dbil_connect.hxx",NEcolor0=255>
   {
     cxxmethod+notify_inst+req Connect(.connect_disconnect+read+write+notify,
                                       .database_driver+read+write,
                                       .server_host+read+write,
                                       .server_name+read+write,
                                       .database_name+read+write,
                                       .user_id+read+write,
                                       .user_password+read+write,
                                       .connect_string+read+write,
                                       .connect_status+write,
                                       .message+write,
                                       .return_code+write,
                                       .dbvisual_connect_descriptor+write
     );
     cxxmethod+notify_deinst Disconnect(.connect_disconnect+read+write,
                                        .connect_status+write,
                                        .message+write
     );
     string+IPort2 database_driver;
     string+IPort2 server_host;
     string+IPort2 server_name;
     string+IPort2 database_name;
     string+IPort2 user_id;
     string+IPort2 user_password;
     string       connect_string;
     int          connect_disconnect;
     string       log_filename = "/tmp/DBlogfile";
     int          append_mode = 1;
     int          connect_status=0;
     string       message;
     int          return_code;
     ptr+Oparam   dbvisual_connect_descriptor;
   };

   group DBconnectInformation{
     string            database_driver;
     string            server_host;
     string            server_name;
     string            database_name;
     string            user_id;
     string            connect_string;
     int               connected;
   };

   // group DBprepareStatement
   // purpose: Prepare (or parse) a relational SQL query
   //
   DBgroup DBprepareStatement <cxx_name="XP_Prep_Query",cxx_class="DBIL_Query",
                            cxx_hdr_files="../dbil/dbil_query.hxx",NEcolor0=65280> 
   {
      cxxmethod+notify_inst+notify_deinst+req prepare(
                            .dbvisual_connect_descriptor+read+notify+req,
                            .statement+read+notify,
                            .process_statement+read+write+notify,
                            .connect_information+write,
                            .db_specific_error_message+write,
                            .db_specific_error_code+write,
                            .rows_per_fetch+read,
                            .userbuf_realloc_interval+read,
                            .userbuf_row_limit+read,
                            .message+write,
                            .processing+write,
                            .done+write,
                            .dbquery_descriptor+write,
                            .return_code+write
                            );
      ptr               dbvisual_connect_descriptor<NEportLevels={2,2}>;
      ptr+Oparam        dbquery_descriptor;
      DBconnectInformation connect_information;
      string+IPort2     statement;
      int               rows_per_fetch = 100;
      int               userbuf_realloc_interval = 100;
      int               userbuf_row_limit = 10000;
      int+Oparam        done=0;
   };

   // group DBexecuteStatement
   // purpose: Execute a relational SQL query
   //
   DBgroup DBexecuteStatement <cxx_name="XP_Exec_Query",
                           cxx_hdr_files="../dbil/dbil_query.hxx",NEcolor0=65280> 
   {
      cxxmethod+notify_inst+req execute(.dbvisual_connect_descriptor+read+notify+req,
                            .dbquery_descriptor+read+notify,
                            .process_statement+read+write+notify,
                            .connect_information+write,
                            .db_specific_error_message+write,
                            .db_specific_error_code+write,
                            .message+write,
                            .processing+write,
                            .iterations+read,
                            .done+write,
                            .return_code+write
                            );
      ptr               dbvisual_connect_descriptor<NEportLevels={2,2}>;
      ptr               dbquery_descriptor<NEportLevels={2,2}>;
      DBconnectInformation connect_information;
      int               iterations = 1;
      int+Oparam        done=0;
   };

   // group DBdefine
   // purpose: Define the output data buffer returned by a query
   DBgroup DBdefine <cxx_name="XP_Define_Query",
                           cxx_hdr_files="../dbil/dbil_query.hxx",NEcolor0=65280> 
   {
      cxxmethod+notify_inst+req define(.dbvisual_connect_descriptor+read+notify+req,
                            .dbquery_descriptor+read+notify,
                            .process_statement+read+write+notify,
                            .connect_information+write,
                            .db_specific_error_message+write,
                            .db_specific_error_code+write,
                            .use_floating_type_only+read,
                            .floating_type+read,
                            .fixed_type+read,
                            .message+write,
                            .processing+write,
                            .done+write,
                            .return_code+write
                            );
      ptr+IPort2     dbvisual_connect_descriptor;
      ptr            dbquery_descriptor<NEportLevels={2,2}>;
      DBconnectInformation connect_information;
      int               use_floating_type_only = 0;
      int               floating_type = 1;
      int               fixed_type = 1;
      int+Oparam        done=0;
   };


   // group DBfetch
   // purpose: Fetch data returned by a relational SQL query
   //
   DBgroup DBfetch <cxx_name="XP_Fetch",need_objs="Cell_Data_Set_Poly Cell_Data_Set int",
      cxx_members="\tint Cancelled() const {return (int) cancel_button;}\n">
   {
      cxxmethod+notify_inst+req fetch(  .dbquery_descriptor+read+notify+req,
                            .loop+read,
                            .cancel_button+read,
                            .fetch_cancelled+write,
                            .fetch_complete+write,
                            .process_statement+read+write+notify,
                            .flush_when_full+read,
                            .query_timeout_secs+read,
                            .null_value_byte+read,
                            .null_value_short+read,
                            .null_value_int+read,
                            .null_value_uint+read,
                            .null_value_float+read,
                            .null_value_double+read,
                            .null_value_string+read,
                            .output_statistics.num_fetches_for_query+write,
                            .output_statistics.rows_processed+write,
                            .output_statistics.num_output_columns+write,
                            .row_specific_error_cnt+write,
                            .output_statistics.userbuf_rows_allocated+write,
                            .output_statistics.userbuf_rows_used+write,
                            .output_statistics.userbuf_bytes_allocated+write,
                            .connect_information+write,
                            .db_specific_error_message+write,
                            .db_specific_error_code+write,
                            .column_array+write,
                            .null_indicators+write,
                            .message+write,
                            .return_code+write,
                            .processing+write,
                            .num_columns+write
                            );
      ptr+IPort2        dbquery_descriptor;
      int               loop =1;                      //auto fetch loop
      int               new_statement=1;
      int               query_timeout_secs= 60;
      int               cancel_button;
      int               fetch_cancelled;
      int               fetch_complete;
      int               flush_when_full = 0;
      int               null_value_byte<NEportLevels=1> = -127 ;
      int               null_value_short<NEportLevels=1> = -999 ;
      int               null_value_int<NEportLevels=1> = -999 ;
      int               null_value_uint<NEportLevels=1> = -1 ;
      float             null_value_float<NEportLevels=1> = -999 ;
      double            null_value_double<NEportLevels=1> = -999;
      string            null_value_string<NEportLevels=1> = "<Null>" ;
      group output_statistics {
        int             num_fetches_for_query;
        int             rows_processed;
        int             num_output_columns;
        int             userbuf_rows_allocated;
        int             userbuf_rows_used;
        int             userbuf_bytes_allocated;
      };
      int               row_specific_error_cnt=0;
      DBconnectInformation connect_information;
      int               num_columns;
      Simple_DB_Column+Oparam  column_array [];
      Null_Array+Oparam    null_indicators [num_columns];
   };
   /*------------------------------------------*/
   /*-             DBquery                    -*/
   /*-                                        -*/
   /*-    Used to issue a select statement    -*/
   /*-    to the data base and a fetch.       -*/
   /*------------------------------------------*/

   // group DBquery
   // purpose: Aggregate function that performs preparation, execution,
   //       definition, and fetch in one continues action.
   DBgroup DBquery <need_objs="Cell_Data_Set_Poly Cell_Data_Set int", 
                     cxx_name="XP_Query", cxx_members=
      "\tint Cancelled() const {return (int) cancel_button;}\n",cxx_class="DBIL_Query",
                            cxx_hdr_files="../dbil/dbil_query.hxx"> 
      {
         cxxmethod+req+notify_inst+notify_deinst query(.dbvisual_connect_descriptor+read+req+notify,
                               .statement+read,
                               .loop+read,
                               .cancel_button+read,
                               .fetch_cancelled+write,
                               .fetch_complete+write,
                               .process_statement+read+write+notify,
                               .flush_when_full+read,
                               .query_timeout_secs+read,
                               .rows_per_fetch+read,
                               .userbuf_row_limit+read,
                               .userbuf_realloc_interval+read,
                               .use_floating_type_only+read,
                               .floating_type+read,
                               .fixed_type+read,
                               .null_value_byte+read,
                               .null_value_short+read,
                               .null_value_int+read,
                               .null_value_uint+read,
                               .null_value_float+read,
                               .null_value_double+read,
                               .null_value_string+read,
                               .output_statistics.num_fetches_for_query+write,
                               .output_statistics.rows_processed+write,
                               .output_statistics.num_output_columns+write,
                               .row_specific_error_cnt+write,
                               .output_statistics.userbuf_rows_allocated+write,
                               .output_statistics.userbuf_rows_used+write,
                               .output_statistics.userbuf_bytes_allocated+write,
                               .connect_information+write,
                               .db_specific_error_message+write,
                               .db_specific_error_code+write,
                               .column_array+write,
                               .null_indicators+write,
                               .message+write,
                               .return_code+write,
                               .processing+write,
                               .num_columns+write
                               );
      ptr               dbvisual_connect_descriptor<NEportLevels=2>;
      string            statement<NEportLevels=2>;
      int               loop =1;                      //auto fetch loop
      int               new_statement=1;
      int               query_timeout_secs= 60;
      int               cancel_button;
      int               fetch_cancelled;
      int               fetch_complete;
      int               flush_when_full = 0;
      int               rows_per_fetch = 100;
      int               userbuf_row_limit = 10000;
      int               userbuf_realloc_interval = 100;
      int               use_floating_type_only = 0;
      int               floating_type = 1;
      int               fixed_type = 1;
      int               null_value_byte<NEportLevels=1> = -127 ;
      int               null_value_short<NEportLevels=1> = -999 ;
      int               null_value_int<NEportLevels=1> = -999 ;
      int               null_value_uint<NEportLevels=1> = -1 ;
      float             null_value_float<NEportLevels=1> = -999 ;
      double            null_value_double<NEportLevels=1> = -999;
      string            null_value_string<NEportLevels=1> = "<Null>" ;
      group output_statistics{
        int             num_fetches_for_query;
        int             rows_processed;
        int             num_output_columns;
        int             userbuf_rows_allocated;
        int             userbuf_rows_used;
        int             userbuf_bytes_allocated;
      };
      int               row_specific_error_cnt=0;
      DBconnectInformation connect_information;
      int               num_columns;
      DBcolumn+Oparam  column_array []{
         null_flag = 0;
      };
      Null_Array+Oparam null_indicators [num_columns];
   };

   /*------------------------------------------*/
   /*-             DBmiscStatement            -*/
   /*-                                        -*/
   /*-    Used to issue a misc. statement     -*/
   /*-                                        -*/
   /*------------------------------------------*/

   DBgroup DBmiscStatement <cxx_name="XP_Misc_SQL"> {
            cxxmethod+notify_inst+req process(.dbvisual_connect_descriptor+read+req+notify,
                                              .process_statement+read+write+notify,
                                              .statement+read,
                                              .connect_information+write,
                                              .db_specific_error_message+write,
                                              .db_specific_error_code+write,
                                              .message+write,
                                              .processing+write,
                                              .return_code+write
                                              );
      ptr                  dbvisual_connect_descriptor<NEportLevels=2>;
      string               statement<NEportLevels=2>;
      DBconnectInformation connect_information;
   };
   /*------------------------------------------*/
   /*-             DBinsert                   -*/
   /*-                                        -*/
   /*-    Used to insert data into the datab. -*/
   /*-                                        -*/
   /*------------------------------------------*/

   DBgroup DBinsert <cxx_name="XP_Insert">{
            cxxmethod+notify_inst+req insert(.dbvisual_connect_descriptor+read+req+notify,
                                             .process_statement+read+write+notify,
                                             .statement+read,
                                             .connect_information+write,
                                             .statement_error_offset+write,
                                             .db_specific_error_message+write,
                                             .db_specific_error_code+write,
                                             .message+write,
                                             .processing+write,
                                             .return_code+write
                                             );
      ptr                  dbvisual_connect_descriptor<NEportLevels=2>;
      string               statement<NEportLevels=2>;
      DBconnectInformation connect_information;
   };

   /*------------------------------------------*/
   /*-             DBupdate                   -*/
   /*-                                        -*/
   /*-    Used to update data into the datab. -*/
   /*-                                        -*/
   /*------------------------------------------*/

   DBgroup DBupdate <cxx_name="XP_Update">{
            cxxmethod+notify_inst+req update(.dbvisual_connect_descriptor+read+req+notify,
                                             .process_statement+read+write+notify,
                                             .statement+read,
                                             .connect_information+write,
                                             .statement_error_offset+write,
                                             .db_specific_error_message+write,
                                             .db_specific_error_code+write,
                                             .message+write,
                                             .processing+write,
                                             .return_code+write
                                             );
      ptr                  dbvisual_connect_descriptor<NEportLevels=2>;
      string               statement<NEportLevels=2>;
      DBconnectInformation connect_information;
   };

   /*------------------------------------------*/
   /*-             DBdelete                   -*/
   /*-                                        -*/
   /*-    Used to delete data from the datab. -*/
   /*-                                        -*/
   /*------------------------------------------*/
   DBgroup DBdelete <cxx_name="XP_Delete">{
            cxxmethod+notify_inst+req sql_delete(.dbvisual_connect_descriptor+read+req+notify,
                                             .process_statement+read+write+notify,
                                             .statement+read,
                                             .connect_information+write,
                                             .statement_error_offset+write,
                                             .db_specific_error_message+write,
                                             .db_specific_error_code+write,
                                             .message+write,
                                             .processing+write,
                                             .return_code+write
                                             );
      ptr                  dbvisual_connect_descriptor<NEportLevels=2>;
      string               statement<NEportLevels=2>;
      DBconnectInformation connect_information;
   };

   /*------------------------------------------*/
   /*-             DBcommit                   -*/
   /*-                                        -*/
   /*-    Used to commit data into the datab. -*/
   /*-                                        -*/
   /*------------------------------------------*/

   DBgroup DBcommit <cxx_name="XP_Commit">{
            cxxmethod+notify_inst+req commit(.dbvisual_connect_descriptor+read+req+notify,
                                             .process_statement+read+write+notify,
                                             .statement+read,
                                             .connect_information+write,
                                             .statement_error_offset+write,
                                             .db_specific_error_message+write,
                                             .db_specific_error_code+write,
                                             .message+write,
                                             .processing+write,
                                             .return_code+write
                                             );
      ptr                  dbvisual_connect_descriptor<NEportLevels=2>;
      int                  process_commit<NEportLevels=2>;
      string               statement<NEportLevels=2>;
      DBconnectInformation connect_information;
      process_statement => process_commit;
   };

   /*------------------------------------------*/
   /*-             DBrollback                 -*/
   /*-                                        -*/
   /*-    Used to rollback transactions.      -*/
   /*-                                        -*/
   /*------------------------------------------*/

   DBgroup DBrollback <cxx_name="XP_Rollback">{
            cxxmethod+notify_inst+req rollback( .dbvisual_connect_descriptor+read+req+notify,
                                                .process_statement+read+write+notify,
                                                .statement+read,
                                                .connect_information+write,
                                                .statement_error_offset+write,
                                                .db_specific_error_message+write,
                                                .db_specific_error_code+write,
                                                .message+write,
                                                .processing+write,
                                                .return_code+write
                                                );
      ptr                  dbvisual_connect_descriptor<NEportLevels=2>;
      int                  process_rollback<NEportLevels=2>;
      string               statement<NEportLevels=2>;
      DBconnectInformation connect_information;
      process_statement => process_rollback;
   };

   /*------------------------------------------*/
   /*-             DBcancel                   -*/
   /*-                                        -*/
   /*-    Used to DBcancel a transaction.     -*/
   /*-                                        -*/
   /*------------------------------------------*/

   DBgroup DBcancel <cxx_name="XP_Cancel">{
            cxxmethod+req cancel(.dbvisual_connect_descriptor+read+req+notify,
                                 .dbquery_descriptor+read,
                                 .process_statement+read+write+notify,
                                 .connect_information+write,
                                 .statement_error_offset+write,
                                 .db_specific_error_message+write,
                                 .db_specific_error_code+write,
                                 .message+write,
                                 .processing+write,
                                 .return_code+write
                                 );
      ptr                  dbvisual_connect_descriptor<NEportLevels=2>;
      ptr                  dbquery_descriptor<NEportLevels=2>;
      int                  process_cancel<NEportLevels=2>;
      DBconnectInformation connect_information;
      process_statement => process_cancel;
   };

   /*-------------------------------------------------*/
   /*-             DBlist                            -*/
   /*-                                               -*/
   /*-    Used to list the output of a query.        -*/
   /*-                                               -*/
   /*-------------------------------------------------*/
   /* Header mode is as follows                       */
   /*       0-> No header information in the list     */
   /*       1-> Column names for the header           */
   /*       2-> Column names and types for the header */
   /*                                                 */
   /* Column_mode is as follows                       */
   /*       0-> Single column mode                    */
   /*       1-> Multiple columns                      */
   /*-------------------------------------------------*/

   group DBlist <cxx_name="XP_List"> {
     int                      num_columns => array_size(column_array);
     DBcolumn+Iparam+req     &column_array[];
     int+Iparam+req           num_rows_to_list;
     int+Iparam+req           header_mode;
     int+Iparam+req           column_mode;
     int+Iparam+req           column_width;
     int+Iparam+req           active_mode;
     string+Oparam            message;
     int+Oparam               return_code = 0;
     int+nonotify             num_strings;
     string+Oparam            list_string[num_strings];
     cxxmethod+notify_val+req list;
   };

   /*------------------------------------------*/
   /*-             DBload                     -*/
   /*-                                        -*/
   /*-  Used to load a statement from a file  -*/
   /*-                                        -*/
   /*------------------------------------------*/

   group DBload <cxx_name="XP_Load"> {
     cxxmethod+req load (  .file_name+read+req,
                           .process_load+read+notify,
                           .statement+write,
                           .processing+write
                        );
     string          file_name<NEportLevels=2>;
     int             process_load<NEportLevels=2>;
     string+Oparam   statement;
     int             processing;
   };
   /*------------------------------------------*/
   /*-             DBsave                     -*/
   /*-                                        -*/
   /*-  Used to save a statement to a file    -*/
   /*-                                        -*/
   /*------------------------------------------*/

   group DBsave <cxx_name="XP_Save"> {
     cxxmethod+req save (.file_name+read+req,
                         .process_save+read+notify,
                         .num_of_strings+read,
                         .string_array+read,
                         .processing+write
                        );
     string          file_name<NEportLevels=2>;
     int             process_save<NEportLevels=2>;
     int+Oparam      processing;
     int             num_of_strings=>array_size(string_array);
     string          &string_array[];
   };

   /*------------------------------------------*/
   /*-             DBsaveConnect              -*/
   /*- Used to save off the connect info      -*/
   /*------------------------------------------*/

   group DBsaveConnect <cxx_name="XP_Save_Connect"> {
     cxxmethod+req save_connect  (  .file_name+read+req,
                                    .process_save+read+notify+req,
                                    .database_driver+read,
                                    .server_host+read,
                                    .server_name+read,
                                    .database_name+read,
                                    .user_id+read,
                                    .user_password+read,
                                    .connect_string+read,
                                    .processing+write
                                 );
     string+Iparam      file_name;
     int+Oparam         processing;
     string+Iparam      file_name;
     string+IPort2      database_driver;
     string+IPort2      server_host;
     string+IPort2      server_name;
     string+IPort2      database_name;
     string+IPort2      user_id;
     string+IPort2      user_password;
     string+IPort2      connect_string;
     int+IPort2         process_save;
   };
   /*-------------------------------------------*/
   /*-             DBloadConnect               -*/
   /*- Used to load the connect info from afile-*/
   /*-------------------------------------------*/

   group DBloadConnect <cxx_name="XP_Load_Connect"> {
     cxxmethod+req load_connect  (  .file_name+read+notify+req,
                                    .process_load+read+notify+req,
                                    .database_driver+write,
                                    .server_host+write,
                                    .server_name+write,
                                    .database_name+write,
                                    .user_id+write,
                                    .user_password+write,
                                    .connect_string+write
                                 );
     string+Iparam      file_name;
     int+IPort2         process_load;
     string+OPort2      database_driver;
     string+OPort2      server_host;
     string+OPort2      server_name;
     string+OPort2      database_name;
     string+OPort2      user_id;
     string+OPort2      user_password;
     string+OPort2      connect_string;
   };

   /*------------------------------------------*/
   /*-             DBappendStatement          -*/
   /*- Used to append multiple statments      -*/
   /*------------------------------------------*/

   group DBappendStatement <cxx_name="XP_Append_Stmt">{
     cxxmethod+req append_stmt   (  .string_a+read,
                                    .string_b+read+notify,
                                    .process+read+req,
                                    .result_string+write
                                 );
     string+IPort2         string_a;
     string+IPort2         string_b;
     int+IPort2            process;
     string+OPort2         result_string;
   };

   /*------------------------------------------*/
   /*-             DBloadOther                -*/
   /*- Used to load the other area            -*/
   /*------------------------------------------*/

   group DBloadOther <cxx_name="XP_Load_Other"> {
     cxxmethod+req load_other (  .file_name+read+req,
                                 .process_load+read+notify,
                                 .list+write,
                                 .processing+write
                              );
     string          file_name<NEportLevels=2>;
     int             process_load<NEportLevels=2>;
     string+Oparam   list[];
     int+Oparam      processing;
   };

   /*------------------------------------------*/
   /*-          DBmodeOptions                 -*/
   /*- Used to compose sql statement for      -*/
   /*- toolbar functions. (e.g., table view)  -*/
   /*------------------------------------------*/

   group DBmodeOptions <cxx_name="XP_ModeOptions"> {
     cxxmethod+req compose (  .option+read,
                              .process_option+read+notify,
                              .statement+write,
                              .tablename+read,
                              .done+write
                           );
     string+IPort2      server_type;   // not used in the new release, here for compatibility
     int+IPort2         option;
     string+IPort2      tablename;
     int+IPort2         process_option;
     string+OPort2      statement;
     int+OPort2         done;
   };

   /*------------------------------------------*/
   /*-          DBerrorString                 -*/
   /*- Used to make a error string using the  -*/
   /*  original statement and a error offset  -*/
   /*  from the query module. Sybase has no   -*/
   /*  offset right now only oracle..         -*/
   /*------------------------------------------*/

   group DBerrorString <cxx_name="XP_ErrorString"> {
     cxxmethod+req compose (  .error_string+read+write,
                              .process_error+read+notify+req,
                              .statement+read,
                              .valid_error+write,
                              .error_offset+read
                           );
     string+IPort2      statement;
     int+IPort2         error_offset;
     int+IPort2         process_error;
     string+OPort2      error_string;
     int+OPort2         valid_error=0;
   };
   /*------------------------------------------*/
   /*-          DBinteractPorts               -*/
   /*- A four way port based on a trigger     -*/
   /*- mode = 1 activate 1st port for insert  -*/
   /*- mode = 2 activate 2ond portfor delete  -*/
   /*- mode = 3 activate 3rd port for update  -*/
   /*- mode = 4 activate 4ourth port for misc -*/
   /*------------------------------------------*/

   group DBinteractPorts <cxx_name="XP_InteractPorts"> {
     cxxmethod+req port (  .error_string+read+write,
                           .process_port+read+notify+req,
                           .mode+read,
                           .insert_port+write,
                           .delete_port+write,
                           .update_port+write,
                           .misc_port+write,
                           .return_code+write,
                           .message+write
                        );
     int+IPort2         mode;
     int+IPort2         process_port;
     int+OPort2         insert_port;
     int+OPort2         delete_port;
     int+OPort2         update_port;
     int+OPort2         misc_port;
     int+OPort2         return_code;
     string+OPort2      message;
   };
};

library+sort+buffered Macros<NEdisplayMode="NEopened",compile_subs=0> {

// On the PC, the border decorations are included in the size of a UIshell,
// so the following corrections are added to all shell dimensions.

#ifdef MSDOS
#define EXTRA_SHELL_WIDTH   8
#define EXTRA_SHELL_HEIGHT 26
#else
#define EXTRA_SHELL_WIDTH  0
#define EXTRA_SHELL_HEIGHT 0
#endif

macro Connect<NEx=242,NEy=77> {
   macro ConnectUI<NEx=99,NEy=176,NEscalingFactor=1.014062643,NExOffset=24.87033081,NEyOffset=-13.80134678,NEwidth=473,NEheight=605> {
      UIshell Shell<NEx=0.,NEy=297.,NEwidth=198,NEheight=242> {
         title => "Connect";
         menu => <-.MainMenu;
         width = 480 + EXTRA_SHELL_WIDTH*4;
         height = 343 + EXTRA_SHELL_HEIGHT;
         cursor<NEportLevels={2,0}> => <-.WaitCursor;
      };
      UIfontCursor WaitCursor<NEx=55.,NEy=110.> {
         attach_cursor<NEportLevels={2,2}>=0;
         cursor_name = "watch";
      };
      UIcmdList MainMenu<NEx=0.,NEy=253.> {
         cmdList => {
            <-.File.FileCommand, <-.DB_Server_Type.ServerType
         };
      };
      macro DB_Server_Type<NEx=0.,NEy=165.,NEscalingFactor=1.013215423,NExOffset=5.182788372,NEyOffset=2.936564207> {
         UIcmdList ServerType<NEx=33,NEy=396,NEportLevels={0,2}> {
            cmdList => {<-.Oracle,
               <-.Informix,<-.Sybase,<-.ODBC};
            label<NEdisplayMode="NEopened"> = "&Server Type";
         };
         UIcmd Oracle<NEx=33.,NEy=44.> {
            label = "&ORACLE";
            active => Templates.UI_GLOBAL.DBoptions.oracleKit;
            message = "Oracle server type";
         };
         UIcmd Informix<NEx=33.,NEy=132.> {
            label = "&INFORMIX";
            active => Templates.UI_GLOBAL.DBoptions.informixKit;
            message = "Informix server type";
         };
         UIcmd Sybase<NEx=33.,NEy=220.> {
            label = "&SYBASE";
            active => Templates.UI_GLOBAL.DBoptions.sybaseKit;
            message = "Sybase server type";
         };
         UIcmd ODBC<NEx=33.,NEy=308.> {
            label = "O&DBC";
            active => Templates.UI_GLOBAL.DBoptions.odbcKit;
            message = "ODBC server type";
         };
         GMOD.parse_v Parse_V_Oracle<NEx=33,NEy=88> {
            on_inst = 0;
            v_commands = "database_driver=\"ORACLE\";";
            trigger => <-.Oracle.do;
            relative => <-.<-.<-.DBconnect;
         };
         GMOD.parse_v Parse_V_Informix<NEx=33,NEy=176> {
            on_inst = 0;
            v_commands = "database_driver=\"INFORMIX\";";
            trigger => <-.Informix.do;
            relative => <-.<-.<-.DBconnect;
         };
         GMOD.parse_v Parse_V_Sybase<NEx=33,NEy=264> {
            on_inst = 0;
            v_commands = "database_driver=\"SYBASE\";";
            trigger => <-.Sybase.do;
            relative => <-.<-.<-.DBconnect;
         };
         GMOD.parse_v Parse_V_ODBC<NEx=33,NEy=352> {
            on_inst = 0;
            v_commands = "database_driver=\"ODBC\";";
            trigger => <-.ODBC.do;
            relative => <-.<-.<-.DBconnect;
            active=1;
         };
      };
      UIpanel MainPanel<NEx=0.,NEy=341.,NEwidth=297,NEheight=264> {
         parent => <-.Shell;
         y = 1;
         x = 2;
         width => <-.Shell.clientWidth;
         height => <-.Shell.clientHeight;
      };
      UIframe Frame<NEx=0.,NEy=385.,NEwidth=253,NEheight=286> {
         parent => <-.MainPanel;
         y = 0;
         width => (<-.MainPanel.width - 3);
         height<NEdisplayMode="NEopened"> => (<-.MainPanel.height - 140);
      };
      macro Server_Type<NEx=275.,NEy=154.,NEwidth=187,NEheight=418> {
         UIlabel DatabaseDriver<NEx=11,NEy=176> {
            parent => <-.Frame;
            label<NEdisplayMode="NEopened"> => "Server Type:";
            x = 8;
            y = 22;
            width<NEdisplayMode="NEopened"> = 100 + EXTRA_SHELL_WIDTH;
            alignment = 0;
         };
         link Frame<NEx=11,NEy=132,NEportLevels={2,1}> => <-.Frame;
         UItext DriverText<NEx=11,NEy=220> {
            parent => <-.Frame;
            y = 16;
            x = 108 + EXTRA_SHELL_WIDTH*2;
            updateMode = 2;
            text<NEportLevels={0,0}> => <-.<-.<-.DBconnect.database_driver;
            color {
               backgroundColor = "white";
            };
         };
      };
      macro HostName<NEx=275.,NEy=242.> {
         UIlabel HostName<NEx=33,NEy=165> {
            parent => <-.Frame;
            label => "Host Name:";
            y = 24;
            x = 224 + EXTRA_SHELL_WIDTH;
            width<NEdisplayMode="NEopened"> = 100;
            alignment = 0;
         };
         link Frame<NEx=33,NEy=121,NEportLevels={2,1}> => <-.Frame;
         UItext HostText<NEx=33,NEy=209> {
            parent => <-.Frame;
            x = 340 + EXTRA_SHELL_WIDTH*4;
            y = 16;
            updateMode = 2;
            text<NEportLevels={0,0}> => <-.<-.<-.DBconnect.server_host;
            color {
               backgroundColor = "white";
            };
         };
      };
      macro ServerName<NEx=275.,NEy=286.,NEwidth=209,NEheight=374> {
         link Frame<NEx=22,NEy=66,NEportLevels={2,1}> => <-.Frame;
         UItext ServerNameText<NEx=22,NEy=154> {
            parent => <-.Frame;
            x = 108 + EXTRA_SHELL_WIDTH*2;
            y = 56;
            updateMode = 2;
            text<NEportLevels={0,0}> => <-.<-.<-.DBconnect.server_name;
            color {
               backgroundColor = "white";
            };
         };
         UIlabel ServerName<NEx=22,NEy=110> {
            parent => <-.Frame;
            label<NEdisplayMode="NEopened"> => "Server Name:";
            x = 8;
            y = 64;
            width<NEdisplayMode="NEopened"> = 100 + EXTRA_SHELL_WIDTH;
            alignment = 0;
         };
      };
      macro DatabaseName<NEx=275.,NEy=198.> {
         UItext Text<NEx=33,NEy=220> {
            parent => <-.Frame;
            x = 340 + EXTRA_SHELL_WIDTH*4;
            y = 52;
            updateMode = 2;
            text<NEportLevels={0,0}> => <-.<-.<-.DBconnect.database_name;
            color {
               backgroundColor = "white";
            };
         };
         UIlabel DatabaseName<NEx=33,NEy=176> {
            parent => <-.Frame;
            label => "Database Name:";
            x = 224 + EXTRA_SHELL_WIDTH;
            y = 64;
            width = 110 + EXTRA_SHELL_WIDTH*3;
            alignment = 0;
         };
         link Frame<NEx=33,NEy=132,NEportLevels={2,1}> => <-.Frame;
      };
      macro UserId<NEx=275.,NEy=418.> {
         link Frame<NEx=22,NEy=88,NEportLevels={2,1}> => <-.User_Frame;
         UIlabel User_id<NEx=22,NEy=132> {
            parent => <-.Frame;
            label => "User ID:";
            x<NEdisplayMode="NEopened"> = 8;
            y = 12;
            width = 60 + EXTRA_SHELL_WIDTH*3;
            alignment = 0;
         };
         UItext UserText<NEx=22,NEy=176> {
            parent => <-.Frame;
            x = 68 + EXTRA_SHELL_WIDTH*3;
            y = 8;
            updateMode = 2;
            text<NEportLevels={0,0}> => <-.<-.<-.DBconnect.user_id;
            width = 130;
            color {
               backgroundColor = "white";
            };
         };
      };
      macro UserPassword<NEx=275.,NEy=374.> {
         link Frame<NEx=33,NEy=99,NEportLevels={2,1}> => <-.User_Frame;
         UItext Text<NEx=33.,NEy=187.> {
            parent => <-.Frame;
            x = 336 + EXTRA_SHELL_WIDTH*3;
            y = 8;
            width = 130;
            updateMode = 2;
            text<NEportLevels={0,0}> => <-.<-.<-.DBconnect.user_password;
            color {
               backgroundColor = "white";
               foregroundColor = "white";
           };
         };
         UIlabel UserPassword<NEx=33,NEy=143> {
            parent => <-.Frame;
            label<NEdisplayMode="NEopened"> => "User Password:";
            x = 224 + EXTRA_SHELL_WIDTH;
            y = 12;
            width = 110 + EXTRA_SHELL_WIDTH*2;
            alignment = 0;
         };
      };
      macro ConnectString<NEx=275.,NEy=330.,NEscalingFactor=1,NExOffset=0,NEyOffset=0> {
         link Frame<NEx=22,NEy=110,NEportLevels={2,1}> => <-.Frame;
         UItext Text<NEx=22,NEy=209> {
            parent => <-.Frame;
            x = 108 + EXTRA_SHELL_WIDTH*4;
            y = 100;
            width = 330;
            updateMode = 2;
            text<NEportLevels={0,0}> => <-.<-.<-.DBconnect.connect_string;
            color {
               backgroundColor = "white";
            };
         };
         UIlabel ConnectString<NEx=22,NEy=165> {
            parent => <-.Frame;
            label => "Connect String:";
            x = 8;
            y = 104;
            width = 100 + EXTRA_SHELL_WIDTH*4;
            alignment = 0;
         };
      };

   UIbutton Connect<NEx=572.,NEy=363.,NEwidth=297.,NEheight=517.> {
      parent => <-.MessageFrame;
      label => "Connect";
      y = 50;
      x = 300;
      message = "Connect to server";
      visible => (1 - <-.Disconnect.visible);
      do  => <-.<-.DBconnect.connect_disconnect;
   };

   UIbutton Disconnect<NEx=583.,NEy=429.,NEwidth=297.,NEheight=517.> {
      parent => <-.MessageFrame;
      label => "Disconnect";
      y = 50;
      x = 300;
      message = "Disconnect from server";
      visible => <-.<-.DBconnect.connect_status;
      do  => <-.<-.DBconnect.connect_disconnect;
   };


      UIframe User_Frame<NEx=0.,NEy=429.> {
         parent => <-.MainPanel;
         y = 154;
         width => (<-.MainPanel.width - 3);
         height<NEdisplayMode="NEopened"> => (<-.MainPanel.height - 237);
      };
      UIframe MessageFrame<NEx=0.,NEy=473.,NEwidth=253,NEheight=275> {
         parent => <-.MainPanel;
         y = 210;
         width => (<-.MainPanel.width - 3);
         height => (<-.MainPanel.height - y);
      };
      macro Message<NEx=275.,NEy=110.> {
         link TextInput<NEx=33,NEy=99,NEportLevels={2,1}> => <-.Message_return;
         link Frame<NEx=33,NEy=55,NEportLevels={2,1}> => <-.MessageFrame;
         UIlabel Message<NEx=33,NEy=154> {
            parent => <-.Frame;
            label => "Message:";
            x = 12;
            y = 16;
            width = 100;
            alignment = 0;
         };
         UItext Text<NEx=33,NEy=198> {
            parent => <-.Frame;
            x = 116 + EXTRA_SHELL_WIDTH;
            y = 8;
            width = 350;
            outputOnly = 1;
            text<NEportLevels={2,0}> => <-.TextInput;
            color {
               backgroundColor = "white";
            };
         };
      };
      macro StatusCode<NEx=275.,NEy=66.> {
         link Frame<NEx=33,NEy=77,NEportLevels={2,1}> => <-.MessageFrame;
         link ValueIn<NEx=33,NEy=121,NEportLevels={2,1}> => <-.Status_code;
         UIlabel StatusCode<NEx=33,NEy=176> {
            parent => <-.Frame;
            label => "Status Code:";
            x = 12;
            y = 48;
            width = 100 + EXTRA_SHELL_WIDTH;
            alignment = 0;
         };
         UIfield Value<NEx=33,NEy=220> {
            parent => <-.Frame;
            value => <-.ValueIn;
            x = 116 + EXTRA_SHELL_WIDTH;
            y = 44;
            outputOnly = 1;
            mode<NEdisplayMode="NEopened"> = 1;
            color {
               backgroundColor = "white";
            };
         };
      };
      link Message_return<NEx=0.,NEy=77.,NEportLevels={2,1}> => <-.DBconnect.message;
      link Status_code<NEx=0.,NEy=33.,NEportLevels={2,1}> => <-.DBconnect.return_code;
      macro File<NEx=0.,NEy=121.> {
         UIcmdList FileCommand<NEx=616.,NEy=143.,NEportLevels={0,2}> {
            label = "&File";
            cmdList => {<-.Load_settings,
               <-.Save_settings};
         };
         UIcmd Load_settings<NEx=352.,NEy=66.> {
            label<NEdisplayMode="open"> = "&Load New Settings...";
            message = "Load settings from a file";
         };
         UIcmd Save_settings<NEx=66.,NEy=66.> {
            label = "&Save Current Settings...";
            message = "Save the current settings";
         };
         DBsaveConnect DBsaveConnect<NEx=66.,NEy=231.> {
            file_name => <-.UIfileDialog.filename;
            database_driver => <-.<-.Server_Type.DriverText.text;
            server_host => <-.<-.HostName.HostText.text;
            server_name => <-.<-.ServerName.ServerNameText.text;
            database_name => <-.<-.DatabaseName.Text.text;
            user_id => <-.<-.UserId.UserText.text;
            user_password => <-.<-.UserPassword.Text.text;
            connect_string => <-.<-.ConnectString.Text.text;
            process_save => <-.UIfileDialog.ok;
         };
         DBloadConnect DBloadConnect<NEx=352.,NEy=231.> {
            file_name => <-.UIfileDialog#1.filename;
            process_load => <-.UIfileDialog#1.ok;
            database_driver => <-.<-.Server_Type.DriverText.text;
            server_host => <-.<-.HostName.HostText.text;
            server_name => <-.<-.ServerName.ServerNameText.text;
            database_name => <-.<-.DatabaseName.Text.text;
            user_id => <-.<-.UserId.UserText.text;
            user_password => <-.<-.UserPassword.Text.text;
            connect_string => <-.<-.ConnectString.Text.text;
         };
         DBflushEvents flushEvents1<NEx=66.,NEy=121.> {
            in<NEportLevels={2,0}> => <-.Save_settings.do;
         };
         DBflushEvents flushEvents2<NEx=352.,NEy=121.> {
            in<NEportLevels={2,0}> => <-.Load_settings.do;
         };
         StandardDialogs.UIfileDialog UIfileDialog<NEx=66.,NEy=176.> {
            visible => <-.flushEvents1.out;
            ok<NEportLevels={1,2}>;
            title = "Save Connection Information";
            searchPattern = "*.con";
         };
         StandardDialogs.UIfileDialog UIfileDialog#1<NEx=352.,NEy=176.> {
            visible => <-.flushEvents2.out;
            ok<NEportLevels={1,2}>;
            title = "Load Connection Information";
            searchPattern = "*.con";
         };
      };
   };
   DBconnect DBconnect<NEx=44,NEy=220,NEwidth=418,NEheight=374> {
      message<NEportLevels={0,2}>;
      return_code<NEportLevels={0,2}>;
      dbvisual_connect_descriptor<NEportLevels={0,3}>;
      log_filename = "";
   };
};

macro Query<NEx=253.,NEy=220.,NEscalingFactor=1.013053536,NExOffset=0.8160095215,NEyOffset=-2.757263184> {
   link dbvisual_connect_descriptor<NEportLevels={2,1}>;
   macro QueryUI<NExOffset=0.,NEyOffset=0.,NEscalingFactor=1.,NEx=11.,NEy=374.,NEwidth=473,NEheight=605> {
      UIshell Shell<NEx=187.,NEy=363.,NEwidth=198,NEheight=242> {
         width = 489 + EXTRA_SHELL_WIDTH*6;
         height = 458 + EXTRA_SHELL_HEIGHT;
         title => "Query";
         menu => <-.MainMenu;
         cursor<NEportLevels={2,0}> => <-.WaitCursor;
      };
      UIfontCursor WaitCursor<NEx=55.,NEy=110.> {
         attach_cursor<NEportLevels={2,2}>=0;
         cursor_name = "watch";
      };
      UIcmdList MainMenu<NEx=187.,NEy=319.> {
         cmdList => {
            <-.File.FileCommand,<-.Statement.Statement,
            <-.Parameters.Parameters,<-.Display.Display,<-.LoadModes.LoadModes
         };
      };
      macro Statement<NEx=187.,NEy=143.,NEscalingFactor=1.013215423,NExOffset=5.182788372,NEyOffset=2.936564207> {
         UIcmdList Statement<NEx=35,NEy=390,NEportLevels={0,2}> {
            label<NEdisplayMode="NEopened"> = "&Statement";
            cmdList => {<-.Process,
               <-.Cancel,<-.Reset};
         };
         UIcmd Process<NEx=70.,NEy=120.> {
            label = "&Process";
            message = "Process the current statement";
         };
         UIcmd Cancel<NEx=350.,NEy=120.> {
            label = "&Cancel";
            message = "Cancel the query";
         };
         UIcmd Reset<NEx=627.,NEy=121.> {
            label = "&Reset";
            message = "Reset the query";
         };
         GMOD.parse_v Parse_V_Process<NEx=66.,NEy=209.> {
            v_commands = "process_statement=1;";
            trigger => <-.flushEvents.out;
            on_inst = 0;
            relative => <-.<-.<-.DBquery;
         };
         GMOD.parse_v Parse_V_Cancel<NEx=352,NEy=209> {
            v_commands = "cancel_button=1;";
            trigger => <-.flushEvents#1.out;
            on_inst = 0;
            relative => <-.<-.<-.DBquery;
         };
         GMOD.parse_v Parse_V_Reset<NEx=627,NEy=209> {
            v_commands = "new_statement=1;";
            trigger => <-.flushEvents#2.out;
            on_inst = 0;
            relative => <-.<-.<-.DBquery;
         };
         DBflushEvents flushEvents<NEx=66,NEy=165> {
            in<NEportLevels={2,0}> => <-.Process.do;
         };
         DBflushEvents flushEvents#1<NEx=352,NEy=165> {
            in<NEportLevels={2,0}> => <-.Cancel.do;
         };
         DBflushEvents flushEvents#2<NEx=627,NEy=165> {
            in<NEportLevels={2,0}> => <-.Reset.do;
         };
      };
      UIpanel MainPanel<NEx=187.,NEy=407.,NEwidth=297,NEheight=264> {
         x = 2;
         y = 1;
         width => <-.Shell.clientWidth;
         height => <-.Shell.clientHeight;
         parent => <-.Shell;
      };
      link Message_return<NEx=187.,NEy=11.,NEportLevels={2,1}> => <-.DBquery.message;
      link Status_code<NEx=22.,NEy=11.,NEportLevels={2,1}> => <-.DBquery.return_code;
      macro Parameters<NEx=187.,NEy=187.,NEscalingFactor=1,NExOffset=0,NEyOffset=0> {
         UIcmdList Parameters<NEx=33.,NEy=308.,NEportLevels={0,2}> {
            label = "&Parameters";
            cmdList => {<-.Control_Panel,
               <-.OutputPanel};
         };
         UIcmd Control_Panel<NEx=33.,NEy=22.> {
            label = "&Control...";
            message = "Show control panel";
         };
         GMOD.parse_v Parse_V_Control<NEx=33,NEy=110,NEwidth=297,NEheight=231> {
            v_commands = "visible = 1;";
            trigger => <-.flushEvents.out;
            on_inst = 0;
            relative => <-.<-.ControlUI.UIshell;
         };
         GMOD.parse_v Parse_V_Output<NEx=33,NEy=264,NEwidth=297,NEheight=231> {
            v_commands = "visible = 1;";
            trigger => <-.flushEvents#1.out;
            on_inst = 0;
            relative => <-.<-.OutputUI.UIshell;
         };
         UIcmd OutputPanel<NEx=33.,NEy=176.> {
            label = "&Output Types...";
            message = "Force output types from query";
         };
         DBflushEvents flushEvents<NEx=33,NEy=66> {
            in<NEportLevels={2,0}> => <-.Control_Panel.do;
         };
         DBflushEvents flushEvents#1<NEx=33,NEy=220> {
            in<NEportLevels={2,0}> => <-.OutputPanel.do;
         };
      };
      macro ControlUI<NEx=22.,NEy=275.,NEscalingFactor=1.008550882,NExOffset=-235.0962524,NEyOffset=244.876709> {
         Shells.UIshell UIshell<NEx=572,NEy=-220,NEwidth=209,NEheight=231> {
            width = 440 + EXTRA_SHELL_WIDTH*8;
            height = 242 + EXTRA_SHELL_HEIGHT*2;
            title => "Query Control";
            visible = 0;
         };
         UIframe Frame_Null<NEx=253,NEy=-66> {
            x = 3;
            y = 3;
            width = 436 + EXTRA_SHELL_WIDTH*6;
            height = 111;
            parent => <-.UIpanel;
         };
         Panels.UIpanel UIpanel<NEx=572,NEy=-165> {
            y = 0;
            width = 440 + EXTRA_SHELL_WIDTH*8;
            height = 242;
            parent => <-.UIshell;
         };
         macro NullValUint<NEx=253,NEy=-11> {
            link Frame<NEx=22,NEy=88,NEportLevels={2,1}> => <-.Frame_Null;
            UIlabel NullValUint<NEx=22,NEy=132> {
               x = 223 + EXTRA_SHELL_WIDTH*4;
               y = 40;
               width = 105 + EXTRA_SHELL_WIDTH*2;
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               label => "Null value uint:";
               alignment = 0;
            };
            UIfield Value<NEx=22,NEy=176,NEwidth=330,NEheight=242> {
               x = 327 + EXTRA_SHELL_WIDTH*6;
               y = 34;
               height = 33;
               updateMode = 2;
               color {
                  backgroundColor = "white";
               };
               parent => <-.Frame;
               value => <-.<-.<-.<-.DBquery.null_value_uint;
               mode = 1;
            };
         };
         macro NullValInt<NEx=253,NEy=33> {
            link Frame<NEx=22,NEy=88,NEportLevels={2,1}> => <-.Frame_Null;
            UIlabel NullValInt<NEx=22,NEy=132> {
               x = 223 + EXTRA_SHELL_WIDTH*4;
               y = 10;
               width =  105 + EXTRA_SHELL_WIDTH;
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               label => "Null value int:";
               alignment = 0;
            };
            UIfield Value<NEx=22,NEy=176> {
               x = 328 + EXTRA_SHELL_WIDTH*6;
               y = 2;
               height = 33;
               updateMode = 2;
               color {
                  backgroundColor = "white";
               };
               parent => <-.Frame;
               value => <-.<-.<-.<-.DBquery.null_value_int;
               mode = 1;
            };
         };
         macro NullValShort<NEx=253,NEy=77> {
            link Frame<NEx=22,NEy=88,NEportLevels={2,1}> => <-.Frame_Null;
            UIlabel NullValShort<NEx=22,NEy=132> {
               y = 6;
               width = 105 + EXTRA_SHELL_WIDTH*3;
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               label => "Null value short:";
               alignment = 0;
            };
            UIfield Value<NEx=22,NEy=176> {
               x = 120 + EXTRA_SHELL_WIDTH*3;
               y = 2;
               height = 33;
               updateMode = 2;
               color {
                  backgroundColor = "white";
               };
               parent => <-.Frame;
               value => <-.<-.<-.<-.DBquery.null_value_short;
               mode = 1;
            };
         };
         macro NullValByte<NEx=253,NEy=121> {
            link Frame<NEx=22,NEy=88,NEportLevels={2,1}> => <-.Frame_Null;
            UIlabel NullValByte<NEx=22,NEy=132> {
               x = 222 + EXTRA_SHELL_WIDTH*4;
               y = 73;
               width = 106 + EXTRA_SHELL_WIDTH*2;
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               label => "Null value byte:";
               alignment = 0;
            };
            UIfield Value<NEx=22,NEy=176> {
               x = 328 + EXTRA_SHELL_WIDTH*6;
               y = 68;
               updateMode = 2;
               decimalPoints=0;
               color {
                  backgroundColor = "white";
               };
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               value<NEportLevels={0,0}> => <-.<-.<-.<-.DBquery.null_value_byte;
            };
         };
         macro UserBufReallocInt<NEx=506,NEy=66,NEscalingFactor=1,NExOffset=0,NEyOffset=0> {
            link Frame<NEx=22,NEy=110,NEportLevels={2,1}> => <-.Frame_User;
            UIfield Value<NEx=22,NEy=209> {
               x = 164 + EXTRA_SHELL_WIDTH*5;
               y = 33;
               width = 90 + EXTRA_SHELL_WIDTH;
               decimalPoints=0;
               updateMode = 2;
               color {
                  backgroundColor = "white";
               };
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               value<NEportLevels={0,0}> => <-.<-.<-.<-.DBquery.userbuf_realloc_interval;
            };
            UIlabel ReallocInterval<NEx=22,NEy=165> {
               y = 37;
               width = 164 + EXTRA_SHELL_WIDTH*5;
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               label => "User buf realloc interval:";
               alignment = 0;
            };
         };
         macro NullValTheFloat<NEx=506,NEy=-22> {
            link Frame<NEx=33,NEy=99,NEportLevels={2,1}> => <-.Frame_Null;
            UIlabel NullValTheFloat<NEx=33,NEy=143> {
               y = 39;
               width = 102 + EXTRA_SHELL_WIDTH*3;
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               label => "Null value float:";
               alignment = 0;
            };
            UIfield Value<NEx=33,NEy=187> {
               x = 120 + EXTRA_SHELL_WIDTH*3;
               y = 34;
               height = 33;
               updateMode = 2;
               color<NEdisplayMode="NEopened"> {
                  backgroundColor = "white";
               };
               parent => <-.Frame;
               value => <-.<-.<-.<-.DBquery.null_value_float;
               decimalPoints = 1;
            };
         };
         macro NullValTheDouble<NEx=506,NEy=22> {
            link Frame<NEx=22,NEy=88,NEportLevels={2,1}> => <-.Frame_Null;
            UIlabel NullValTheDouble<NEx=22,NEy=132> {
               y = 70;
               width = 120 + EXTRA_SHELL_WIDTH*3;
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               label => "Null value double:";
               alignment = 0;
            };
            UIfield Value<NEx=22,NEy=176> {
               x = 120 + EXTRA_SHELL_WIDTH*3;
               y = 67;
               height = 33;
               decimalPoints=0;
               updateMode = 2;
               color {
                  backgroundColor = "white";
               };
               parent => <-.Frame;
               value => <-.<-.<-.<-.DBquery.null_value_double;
               decimalPoints = 1;
            };
         };
         macro UserBuffRowLimit<NEx=506,NEy=110> {
            UIfield Value<NEx=33,NEy=220> {
               x = 164 + EXTRA_SHELL_WIDTH*5;
               y = 1;
               width = 90;
               decimalPoints=0;
               updateMode = 2;
               color {
                  backgroundColor = "white";
               };
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               value<NEportLevels={0,0}> => <-.<-.<-.<-.DBquery.userbuf_row_limit;
            };
            UIlabel UserBufRowLimit<NEx=33,NEy=176> {
               y = 5;
               width = 164;
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               label => "User buf row limit:";
               alignment = 0;
            };
            link Frame<NEx=33,NEy=132,NEportLevels={2,1}> => <-.Frame_User;
         };
         macro RowsPerFetch<NEx=935,NEy=-22> {
            UIlabel RowsPerFetch<NEx=33,NEy=165> {
               y = 7;
               width = 110 + EXTRA_SHELL_WIDTH*2;
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               label => "Rows per fetch:";
               alignment = 0;
            };
            link Frame<NEx=33,NEy=121,NEportLevels={2,1}> => <-.Frame;
            UIfield Value<NEx=33,NEy=209> {
               x = 106 + EXTRA_SHELL_WIDTH*5;
               y = 3;
               decimalPoints=0;
               updateMode = 2;
               color {
                  backgroundColor = "white";
               };
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               value<NEportLevels={0,0}> => <-.<-.<-.<-.DBquery.rows_per_fetch;
            };
         };
         macro QueryTimeout<NEx=935,NEy=22,NEwidth=187,NEheight=418> {
            UIlabel QueryTimeout<NEx=11,NEy=176> {
               x = 219 + EXTRA_SHELL_WIDTH*4;
               y = 8;
               width = 130 + EXTRA_SHELL_WIDTH*4;
               events {
                  buttonPress = 1;
                  buttonRelease = 1;
               };
               parent => <-.Frame;
               label => "Query timeout (sec):";
               alignment = 0;
            };
            link Frame<NEx=11,NEy=132,NEportLevels={2,1}> => <-.Frame;
            UIfield Value<NEx=11,NEy=220> {
               x = 355 + EXTRA_SHELL_WIDTH*9;
               y = 3;
               width = 50;
               height = 33;
               updateMode = 2;
               color<NEdisplayMode="NEopened"> {
                  backgroundColor = "white";
               };
               parent => <-.Frame;
               value => <-.<-.<-.<-.DBquery.query_timeout_secs;
               mode = 1;
            };
         };
         UIframe Frame_User<NEx=506,NEy=-66,NEwidth=198,NEheight=297> {
            x = 3;
            y = 115;
            width = 262 + EXTRA_SHELL_WIDTH*6;
            height = 75;
            parent => <-.UIpanel;
         };
         UIframe Frame_Toggle<NEx=748,NEy=-66> {
            x = 266 + EXTRA_SHELL_WIDTH*6;
            y = 115;
            width = 173;
            height = 75;
            parent => <-.UIpanel;
         };
         UItoggle Fetch_loop<NEx=748,NEy=-22> {
            x = 25 - EXTRA_SHELL_WIDTH;
            y = 7;
            width = 120 + EXTRA_SHELL_WIDTH*3;
            parent => <-.Frame_Toggle;
            label = " Auto fetch loop";
            set => <-.<-.<-.DBquery.loop;
         };
         UItoggle Flush_when_full<NEx=748,NEy=22> {
            x = 25 - EXTRA_SHELL_WIDTH;
            y = 34;
            width = 120 + EXTRA_SHELL_WIDTH*3;
            parent => <-.Frame_Toggle;
            label => " Flush when full";
            set => <-.<-.<-.DBquery.flush_when_full;
         };
         UIframe Frame<NEx=935,NEy=-66> {
            x = 3;
            y = 191;
            width = 436 + EXTRA_SHELL_WIDTH*6;
            height = 47;
            parent => <-.UIpanel;
         };
      };
      OutputUI OutputUI<NEx=22.,NEy=99.,NEscalingFactor=1.026782632,NExOffset=-263.4014282,NEyOffset=247.7944031> {
         FloatType {
            UIradioBox {
               selectedItem => <-.<-.<-.<-.DBquery.floating_type;
            };
         };
         UIshell {
            visible = 0;
         };
         FixedType {
            UIradioBox {
               selectedItem => <-.<-.<-.<-.DBquery.fixed_type;
            };
         };
         Force {
            UIradioBox {
               selectedItem => <-.<-.<-.<-.DBquery.use_floating_type_only;
            };
         };
      };
      StatisticsUI StatisticsUI<NEx=22.,NEy=143.,NEscalingFactor=1.026782632,NExOffset=-265.3492432,NEyOffset=208.8377533> {
         UIshell {
            visible = 0;
         };
         NumFetchesPerQuery {
            Value {
               value<NEportLevels={2,0}> => <-.<-.<-.<-.DBquery.output_statistics.num_fetches_for_query;
            };
         };
         RowsProcessed {
            Value {
               value<NEportLevels={2,0}> => <-.<-.<-.<-.DBquery.output_statistics.rows_processed;
            };
         };
         NumOutputCols {
            Value {
               value<NEportLevels={2,0}> => <-.<-.<-.<-.DBquery.output_statistics.num_output_columns;
            };
         };
         RowSpecErrorCnt {
            Value {
               value<NEportLevels={2,0}> => <-.<-.<-.<-.DBquery.row_specific_error_cnt;
            };
         };
         UserbufRowsAllocated {
            Value {
               value<NEportLevels={2,0}> => <-.<-.<-.<-.DBquery.output_statistics.userbuf_rows_allocated;
            };
         };
         UserbufRowsUsed {
            Value {
               value<NEportLevels={2,0}> => <-.<-.<-.<-.DBquery.output_statistics.userbuf_rows_used;
            };
         };
         UserBufBytesAllocated {
            Value<NEx=44,NEy=209> {
               value<NEportLevels={2,0}> => <-.<-.<-.<-.DBquery.output_statistics.userbuf_bytes_allocated;
            };
         };
      };
      macro Display<NEx=187.,NEy=231.,NEscalingFactor=1,NExOffset=0,NEyOffset=0> {
         UIcmdList Display<NEx=22.,NEy=341.,NEportLevels={0,2}> {
            label = "&Display";
            cmdList => {<-.StatisticsPanel,
               <-.OutputWindow,<-.Connection_information,<-.Toolbar.ToolbarOption};
         };
         UIcmd StatisticsPanel<NEx=583.,NEy=77.> {
            label = "&Statistics";
            message = "Display query statistics ";
         };
         UIcmd Connection_information<NEx=198.,NEy=77.> {
            label = "&Connection Information";
            message = "Display connection information";
         };
         GMOD.parse_v Parse_V_Statistics<NEx=583.,NEy=165.> {
            v_commands = "visible=1;";
            trigger => <-.FlushEvents.out;
            on_inst = 0;
            relative => <-.<-.StatisticsUI.UIshell;
         };
         GMOD.parse_v Parse_V_Connect<NEx=198.,NEy=165.> {
            v_commands = "visible=1;";
            trigger => <-.flushEvents#1.out;
            on_inst = 0;
            relative => <-.<-.ConnectionUI.UIshell;
         };
         UIcmd OutputWindow<NEx=407.,NEy=77.> {
            label = "&Output Window";
            message = "Display query output";
         };
         GMOD.parse_v Parse_V_Output<NEx=407.,NEy=165.,NEwidth=209,NEheight=198> {
            v_commands = "visible=1;";
            trigger => <-.flushEvents#2.out;
            on_inst = 0;
            relative => <-.<-.OutputWindowUI.UIshell;
         };
         DBflushEvents FlushEvents<NEx=583.,NEy=121.> {
            in<NEportLevels={2,0}> => <-.StatisticsPanel.do;
         };
         DBflushEvents flushEvents#1<NEx=198.,NEy=121.> {
            in<NEportLevels={2,0}> => <-.Connection_information.do;
         };
         DBflushEvents flushEvents#2<NEx=407.,NEy=121.> {
            in<NEportLevels={2,0}> => <-.OutputWindow.do;
         };
         macro Toolbar<NEx=22.,NEy=77.,NExOffset=182.,NEyOffset=179.> {
            UIoption ToolbarOption<NEx=154.,NEy=264.,NEportLevels={0,2}> {
               label => "Toolbar";
               message = "Activate toolbar";
               set = 1;
            };
            DBflushEvents FlushEvents1<NEx=154.,NEy=-132.> {
               in<NEportLevels={2,0}> => <-.ToolbarOption.set;
            };
            GMOD.parse_v PraseVTopFrameY40<NEx=154.,NEy=-88.> {
               v_commands = "y=40;";
               trigger => <-.FlushEvents1.out;
               relative => <-.<-.<-.TopFrame.UIframe;
            };
            GMOD.parse_v ParseVStatementsFramey80<NEx=154.,NEy=-44.> {
               v_commands = "y=80;";
               trigger => <-.FlushEvents1.out;
               relative => <-.<-.<-.Statements.StatementFrame;
            };
            DBflushEvents flushEvents<NEx=-88.,NEy=-132.> {
               in<NEportLevels={2,0}> => (<-.ToolbarOption.set + 1);
            };
            GMOD.parse_v ParseVTopFrameY0<NEx=-88.,NEy=-88.> {
               v_commands = "y=0;";
               trigger => <-.flushEvents.out;
               relative => <-.<-.<-.TopFrame.UIframe;
               on_inst = 0;
            };
            GMOD.parse_v ParseVStatementsFrameY40<NEx=-88.,NEy=-44.> {
               v_commands = "y=40;";
               trigger => <-.flushEvents.out;
               relative => <-.<-.<-.Statements.StatementFrame;
               on_inst = 0;
            };
            GMOD.parse_v ParseVToolBarFrameVis0<NEx=-88.,NEy=0.> {
               v_commands = "visible=0;";
               trigger => <-.flushEvents.out;
               relative => <-.<-.<-.Toolbar.UIframe;
               on_inst = 0;
            };
            GMOD.parse_v ParseVToolbarFrameVis1<NEx=154.,NEy=0.> {
               v_commands = "visible=1;";
               relative => <-.<-.<-.Toolbar.UIframe;
               trigger => <-.FlushEvents1.out;
            };
            GMOD.parse_v ParseVButtonFrameVis1<NEx=-88.,NEy=44.> {
               v_commands = "visible=1;";
               trigger => <-.flushEvents.out;
               relative => <-.<-.<-.Buttons.ButtonFrame;
               on_inst = 0;
            };
            GMOD.parse_v ParseVButtonFrameVis0<NEx=154.,NEy=44.> {
               v_commands = "visible=0;";
               trigger => <-.FlushEvents1.out;
               relative => <-.<-.<-.Buttons.ButtonFrame;
            };
         };
      };
      macro Buttons<NEx=374.,NEy=231.,NExOffset=15,NEyOffset=59> {
         UIframe ButtonFrame<NEx=11.,NEy=77.> {
            y => (<-.<-.Shell.clientHeight - 85);
            width => (<-.<-.MainPanel.width - 5);
            height = 40;
            parent => <-.Panel;
         };
         UIbutton Process_statement<NEx=11,NEy=176> {
            x = 8;
            y = 2;
            width = 150;
            height = 28;
            parent => <-.ButtonFrame;
            label => "  Process statement  ";
            do => <-.<-.<-.DBquery.process_statement;
         };
         UIbutton Cancel_statement<NEx=11,NEy=231> {
            UImake_dyn_wind UImake_dyn_wind {
               in_handle => <-.handle;
            };
            do => <-.<-.<-.DBquery.cancel_button;
            x = 385;
            y = 2;
            width = 30;
            height = 28;
            color {
               foregroundColor = "white";
               backgroundColor = "red";
            };
            parent => <-.ButtonFrame;
            label => "X";
         };
         UIbutton Reset_statement<NEx=11,NEy=275> {
            x = 165;
            y = 2;
            width = 150;
            height = 28;
            parent => <-.ButtonFrame;
            label => "  Reset  ";
            do => <-.<-.<-.DBquery.new_statement;
         };
         link Panel<NEx=11,NEy=22,NEportLevels={2,1}> => <-.MainPanel;
         UIlabel CancelLabel<NEx=11,NEy=121> {
            x = 338;
            y = 5;
            width = 50;
            parent => <-.ButtonFrame;
            label = "Cancel";
            alignment = 0;
         };
      };
      OutputWindowUI OutputWindowUI<NEx=22.,NEy=187.,NEscalingFactor=1.001646876,NExOffset=367.2086487,NEyOffset=247.9178009> {
         UIshell {
            visible = 0;
            height = 576 + EXTRA_SHELL_HEIGHT;
         };
         RowCommands {
            None<NEx=33,NEy=11,NExOffset=32,NEyOffset=130> {
               Parse_V_None<NEx=0,NEy=66> {
                  relative => <-.<-.<-.<-.<-.DBlist;
               };
            };
            Rows50<NEx=187,NEy=11> {
               Parse_V_Rows50<NEx=33,NEy=198> {
                  relative => <-.<-.<-.<-.<-.DBlist;
               };
            };
            Rows100<NEx=341,NEy=11> {
               Parse_V_Rows100<NEx=22,NEy=165> {
                  relative => <-.<-.<-.<-.<-.DBlist;
               };
            };
            Rows150<NEx=495,NEy=11> {
               Parse_V_Rows150<NEx=22,NEy=176> {
                  relative => <-.<-.<-.<-.<-.DBlist;
               };
            };
            Rows200<NEx=649,NEy=11> {
               Parse_V_Rows200<NEx=22,NEy=176> {
                  relative => <-.<-.<-.<-.<-.DBlist;
               };
            };
            Rows500<NEx=33,NEy=99> {
               Parse_V_Rows500<NEx=22,NEy=165> {
                  relative => <-.<-.<-.<-.<-.DBlist;
               };
            };
            All<NEx=352,NEy=99> {
               Parse_V_All<NEx=11,NEy=176,NEwidth=440,NEheight=253> {
                  relative => <-.<-.<-.<-.<-.DBlist;
               };
            };
            Other<NEx=671,NEy=99> {
               Parse_V_Other<NEx=22,NEy=165> {
                  relative => <-.<-.<-.<-.<-.DBlist;
               };
            };
         };
         ColumnCommands<NEx=-297.,NEy=-132.,NExOffset=10.7701416,NEyOffset=-3.387268066,NEscalingFactor=1.00865829> {
            Parse_V_ColumnNames<NEx=583,NEy=154> {
               relative => <-.<-.<-.<-.DBlist;
            };
            Parse_V_ColumnNames_Types<NEx=308,NEy=154> {
               relative => <-.<-.<-.<-.DBlist;
            };
            Parse_V_None<NEx=44,NEy=154> {
               relative => <-.<-.<-.<-.DBlist;
            };
         };
         UIlist<NEx=-297.,NEy=198.,NEwidth=330,NEheight=341> {
            strings<NEportLevels={2,2}> => <-.<-.<-.DBlist.list_string;
         };
         Clear<NEx=-297.,NEy=0.> {
            Parse_V_Clear<NEx=33,NEy=198,NEwidth=286,NEheight=176> {
               relative => <-.<-.<-.<-.DBlist;
            };
         };
         Spaces<NEx=-297.,NEy=-44.> {
            parse_v<NEx=22.,NEy=154.> {
               relative => <-.<-.<-.<-.DBlist;
            };
            parse_v#1<NEx=187.,NEy=154.> {
               relative => <-.<-.<-.<-.DBlist;
            };
            parse_v#2<NEx=352.,NEy=154.> {
               relative => <-.<-.<-.<-.DBlist;
            };
            parseVOther {
               relative => <-.<-.<-.<-.DBlist;
            };
         };
         ColumnMode<NEx=-297.,NEy=-88.> {
            parse_v<NEx=55.,NEy=176.> {
               relative => <-.<-.<-.<-.DBlist;
            };
            parse_v#1<NEx=55.,NEy=341.> {
               relative => <-.<-.<-.<-.DBlist;
            };
         };
      };

      macro Message<NEx=374.,NEy=99.,NExOffset=52,NEyOffset=123> {
         UIframe MessageFrame<NEportLevels={0,2},NEx=-22.,NEy=22.,NEwidth=253,NEheight=275> {
            y => (<-.<-.MainPanel.clientHeight - 45);
            width => (<-.<-.MainPanel.clientWidth - 5);
            height => (<-.<-.MainPanel.clientHeight - .y);
            parent => <-.Panel;
         };
         macro Message<NEx=-22,NEy=66> {
            link TextInput<NEx=33,NEy=99,NEportLevels={3,1}> => <-.<-.Message_return;
            link Frame<NEx=33,NEy=55,NEportLevels={2,1}> => <-.MessageFrame;
            UIlabel Message<NEx=33.,NEy=154.> {
               x = 8;
               y = 8;
               width = 62 + EXTRA_SHELL_WIDTH*2;
               parent => <-.Frame;
               label => "Message:";
               alignment = 0;
            };
            UItext Text<NEx=33.,NEy=198.> {
               x = 75 + EXTRA_SHELL_WIDTH*2;
               y = 3;
               width = 210;
               outputOnly = 1;
               color {
                  backgroundColor = "white";
               };
               parent => <-.Frame;
               text<NEportLevels={2,0}> => <-.TextInput;
            };
         };
         macro StatusCode<NEx=-22,NEy=110> {
            link Frame<NEx=33,NEy=77,NEportLevels={2,1}> => <-.MessageFrame;
            link ValueIn<NEx=33,NEy=121,NEportLevels={3,1}> => <-.<-.Status_code;
            UIlabel StatusCode<NEx=33.,NEy=176.> {
               x = 295 + EXTRA_SHELL_WIDTH*3;
               y = 8;
               width = 50 + EXTRA_SHELL_WIDTH;
               parent => <-.Frame;
               label => "Status:";
            };
            UIfield Code<NEx=33.,NEy=220.> {
               parent => <-.Frame;
               value => <-.ValueIn;
               x = 350 + EXTRA_SHELL_WIDTH*4;
               y = 2;
               height = 33;
               outputOnly = 1;
               color {
                  backgroundColor = "white";
               };
               mode = 1;
            };
         };
         link Panel<NEx=-22,NEy=-22,NEportLevels={2,1}> => <-.MainPanel;
      };
      macro Statements<NEx=374.,NEy=143.,NExOffset=2,NEyOffset=141> {
         UIframe StatementFrame<NEx=22.,NEy=44.,NEwidth=385.,NEheight=286.> {
            y = 80;
            width => (<-.<-.Shell.clientWidth - 5);
            height => (<-.<-.Shell.clientHeight - 165);
            parent => <-.Panel;
         };
         link Panel<NEx=22.,NEy=-44.,NEportLevels={2,1}> => <-.MainPanel;
         Panels.UIscrolledWindow UIscrolledWindow<NEx=22.,NEy=0.,NEwidth=396.,NEheight=286.> {
            x = 0;
            y = 0;
            width => (<-.StatementFrame.width - 10);
            height => (<-.StatementFrame.height - 5);
            virtualWidth => <-.Text.width;
            virtualHeight => <-.Text.height;
            parent<NEportLevels={3,0}> => <-.StatementFrame;
         };
         UItext Text<NEx=22.,NEy=88.,NEwidth=286,NEheight=264> {
            y = 0;
            width = 1156;
            height = 2000;
            updateMode = 2;
            color {
               backgroundColor = "white";
            };
            parent => <-.UIscrolledWindow;
            text<NEportLevels={2,0}>;
            multiLine = 1;
         };
      };
      ConnectionUI ConnectionUI<NEx=22.,NEy=231.,NEscalingFactor=1.026782632,NExOffset=-263.4014282,NEyOffset=247.7944031> {
         UIshell<NEx=297,NEy=-187,NEwidth=209,NEheight=231> {
            visible = 0;
         };
         DatabaseDriver<NEx=297,NEy=-44> {
            Text<NEx=44,NEy=198> {
               text => <-.<-.<-.<-.DBquery.connect_information.database_driver;
            };
         };
         HostName<NEx=297,NEy=0> {
            Text<NEx=44,NEy=209> {
               text => <-.<-.<-.<-.DBquery.connect_information.server_host;
            };
         };
         ServerName<NEx=297,NEy=55> {
            Text<NEx=44,NEy=209> {
               text => <-.<-.<-.<-.DBquery.connect_information.server_name;
            };
         };
         DatabaseName<NEx=297,NEy=110> {
            Text<NEx=44,NEy=209> {
               text => <-.<-.<-.<-.DBquery.connect_information.database_name;
            };
         };
         UserId<NEx=297,NEy=154> {
            Text<NEx=44,NEy=209> {
               text => <-.<-.<-.<-.DBquery.connect_information.user_id;
            };
         };
         ConnectString<NEx=297,NEy=198> {
            Text<NEx=44,NEy=209> {
               text => <-.<-.<-.<-.DBquery.connect_information.connect_string;
            };
         };
      };
      macro File<NEx=187.,NEy=99.> {
         UIcmdList FileCommand<NEx=660,NEy=451,NEportLevels={0,2}> {
            label = "&File";
            cmdList => {<-.Save_statement,
               <-.Load_statement};
         };
         UIcmd Load_statement<NEx=484.,NEy=77.> {
            label = "&Load Statement...";
            message = "Load a statement";
         };
         UIcmd Save_statement<NEx=253.,NEy=77.> {
            label = "&Save Statement...";
            message = "Save the statement to a file";
         };
         UIfileDialog Load<NEx=484,NEy=132,NEwidth=220,NEheight=220> {
            visible => <-.Load_statement.do;
            title => "Load Statement";
            ok<NEportLevels={1,2}>;
            okButton<NEportLevels={0,0}>;
            searchPattern = "*.sql";
         };
         UIfileDialog Save<NEx=253,NEy=132,NEwidth=187,NEheight=220> {
            visible => <-.Save_statement.do;
            title => "Save Statement";
            ok<NEportLevels={1,2}>;
            okButton<NEportLevels={0,0}>;
            searchPattern = "*.sql";
         };
         UIinfoDialog UIinfoDialog#1<NEx=253,NEy=220,NEwidth=231,NEheight=220> {
            width = 200;
            visible => <-.Save#1.processing;
            title => "Save";
            okButton = 1;
            okLabelString = "    OK    ";
            cancelButton = 0;
            message = "Saving statement to file";
         };
         DBsave Save#1<NEx=253,NEy=176,NEwidth=341,NEheight=231> {
            file_name => <-.Save.filename;
            num_of_strings = 1;
            string_array => <-.<-.Statements.Text.text;
            process_save => <-.Save.ok;
         };
         DBload DBload<NEx=484,NEy=176,NEwidth=231,NEheight=132> {
            file_name => <-.Load.filename;
            process_load => <-.Load.ok;
            statement => <-.<-.Statements.Text.text;
         };
         UIinfoDialog UIinfoDialog#2<NEx=484,NEy=220,NEwidth=231,NEheight=220> {
            width = 200;
            visible => <-.DBload.processing;
            title => "Save";
            okButton = 1;
            okLabelString = "    OK    ";
            cancelButton = 0;
            message = "Loading statement";
         };
      };
      macro Util<NEx=374.,NEy=187.,NExOffset=26,NEyOffset=-25> {
         link Panel<NEx=11.,NEy=99.,NEportLevels={2,1}> => <-.MainPanel;
         UIframe UtilFrame<NEx=11.,NEy=154.,NEwidth=385.,NEheight=352.> {
            parent => <-.Panel;
            y => ((<-.<-.Statements.StatementFrame.y + <-.<-.Statements.StatementFrame.clientHeight) + 6);
            width => (<-.<-.MainPanel.clientWidth - 5);
            height = 40;
         };
         UIbutton ControlPar<NEx=0.,NEy=242.> {
            parent => <-.UtilFrame;
            height = 34;
            x = 5;
            y = 0;
            width = 37;
            label = "Query Control";
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/control.x";
               fileType = "avs_image";
            };
         };
         UIbutton OutputPar<NEx=165.,NEy=231.> {
            parent => <-.UtilFrame;
            height = 34;
            x = 43;
            y = 0;
            width = 37;
            label = "Output Types" ;
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/types.x";
               fileType = "avs_image";
            };
         };
         UIbutton DisplayStats<NEx=319.,NEy=231.> {
            parent => <-.UtilFrame;
            height = 34;
            label = "Query Statistics";
            x = 81;
            y = 0;
            width = 37;
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/stats.x";
               fileType = "avs_image";
            };
         };
         UIbutton DisOutputWindow<NEx=165.,NEy=275.> {
            parent => <-.UtilFrame;
            height = 34;
            x = 120;
            y = 0;
            width = 38;
            label = "Display Output";
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/output.x";
               fileType = "avs_image";
            };
         };
         UIbutton DisConnInfo<NEx=638.,NEy=231.> {
            parent => <-.UtilFrame;
            height = 34;
            x = 160;
            y = 0;
            width = 37;
            label = "Connect Information" ;
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/connect.x";
               fileType = "avs_image";
            };
         };
         DBflushEvents flushEvents1<NEx=0.,NEy=286.> {
            in<NEportLevels={2,0}> => <-.ControlPar.do;
         };
         DBflushEvents flushEvents2<NEx=473.,NEy=231.> {
            in<NEportLevels={2,0}> => <-.OutputPar.do;
         };
         DBflushEvents flushEvents3<NEx=319.,NEy=286.> {
            in<NEportLevels={2,0}> => <-.DisplayStats.do;
         };
         DBflushEvents flushEvents4<NEx=473.,NEy=286.> {
            in<NEportLevels={2,0}> => <-.DisOutputWindow.do;
         };
         DBflushEvents flushEvents5<NEx=638.,NEy=286.> {
            in<NEportLevels={2,0}> => <-.DisConnInfo.do;
         };
         GMOD.parse_v parse_v<NEx=0.,NEy=330.> {
            v_commands = "visible=1;";
            trigger => <-.flushEvents1.out;
            on_inst = 0;
            relative => <-.<-.ControlUI.UIshell;
         };
         GMOD.parse_v parse_v#1<NEx=165.,NEy=330.> {
            v_commands = "visible=1;";
            trigger => <-.flushEvents2.out;
            on_inst = 0;
            relative => <-.<-.OutputUI.UIshell;
         };
         GMOD.parse_v parse_v#2<NEx=319.,NEy=330.> {
            v_commands = "visible=1;";
            trigger => <-.flushEvents3.out;
            on_inst = 0;
            relative => <-.<-.StatisticsUI.UIshell;
         };
         GMOD.parse_v parse_v#3<NEx=473.,NEy=330.> {
            v_commands = "visible=1;";
            trigger => <-.flushEvents4.out;
            on_inst = 0;
            relative => <-.<-.OutputWindowUI.UIshell;
         };
         GMOD.parse_v parse_v#4<NEx=638.,NEy=330.> {
            v_commands = "visible=1;";
            trigger => <-.flushEvents5.out;
            on_inst = 0;
            relative => <-.<-.ConnectionUI.UIshell;
         };
      };
      macro TopFrame<NEx=374.,NEy=275.,NExOffset=72.,NEyOffset=208.> {
         macro ConnectionStatus<NEx=308.,NEy=-11.> {
            link Panel<NEx=55,NEy=88,NEportLevels={2,1}> => <-.UIframe;
            UIlabel ConnectionStatus<NEx=55.,NEy=132.> {
               x = 225;
               y = 6;
               width = 125 + EXTRA_SHELL_WIDTH*4;
               parent => <-.Panel;
               label => "Connection Status:";
               alignment = 0;
            };
            UItext Text<NEx=55.,NEy=220.> {
               x = 350 + EXTRA_SHELL_WIDTH*4;
               y = 0;
               width = 107 + EXTRA_SHELL_WIDTH*2;
               outputOnly = 1;
               color {
                  backgroundColor = "white";
               };
               parent => <-.Panel;
               text<NEportLevels={2,0}> => <-.ConOrDisconnect.out;
            };
            group ConOrDisconnect<NEx=55.,NEy=176.> {
               int input<NEportLevels={0,0}> => <-.<-.<-.<-.DBquery.connect_information.connected;
               string a[2] = {"Disconnected",
                  "Connected"};
               string out<NEportLevels={0,2}> => a[.input];
            };
         };
         UIlabel StatementWindow<NEx=132.,NEy=-11.> {
            parent => <-.UIframe;
            label => "Statement Window";
            y = 6;
            x = 55;
            width = 130 + EXTRA_SHELL_WIDTH*3;
            alignment = 0;
         };
         macro Clear<NEx=-33.,NEy=-11.> {
            UIbutton ClearButton<NEx=22,NEy=110> {
               x = 7;
               y = 3;
               width = 40;
               height = 30;
               parent<NEportLevels={3,0}> => <-.<-.UIframe;
               message = "Clear the query statement window";
               labelPixmap<NEdisplayMode="open"> {
                 filename = "$XP_PATH<0>/v/db/icons/clear.x";
                 fileType = "avs_image";
               };
               label => "Clear";
            };
            DBflushEvents flushEvents<NEx=22,NEy=154> {
               in<NEportLevels={2,0}> => <-.ClearButton.do;
            };
            GMOD.parse_v parse_v_relative_no_inst<NEx=22,NEy=198,NEwidth=242,NEheight=187> {
               v_commands = "text=\"\";";
               trigger => <-.flushEvents.out;
               on_inst = 0;
               relative => <-.<-.<-.Statements.Text;
            };
         };
         Panels.UIframe UIframe<NEx=77.,NEy=-143.> {
            parent<NEportLevels={3,0}> => <-.<-.MainPanel;
            y = 40;
            width => (<-.<-.Shell.clientWidth - 5);
            height = 40;
         };
      };
      macro Toolbar<NEx=374.,NEy=319.> {
         link Panel<NEportLevels={2,1},NEx=473.,NEy=22.> => <-.MainPanel;
         Panels.UIframe UIframe<NEx=616.,NEy=132.> {
            parent => <-.Panel;
            y = 0;
            width => (<-.<-.Shell.clientWidth - 5);
            height = 40;
            pixmap<NEdisplayMode="open">;
         };
         UIbutton GraphBut1<NEx=11.,NEy=418.> {
            parent => <-.UIframe;
            height = 34;
            x = 5;
            y = 0;
            width = 36;
            label => ;
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/barchart.x";
               fileType = "avs_image";
            };
         };
         UIbutton GraphBut2<NEx=176.,NEy=418.> {
            parent => <-.UIframe;
            height = 34;
            x = 43;
            y = 0;
            width = 36;
            label => ;
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/barchart.x";
               fileType = "avs_image";
            };
         };
         UIbutton GraphBut3<NEx=330.,NEy=418.> {
            parent => <-.UIframe;
            height = 34;
            x = 81;
            y = 0;
            width = 37;
            label => ;
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/barchart.x";
               fileType = "avs_image";
            };
         };
         UIbutton GraphBut4<NEx=484.,NEy=418.> {
            parent => <-.UIframe;
            height = 34;
            x = 120;
            y = 0;
            width = 37;
            label => ;
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/barchart.x";
               fileType = "avs_image";
            };
         };
         UIbutton GraphBut5<NEx=638.,NEy=418.> {
            parent => <-.UIframe;
            height = 34;
            x = 160;
            y = 0;
            width = 37;
            label => ;
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/barchart.x";
               fileType = "avs_image";
            };
         };

         UIbutton Process<NEx=11.,NEy=132.> {
            parent => <-.UIframe;
            height = 34;
            x = 357;
            y = 0;
            width = 37;
            message = "Process Query";
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/process.x";
               fileType = "avs_image";
            };
         };
         UIbutton Reset<NEx=176.,NEy=132.> {
            parent => <-.UIframe;
            height = 34;
            x = 396;
            y = 0;
            width = 37;
            message = "Reset Query";
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/reset.x";
               fileType = "avs_image";
            };
         };
         UIbutton Cancel<NEx=330.,NEy=132.> {
            UImake_dyn_wind UImake_dyn_wind {
               in_handle => <-.handle;
            };
            do => <-.<-.<-.DBquery.cancel_button;
            parent => <-.UIframe;
            height = 34;
            x = 435;
            y = 0;
            width = 37;
            message = "Cancel Query";
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/cancel.x";
               fileType = "avs_image";
            };
         };
         link Graph1<NEportLevels={1,3},NEx=11.,NEy=473.> => .GraphBut1.do;
         link Graph2<NEportLevels={1,3},NEx=176.,NEy=473.> => .GraphBut2.do;
         link Graph3<NEportLevels={1,3},NEx=330.,NEy=473.> => .GraphBut3.do;
         link Graph4<NEportLevels={1,3},NEx=484.,NEy=473.> => .GraphBut4.do;
         link Graph5<NEportLevels={1,3},NEx=638.,NEy=473.> => .GraphBut5.do;
         DBflushEvents FlushEvents1<NEx=11.,NEy=176.> {
            in<NEportLevels={2,0}> => <-.Process.do;
         };
         GMOD.parse_v parse_v<NEx=11.,NEy=220.> {
            v_commands = "process_statement=1;";
            trigger => <-.FlushEvents1.out;
            relative => <-.<-.<-.DBquery;
            on_inst = 0;
         };
         GMOD.parse_v parse_v#1<NEx=176.,NEy=220.> {
            v_commands = "new_statement=1;";
            trigger => <-.FlushEvents2.out;
            relative => <-.<-.<-.DBquery;
            on_inst = 0;
         };
         DBflushEvents FlushEvents2<NEx=176.,NEy=176.> {
            in<NEportLevels={2,0}> => <-.Reset.do;
         };
         macro SysViewsTablsColUser<NEx=330.,NEy=220.,NExOffset=339.,NEyOffset=156.> {
            link Frame<NEportLevels={2,1},NEx=-286.,NEy=-99.> => <-.UIframe;
            macro Tables<NEx=-286.,NEy=-55.,NExOffset=-28.,NEyOffset=-11.> {
               UIbutton SysTables<NEx=242.,NEy=33.> {
                  parent<NEportLevels={3,0}> => <-.<-.Frame;
                  height = 34;
                  x = 200;
                  y = 0;
                  width = 37;
                  label => "Tables";
                  labelPixmap<NEdisplayMode="open"> {
                     filename = "$XP_PATH<0>/v/db/icons/tables.x";
                     fileType = "avs_image";
                  };
               };
               DBquery DBquery<NEx=66.,NEy=154.,NEwidth=231.,NEheight=231.> {
                  statement => <-.DBmodeOptions.statement;
                  process_statement => <-.DBmodeOptions.done;
                  connect_information<NEdisplayMode="open"> {
                     database_driver<NEportLevels={0,3}>;
                  };
                  new_statement<NEportLevels={2,0}>;
                  dbvisual_connect_descriptor => <-.<-.<-.<-.<-.DBquery.dbvisual_connect_descriptor;
               };
               DBmodeOptions DBmodeOptions<NEx=66.,NEy=209.> {
                  server_type => <-.DBquery.connect_information.database_driver;
                  process_option => <-.SysTables.do;
                  option = 1;
               };
               DBlist DBlist<NEx=66.,NEy=264.> {
                  column_array => <-.DBquery.column_array;
                  num_rows_to_list => array_size(column_array[0].values);
                  header_mode = 0;
                  active_mode = 1;
                  column_mode = 0;
                  column_width = 30;
               };
               Shells.UIshell UIshell<NEx=440.,NEy=396.> {
                  visible => <-.SysTables.do;
                  title => "Table List";
                  menu => <-.UIcmdList#1;
                  width = 210 + EXTRA_SHELL_WIDTH;
               };
               Panels.UIframe UIframe<NEx=440.,NEy=451.> {
                  parent => <-.UIshell;
                  y = 5;
                  x = 5;
                  width => (<-.UIshell.clientWidth - 10);
                  height => (<-.UIshell.clientHeight - 10);
               };
               Commands.UIcmdList UIcmdList<NEx=440.,NEy=297.> {
                  cmdList => {<-.SaveFile};
                  label = "&File";
               };
               UIcmd SaveFile<NEx=440.,NEy=132.> {
                  label => "&Save Output to File...";
               };
               Commands.UIcmdList UIcmdList#1<NEx=440.,NEy=341.> {
                  cmdList => {<-.UIcmdList};
               };
               Controls.UIlist UIlist<NEx=66.,NEy=319.> {
                  parent => <-.UIframe;
                  height => <-.UIframe.clientHeight;
                  y = 0;
                  width => <-.UIframe.clientWidth;
                  color {
                     backgroundColor = "white";
                  };
                  strings => <-.DBlist.list_string;
                  selectedText<NEportLevels={0,2}>;
                  selectedItem=-1;
               };
               DBsave DBsave<NEx=440.,NEy=242.> {
                  file_name => <-.UIfileDialog.filename;
                  string_array => <-.DBlist.list_string;
                  process_save => <-.UIfileDialog.ok;
               };
               StandardDialogs.UIfileDialog UIfileDialog<NEx=440.,NEy=187.> {
                  visible => <-.SaveFile.do;
                  title => "Save Table List";
                  ok<NEportLevels={1,2}>;
                  searchPattern = "*.lst";
               };
               GMOD.parse_v parse_v<NEx=55.,NEy=66.> {
                  v_commands = "new_statement=1;";
                  trigger => <-.SysTables.do;
                  on_inst = 0;
                  relative => <-.DBquery;
               };
               DBappendStatement DBappendStatement<NEx=55.,NEy=374.> {
                  string_a => <-.<-.<-.<-.Statements.Text.text;
                  string_b => <-.UIlist.selectedText;
                  process => <-.UIlist.selectedItem;
                  result_string=> <-.<-.<-.<-.Statements.Text.text;
               };
            };
            macro Columns<NEx=-286.,NEy=-11.,NExOffset=274.,NEyOffset=310.> {
               UIpromptDialog Prompt<NEx=11.,NEy=-220.> {
                  visible => <-.SysCols.do;
                  ok<NEportLevels={1,2}>;
                  title => "Column Names";
                  prompt = "Enter the table name";
                  applyButton = 0;
               };
               DBmodeOptions DBmodeOptions#2<NEx=-176.,NEy=-165.> {
                  server_type => <-.DBquery.connect_information.database_driver;
                  option = 3;
                  tablename => <-.Prompt.text;
                  process_option<NEportLevels={2,2}> => <-.Prompt.ok;
               };
               DBquery DBquery<NEx=-176.,NEy=-110.> {
                  statement => <-.DBmodeOptions#2.statement;
                  process_statement => <-.DBmodeOptions#2.done;
                  new_statement<NEportLevels={2,0}>;
                  connect_information<NEdisplayMode="open"> {
                  database_driver<NEportLevels={0,3}>;
                  };
                  dbvisual_connect_descriptor => <-.<-.<-.<-.<-.DBquery.dbvisual_connect_descriptor;
               };
               DBlist DBlist<NEx=-176.,NEy=-44.> {
                  column_array => <-.DBquery.column_array;
                  num_rows_to_list => array_size(column_array[0].values);
                  header_mode = 1;
                  column_mode = 0;
                  column_width = 30;
                  active_mode = 1;
               };
               Shells.UIshell UIshell<NEx=209.,NEy=-11.> {
                  visible => <-.Prompt.ok;
                  title => "Column List";
                  menu => <-.UIcmdList#1;
                  width = 210 + EXTRA_SHELL_WIDTH;
               };
               Panels.UIframe UIframe<NEx=209.,NEy=44.> {
                  parent => <-.UIshell;
                  y = 5;
                  x = 5;
                  width => (<-.UIshell.clientWidth - 10);
                  height => (<-.UIshell.clientHeight - 10);
               };
               Commands.UIcmdList UIcmdList<NEx=209.,NEy=-110.> {
                  cmdList => {<-.SaveFile};
                  label = "&File";
               };
               UIcmd SaveFile<NEx=209.,NEy=-275.> {
                  label => "&Save Output to File...";
               };
               Commands.UIcmdList UIcmdList#1<NEx=209.,NEy=-66.> {
                  cmdList => {<-.UIcmdList};
               };
               Controls.UIlist UIlist<NEx=-176.,NEy=11.> {
                  parent => <-.UIframe;
                  height => <-.UIframe.clientHeight;
                  y = 0;
                  width => <-.UIframe.clientWidth;
                  color {
                     backgroundColor = "white";
                  };
                  strings => <-.DBlist.list_string;
                  selectedItem<NEportLevels={0,2}>;
               };
               DBsave DBsave<NEx=209.,NEy=-165.> {
                  file_name => <-.UIfileDialog.filename;
                  string_array => <-.DBlist.list_string;
                  process_save => <-.UIfileDialog.ok;
               };
               StandardDialogs.UIfileDialog UIfileDialog<NEx=209.,NEy=-220.> {
                  visible => <-.SaveFile.do;
                  title => "Save Column List";
                  ok<NEportLevels={1,2}>;
                  searchPattern = "*.lst";
               };
               UIbutton SysCols<NEx=11.,NEy=-264.> {
                  parent<NEportLevels={4,0}> => <-.<-.Frame;
                  height = 34;
                  x = 239;
                  y = 0;
                  width = 37;
                  label => "Columns";
                  labelPixmap<NEdisplayMode="open"> {
                     filename = "$XP_PATH<0>/v/db/icons/columns.x";
                     fileType = "avs_image";
                  };
               };
               GMOD.parse_v parse_v<NEx=-176.,NEy=-220.> {
                  v_commands = "new_statement=1;";
                  trigger => <-.Prompt.ok;
                  relative => <-.DBquery;
               };
               DBappendStatement DBappendStatement<NEx=-176.,NEy=77.> {
                  string_a => <-.<-.<-.<-.Statements.Text.text;
                  string_b => <-.UIlist.selectedText;
                  process => <-.UIlist.selectedItem;
                  result_string => <-.<-.<-.<-.Statements.Text.text;
               };
            };
            macro Views<NEx=-286.,NEy=33.,NExOffset=242.8303528,NEyOffset=310.5056152,NEscalingFactor=1.037454247> {
               UIbutton SysViews<NEx=-11.,NEy=-264.> {
                  parent<NEportLevels={3,0}> => <-.<-.Frame;
                  height = 34;
                  x = 279;
                  y = 0;
                  width = 37;
                  label => "Views";
                  labelPixmap<NEdisplayMode="open"> {
                     filename = "$XP_PATH<0>/v/db/icons/views.x";
                     fileType = "avs_image";
                  };
               };
               DBquery DBquery<NEx=-176.,NEy=-121.> {
                  statement => <-.DBmodeOptions#1.statement;
                  process_statement => <-.DBmodeOptions#1.done;
                  connect_information {
                     database_driver<NEportLevels={0,3}>;
                  };
                  new_statement<NEportLevels={2,0}>;
                  dbvisual_connect_descriptor => <-.<-.<-.<-.<-.DBquery.dbvisual_connect_descriptor;
               };
               DBmodeOptions DBmodeOptions#1<NEx=-165.,NEy=-187.> {
                  server_type => <-.DBquery.connect_information.database_driver;
                  option = 2;
                  process_option => <-.SysViews.do;
               };
               DBlist DBlist#1<NEx=-176.,NEy=-33.> {
                  column_array => <-.DBquery.column_array;
                  num_rows_to_list => array_size(column_array[0].values);
                  header_mode = 0;
                  active_mode = 1;
                  column_mode = 0;
                  column_width = 30;
               };
               Shells.UIshell UIshell<NEx=253.,NEy=-22.> {
                  visible => <-.SysViews.do;
                  title => "View List";
                  menu => <-.UIcmdList#1;
                  width = 210 + EXTRA_SHELL_WIDTH;
               };
               Panels.UIframe UIframe<NEx=253.,NEy=33.> {
                  parent => <-.UIshell;
                  y = 5;
                  x = 5;
                  width => (<-.UIshell.clientWidth - 10);
                  height => (<-.UIshell.clientHeight - 10);
               };
               Commands.UIcmdList UIcmdList<NEx=253.,NEy=-121.> {
                  cmdList => {<-.SaveFile};
                  label = "&File";
               };
               UIcmd SaveFile<NEx=253.,NEy=-286.> {
                  label => "&Save Output to File...";
               };
               Commands.UIcmdList UIcmdList#1<NEx=253.,NEy=-77.> {
                  cmdList => {<-.UIcmdList};
               };
               Controls.UIlist UIlist<NEx=-176.,NEy=22.> {
                  parent => <-.UIframe;
                  height => <-.UIframe.clientHeight;
                  y = 0;
                  width => <-.UIframe.clientWidth;
                  color {
                     backgroundColor = "white";
                  };
                  strings => <-.DBlist#1.list_string;
                  selectedItem<NEportLevels={0,2}>;
               };
               DBsave DBsave<NEx=253.,NEy=-176.> {
                  file_name => <-.UIfileDialog.filename;
                  string_array => <-.DBlist#1.list_string;
                  process_save => <-.UIfileDialog.ok;
               };
               StandardDialogs.UIfileDialog UIfileDialog<NEx=253.,NEy=-231.> {
                  visible => <-.SaveFile.do;
                  title => "Save View List";
                  ok<NEportLevels={1,2}>;
                  searchPattern = "*.lst";
               };
               GMOD.parse_v parse_v<NEx=-176.,NEy=-264.> {
                  v_commands = "new_statement=1;";
                  trigger => <-.SysViews.do;
                  on_inst = 0;
                  relative => <-.DBquery;
               };
               DBappendStatement DBappendStatement<NEx=-165.,NEy=88.> {
                  string_a => <-.<-.<-.<-.Statements.Text.text;
                  string_b => <-.UIlist.selectedText;
                  process => <-.UIlist.selectedItem;
                  result_string => <-.<-.<-.<-.Statements.Text.text;
               };
            };
            macro UserDefined<NEx=-286.,NEy=77.,NExOffset=278.,NEyOffset=325.> {
               UIbutton UserTabls<NEx=-55.,NEy=-275.> {
                  parent<NEportLevels={3,0}> => <-.<-.Frame;
                  height = 34;
                  x = 318;
                  y = 0;
                  width = 37;
                  label => "User Define";
                  labelPixmap<NEdisplayMode="open"> {
                     filename = "$XP_PATH<0>/v/db/icons/user.x";
                     fileType = "avs_image";
                  };
               };
               StandardDialogs.UIfileDialog UIfileDialog<NEx=143.,NEy=-231.> {
                  visible => <-.SaveFile.do;
                  title => "Save User List";
                  ok<NEportLevels={1,2}>;
                  searchPattern = "*.lst";
               };
               DBloadOther DBloadOther<NEx=-176.,NEy=-121.> {
                  process_load => <-.UserTabls.do;
                  file_name => <-.UIfileDialog#1.filename;
               };
               Shells.UIshell UIshell<NEx=143.,NEy=-22.> {
                  visible => <-.UIfileDialog#1.ok;
                  title => "User-defined List";
                  menu => <-.UIcmdList#1;
                  width = 210 + EXTRA_SHELL_WIDTH;
               };
               Panels.UIframe UIframe<NEx=143.,NEy=33.> {
                  parent => <-.UIshell;
                  y = 5;
                  x = 5;
                  width => (<-.UIshell.clientWidth - 10);
                  height => (<-.UIshell.clientHeight - 10);
               };
               Commands.UIcmdList UIcmdList<NEx=143.,NEy=-121.> {
                  cmdList => {<-.SaveFile};
                  label = "&File";
               };
               UIcmd SaveFile<NEx=143.,NEy=-286.> {
                  label => "&Save Output to File...";
               };
               Commands.UIcmdList UIcmdList#1<NEx=143.,NEy=-77.> {
                  cmdList => {<-.UIcmdList};
               };
               Controls.UIlist UIlist<NEx=-187.,NEy=-66.> {
                  parent => <-.UIframe;
                  height => <-.UIframe.clientHeight;
                  y = 0;
                  width => <-.UIframe.clientWidth;
                  color {
                     backgroundColor = "white";
                  };
                  strings => <-.DBloadOther.list;
                  selectedItem<NEportLevels={0,2}>;
               };
               DBsave DBsave<NEx=143.,NEy=-176.> {
                  file_name => <-.UIfileDialog.filename;
                  string_array => <-.DBloadOther.list;
                  process_save => <-.UIfileDialog.ok;
               };
               StandardDialogs.UIfileDialog UIfileDialog#1<NEx=-154.,NEy=-220.> {
                  visible => <-.UserTabls.do;
                  title => "User File";
                  ok<NEportLevels={1,2}>;
                  searchPattern = "*.other";
               };
               DBappendStatement DBappendStatement<NEx=-198.,NEy=0.> {
                  string_a => <-.<-.<-.<-.Statements.Text.text;
                  string_b => <-.UIlist.selectedText;
                  process => <-.UIlist.selectedItem;
                  result_string => <-.<-.<-.<-.Statements.Text.text;
               };
            };
         };
      };
      macro LoadModes<NEx=187.,NEy=275.,NExOffset=9.,NEyOffset=-121.,NEscalingFactor=1.> {
         UIcmdList LoadModes<NEx=22.,NEy=407.,NEportLevels={0,2}> {
            cmdList => {
               <-.User_Tables.UserTables,<-.User_Views.UserViews,
               <-.User_Defined.UserDefined,<-.Column_Names.Column_names};
            label = "&List Modes";
         };
         macro User_Tables<NEx=22.,NEy=176.,NExOffset=-17.06344604,NEyOffset=-11.27746582,NEscalingFactor=1.043588638> {
            UIcmd UserTables<NEx=44.,NEy=99.,NEportLevels={0,2}> {
               label => "&Tables";
               message = "Query for user-defined tables";
            };
            GMOD.parse_v parse_v<NEx=44.,NEy=198.,NEwidth=220.,NEheight=198.> {
               v_commands = "do=1;";
               trigger => <-.FlushEvents.out;
               on_inst = 0;
               relative => <-.<-.<-.Toolbar.SysViewsTablsColUser.Tables.SysTables;
            };
            DBflushEvents FlushEvents<NEx=44.,NEy=154.> {
               in<NEportLevels={2,0}> => <-.UserTables.do;
            };
         };
         macro User_Views<NEx=22.,NEy=231.,NExOffset=36.,NEyOffset=252.> {
            UIcmd UserViews<NEx=22.,NEy=-143.,NEportLevels={0,2}> {
               label => "&Views";
               message = "Query for user-defined views";
            };
            DBflushEvents FlushEvents1<NEx=22.,NEy=-88.> {
               in<NEportLevels={2,0}> => <-.UserViews.do;
            };
            GMOD.parse_v parse_v#1<NEx=22.,NEy=-44.> {
               v_commands = "do=1;";
               trigger => <-.FlushEvents1.out;
               on_inst = 0;
               relative => <-.<-.<-.Toolbar.SysViewsTablsColUser.Views.SysViews;
            };
         };
         macro User_Defined<NEx=22.,NEy=286.,NExOffset=-3.,NEyOffset=211.> {
            UIcmd UserDefined<NEx=44.,NEy=-110.,NEportLevels={0,2}> {
               label => "User-&defined...";
               message = "Load user-defined items from file";
            };
            DBflushEvents flushEvents<NEx=44.,NEy=-55.> {
               in<NEportLevels={2,0}> => <-.UserDefined.do;
            };
            GMOD.parse_v parse_v#2<NEx=44.,NEy=0.> {
               v_commands = "do=1;";
               trigger => <-.flushEvents.out;
               on_inst = 0;
               relative => <-.<-.<-.Toolbar.SysViewsTablsColUser.UserDefined.UserTabls;
            };
         };
         macro Column_Names<NEx=22.,NEy=341.,NExOffset=22.,NEyOffset=211.> {
            UIcmd Column_names<NEx=33.,NEy=-99.,NEportLevels={0,2}> {
               label => "&Column Names...";
               message = "Query for column names";
            };
            DBflushEvents flushEvents<NEx=33.,NEy=-55.> {
               in<NEportLevels={2,0}> => <-.Column_names.do;
            };
            GMOD.parse_v parse_v<NEx=33.,NEy=-11.> {
               v_commands = "do=1;";
               trigger => <-.flushEvents.out;
               on_inst = 0;
               relative => <-.<-.<-.Toolbar.SysViewsTablsColUser.Columns.SysCols;
            };
         };
      };
   };
   DBquery DBquery<NEx=198.,NEy=143.,NEwidth=275,NEheight=341> {
      dbvisual_connect_descriptor<NEportLevels={2,0}> => <-.dbvisual_connect_descriptor;
      message<NEportLevels={0,2}>;
      return_code<NEportLevels={0,2}>;
      query_timeout_secs<NEportLevels={0,0}>;
      num_columns<NEportLevels={0,2}>;
      connect_information {
         connected = 0;
      };
      statement<NEportLevels={2,2}> => <-.QueryUI.Statements.Text.text;
      processing<NEportLevels={0,2}>;
   };

   DBlist DBlist<NEx=396.,NEy=143.,NEwidth=231,NEheight=220> {
      column_array => <-.DBquery.column_array;
      header_mode = 2;
      active_mode = 1;
      num_rows_to_list = 50;
      column_width = 30;
      column_mode = 1;
   };
   link num_columns<NEx=176.,NEy=374.,NEportLevels={1,2}> => .DBquery.num_columns;
   link column_array<NEx=352.,NEy=374.,NEportLevels={1,2}> => .DBquery.column_array;
   link Graph1<NEportLevels={1,2},NEx=14.,NEy=435.> => .QueryUI.Toolbar.Graph1;
   link Graph2<NEportLevels={1,2},NEx=182.,NEy=435.> => .QueryUI.Toolbar.Graph2;
   link Graph3<NEportLevels={1,2},NEx=350.,NEy=435.> => .QueryUI.Toolbar.Graph3;
   link Graph4<NEportLevels={1,2},NEx=518.,NEy=435.> => .QueryUI.Toolbar.Graph4;
   link Graph5<NEportLevels={1,2},NEx=686.,NEy=435.> => .QueryUI.Toolbar.Graph5;
   ErrorUI DBerror {
      ErrorCode<NEx=385.,NEy=253.> {
         value => <-.<-.DBquery.db_specific_error_code;
      };
      UItext<NEx=550.,NEy=242.> {
         text<NEportLevels={2,2}> => <-.<-.DBquery.db_specific_error_message;
      };
      DBerrorString<NEx=209.,NEy=-77.> {
         statement => <-.<-.DBquery.statement;
         error_offset => <-.<-.DBquery.statement_error_offset;
         process_error => <-.<-.DBquery.return_code;
      };
   };

   StandardDialogs.UIwarningDialog UIwarningDialog<NEx=396.,NEy=209.> {
      visible => <-.DBlist.return_code;
      title => "Query Output Window";
      message = "WARNING: Number of rows in fetch buffer is 0  (No rows listed) .";
      color {
         foregroundColor = "red";
      };
      okLabelString = "      OK      ";
      cancelButton = 0;
   };
};

macro Manipulate<NEx=242.,NEy=154.,NEscalingFactor=1.013053536,NExOffset=0.8160095215,NEyOffset=-2.757263184> {
   macro ManipulateUI<NExOffset=0.,NEyOffset=0.,NEscalingFactor=1.,NEx=209.,NEy=176.,NEwidth=473,NEheight=605> {
      UIshell Shell<NEx=231.,NEy=110.,NEwidth=198,NEheight=242> {
         width = 460 + EXTRA_SHELL_WIDTH*6;
         height = 430 + EXTRA_SHELL_HEIGHT;
         title => "Manipulate";
         menu => <-.MainMenu;
      };
      UIcmdList MainMenu<NEx=231.,NEy=66.> {
         cmdList => {
            <-.File.FileCommand,<-.Statement.Statement,<-.Display.Display,
            <-.ListModes.LoadModes,<-.CommitRollback.UIcmdList
         };
      };
      macro Statement<NEx=22.,NEy=110.,NEscalingFactor=1.013215423,NExOffset=5.182788372,NEyOffset=2.936564207> {
         UIcmdList Statement<NEx=154.,NEy=286.,NEportLevels={0,2}> {
            label<NEdisplayMode="NEopened"> = "&Statement";
            cmdList => {<-.Process};
         };
         UIcmd Process<NEx=15.,NEy=109.> {
            label = "&Process";
            message = "Process the current statement";
         };
         GMOD.parse_v Parse_V_Process<NEx=11.,NEy=198.> {
            v_commands = "process_statement=1;";
            trigger => <-.flushEvents.out;
            on_inst = 0;
       relative => <-.<-.<-.DBmiscStatement;
         };
         DBflushEvents flushEvents<NEx=11.,NEy=154.> {
            in<NEportLevels={2,0}> => <-.Process.do;
         };
      };
      UIpanel MainPanel<NEx=231.,NEy=154.,NEwidth=297,NEheight=264> {
         x = 2;
         y = 1;
         width => <-.Shell.clientWidth;
         height => <-.Shell.clientHeight;
         parent => <-.Shell;
      };
      macro Display<NEx=22.,NEy=154.,NEscalingFactor=1,NExOffset=0,NEyOffset=0> {
         UIcmdList Display<NEx=22.,NEy=341.,NEportLevels={0,2}> {
            label = "&Display";
            cmdList => {
               <-.Connection_information,<-.Toolbar.ToolbarOption};
         };
         UIcmd Connection_information<NEx=198.,NEy=77.> {
            label = "&Connection Information";
            message = "Display connection information";
         };
         GMOD.parse_v Parse_V_Connect<NEx=198.,NEy=165.> {
            v_commands = "visible=1;";
            trigger => <-.flushEvents#1.out;
            on_inst = 0;
            relative => <-.<-.Util.ConnectionUI.UIshell;
         };
         DBflushEvents flushEvents#1<NEx=198.,NEy=121.> {
            in<NEportLevels={2,0}> => <-.Connection_information.do;
         };
         macro Toolbar<NEx=22.,NEy=77.,NExOffset=182.,NEyOffset=179.> {
            UIoption ToolbarOption<NEx=154.,NEy=264.,NEportLevels={0,2}> {
               label => "&Toolbar";
               message = "Activate toolbar";
               set = 1;
            };
            DBflushEvents FlushEvents1<NEx=154.,NEy=-132.> {
               in<NEportLevels={2,0}> => <-.ToolbarOption.set;
            };
            GMOD.parse_v PraseVTopFrameY40<NEx=154.,NEy=-88.> {
               v_commands = "y=40;";
               trigger => <-.FlushEvents1.out;
               relative => <-.<-.<-.TopFrame.UIframe;
            };
            GMOD.parse_v ParseVStatementsFramey80<NEx=154.,NEy=-44.> {
               v_commands = "y=80;";
               trigger => <-.FlushEvents1.out;
               relative => <-.<-.<-.Statements.StatementFrame;
            };
            DBflushEvents flushEvents<NEx=-88.,NEy=-132.> {
               in<NEportLevels={2,0}> => (<-.ToolbarOption.set + 1);
            };
            GMOD.parse_v ParseVTopFrameY0<NEx=-88.,NEy=-88.> {
               v_commands = "y=0;";
               trigger => <-.flushEvents.out;
               relative => <-.<-.<-.TopFrame.UIframe;
               on_inst = 0;
            };
            GMOD.parse_v ParseVStatementsFrameY40<NEx=-88.,NEy=-44.> {
               v_commands = "y=40;";
               trigger => <-.flushEvents.out;
               relative => <-.<-.<-.Statements.StatementFrame;
               on_inst = 0;
            };
            GMOD.parse_v ParseVToolBarFrameVis0<NEx=-88.,NEy=0.> {
               v_commands = "visible=0;";
               trigger => <-.flushEvents.out;
               relative => <-.<-.<-.Toolbar.UIframe;
               on_inst = 0;
            };
            GMOD.parse_v ParseVToolbarFrameVis1<NEx=154.,NEy=0.> {
               v_commands = "visible=1;";
               relative => <-.<-.<-.Toolbar.UIframe;
               trigger => <-.FlushEvents1.out;
            };
            GMOD.parse_v ParseVButtonFrameVis1<NEx=-88.,NEy=44.> {
               v_commands = "visible=1;";
               trigger => <-.flushEvents.out;
               relative => <-.<-.<-.Buttons.ButtonFrame;
               on_inst = 0;
            };
            GMOD.parse_v ParseVButtonFrameVis0<NEx=154.,NEy=44.> {
               v_commands = "visible=0;";
               trigger => <-.FlushEvents1.out;
               relative => <-.<-.<-.Buttons.ButtonFrame;
            };
         };
      };
      macro Buttons<NEx=418.,NEy=66.,NExOffset=15,NEyOffset=59> {
         UIframe ButtonFrame<NEx=11.,NEy=77.> {
            y => (<-.<-.Shell.clientHeight - 85);
            width => (<-.<-.MainPanel.width - 5);
            height = 40;
            parent => <-.Panel;
         };
         UIbutton Process_statement<NEx=11,NEy=176> {
            x = 8;
            y = 2;
            width = 150;
            height = 28;
            parent => <-.ButtonFrame;
            label => "  Process statement  ";
            do => ;
         };
         link Panel<NEx=11,NEy=22,NEportLevels={2,1}> => <-.MainPanel;
      };
      macro Message<NEx=418.,NEy=198.,NExOffset=51.,NEyOffset=53.,NEscalingFactor=1.> {
         UIframe MessageFrame<NEx=-22.,NEy=22.,NEwidth=253,NEheight=275> {
            y => (<-.<-.MainPanel.clientHeight - 45);
            width => (<-.<-.MainPanel.clientWidth - 5);
            height => (<-.<-.MainPanel.clientHeight - .y);
            parent => <-.Panel;
         };
         link Panel<NEx=-22,NEy=-22,NEportLevels={2,1}> => <-.MainPanel;
         UIlabel MessageLabel<NEx=-22.,NEy=66.> {
            x = 2;
            y = 8;
            width = 62 + EXTRA_SHELL_WIDTH*2;
            parent => <-.MessageFrame;
            label => "Message:";
            alignment = 0;
         };
         UItext Text<NEx=-22.,NEy=110.> {
            x = 66 + EXTRA_SHELL_WIDTH*2;
            y = 3;
            width = 210;
            outputOnly = 1;
            color {
               backgroundColor = "white";
            };
            parent => <-.MessageFrame;
            text<NEportLevels={2,0}>;
         };
         UIlabel StatusLabel<NEx=-22.,NEy=154.> {
            x = 289 + EXTRA_SHELL_WIDTH*3;
            y = 8;
            width = 50 + EXTRA_SHELL_WIDTH;
            parent => <-.MessageFrame;
            label => "Status:";
         };
         UIfield Code<NEx=-22.,NEy=198.> {
            parent => <-.MessageFrame;
            value<NEportLevels={2,2}> => <-.<-.<-.ReturnCode;
            x = 348 + EXTRA_SHELL_WIDTH*4;
            y = 2;
            height = 33;
            outputOnly = 1;
            color {
               backgroundColor = "white";
            };
            mode = 1;
         };
      };
      macro Statements<NEx=418.,NEy=154.,NExOffset=2,NEyOffset=141> {
         UIframe StatementFrame<NEx=22.,NEy=44.,NEwidth=385.,NEheight=286.> {
            y = 80;
            width => (<-.<-.Shell.clientWidth - 5);
            height => (<-.<-.Shell.clientHeight - 165);
            parent => <-.Panel;
         };
         link Panel<NEx=22.,NEy=-44.,NEportLevels={2,1}> => <-.MainPanel;
         Panels.UIscrolledWindow UIscrolledWindow<NEx=22.,NEy=0.,NEwidth=396.,NEheight=286.> {
            x = 0;
            y = 0;
            width => (<-.StatementFrame.width - 10);
            height => (<-.StatementFrame.height - 5);
            virtualWidth => <-.Text.width;
            virtualHeight => <-.Text.height;
            parent<NEportLevels={3,0}> => <-.StatementFrame;
         };
         UItext Text<NEx=22.,NEy=88.,NEwidth=286,NEheight=264> {
            y = 0;
            width = 1156;
            height = 2000;
            updateMode = 2;
            color {
               backgroundColor = "white";
            };
            parent => <-.UIscrolledWindow;
            text<NEportLevels={2,4}>;
            multiLine = 1;
         };
      };
      macro File<NEx=22.,NEy=66.> {
         UIcmdList FileCommand<NEx=660,NEy=451,NEportLevels={0,2}> {
            label = "&File";
            cmdList => {<-.Save_statement,
               <-.Load_statement};
         };
         UIcmd Load_statement<NEx=484.,NEy=77.> {
            label = "&Load Statement...";
            message = "Load a statement";
         };
         UIcmd Save_statement<NEx=253.,NEy=77.> {
            label = "&Save Statement...";
            message = "Save the statement to a file";
         };
         UIfileDialog Load<NEx=484,NEy=132,NEwidth=220,NEheight=220> {
            visible => <-.Load_statement.do;
            title => "Load Statement";
            ok<NEportLevels={1,2}>;
            okButton<NEportLevels={0,0}>;
            searchPattern = "*.sql";
         };
         UIfileDialog Save<NEx=253,NEy=132,NEwidth=187,NEheight=220> {
            visible => <-.Save_statement.do;
            title => "Save Statement";
            ok<NEportLevels={1,2}>;
            okButton<NEportLevels={0,0}>;
            searchPattern = "*.sql";
         };
         UIinfoDialog UIinfoDialog#1<NEx=253,NEy=220,NEwidth=231,NEheight=220> {
            width = 200;
            visible => <-.Save#1.processing;
            title => "Save";
            okButton = 1;
            okLabelString = "    OK    ";
            cancelButton = 0;
            message = "Saving statement to file";
         };
         DBsave Save#1<NEx=253,NEy=176,NEwidth=341,NEheight=231> {
            file_name => <-.Save.filename;
            num_of_strings = 1;
            string_array => <-.<-.Statements.Text.text;
            process_save => <-.Save.ok;
         };
         DBload DBload<NEx=484,NEy=176,NEwidth=231,NEheight=132> {
            file_name => <-.Load.filename;
            process_load => <-.Load.ok;
            statement => <-.<-.Statements.Text.text;
         };
         UIinfoDialog UIinfoDialog#2<NEx=484,NEy=220,NEwidth=231,NEheight=220> {
            width = 200;
            visible => <-.DBload.processing;
            title => "Save";
            okButton = 1;
            okLabelString = "    OK    ";
            cancelButton = 0;
            message = "Loading statement";
         };
      };
      macro Util<NEx=418.,NEy=110.,NExOffset=26,NEyOffset=-25> {
         link Panel<NEx=11.,NEy=110.,NEportLevels={2,1}> => <-.MainPanel;
         UIframe UtilFrame<NEx=11.,NEy=165.,NEwidth=385.,NEheight=352.> {
            parent => <-.Panel;
            y => ((<-.<-.Statements.StatementFrame.y + <-.<-.Statements.StatementFrame.clientHeight) + 6);
            width => (<-.<-.MainPanel.clientWidth - 5);
            height = 40;
         };
         UIbutton DisConnInfo<NEx=11.,NEy=209.> {
            parent => <-.UtilFrame;
            height = 34;
            x = 5;
            y = 0;
            width = 37;
            label = "Connect Information";
            labelPixmap<NEdisplayMode="open"> {
               filename = "$XP_PATH<0>/v/db/icons/connect.x";
               fileType = "avs_image";
            };
         };
         DBflushEvents flushEvents5<NEx=11.,NEy=253.> {
            in<NEportLevels={2,0}> => <-.DisConnInfo.do;
         };
         ConnectionUI ConnectionUI<NEx=11.,NEy=297.> {
            UIshell {
               visible<NEportLevels={3,0}> => <-.<-.flushEvents5.out;
            };
            DatabaseDriver {
               Text {
                  text => <-.<-.<-.<-.<-.DBinsert.connect_information.database_driver;
               };
            };
            HostName {
               Text {
                  text => <-.<-.<-.<-.<-.DBinsert.connect_information.server_host;
               };
            };
            ServerName {
               Text {
                  text => <-.<-.<-.<-.<-.DBinsert.connect_information.server_name;
               };
            };
            DatabaseName {
               Text {
                  text => <-.<-.<-.<-.<-.DBinsert.connect_information.database_name;
               };
            };
            UserId {
               Text {
                  text => <-.<-.<-.<-.<-.DBinsert.connect_information.user_id;
                  color<NEdisplayMode="closed">;
               };
            };
            ConnectString {
               Text {
                  text => <-.<-.<-.<-.<-.DBinsert.connect_information.connect_string;
                  color<NEdisplayMode="closed">;
               };
            };
         };
      };
      macro TopFrame<NEx=418.,NEy=242.,NExOffset=72.,NEyOffset=208.> {
         macro ConnectionStatus<NEx=308.,NEy=-11.> {
            link Panel<NEx=55,NEy=88,NEportLevels={2,1}> => <-.UIframe;
            UIlabel ConnectionStatus<NEx=55.,NEy=132.> {
               x = 214;
               y = 6;
               width = 125 + EXTRA_SHELL_WIDTH*4;
               parent => <-.Panel;
               label => "Connection Status:";
               alignment = 0;
            };
            UItext Text<NEx=55.,NEy=220.> {
               x = 341 + EXTRA_SHELL_WIDTH*4;
               y = 0;
               width = 107 + EXTRA_SHELL_WIDTH*2;
               outputOnly = 1;
               color {
                  backgroundColor = "white";
               };
               parent => <-.Panel;
               text<NEportLevels={2,0}> => <-.ConOrDisconnect.out;
            };
            group ConOrDisconnect<NEx=55.,NEy=176.> {
               int input<NEportLevels={0,0}> => <-.<-.<-.<-.DBinsert.connect_information.connected;
               string a[2] = {"Disconnected",
                  "Connected"};
               string out<NEportLevels={0,2}> => a[.input];
            };
         };
         UIlabel StatementWindow<NEx=132.,NEy=-11.> {
            parent => <-.UIframe;
            label => "Statement Window";
            y = 6;
            x = 55;
            width = 130 + EXTRA_SHELL_WIDTH*3;
            alignment = 0;
         };
         macro Clear<NEx=-33.,NEy=-11.> {
            UIbutton ClearButton<NEx=22,NEy=110> {
               x = 7;
               y = 3;
               width = 40;
               height = 30;
               parent<NEportLevels={3,0}> => <-.<-.UIframe;
               message = "Clear the statement window";
               labelPixmap<NEdisplayMode="open"> {
                 filename = "$XP_PATH<0>/v/db/icons/clear.x";
                 fileType = "avs_image";
               };
               label = "Clear";
            };
            DBflushEvents flushEvents<NEx=22,NEy=154> {
               in<NEportLevels={2,0}> => <-.ClearButton.do;
            };
            GMOD.parse_v parse_v_relative_no_inst<NEx=22,NEy=198,NEwidth=242,NEheight=187> {
               v_commands = "text=\"\";";
               trigger => <-.flushEvents.out;
               on_inst = 0;
               relative => <-.<-.<-.Statements.Text;
            };
         };
         Panels.UIframe UIframe<NEx=77.,NEy=-143.> {
            parent<NEportLevels={3,0}> => <-.<-.MainPanel;
            y = 40;
            width => (<-.<-.Shell.clientWidth - 5);
            height = 40;
         };
      };
      macro Toolbar<NEx=418.,NEy=286.> {
         link Panel<NEportLevels={2,1},NEx=33.,NEy=22.> => <-.MainPanel;
         Panels.UIframe UIframe<NEx=33.,NEy=88.> {
            parent => <-.Panel;
            y = 0;
            width => (<-.<-.Shell.clientWidth - 5);
            height = 40;
            pixmap<NEdisplayMode="open">;
         };
         macro Rollback<NEx=198.,NEy=297.,NExOffset=14.,NEyOffset=48.> {
            UIbutton Rollback<NEx=33.,NEy=77.> {
               parent<NEportLevels={3,0}> => <-.<-.UIframe;
               height = 34;
               x = 290;
               y = 0;
               width = 37;
               label = "Rollback";
               labelPixmap<NEdisplayMode="open"> {
                  filename = "$XP_PATH<0>/v/db/icons/rollback.x";
                  fileType = "avs_image";
               };
               do => <-.<-.<-.CommitRollback.Rollback.do;
            };
         };
         macro Commit<NEx=33.,NEy=297.> {
            UIbutton Commit<NEx=66.,NEy=110.> {
               parent<NEportLevels={3,0}> => <-.<-.UIframe;
               height = 34;
               x = 252;
               y = 0;
               width = 37;
               label = "Commit";
               labelPixmap<NEdisplayMode="open"> {
                  filename = "$XP_PATH<0>/v/db/icons/commit.x";
                  fileType = "avs_image";
               };
               do => <-.<-.<-.CommitRollback.Commit.do;
            };
         };
         macro Process<NEx=363.,NEy=297.,NExOffset=3.,NEyOffset=56.> {
            UIbutton Process<NEx=22.,NEy=88.> {
               parent<NEportLevels={3,0}> => <-.<-.UIframe;
               height = 34;
               x = 370;
               y = 0;
               width = 37;
               label = "Process";
               message = "Process Query";
               labelPixmap<NEdisplayMode="open"> {
                  filename = "$XP_PATH<0>/v/db/icons/process.x";
                  fileType = "avs_image";
               };
            };
         };
         macro Tables<NEx=33.,NEy=242.,NExOffset=-28.,NEyOffset=-11.> {
            UIbutton SysTables<NEx=242.,NEy=33.> {
               parent<NEportLevels={3,0}> => <-.<-.UIframe;
               height = 34;
               x = 5;
               y = 0;
               width = 37;
               label => "Tables";
               labelPixmap<NEdisplayMode="open"> {
                  filename = "$XP_PATH<0>/v/db/icons/tables.x";
                  fileType = "avs_image";
               };
            };
            DBquery DBquery<NEx=66.,NEy=154.,NEwidth=231.,NEheight=231.> {
               statement => <-.DBmodeOptions.statement;
               process_statement => <-.DBmodeOptions.done;
               connect_information<NEdisplayMode="open"> {
                  database_driver<NEportLevels={0,3}>;
               };
               loop = 0;
               new_statement=1;
               dbvisual_connect_descriptor => <-.<-.<-.<-.dbvisual_connect_descriptor;
            };
            GMOD.parse_v parse_v_table {
               v_commands = "new_statement=1;";
               trigger => <-.DBquery.new_statement;
               on_inst = 0;
               relative => <-.DBquery;
            };
            DBmodeOptions DBmodeOptions<NEx=66.,NEy=209.> {
               server_type => <-.DBquery.connect_information.database_driver;
               process_option => <-.SysTables.do;
               option = 1;
            };
            DBlist DBlist<NEx=66.,NEy=264.> {
               column_array => <-.DBquery.column_array;
               num_rows_to_list => array_size(column_array[0].values);
               header_mode = 0;
               active_mode = 1;
               column_mode = 0;
               column_width = 30;
            };
            Shells.UIshell UIshell<NEx=440.,NEy=396.> {
               visible => <-.SysTables.do;
               title => "Table List";
               menu => <-.UIcmdList#1;
               width = 284 + EXTRA_SHELL_WIDTH;
               height = 352 + EXTRA_SHELL_HEIGHT;
            };
            Panels.UIframe UIframe<NEx=440.,NEy=451.> {
               parent => <-.UIshell;
               y = 5;
               x = 5;
               width => (<-.UIshell.clientWidth - 10);
               height => (<-.UIshell.clientHeight - 10);
            };
            Commands.UIcmdList UIcmdList<NEx=440.,NEy=297.> {
               cmdList => {<-.SaveFile};
               label = "&File";
            };
            UIcmd SaveFile<NEx=440.,NEy=132.> {
               label => "&Save Output to File...";
            };
            Commands.UIcmdList UIcmdList#1<NEx=440.,NEy=341.> {
               cmdList => {<-.UIcmdList};
            };
            Controls.UIlist UIlist<NEx=66.,NEy=319.> {
               parent => <-.UIframe;
               height => <-.UIframe.clientHeight;
               y = 0;
               width => <-.UIframe.clientWidth;
               color {
                  backgroundColor = "white";
               };
               strings => <-.DBlist.list_string;
               selectedText<NEportLevels={0,2}>;
               selectedItem=0;
            };
            DBsave DBsave<NEx=440.,NEy=242.> {
               file_name => <-.UIfileDialog.filename;
               string_array => <-.DBlist.list_string;
               process_save => <-.UIfileDialog.ok;
            };
            StandardDialogs.UIfileDialog UIfileDialog<NEx=440.,NEy=187.> {
               visible => <-.SaveFile.do;
               title => "Save Table List";
               ok<NEportLevels={1,2}>;
               searchPattern = "*.lst";
            };
            DBappendStatement DBappendStatement<NEx=55.,NEy=374.> {
               string_a => <-.<-.<-.Statements.Text.text;
               string_b => <-.UIlist.selectedText;
               process => <-.UIlist.selectedItem;
               result_string => <-.<-.<-.Statements.Text.text;
            };
         };
         macro Columns<NEx=198.,NEy=242.,NExOffset=274.,NEyOffset=310.> {
            DBquery DBquery<NEx=-176.,NEy=-110.> {
               statement => <-.DBmodeOptions#2.statement;
               process_statement => <-.DBmodeOptions#2.done;
          loop = 0;
               new_statement=1;
               connect_information<NEdisplayMode="open"> {
                  database_driver<NEportLevels={0,3}>;
               };
               dbvisual_connect_descriptor => <-.<-.<-.<-.dbvisual_connect_descriptor;
            };
            GMOD.parse_v parse_v_table {
               v_commands = "new_statement=1;";
               trigger => <-.DBquery.new_statement;
               on_inst = 0;
               relative => <-.DBquery;
            };
            UIpromptDialog Prompt<NEx=11.,NEy=-220.> {
               visible => <-.SysCols.do;
               ok<NEportLevels={1,2}>;
               title => "Column Names";
               prompt = "Enter the table name";
               applyButton = 0;
            };
            DBmodeOptions DBmodeOptions#2<NEx=-176.,NEy=-165.> {
               server_type => <-.DBquery.connect_information.database_driver;
               option = 3;
               tablename => <-.Prompt.text;
               process_option => <-.Prompt.ok;
            };
            DBlist DBlist<NEx=-176.,NEy=-44.> {
               column_array => <-.DBquery.column_array;
               num_rows_to_list = array_size(column_array[0].values);
               header_mode = 1;
               column_mode = 0;
               column_width = 30;
               active_mode = 1;
            };
            Shells.UIshell UIshell<NEx=209.,NEy=-11.> {
               visible => <-.Prompt.ok;
               title => "Column List";
               menu => <-.UIcmdList#1;
               width = 210 + EXTRA_SHELL_WIDTH;
            };
            Panels.UIframe UIframe<NEx=209.,NEy=44.> {
               parent => <-.UIshell;
               y = 5;
               x = 5;
               width => (<-.UIshell.clientWidth - 10);
               height => (<-.UIshell.clientHeight - 10);
            };
            Commands.UIcmdList UIcmdList<NEx=209.,NEy=-110.> {
               cmdList => {<-.SaveFile};
               label = "&File";
            };
            UIcmd SaveFile<NEx=209.,NEy=-275.> {
               label => "&Save Output to File...";
            };
            Commands.UIcmdList UIcmdList#1<NEx=209.,NEy=-66.> {
               cmdList => {<-.UIcmdList};
            };
            Controls.UIlist UIlist<NEx=-176.,NEy=11.> {
               parent => <-.UIframe;
               height => <-.UIframe.clientHeight;
               y = 0;
               width => <-.UIframe.clientWidth;
               color {
                  backgroundColor = "white";
               };
               strings => <-.DBlist.list_string;
               selectedItem<NEportLevels={0,2}>;
            };
            DBsave DBsave<NEx=209.,NEy=-165.> {
               file_name => <-.UIfileDialog.filename;
               string_array => <-.DBlist.list_string;
               process_save => <-.UIfileDialog.ok;
            };
            StandardDialogs.UIfileDialog UIfileDialog<NEx=209.,NEy=-220.> {
               visible => <-.SaveFile.do;
               title => "Save Column List";
               ok<NEportLevels={1,2}>;
               searchPattern = "*.lst";
            };
            UIbutton SysCols<NEx=11.,NEy=-264.> {
               parent<NEportLevels={3,0}> => <-.<-.UIframe;
               height = 34;
               x = 43;
               y = 0;
               width = 37;
               label => "Columns";
               labelPixmap<NEdisplayMode="open"> {
                  filename = "$XP_PATH<0>/v/db/icons/columns.x";
                  fileType = "avs_image";
               };
            };
            DBappendStatement DBappendStatement<NEx=-176.,NEy=77.> {
               string_a => <-.<-.<-.Statements.Text.text;
               string_b => <-.UIlist.selectedText;
               process => <-.UIlist.selectedItem;
               result_string => <-.<-.<-.Statements.Text.text;
            };
         };
         macro Views<NEx=363.,NEy=242.,NExOffset=242.8303528,NEyOffset=310.5056152,NEscalingFactor=1.037454247> {
            UIbutton SysViews<NEx=-11.,NEy=-264.> {
               parent<NEportLevels={3,0}> => <-.<-.UIframe;
               height = 34;
               x = 81;
               y = 0;
               width = 37;
               label => "Views";
               labelPixmap<NEdisplayMode="open"> {
                  filename = "$XP_PATH<0>/v/db/icons/views.x";
                  fileType = "avs_image";
               };
            };
            DBquery DBquery<NEx=-176.,NEy=-121.> {
               statement => <-.DBmodeOptions#1.statement;
               process_statement => <-.DBmodeOptions#1.done;
               connect_information {
                  database_driver<NEportLevels={0,3}>;
               };
               new_statement<NEportLevels={2,0}>;
               dbvisual_connect_descriptor => <-.<-.<-.<-.dbvisual_connect_descriptor;
            };
            DBmodeOptions DBmodeOptions#1<NEx=-165.,NEy=-187.> {
               server_type => <-.DBquery.connect_information.database_driver;
               option = 2;
               process_option => <-.SysViews.do;
            };
            DBlist DBlist#1<NEx=-176.,NEy=-33.> {
               column_array => <-.DBquery.column_array;
               num_rows_to_list => array_size(column_array[0].values);
               header_mode = 0;
               active_mode = 1;
               column_mode = 0;
               column_width = 30;
            };
            Shells.UIshell UIshell<NEx=253.,NEy=-22.> {
               visible => <-.SysViews.do;
               title => "View List";
               menu => <-.UIcmdList#1;
               width = 210 + EXTRA_SHELL_WIDTH;
            };
            Panels.UIframe UIframe<NEx=253.,NEy=33.> {
               parent => <-.UIshell;
               y = 5;
               x = 5;
               width => (<-.UIshell.clientWidth - 10);
               height => (<-.UIshell.clientHeight - 10);
            };
            Commands.UIcmdList UIcmdList<NEx=253.,NEy=-121.> {
               cmdList => {<-.SaveFile};
               label = "&File";
            };
            UIcmd SaveFile<NEx=253.,NEy=-286.> {
               label => "&Save Output to File...";
            };
            Commands.UIcmdList UIcmdList#1<NEx=253.,NEy=-77.> {
               cmdList => {<-.UIcmdList};
            };
            Controls.UIlist UIlist<NEx=-176.,NEy=22.> {
               parent => <-.UIframe;
               height => <-.UIframe.clientHeight;
               y = 0;
               width => <-.UIframe.clientWidth;
               color {
                  backgroundColor = "white";
               };
               strings => <-.DBlist#1.list_string;
               selectedItem<NEportLevels={0,2}>;
            };
            DBsave DBsave<NEx=253.,NEy=-176.> {
               file_name => <-.UIfileDialog.filename;
               string_array => <-.DBlist#1.list_string;
               process_save => <-.UIfileDialog.ok;
            };
            StandardDialogs.UIfileDialog UIfileDialog<NEx=253.,NEy=-231.> {
               visible => <-.SaveFile.do;
               title => "Save View List";
               ok<NEportLevels={1,2}>;
               searchPattern = "*.lst";
            };
            DBappendStatement DBappendStatement<NEx=-165.,NEy=88.> {
               string_a => <-.<-.<-.Statements.Text.text;
               string_b => <-.UIlist.selectedText;
               process => <-.UIlist.selectedItem;
               result_string => <-.<-.<-.Statements.Text.text;
            };
         };
         macro UserDefined<NEx=528.,NEy=242.,NExOffset=278.,NEyOffset=325.> {
            UIbutton UserTabls<NEx=-55.,NEy=-275.> {
               parent<NEportLevels={3,0}> => <-.<-.UIframe;
               height = 34;
               x = 120;
               y = 0;
               width = 37;
               label => "User Define";
               labelPixmap<NEdisplayMode="open"> {
                  filename = "$XP_PATH<0>/v/db/icons/user.x";
                  fileType = "avs_image";
               };
            };
            StandardDialogs.UIfileDialog UIfileDialog<NEx=143.,NEy=-231.> {
               visible => <-.SaveFile.do;
               title => "Save User List";
               ok<NEportLevels={1,2}>;
               searchPattern = "*.lst";
            };
            DBloadOther DBloadOther<NEx=-176.,NEy=-121.> {
               process_load => <-.UserTabls.do;
               file_name => <-.UIfileDialog#1.filename;
            };
            Shells.UIshell UIshell<NEx=143.,NEy=-22.> {
               visible => <-.UIfileDialog#1.ok;
               title => "User-defined List";
               menu => <-.UIcmdList#1;
               width = 210 + EXTRA_SHELL_WIDTH;
            };
            Panels.UIframe UIframe<NEx=143.,NEy=33.> {
               parent => <-.UIshell;
               y = 5;
               x = 5;
               width => (<-.UIshell.clientWidth - 10);
               height => (<-.UIshell.clientHeight - 10);
            };
            Commands.UIcmdList UIcmdList<NEx=143.,NEy=-121.> {
               cmdList => {<-.SaveFile};
               label = "&File";
            };
            UIcmd SaveFile<NEx=143.,NEy=-286.> {
               label => "&Save Output to File...";
            };
            Commands.UIcmdList UIcmdList#1<NEx=143.,NEy=-77.> {
               cmdList => {<-.UIcmdList};
            };
            Controls.UIlist UIlist<NEx=-187.,NEy=-66.> {
               parent => <-.UIframe;
               height => <-.UIframe.clientHeight;
               y = 0;
               width => <-.UIframe.clientWidth;
               color {
                  backgroundColor = "white";
               };
               strings => <-.DBloadOther.list;
               selectedItem<NEportLevels={0,2}>;
            };
            DBsave DBsave<NEx=143.,NEy=-176.> {
               file_name => <-.UIfileDialog.filename;
               string_array => <-.DBloadOther.list;
               process_save => <-.UIfileDialog.ok;
            };
            StandardDialogs.UIfileDialog UIfileDialog#1<NEx=-154.,NEy=-220.> {
               visible => <-.UserTabls.do;
               title => "User File";
               ok<NEportLevels={1,2}>;
               searchPattern = "*.other";
            };
            DBappendStatement DBappendStatement<NEx=-198.,NEy=0.> {
               string_a => <-.<-.<-.Statements.Text.text;
               string_b => <-.UIlist.selectedText;
               process => <-.UIlist.selectedItem;
               result_string => <-.<-.<-.Statements.Text.text;
            };
         };
      };
      macro ListModes<NEx=22.,NEy=198.,NExOffset=9.,NEyOffset=-121.,NEscalingFactor=1.> {
         UIcmdList LoadModes<NEx=22.,NEy=407.,NEportLevels={0,2}> {
            cmdList => {
               <-.User_Tables.UserTables,<-.User_Views.UserViews,
               <-.User_Defined.UserDefined,<-.Column_Names.Column_names};
            label = "&List Modes";
         };
         macro User_Tables<NEx=22.,NEy=176.,NExOffset=-17.06344604,NEyOffset=-11.27746582,NEscalingFactor=1.043588638> {
            UIcmd UserTables<NEx=44.,NEy=99.,NEportLevels={0,2}> {
               label => "&Tables";
               message = "Query for user-defined tables";
            };
            GMOD.parse_v parse_v<NEx=44.,NEy=198.,NEwidth=220.,NEheight=198.> {
               v_commands = "do=1;";
               trigger => <-.FlushEvents.out;
               on_inst = 0;
               relative => <-.<-.<-.Toolbar.Tables.SysTables;
            };
            DBflushEvents FlushEvents<NEx=44.,NEy=154.> {
               in<NEportLevels={2,0}> => <-.UserTables.do;
            };
         };
         macro User_Views<NEx=22.,NEy=231.,NExOffset=36.,NEyOffset=252.> {
            UIcmd UserViews<NEx=22.,NEy=-143.,NEportLevels={0,2}> {
               label => "&Views";
               message = "Query for user-defined views";
            };
            DBflushEvents FlushEvents1<NEx=22.,NEy=-88.> {
               in<NEportLevels={2,0}> => <-.UserViews.do;
            };
            GMOD.parse_v parse_v#1<NEx=22.,NEy=-44.> {
               v_commands = "do=1;";
               trigger => <-.FlushEvents1.out;
               on_inst = 0;
               relative => <-.<-.<-.Toolbar.Views.SysViews;
            };
         };
         macro User_Defined<NEx=22.,NEy=286.,NExOffset=-3.,NEyOffset=211.> {
            UIcmd UserDefined<NEx=44.,NEy=-110.,NEportLevels={0,2}> {
               label => "User-&defined...";
               message = "Load user-defined items from file";
            };
            DBflushEvents flushEvents<NEx=44.,NEy=-55.> {
               in<NEportLevels={2,0}> => <-.UserDefined.do;
            };
            GMOD.parse_v parse_v#2<NEx=44.,NEy=0.> {
               v_commands = "do=1;";
               trigger => <-.flushEvents.out;
               on_inst = 0;
               relative => <-.<-.<-.Toolbar.UserDefined.UserTabls;
            };
         };
         macro Column_Names<NEx=22.,NEy=341.,NExOffset=22.,NEyOffset=211.> {
            UIcmd Column_names<NEx=33.,NEy=-99.,NEportLevels={0,2}> {
               label => "&Column Names...";
               message = "Query for column names";
            };
            DBflushEvents flushEvents<NEx=33.,NEy=-55.> {
               in<NEportLevels={2,0}> => <-.Column_names.do;
            };
            GMOD.parse_v parse_v<NEx=33.,NEy=-11.> {
               v_commands = "do=1;";
               trigger => <-.flushEvents.out;
               on_inst = 0;
               relative => <-.<-.<-.Toolbar.Columns.SysCols;
            };
         };
      };
      macro CommitRollback<NEx=22.,NEy=242.> {
         Commands.UIcmdList UIcmdList<NEx=0.,NEy=22.,NEportLevels={0,2}> {
            cmdList => {<-.Commit,
               <-.Rollback};
            label = "&Com/Roll";
         };
         UIcmd Rollback<NEx=440.,NEy=44.> {
            label = "&Rollback";
            message = "Rollback the changes";
         };
         UIcmd Commit<NEx=198.,NEy=44.> {
            label = "&Commit";
            message = "Commit the changes to the database";
         };
         DBflushEvents flushEvents1<NEx=198.,NEy=99.> {
            in<NEportLevels={2,0}> => <-.Commit.do;
         };
         DBflushEvents flushEvents2<NEx=440.,NEy=99.> {
            in<NEportLevels={2,0}> => <-.Rollback.do;
         };
         DBcommit DBcommit<NEx=198.,NEy=154.> {
            dbvisual_connect_descriptor => <-.<-.<-.dbvisual_connect_descriptor;
            process_commit => <-.flushEvents1.out;
            db_specific_error_message => <-.<-.<-.ErrorString;
            message => <-.<-.Message.Text.text;
            return_code => <-.<-.<-.ReturnCode;
            db_specific_error_code => <-.<-.<-.ErrorCode;
            processing => <-.<-.<-.PleaseWait.visible;
         };
         DBrollback DBrollback<NEx=440.,NEy=154.> {
            dbvisual_connect_descriptor => <-.<-.<-.dbvisual_connect_descriptor;
            process_rollback => <-.flushEvents2.out;
            db_specific_error_message => <-.<-.<-.ErrorString;
            message => <-.<-.Message.Text.text;
            return_code => <-.<-.<-.ReturnCode;
            db_specific_error_code => <-.<-.<-.ErrorCode;
            processing => <-.<-.<-.PleaseWait.visible;
         };
      };
   };
   ErrorUI Error<NEx=209.,NEy=253.,NExOffset=134.,NEyOffset=130.> {
      UItext<NEx=506.,NEy=242.> {
         text<NEportLevels={2,2}> => <-.<-.ErrorString;
      };
      DBerrorString<NEx=165.,NEy=-77.> {
         statement<NEportLevels={3,0}> => <-.<-.ManipulateUI.Statements.Text.text;
         process_error<NEportLevels={3,0}> => <-.<-.DBmiscStatement.return_code;
         error_offset<NEportLevels={3,0}> => <-.<-.DBmiscStatement.statement_error_offset;
      };
   };
   UIworkingDialog PleaseWait<NEx=11.,NEy=385.,NEwidth=396.,NEheight=253.> {
      title => "Working";
      message = "Please Wait... processing";
      width = 265;
      color {
         foregroundColor = "blue";
      };
      okButton = 0;
      cancelButton = 0;
   };
   DBinsert DBinsert<NEx=11.,NEy=121.> {
      dbvisual_connect_descriptor => <-.dbvisual_connect_descriptor;
      message => <-.ManipulateUI.Message.Text.text;
      return_code => <-.ReturnCode;
      db_specific_error_code => <-.ErrorCode;
      statement_error_offset => <-.Error.DBerrorString.error_offset;
      db_specific_error_message => <-.ErrorString;
      processing => <-.PleaseWait.visible;
   };
   DBupdate DBupdate<NEx=11.,NEy=209.> {
      dbvisual_connect_descriptor => <-.dbvisual_connect_descriptor;
      message => <-.ManipulateUI.Message.Text.text;
      return_code => <-.ReturnCode;
      db_specific_error_code => <-.ErrorCode;
      statement_error_offset => <-.Error.DBerrorString.error_offset;
      db_specific_error_message => <-.ErrorString;
      processing => <-.PleaseWait.visible;
   };
   link dbvisual_connect_descriptor<NEportLevels={2,1},NEx=11.,NEy=33.>;
   DBdelete DBdelete<NEx=11.,NEy=165.,NEwidth=220.,NEheight=209.> {
      dbvisual_connect_descriptor => <-.dbvisual_connect_descriptor;
      message => <-.ManipulateUI.Message.Text.text;
      return_code => <-.ReturnCode;
      db_specific_error_code => <-.ErrorCode;
      statement_error_offset => <-.Error.DBerrorString.error_offset;
      db_specific_error_message => <-.ErrorString;
      processing => <-.PleaseWait.visible;
   };
   DBmiscStatement DBmiscStatement<NEx=363.,NEy=110.,NEwidth=297.,NEheight=242.> {
      dbvisual_connect_descriptor => <-.dbvisual_connect_descriptor;
      statement => <-.ManipulateUI.Statements.Text.text;
      process_statement => <-.ManipulateUI.Toolbar.Process.Process.do;
      message => <-.ManipulateUI.Message.Text.text;
      return_code<NEportLevels={0,2}> => <-.ReturnCode;
      db_specific_error_code => <-.ErrorCode;
      statement_error_offset<NEportLevels={0,2}>;
      db_specific_error_message => <-.ErrorString;
      processing => <-.PleaseWait.visible;
   };
   int ReturnCode<NEportLevels={0,0},NEx=11.,NEy=253.>;
   int ErrorCode<NEportLevels={0,0},NEx=11.,NEy=297.>;
   string ErrorString<NEportLevels={0,0},NEx=11.,NEy=341.>;
};
macro Tools<NEx=143.,NEy=132.,NExOffset=298.,NEyOffset=234.> {
   Shells.UIshell UIshell<NEx=22.,NEy=-198.> {
      title = "AVS/Express DB Tools";
      width = 263 + EXTRA_SHELL_WIDTH*2;
      height = 145 + EXTRA_SHELL_HEIGHT*2;
   };
   Panels.UIpanel UIpanel<NEx=22.,NEy=-154.> {
      parent => <-.UIshell;
      y = 0;
      width => <-.UIshell.clientWidth;
      height => <-.UIshell.clientHeight;
      color<NEdisplayMode="open"> {
         backgroundColor<NEdisplayMode="open">;
      };
   };
   Panels.UIframe UIframe<NEx=22.,NEy=-110.> {
      parent => <-.UIpanel;
      y = 5;
      x = 5;
      width => (<-.UIpanel.clientWidth - 10);
      height => (<-.UIpanel.clientHeight - 10);
   };
   UIbutton ConnectButton<NEx=-253.,NEy=55.> {
      parent => <-.UIframe;
      height = 80;
      label => "Connect to a database";
      y = 5;
      width = 80;
      labelPixmap<NEdisplayMode="open"> {
         filename = "$XP_PATH<0>/v/db/icons/conn_t.x";
         fileType = "avs_image";
      };
   };
   UIbutton QueryButton<NEx=22.,NEy=55.> {
      parent => <-.UIframe;
      height = 80;
      label = "Construct a Query";
      x = 83;
      y = 5;
      width = 80;
      labelPixmap<NEdisplayMode="open"> {
         filename = "$XP_PATH<0>/v/db/icons/query_t.x";
         fileType = "avs_image";
      };
   };
   UIbutton ManipulateButton<NEx=275.,NEy=55.> {
      parent => <-.UIframe;
      height = 80;
      label ="Read/Write Operations";
      x = 166;
      y = 5;
      width = 80;
      labelPixmap<NEdisplayMode="open"> {
         filename<NEdisplayMode="open"> = "$XP_PATH<0>/v/db/icons/manip_t.x";
         fileType = "avs_image";
      };
   };
   UIlabel ConnectLabel<NEx=-253.,NEy=11.> {
      parent => <-.UIframe;
      label = "Connect";
      x = 7;
      y = 88;
      width = 60 + EXTRA_SHELL_WIDTH;
      alignment = 0;
   };
   UIlabel QueryLabel<NEx=22.,NEy=11.> {
      parent => <-.UIframe;
      label<NEdisplayMode="open"> = "Query";
      x = 100;
      y = 88;
      width = 60;
      alignment<NEdisplayMode="open"> = 0;
   };
   UIlabel Manipulate_label<NEx=275.,NEy=11.> {
      parent => <-.UIframe;
      label = "Manipulate";
      x = 168;
      y = 87;
      width = 70 + EXTRA_SHELL_WIDTH*2;
   };
   Connect Connect#1<NEx=-253.,NEy=99.> {
      ConnectUI {
         Shell {
            visible<NEportLevels={4,0}> => <-.<-.<-.ConnectButton.do;
         };
      };
   };
   Query Query#1<NEx=22.,NEy=165.> {
      column_array<NEportLevels={1,3}>;
      QueryUI {
         Shell {
            visible<NEportLevels={4,0}> => <-.<-.<-.QueryButton.do;
         };
      };
      DBquery {
         dbvisual_connect_descriptor => <-.<-.Connect#1.DBconnect.dbvisual_connect_descriptor;
      };
   };
   Manipulate Manipulate#1<NEx=286.,NEy=121.> {
      ManipulateUI {
         Shell {
            visible<NEportLevels={4,0}> => <-.<-.<-.ManipulateButton.do;
         };
      };
      dbvisual_connect_descriptor => <-.Connect#1.DBconnect.dbvisual_connect_descriptor;
   };
};
};

library+sort+buffered UI_Macro <NEdisplayMode="NEopened",compile_subs=0> {

macro ConnectionUI<NEx=22.,NEy=198.,NEscalingFactor=1.026782632,NExOffset=-263.4014282,NEyOffset=247.7944031> {
   macro UserId#6<NEx=-33,NEy=11> {
      link Frame<NEx=22,NEy=88,NEportLevels={2,1}>;
      UIlabel User_id<NEx=22,NEy=132> {
         x<NEdisplayMode="NEopened"> = 224;
         y = 6;
         width = 60;
         parent => <-.Frame;
         label => "User ID:";
         alignment = 0;
      };
      UItext UserText<NEx=22,NEy=176> {
         x = 277;
         y = 1;
         outputOnly = 1;
         parent => <-.Frame;
         text<NEportLevels={0,0}>;
      };
   };
   macro UserId#7<NEx=0,NEy=66> {
      link Frame<NEx=22,NEy=88,NEportLevels={2,1}>;
      UIlabel User_id<NEx=22,NEy=132> {
         x<NEdisplayMode="NEopened"> = 224;
         y = 6;
         width = 60;
         parent => <-.Frame;
         label => "User ID:";
         alignment = 0;
      };
      UItext UserText<NEx=22,NEy=176> {
         x = 277;
         y = 1;
         outputOnly = 1;
         parent => <-.Frame;
         text<NEportLevels={0,0}>;
      };
   };
   Panels.UIpanel UIpanel<NEx=297,NEy=-143> {
      y = 0;
      width = 305;
      height = 235;
      parent => <-.UIshell;
   };
   Shells.UIshell UIshell<NEx=297,NEy=-187,NEwidth=209,NEheight=231> {
      width = 305 + EXTRA_SHELL_WIDTH*6;
      height = 235 + EXTRA_SHELL_HEIGHT*2;
      visible = 1;
      title = "Connection Information";
   };
   UIframe Frame<NEx=297,NEy=-88> {
      x = 3;
      y = 3;
      width = 300 + EXTRA_SHELL_WIDTH*6;
      height = 230;
      parent => <-.UIpanel;
   };
   macro DatabaseDriver<NEx=297,NEy=-44> {
      UIlabel DatabaseDriver<NEx=44,NEy=154> {
         x = 7;
         y = 15;
         width = 110 + EXTRA_SHELL_WIDTH*3;
         parent => <-.Frame;
         label => "Database Driver:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=99,NEportLevels={2,1}> => <-.Frame;
      UItext Text<NEx=44,NEy=198> {
         x = 120 + EXTRA_SHELL_WIDTH*3;
         y = 7;
         outputOnly = 1;
         color {
            backgroundColor = "white";
         };
         parent => <-.Frame;
      };
   };
   macro HostName<NEx=297,NEy=0> {
      UIlabel HostName<NEx=44,NEy=165> {
         x = 7;
         y = 49;
         parent => <-.Frame;
         label => "Host Name:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=110,NEportLevels={2,1}> => <-.Frame;
      UItext Text<NEx=44,NEy=209> {
         x = 120 + EXTRA_SHELL_WIDTH*3;
         y = 42;
         width = 170;
         outputOnly = 1;
         color {
            backgroundColor = "white";
         };
         parent => <-.Frame;
      };
   };
   macro ServerName<NEx=297,NEy=55> {
      UIlabel ServerName<NEx=44,NEy=165> {
         x = 8 ;
         y = 86;
        width = 100 + EXTRA_SHELL_WIDTH;
         parent => <-.Frame;
         label => "Server Name:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=110,NEportLevels={2,1}> => <-.Frame;
      UItext Text<NEx=44,NEy=209> {
         x = 120 + EXTRA_SHELL_WIDTH*3;
         y = 79;
         width = 170;
         outputOnly = 1;
         color {
            backgroundColor = "white";
         };
         parent => <-.Frame;
      };
   };
   macro DatabaseName<NEx=297,NEy=110> {
      UIlabel DatabaseName<NEx=44,NEy=165> {
         x = 8;
         y = 120;
         width = 110 + EXTRA_SHELL_WIDTH*3;
         parent => <-.Frame;
         label => "Database Name:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=110,NEportLevels={2,1}> => <-.Frame;
      UItext Text<NEx=44,NEy=209> {
         x = 120 + EXTRA_SHELL_WIDTH*3;
         y = 115;
         width = 170;
         outputOnly = 1;
         color {
            backgroundColor = "white";
         };
         parent => <-.Frame;
      };
   };
   macro UserId<NEx=297,NEy=154> {
      UIlabel UserId<NEx=44,NEy=165> {
         x = 7;
         y = 154;
         parent => <-.Frame;
         label => "User ID:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=110,NEportLevels={2,1}> => <-.Frame;
      UItext Text<NEx=44,NEy=209> {
         x = 120 + EXTRA_SHELL_WIDTH*3;
         y = 148;
         width = 170;
         outputOnly = 1;
         color<NEdisplayMode="NEopened"> {
            backgroundColor = "white";
         };
         parent => <-.Frame;
      };
   };
   macro ConnectString<NEx=297,NEy=198> {
      UIlabel ConnectString<NEx=44,NEy=165> {
         x = 7;
         y = 189;
        width = 100 + EXTRA_SHELL_WIDTH*4;
         parent => <-.Frame;
         label => "Connect String:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=110,NEportLevels={2,1}> => <-.Frame;
      UItext Text<NEx=44,NEy=209> {
         x = 120 + EXTRA_SHELL_WIDTH*3;
         y = 184;
         width = 170;
         outputOnly = 1;
         color<NEdisplayMode="NEopened"> {
            backgroundColor = "white";
         };
         parent => <-.Frame;
      };
   };
};

macro ErrorUI<NEx=231.,NEy=77.,NExOffset=134.,NEyOffset=130.> {
   UIshell ErrorShell<NEx=209.,NEy=99.> {
      visible => <-.DBerrorString.valid_error;
      title => "Error";
      width = 500 + EXTRA_SHELL_WIDTH;
      height = 187 + EXTRA_SHELL_HEIGHT;
   };
   UIpanel ErrorPanel<NEx=209.,NEy=143.> {
      parent => <-.ErrorShell;
      y = 0;
      width => <-.ErrorShell.clientWidth;
      height => <-.ErrorShell.clientHeight;
   };
   UIframe ErrorFrame<NEx=209.,NEy=187.> {
      parent => <-.ErrorPanel;
      y = 5;
      x = 5;
      width => (<-.ErrorPanel.clientWidth - 10);
      height => (<-.ErrorPanel.clientHeight - 10);
   };
   Controls.UItext ErrorText<NEx=-110.,NEy=352.> {
      parent => <-.TopFrame;
      x = 2;
      y = 25;
      width => (<-.TopFrame.clientWidth - 5);
      height => (<-.TopFrame.clientHeight - 30);
      color {
         backgroundColor = "white";
      };
      rows = 2;
      multiLine = 1;
      outputOnly = 1;
      text<NEportLevels={2,2}> => <-.DBerrorString.error_string;
   };
   Controls.UIlabel SysErrLabel<NEx=550.,NEy=286.> {
      parent => <-.BottomFrame;
      label = "System Error:";
      x = 2;
      y = 5;
      width = 90;
      color {
         foregroundColor = "red";
      };
      alignment = 0;
   };
   Controls.UIlabel ErrorCodeLab<NEx=385.,NEy=286.> {
      parent => <-.BottomFrame;
      label = "Error Code:";
      x = 5;
      y = 40;
      width = 70;
      color {
         foregroundColor = "red";
      };
   };
   UIfield ErrorCode<NEx=385.,NEy=341.> {
      parent => <-.BottomFrame;
      x = 110;
      y = 35;
      height = 33;
      color {
         backgroundColor = "white";
      };
      decimalPoints = 0;
      outputOnly = 1;
      value => <-.Error_code;
   };
   Controls.UIlabel UIlabel<NEx=66.,NEy=352.> {
      parent => <-.TopFrame;
      label = "Statement Error Location:";
      x = 3;
      y = 0;
      width = 160;
      color {
         foregroundColor = "red";
      };
      alignment = 0;
   };
   Controls.UItext UItext<NEx=550.,NEy=341.> {
      parent => <-.BottomFrame;
      x = 109;
      y = 0;
      width => (<-.BottomFrame.clientWidth - 112);
      outputOnly = 1;
      color {
         backgroundColor = "white";
      };
      text<NEportLevels={2,2}> => <-.Error_message;
   };
   UIframe BottomFrame<NEx=429.,NEy=220.> {
      parent => <-.ErrorFrame;
      y => (<-.ErrorText.height + 37);
      width => <-.ErrorFrame.clientWidth;
      height = 79;
   };
   UIframe TopFrame<NEx=-22.,NEy=242.> {
      parent => <-.ErrorFrame;
      y = 0;
      width => <-.ErrorFrame.clientWidth;
      height => (<-.ErrorFrame.clientHeight - 80);
   };
   DBerrorString DBerrorString<NEx=209.,NEy=44.> {
      statement => <-.Statement;
      error_offset => <-.Error_offset;
      process_error => <-.Process_error;
   };
   link Statement<NEportLevels={2,1},NEx=0.,NEy=-110.>;
   link Error_offset<NEportLevels={2,1},NEx=0.,NEy=-66.>;
   link Process_error<NEportLevels={2,1},NEx=0.,NEy=-22.>;
   link Error_code<NEportLevels={2,1},NEx=0.,NEy=22.>;
   link Error_message<NEportLevels={2,1},NEx=0.,NEy=66.>;
};

macro StatisticsUI<NEx=22.,NEy=110.,NEscalingFactor=1.026782632,NExOffset=-265.3492432,NEyOffset=208.8377533> {
   macro UserId#6<NEx=-33,NEy=11> {
      link Frame<NEx=22,NEy=88,NEportLevels={2,1}>;
      UIlabel User_id<NEx=22,NEy=132> {
         x<NEdisplayMode="NEopened"> = 224;
         y = 6;
         width = 60;
         parent => <-.Frame;
         label => "User ID:";
         alignment = 0;
      };
      UItext UserText<NEx=22,NEy=176> {
         x = 277;
         y = 1;
         outputOnly = 1;
         parent => <-.Frame;
         text<NEportLevels={0,0}>;
      };
   };
   macro UserId#7<NEx=0,NEy=66> {
      link Frame<NEx=22,NEy=88,NEportLevels={2,1}>;
      UIlabel User_id<NEx=22,NEy=132> {
         x<NEdisplayMode="NEopened"> = 224;
         y = 6;
         width = 60;
         parent => <-.Frame;
         label => "User ID:";
         alignment = 0;
      };
      UItext UserText<NEx=22,NEy=176> {
         x = 277;
         y = 1;
         outputOnly = 1;
         parent => <-.Frame;
         text<NEportLevels={0,0}>;
      };
   };
   Panels.UIpanel UIpanel<NEx=297,NEy=-143> {
      y = 0;
      width = 305 + EXTRA_SHELL_WIDTH*6;
      height = 265;
      parent => <-.UIshell;
   };
   Shells.UIshell UIshell<NEx=297,NEy=-187,NEwidth=209,NEheight=231> {
      width = 305 + EXTRA_SHELL_WIDTH*8;
      height = 265 + EXTRA_SHELL_HEIGHT*2;
      visible = 1;
      title => "Query Statistics";
   };
   UIframe Frame<NEx=297,NEy=-88> {
      x = 3;
      y = 3;
      width = 300 + EXTRA_SHELL_WIDTH*5;
      height = 258;
      parent => <-.UIpanel;
   };
   macro NumFetchesPerQuery<NEx=297,NEy=-44> {
      UIlabel NumberOfFetches<NEx=44,NEy=143> {
         x = 7;
         y = 15;
         width = 180;
         parent => <-.Frame;
         label<NEdisplayMode="NEopened"> => "Number of fetches:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=99,NEportLevels={2,1}> => <-.Frame;
      UIfield Value<NEx=44,NEy=187,NEwidth=484,NEheight=242> {
         x = 190 + EXTRA_SHELL_WIDTH*5;
         y = 7;
         height = 33;
         active<NEportLevels={1,0}>;
         color<NEdisplayMode="NEopened"> {
            backgroundColor = "white";
         };
         parent => <-.Frame;
         mode = 1;
         outputOnly = 1;
      };
   };
   macro RowsProcessed<NEx=297,NEy=0> {
      UIlabel RowsProcessed<NEx=44,NEy=165> {
         x = 7;
         y = 49;
         width = 180;
         parent => <-.Frame;
         label => "Rows processed:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=110,NEportLevels={2,1}> => <-.Frame;
      UIfield Value<NEx=44,NEy=209> {
         x = 190 + EXTRA_SHELL_WIDTH*5;
         y = 42;
         height = 33;
         active<NEportLevels={1,0}>;
         color<NEdisplayMode="NEopened"> {
            backgroundColor = "white";
         };
         parent => <-.Frame;
         mode = 1;
         outputOnly = 1;
      };
   };
   macro NumOutputCols<NEx=297,NEy=55> {
      UIlabel NumOutputCols<NEx=44,NEy=165> {
         x = 8;
         y = 86;
         width<NEdisplayMode="NEopened"> = 180 + EXTRA_SHELL_WIDTH*5;
         parent => <-.Frame;
         label => "Number of output columns:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=110,NEportLevels={2,1}> => <-.Frame;
      UIfield Value<NEx=44,NEy=209> {
         x = 190 + EXTRA_SHELL_WIDTH*5;
         y = 79;
         height = 33;
         active<NEportLevels={1,0}>;
         color {
            backgroundColor = "white";
         };
         parent => <-.Frame;
         mode = 1;
         outputOnly = 1;
      };
   };
   macro RowSpecErrorCnt<NEx=297,NEy=110> {
      UIlabel RowSpecErrorCnt<NEx=44,NEy=165> {
         x = 8;
         y = 120;
         width = 180 + EXTRA_SHELL_WIDTH*3;
         parent => <-.Frame;
         label => "Row specific error count:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=110,NEportLevels={2,1}> => <-.Frame;
      UIfield Value<NEx=44,NEy=209> {
         x = 190 + EXTRA_SHELL_WIDTH*5;
         y = 115;
         height = 33;
         active<NEportLevels={1,0}>;
         color<NEdisplayMode="NEopened"> {
            backgroundColor = "white";
         };
         parent => <-.Frame;
         mode = 1;
         outputOnly = 1;
      };
   };
   macro UserbufRowsAllocated<NEx=297,NEy=154> {
      UIlabel UserBufRowsAllocated<NEx=44,NEy=165> {
         x = 7;
         y = 154;
         width = 180 + EXTRA_SHELL_WIDTH*5;
         parent => <-.Frame;
         label => "User buffer rows allocated:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=99,NEportLevels={2,1}> => <-.Frame;
      UIfield Value<NEx=44,NEy=209> {
         x = 190 + EXTRA_SHELL_WIDTH*5;
         y = 148;
         height = 33;
         active<NEportLevels={1,0}>;
         color {
            backgroundColor = "white";
         };
         parent => <-.Frame;
         mode = 1;
         outputOnly = 1;
      };
   };
   macro UserbufRowsUsed<NEx=297,NEy=198> {
      UIlabel UserBufRowsUsed<NEx=44,NEy=165> {
         x = 7;
         y = 189;
         width = 180 + EXTRA_SHELL_WIDTH;
         parent => <-.Frame;
         label => "User buffer rows used:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=110,NEportLevels={2,1}> => <-.Frame;
      UIfield Value<NEx=44,NEy=209> {
         x = 190 + EXTRA_SHELL_WIDTH*5;
         y = 184;
         height = 33;
         active<NEportLevels={1,0}>;
         color {
            backgroundColor = "white";
         };
         parent => <-.Frame;
         mode = 1;
         outputOnly = 1;
      };
   };
   macro UserBufBytesAllocated<NEx=297,NEy=242> {
      UIlabel UserBufBytesAllocated<NEx=44,NEy=165> {
         x = 6;
         y = 222;
         width = 180 + EXTRA_SHELL_WIDTH*5;
         parent => <-.Frame;
         label => "User buffer bytes allocated:";
         alignment = 0;
      };
      link Frame<NEx=44,NEy=110,NEportLevels={2,1}> => <-.Frame;
      UIfield Value<NEx=44,NEy=209> {
         x = 190 + EXTRA_SHELL_WIDTH*5;
         y = 217;
         height = 33;
         active<NEportLevels={1,0}>;
         color<NEdisplayMode="NEopened"> {
            backgroundColor = "white";
         };
         parent => <-.Frame;
         mode = 1;
         outputOnly = 1;
      };
   };
};

macro OutputUI<NEx=22.,NEy=66.,NEscalingFactor=1.026782632,NExOffset=-263.4014282,NEyOffset=247.7944031> {
   UIframe FrameFloat<NEx=495,NEy=-88> {
      x = 3;
      y = 120;
      width = 120 + EXTRA_SHELL_WIDTH*2;
      height = 85;
      parent => <-.UIpanel;
   };
   macro FloatType<NEx=495,NEy=-33,NEscalingFactor=1,NExOffset=0,NEyOffset=0> {
      link Frame<NEx=22,NEy=88,NEportLevels={2,1}> => <-.FrameFloat;
      UIlabel FixedType<NEx=22,NEy=176> {
         x = 223;
         y = 40;
         width = 105;
         events {
            buttonPress = 1;
            buttonRelease = 1;
         };
         parent => <-.Frame;
         label => "Null value uint:";
         alignment = 0;
      };
      Controls.UIradioBox UIradioBox<NEx=22,NEy=308> {
         x = 10;
         y = 30;
         parent => <-.Frame;
         cmdList => {<-.TheFloat,
            <-.TheDouble};
      };
      UIoption TheFloat<NEx=22,NEy=220> {
         label = "Float";
      };
      UIoption TheDouble<NEx=22,NEy=264> {
         label<NEdisplayMode="NEopened"> = "Double";
      };
      UIlabel FloatTypeLabel<NEx=22,NEy=132> {
         x = 10;
         y = 0;
         parent<NEdisplayMode="NEopened"> => <-.Frame;
         label => "Float Type";
         alignment<NEdisplayMode="NEopened"> = 0;
      };
   };
   UIframe FrameFixed<NEx=660,NEy=-88> {
      x = 125 + EXTRA_SHELL_WIDTH;
      y = 3;
      width = 150 + EXTRA_SHELL_WIDTH*4;
      height = 202;
      parent => <-.UIpanel;
   };
   Panels.UIpanel UIpanel<NEx=495,NEy=-154> {
      y = 0;
      width = 439;
      height = 400;
      parent => <-.UIshell;
   };
   Shells.UIshell UIshell<NEx=495,NEy=-198,NEwidth=209,NEheight=231> {
      width = 278 + EXTRA_SHELL_WIDTH*6;
      height = 225 + EXTRA_SHELL_HEIGHT;
      visible = 1;
      title => "Query Output Types";
   };
   macro FixedType<NEx=660,NEy=-33,NEscalingFactor=1,NExOffset=0,NEyOffset=0> {
      link Frame<NEx=22,NEy=88,NEportLevels={2,1}> => <-.FrameFixed;
      Controls.UIradioBox UIradioBox<NEx=22,NEy=396> {
         x = 10;
         y = 50;
         width = 130 + EXTRA_SHELL_WIDTH*4;
         parent => <-.Frame;
         cmdList => {
            <-.Default,<-.Integer,<-.Short_Integer,<-.Byte,
            <-.Unsigned_Integer
         };
      };
      UIoption Default<NEx=22,NEy=176> {
         label = "Default";
      };
      UIoption Integer<NEx=22,NEy=308> {
         label = "Integer";
      };
      UIoption Byte<NEx=22,NEy=220> {
         label = "Byte";
      };
      UIoption Short_Integer<NEx=22,NEy=264> {
         label = "Short Integer";
      };
      UIoption Unsigned_Integer<NEx=22,NEy=352> {
         label = "Unsigned Integer";
      };
      UIlabel FixedTypeLabel<NEx=22,NEy=132> {
         x = 15;
         y = 15;
         parent => <-.Frame;
         label => "Fixed Type";
         alignment<NEdisplayMode="NEopened"> = 0;
      };
   };
   macro Force<NEx=319,NEy=-33,NEscalingFactor=1.059406042,NExOffset=377.1725159,NEyOffset=177.5181427> {
      Controls.UIradioBox UIradioBox<NEx=-341,NEy=66,NEwidth=198,NEheight=242> {
         x = 10;
         y = 32;
         width = 100  + EXTRA_SHELL_WIDTH;
         parent => <-.Frame;
         cmdList => {<-.DefaultType,
            <-.FloatType,<-.Fixedtype};
      };
      UIoption DefaultType<NEx=-341,NEy=-66> {
         label = "Default ";
      };
      UIoption FloatType<NEx=-341,NEy=-22> {
         label = "Float Type";
      };
      UIoption Fixedtype<NEx=-341,NEy=22> {
         label = "Fixed Type";
      };
      UIlabel ForceLabel<NEx=-341,NEy=110> {
         x = 1;
         y = 4;
         parent => <-.Frame;
         label => "Force Output";
      };
      link Frame<NEx=-341,NEy=-132,NEportLevels={2,1}> => <-.FrameForce;
   };
   UIframe FrameForce<NEx=319,NEy=-88> {
      x = 3;
      y = 3;
      width = 120 + EXTRA_SHELL_WIDTH*2;
      height = 115;
      parent => <-.UIpanel;
   };
};

macro OutputWindowUI<NEx=22.,NEy=154.,NEscalingFactor=1.001646876,NExOffset=367.2086487,NEyOffset=247.9178009> {
   UIframe ColumnFrame<NEx=-297.,NEy=143.,NEwidth=253,NEheight=286> {
      x = 13;
      y = 15;
      width => (<-.UIshell.clientWidth - 27);
      height => (<-.UIshell.clientHeight - 15);
      parent => <-.UIshell;
   };
   Shells.UIshell UIshell<NEx=-297.,NEy=88.,NEwidth=242,NEheight=231> {
      width = 575 + EXTRA_SHELL_WIDTH;
      visible = 1;
      title => "Output Window";
      menu => <-.Output_window;
      height = 582 + EXTRA_SHELL_HEIGHT;
   };
   macro RowCommands<NEx=-297.,NEy=-176.,NExOffset=25.53320313,NEyOffset=13.29293823,NEscalingFactor=0.9500070214> {
      UImenuSeparator UIseperator<NEx=198,NEy=99>;
      UIcmdList Rows<NEx=363.,NEy=275.,NEportLevels={0,2}> {
         label = "&Rows";
         radioBehavior = 1;
         cmdList => {
            <-.None.None,<-.Rows50.Rows50,<-.Rows100.Rows100,
            <-.Rows150.Rows150,<-.Rows200.Rows200,<-.Rows500.Rows500,
            <-.All.All,<-.Seperator,<-.Other.Other
         };
      };
      UImenuSeparator Seperator<NEx=506,NEy=99>;
      macro None<NEx=33,NEy=11,NExOffset=32,NEyOffset=130> {
         UIoption None<NEx=0.,NEy=-22.,NEportLevels={0,2}> {
            label = "&None";
            message = "Display no rows";
         };
         GMOD.parse_v Parse_V_None<NEx=0,NEy=66> {
            v_commands = "num_rows_to_list=0;";
            trigger => <-.flushEvents.out;
            on_inst = 0;
         };
         DBflushEvents flushEvents<NEx=0,NEy=22> {
            in<NEportLevels={2,0}> => <-.None.set;
         };
      };
      macro Rows50<NEx=187,NEy=11> {
         UIoption Rows50<NEx=33.,NEy=110.,NEportLevels={0,2}> {
            label = "&50 Rows";
            message = "Display 50 rows";
       set = 1;
         };
         GMOD.parse_v Parse_V_Rows50<NEx=33,NEy=198> {
            v_commands = "num_rows_to_list=50;";
            trigger => <-.flushEvents.out;
            on_inst = 0;
         };
         DBflushEvents flushEvents<NEx=33,NEy=154> {
            in<NEportLevels={2,0}> => <-.Rows50.set;
         };
      };
      macro Rows100<NEx=341,NEy=11> {
         UIoption Rows100<NEx=22.,NEy=77.,NEportLevels={0,2}> {
            label = "&100 Rows";
            message = "Display 100 rows";
         };
         GMOD.parse_v Parse_V_Rows100<NEx=22,NEy=165> {
            v_commands = "num_rows_to_list=100;";
            trigger => <-.flushEvents.out;
            on_inst = 0;
         };
         DBflushEvents flushEvents<NEx=22,NEy=121> {
            in<NEportLevels={2,0}> => <-.Rows100.set;
         };
      };
      macro Rows150<NEx=495,NEy=11> {
         UIoption Rows150<NEx=22.,NEy=88.,NEportLevels={0,2}> {
            label = "15&0 Rows";
            message = "Display 150 rows";
         };
         GMOD.parse_v Parse_V_Rows150<NEx=22,NEy=176> {
            v_commands = "num_rows_to_list=150;";
            trigger => <-.flushEvents.out;
            on_inst = 0;
         };
         DBflushEvents flushEvents<NEx=22,NEy=132> {
            in<NEportLevels={2,0}> => <-.Rows150.set;
         };
      };
      macro Rows200<NEx=649,NEy=11> {
         UIoption Rows200<NEx=22.,NEy=88.,NEportLevels={0,2}> {
            label = "&200 Rows";
            message = "Display 200 rows";
         };
         GMOD.parse_v Parse_V_Rows200<NEx=22,NEy=176> {
            v_commands = "num_rows_to_list=200;";
            trigger => <-.flushEvents.out;
            on_inst = 0;
         };
         DBflushEvents flushEvents<NEx=22,NEy=132> {
            in<NEportLevels={2,0}> => <-.Rows200.set;
         };
      };
      macro Rows500<NEx=33,NEy=99> {
         UIoption Rows500<NEx=22.,NEy=77.,NEportLevels={0,2}> {
            label = "500 &Rows";
            message = "Display 500 rows";
         };
         GMOD.parse_v Parse_V_Rows500<NEx=22,NEy=165> {
            v_commands = "num_rows_to_list=500;";
            trigger => <-.flushEvents.out;
            on_inst = 0;
         };
         DBflushEvents flushEvents<NEx=22,NEy=121> {
            in<NEportLevels={2,0}> => <-.Rows500.set;
         };
      };
      macro All<NEx=352,NEy=99> {
         UIoption All<NEx=11.,NEy=88.,NEportLevels={0,2}> {
            label = "&All";
            message = "Display all the rows";
         };
         GMOD.parse_v Parse_V_All<NEx=11,NEy=176,NEwidth=440,NEheight=253> {
            v_commands = "num_rows_to_list =>array_size(column_array[0].values);";
            trigger => <-.flushEvents.out;
            on_inst = 0;
         };
         DBflushEvents flushEvents<NEx=11,NEy=132> {
            in<NEportLevels={2,0}> => <-.All.set;
         };
      };
      macro Other<NEx=671,NEy=99> {
         UIcmd Other<NEx=22.,NEy=110.,NEportLevels={0,2}> {
            label = "&Other...";
            message = "Display user-specified number of rows";
         };
         UIpromptDialog Prompt<NEx=22.,NEy=187.,NEwidth=297,NEheight=264> {
            visible => <-.Other.do;
            title => "Rows";
            ok<NEportLevels={1,2}> = 1;
            applyButton = 0;
            prompt = "Enter number of rows";
         };
         GMOD.parse_v Parse_V_Other<NEx=11,NEy=176,NEwidth=440,NEheight=253> {
            v_commands => "num_rows_to_list = " + <-.Prompt.text + ";";
            trigger => <-.flushEvents.out;
            on_inst = 0;
         };
         DBflushEvents flushEvents<NEx=11,NEy=132> {
            in<NEportLevels={2,0}> => <-.Prompt.ok;
         };
      };
   };
   macro ColumnCommands<NEx=-297.,NEy=-132.,NExOffset=10.7701416,NEyOffset=-3.387268066,NEscalingFactor=1.00865829> {
      UIoption column_names<NEx=583.,NEy=55.> {
         label = "&Column Names";
         message = "Display column names";
      };
      UIoption column_names_and_types<NEx=308.,NEy=55.> {
         label = "Column Names and &Types";
         set = 1;
         message = "Display column names and types";
      };
      UIcmdList Columns<NEx=220.,NEy=220.,NEportLevels={0,2}> {
         label = "&Columns";
         radioBehavior = 1;
         cmdList => {<-.None#1,
            <-.column_names,<-.column_names_and_types};
      };
      UIoption None#1<NEx=44.,NEy=55.> {
         label = "&None";
         message = "Display no columns";
      };
      GMOD.parse_v Parse_V_ColumnNames<NEx=583,NEy=154> {
         v_commands = "header_mode=1;";
         trigger => <-.flushEvents#2.out;
         on_inst = 0;
      };
      GMOD.parse_v Parse_V_ColumnNames_Types<NEx=308,NEy=154> {
         v_commands = "header_mode=2;";
         trigger => <-.flushEvents#1.out;
         on_inst = 0;
      };
      GMOD.parse_v Parse_V_None<NEx=44,NEy=154> {
         v_commands = "header_mode=0;";
         trigger => <-.flushEvents.out;
         on_inst = 0;
      };
      DBflushEvents flushEvents<NEx=44,NEy=110> {
         in<NEportLevels={2,0}> => <-.None#1.set;
      };
      DBflushEvents flushEvents#1<NEx=308,NEy=110> {
         in<NEportLevels={2,0}> => <-.column_names_and_types.set;
      };
      DBflushEvents flushEvents#2<NEx=583,NEy=110> {
         in<NEportLevels={2,0}> => <-.column_names.set;
      };
   };
   UIcmdList Output_window<NEx=-297.,NEy=44.> {
      label = "&Output Window";
      cmdList => {
         <-.File.FileCommand,<-.RowCommands.Rows,<-.ColumnCommands.Columns,
         <-.ColumnMode.ColumnMode,<-.Spaces.Spaces,<-.Clear.Clear
      };
   };
   Controls.UIlist UIlist<NEx=-297.,NEy=198.,NEwidth=330,NEheight=341> {

#ifdef MSDOS
      font = "courier";
#else
       fontList ="-adobe-courier-bold-r-normal--12-120-75-75-m-70-iso8859-1";
       fontAttributes.fontString => <-.fontList;
#endif

      y = 0;
      width => (<-.ColumnFrame.width - 5);
      height => (<-.ColumnFrame.height - 5);
      color {
         backgroundColor = "white";
      };
      parent => <-.ColumnFrame;
      listIsEditable = 0;
      selectedItem = 0;
   };
   macro File<NEx=-297.,NEy=-220.> {
      UIcmdList FileCommand<NEx=44,NEy=187,NEportLevels={0,2}> {
         label = "&File";
         cmdList => {<-.Save_output};
      };
      UIcmd Save_output<NEx=44.,NEy=33.> {
         label = "&Save Output...";
         message = "Save output to a file";
      };
      UIfileDialog File<NEx=44,NEy=88,NEwidth=253,NEheight=264> {
         visible => <-.Save_output.do;
         title => "Save Output";
         ok<NEportLevels={1,2}>;
      };
      DBsave DBsave<NEx=44.,NEy=143.> {
         file_name => <-.File.filename;
         string_array => <-.<-.UIlist.strings;
         process_save => <-.File.ok;
      };
   };
   macro Clear<NEx=-297.,NEy=0.> {
      UIcmd Clearwindow<NEx=33.,NEy=99.> {
         label = "&Clear Output Window";
         message = "Clear output window";
      };
      UIcmdList Clear<NEx=33,NEy=242,NEportLevels={0,2}> {
         label = "&Clear";
         cmdList => {<-.Clearwindow};
      };
      DBflushEvents flushEvents<NEx=33,NEy=143> {
         in<NEportLevels={2,0}> => <-.Clearwindow.do;
      };
      GMOD.parse_v Parse_V_Clear<NEx=33,NEy=198,NEwidth=286,NEheight=176> {
         v_commands = "num_rows_to_list=0;";
         trigger => <-.flushEvents.out;
         on_inst = 0;
      };
   };
   macro Spaces<NEx=-297.,NEy=-44.> {
      UIoption spaces10<NEx=22.,NEy=66.> {
         label => "&10 Spaces";
         message = "Set spacing between columns to 10";
      };
      UIoption spaces20<NEx=187.,NEy=66.> {
         label => "&20 Spaces";
         set = 1;
         message = "Set spacing between column to 20";
      };
      UIoption spaces30<NEx=352.,NEy=66.> {
         label => "&30 Spaces";
         message = "Set spacing between column to 30";
      };
      Commands.UImenuSeparator UImenuSeparator<NEx=671.,NEy=66.>;
      UIcmdList Spaces<NEx=671.,NEy=198.,NEportLevels={0,2}> {
         cmdList => {
            <-.spaces10,<-.spaces20,<-.spaces30,<-.UImenuSeparator,<-.Other
         };
         label = "&Spaces";
         radioBehavior = 1;
      };
      UIcmd Other<NEx=517.,NEy=66.> {
         label => "&Other...";
         message = "Set spacing between columns";
      };
      DBflushEvents flushEvents1<NEx=22.,NEy=110.> {
         in<NEportLevels={2,0}> => <-.spaces10.set;
      };
      GMOD.parse_v parse_v<NEx=22.,NEy=154.> {
         v_commands = "column_width=10;";
         trigger => <-.flushEvents1.out;
         on_inst = 0;
      };
      DBflushEvents flushEvents2<NEx=187.,NEy=110.> {
         in<NEportLevels={2,0}> => <-.spaces20.set;
      };
      GMOD.parse_v parse_v#1<NEx=187.,NEy=154.> {
         v_commands = "column_width=20;";
         trigger => <-.flushEvents2.out;
         on_inst = 0;
      };
      DBflushEvents flushEvents3<NEx=352.,NEy=110.> {
         in<NEportLevels={2,0}> => <-.spaces30.set;
      };
      GMOD.parse_v parse_v#2<NEx=352.,NEy=154.> {
         v_commands = "column_width=30;";
         trigger => <-.flushEvents3.out;
         on_inst = 0;
      };
      DBflushEvents flushEvents<NEx=517.,NEy=110.> {
         in<NEportLevels={2,0}> => <-.Other.do;
      };
      UIpromptDialog Prompt<NEx=517.,NEy=154.> {
         visible => <-.flushEvents.out;
         title => "Spacing";
         prompt = "Enter the spacing between columns";
         ok<NEportLevels={1,2}>;
         applyButton = 0;
      };
      DBflushEvents flushEventsOther {
         in<NEportLevels={2,0}> => <-.Prompt.ok;
      };
      GMOD.parse_v parseVOther {
         v_commands => "column_width = " + <-.Prompt.text + ";";
         trigger => <-.flushEventsOther.out;
         on_inst = 0;
      };
   };
   macro ColumnMode<NEx=-297.,NEy=-88.> {
      UIcmdList ColumnMode<NEx=253.,NEy=209.,NEportLevels={0,2}> {
         cmdList => {<-.single,
            <-.multiple};
         label = "&Column Mode";
         radioBehavior = 1;
      };
      UIoption single<NEx=55.,NEy=88.> {
         message = "Set output to single-column form";
         label = "&Single";
      };
      UIoption multiple<NEx=55.,NEy=253.> {
         set = 1;
         message = "Set output to multiple columns";
         label = "&Multiple";
      };
      DBflushEvents flushEvents1<NEx=55.,NEy=132.> {
         in<NEportLevels={2,0}> => <-.single.set;
      };
      DBflushEvents flushEvents<NEx=55.,NEy=297.> {
         in<NEportLevels={2,0}> => <-.multiple.set;
      };
      GMOD.parse_v parse_v<NEx=55.,NEy=176.> {
         v_commands<NEdisplayMode="open"> = "column_mode=0;";
         trigger => <-.flushEvents1.out;
         on_inst = 0;
      };
      GMOD.parse_v parse_v#1<NEx=55.,NEy=341.> {
         v_commands = "column_mode=1;";
         trigger => <-.flushEvents.out;
         on_inst = 0;
      };
   };
};
};

library+sort+buffered Mappers<NEdisplayMode="NEopened",compile_subs=0> {
MODS.table_to_uniform_field Table_to_Uniform_Field;
MODS.table_to_scatter_field Table_to_Scatter_Field;
};

};
